
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 * 
 */
public abstract class SGElementGroupRectangle extends SGElementGroupSXY
{


	/**
	 * 
	 */
	protected float mRectangleWidth = 1.0f/SGConstants.CM_POINT_RATIO;


	/**
	 * 
	 */
	protected float mRectangleHeight = 0.0f;


	/**
	 * 
	 */
	protected float mEdgeLineWidth = 0.10f/SGConstants.CM_POINT_RATIO;


	/**
	 * 
	 */
	protected Color mEdgeLineColor = Color.black;



	/**
	 * 
	 */
	protected final String SET_EDGE_LINE_WIDTH = "Set the width of edge line";


	/**
	 * 
	 */
	protected final String SET_EDGE_COLOR = "Set the edge color";



	/**
	 *
	 */
	public SGElementGroupRectangle()
	{
		super();
	}


	/**
	 * 
	 */
	public float getRectangleWidth()
	{
		return this.mRectangleWidth;
	}


	/**
	 * 
	 */
	public float getRectangleHeight()
	{
		return this.mRectangleHeight;
	}


	/**
	 * 
	 */
	public float getEdgeLineWidth()
	{
		return this.mEdgeLineWidth;
	}
	
	
	/**
	 * 
	 */
	public Color getEdgeLineColor()
	{
		return this.mEdgeLineColor;
	}



	/**
	 * 
	 */
	public boolean setRectangleWidth( final float width )
	{
		this.mRectangleWidth = width;
		return true;
	}


	/**
	 * 
	 */
	public boolean setRectangleHeight( final float height )
	{
		this.mRectangleHeight = height;
		return true;
	}


	/**
	 *
	 */
	public boolean setEdgeLineWidth( final float width )
	{
		mEdgeLineWidth = width;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementBar2D el = (SGDrawingElementBar2D)mDrawingElementList.get(ii);
			el.setEdgeLineWidth(mEdgeLineWidth);
		}
		return true;
	}



	/**
	 *
	 */
	public boolean setEdgeLineColor( final Color color )
	{
		mEdgeLineColor = color;
		for( int ii=0; ii<mDrawingElementList.size(); ii++ )
		{
			SGDrawingElementBar2D el = (SGDrawingElementBar2D)mDrawingElementList.get(ii);
			el.setEdgeLineColor(mEdgeLineColor);
		}
		return true;
	}






	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementRectangle) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementRectangle rect = (SGDrawingElementRectangle)element;
		this.setRectangleWidth( rect.getWidth() );
		this.setRectangleHeight( rect.getHeight() );
		this.setEdgeLineWidth( rect.getEdgeLineWidth() );
		this.setEdgeLineColor( rect.getEdgeLineColor() );

		return true;
	}



}
