
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.geom.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 *
 */

public abstract class SGDrawingElementLine extends SGDrawingElement
{

	/**
	 * 
	 */
	public static final int LINE_TYPE_SOLID = 1;


	/**
	 * 
	 */
	public static final int LINE_TYPE_BROKEN = 2;


	/**
	 * 
	 */
	public static final int LINE_TYPE_DOT = 3;


	/**
	 * 
	 */
	public static final String LINE_NAME_SOLID = "Solid";


	/**
	 * 
	 */
	public static final String LINE_NAME_BROKEN = "Broken";


	/**
	 * 
	 */
	public static final String LINE_NAME_DOT = "Dotted";



	/**
	 *
	 */
	protected SGTuple2f mStart = null;


	/**
	 *
	 */
	protected SGTuple2f mEnd = null;


	/**
	 *
	 */
	protected int mLineType = LINE_TYPE_SOLID;


	/**
	 *
	 */
	protected float mLineWidth
		= 0.10f/SGConstants.CM_POINT_RATIO;



	/**
	 *
	 */
	public SGDrawingElementLine()
	{
		super();
	}


	/**
	 *
	 */
	public SGDrawingElementLine(
		final SGTuple2f start,
		final SGTuple2f end )
	{
		super();

		mStart = start;
		mEnd = end;
	}


	/**
	 *
	 */
	public SGDrawingElementLine(
		final SGTuple2f start,
		final SGTuple2f end,
		final float lineWidth )
	{
		super();

		mStart = start;
		mEnd = end;
		mLineWidth = lineWidth;
	}


	/**
	 * 
	 * @param el
	 */
	public SGDrawingElementLine( final SGDrawingElementLine el )
	{
		super();
		this.mStart = el.getStart();
		this.mEnd = el.getEnd();
		this.mLineWidth = el.getLineWidth();
		this.mLineType = el.getLineType();
	}



	/**
	 *
	 */
	public boolean setType( final int type )
	{
		mLineType = type;
		return true;
	}


	/**
	 *
	 */
	public boolean setTermPoints(
		final SGTuple2f start, final SGTuple2f end )
	{
		mStart = start;
		mEnd = end;
		return true;
	}


	/**
	 *
	 */
	public boolean setLineWidth( final float width )
	{
		mLineWidth = width;
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineType( final int type )
	{
		this.mLineType = type;
		return true;
	}



	/**
	 * 
	 */
	public SGTuple2f getStart()
	{
		return new SGTuple2f( mStart.x, mStart.y );
	}


	/**
	 * 
	 */
	public SGTuple2f getEnd()
	{
		return new SGTuple2f( mEnd.x, mEnd.y );
	}


	/**
	 *
	 */
	public int getLineType()
	{
		return mLineType;
	}


	/**
	 *
	 */
	public float getLineWidth()
	{
		return mLineWidth;
	}



	/**
	 * 
	 */
	public static Integer getLineTypeFromName( final String name )
	{

		if( name==null )
		{
			return null;
		}
		
		int type;
		if( name.equals( SGDrawingElementLine.LINE_NAME_SOLID ) )
		{
			type = SGDrawingElementLine.LINE_TYPE_SOLID;
		}
		else if( name.equals( SGDrawingElementLine.LINE_NAME_BROKEN ) )
		{
			type = SGDrawingElementLine.LINE_TYPE_BROKEN;
		}
		else if( name.equals( SGDrawingElementLine.LINE_NAME_DOT ) )
		{
			type = SGDrawingElementLine.LINE_TYPE_DOT;
		}
		else
		{
			return null;
		}

		return new Integer(type);
	}



	/**
	 * 
	 */
	public static String getLineTypeName( final int type )
	{
		
		String name = null;
		switch( type )
		{
			case SGDrawingElementLine.LINE_TYPE_SOLID :
			{
				name = SGDrawingElementLine.LINE_NAME_SOLID;
				break;
			}

			case SGDrawingElementLine.LINE_TYPE_BROKEN :
			{
				name = SGDrawingElementLine.LINE_NAME_BROKEN;
				break;
			}

			case SGDrawingElementLine.LINE_TYPE_DOT :
			{
				name = SGDrawingElementLine.LINE_NAME_DOT;
				break;
			}

			default :
			{
				
			}
		}
		
		return name;
	}



	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementLine) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementLine line = (SGDrawingElementLine)element;

		this.setLineType( line.getLineType() );
		this.setLineWidth( line.getLineWidth() );
	
		return true;
	}



}
