/*
 * Created on 2004/06/18
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGData;

/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SGSXYMultipleData extends SGData implements SGITwoDimensionalData
{


	/**
	 * 
	 */
	private double[] mXValueArray = null;


	/**
	 * 
	 */
	private double[][] mYValueArray = null;


	/**
	 * 
	 */
	public SGSXYMultipleData()
	{
		super();
	}


	/**
	 * 
	 */
	public SGSXYMultipleData( final double[] xArray, final double[][] yArray )
	{
		super();

		if( xArray==null || yArray==null )
		{
			throw new IllegalArgumentException();
		}

		if( yArray.length==0 )
		{
			throw new IllegalArgumentException();
		}

		int len = xArray.length;
		for( int ii=0; ii<yArray.length; ii++ )
		{
			if( yArray[ii].length != len )
			{
				throw new IllegalArgumentException();
			}
		}

		this.mXValueArray = xArray;
		this.mYValueArray = yArray;
	}


	/**
	 * 
	 */
	public int getDataNumber()
	{
		return this.mYValueArray.length;
	}


	/**
	 * 
	 */
	public int getDataLength()
	{
		return this.mYValueArray[0].length;
	}


	/**
	 * 
	 */
	public double[] getXValueArray()
	{
		return this.mXValueArray;
	}


	/**
	 * 
	 */
	public double[][] getYValueArray()
	{
		return this.mYValueArray;
	}


	/**
	 * 
	 */
	public SGSXYData[] getSXYDataArray()
	{
		double[] xArray = this.getXValueArray();

		SGSXYData[] array = new SGSXYData[this.mYValueArray.length];
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii] = new SGSXYData( xArray, this.mYValueArray[ii] );
		}

		return array;
	}


	/**
	 * 
	 */
	public double getMinValueX()
	{
		double[] array = this.getXValueArray();

		double min = Double.MAX_VALUE;
		for( int ii=0; ii<array.length; ii++ )
		{
			final double value = array[ii];
			if( value < min )
			{
				min = value;
			}
		}

		return min;
	}


	/**
	 * 
	 */
	public double getMaxValueX()
	{
		double[] array = this.getXValueArray();

		double max = - Double.MAX_VALUE;
		for( int ii=0; ii<array.length; ii++ )
		{
			final double value = array[ii];
			if( value > max )
			{
				max = value;
			}
		}

		return max;
	}


	/**
	 * 
	 */
	public double getMinValueY()
	{
		double min = Double.MAX_VALUE;
		for( int ii=0; ii<this.mYValueArray.length; ii++ )
		{
			for( int jj=0; jj<this.mYValueArray[ii].length; jj++ )
			{
				final double value = this.mYValueArray[ii][jj];
				if( value < min )
				{
					min = value;
				}
			}
		}

		return min;
	}


	/**
	 * 
	 */
	public double getMaxValueY()
	{
		double max = - Double.MAX_VALUE;
		for( int ii=0; ii<this.mYValueArray.length; ii++ )
		{
			for( int jj=0; jj<this.mYValueArray[ii].length; jj++ )
			{
				final double value = this.mYValueArray[ii][jj];
				if( value > max )
				{
					max = value;
				}
			}
		}

		return max;
	}



	/**
	 * 
	 */
	public boolean setData( final SGData data )
	{

		if( !(data instanceof SGSXYMultipleData) )
		{
			return false;
		}

		SGSXYMultipleData data_ = (SGSXYMultipleData)data;
		this.mXValueArray = data_.getXValueArray();
		this.mYValueArray = data_.getYValueArray();

		return true;
	}


	/**
	 * 
	 */
	protected boolean setXValueArray( final double[] array )
	{
		this.mXValueArray = array;
		return true;
	}


	/**
	 * 
	 */
	protected boolean setYValueArray( final double[][] array )
	{
		this.mYValueArray = array;
		return true;
	}


}
