/*
 * SGWndFigureIDSelectionWizardDialog.java
 *
 * Created on 2004/06/28, 15:23
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;
import jp.riken.brain.ni.samuraigraph.figure.java2d.*;


/**
 *
 * @author  kuromaru
 */
public class SGFigureIDSelectionWizardDialog extends SGWizardDialog implements CaretListener
{

	/**
	 * 
	 */
	public static final String TITLE = "Input the figure ID.";


	/**
	 * 
	 * @param title
	 */
	public SGFigureIDSelectionWizardDialog(final Frame owner, final boolean modal)
	{
		super(owner,modal);
		this.initComponents();
		this.initProperty();
	}

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mNextButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPanel = new javax.swing.JPanel();
        mFigureIDLabel = new javax.swing.JLabel();
        mFigureIDTextField = new javax.swing.JTextField();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mNextButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.TitledBorder("Figure ID"));
        mFigureIDLabel.setText("Figure ID");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFigureIDLabel, gridBagConstraints);

        mFigureIDTextField.setText("1");
        mFigureIDTextField.setPreferredSize(new java.awt.Dimension(55, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFigureIDTextField, gridBagConstraints);

        getContentPane().add(mPanel, new java.awt.GridBagConstraints());

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    protected javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mFigureIDLabel;
    private javax.swing.JTextField mFigureIDTextField;
    protected javax.swing.JButton mNextButton;
    private javax.swing.JPanel mPanel;
    // ϐ錾̏I//GEN-END:variables
    
    
    
   	/**
	 * 
	 */
	private boolean initProperty()
	{

		//
		this.setTitle( SGFigureIDSelectionWizardDialog.TITLE );


		//
		this.setResizable(false);

		//
//		this.mOKButton.addActionListener(this);
		this.mCancelButton.addActionListener(this);
//		this.mPreviousButton.addActionListener(this);
		this.mNextButton.addActionListener(this);


		//
		this.mFigureIDTextField.addCaretListener(this);

		return true;
	}



	/**
	 * 
	 */
	public int getFigureID()
	{
		String str = this.getFigureIDString();
		Integer n = Integer.valueOf(str);
		final int id = n.intValue();
		return id;
	}


	/**
	 * 
	 */
	public String getFigureIDString()
	{
		return this.mFigureIDTextField.getText();
	}


	/**
	 * 
	 */
	public boolean setFigureID( final int id )
	{
		this.mFigureIDTextField.setText( new Integer( id ).toString() );
		return true;
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		Object source = e.getSource();
            
//		if( source.equals( this.mOKButton ) )
//		{
//			this.onOK();
//		}
		if( source.equals( this.mCancelButton ) )
		{
			this.onCanceled();
		}

		if( source.equals( this.mNextButton ) )
		{
			this.onNext();
		}

	}



	/**
	 * 
	 */
	public void caretUpdate(CaretEvent e)
	{
		Object source = e.getSource();

		if( source.equals( this.mFigureIDTextField ) )
		{
			JTextComponent tf = (JTextComponent)source;
			String str = tf.getText();

			try
			{
				Integer n = Integer.valueOf(str);
				this.mNextButton.setEnabled(true);
			}
			catch( NumberFormatException ex )
			{
				System.out.println("l͂ĉB");
				this.mNextButton.setEnabled(false);
			}
			
		}

	}

}
