Option Explicit
Dim objWshShell, objArgs, objFs, objEnv, objDone, I
Set objWshShell = WScript.CreateObject("WScript.Shell")
Set objFs       = WScript.CreateObject("Scripting.FileSystemObject")
Set objEnv      = objWshShell.Environment("process")
Set objArgs     = WScript.Arguments

objEnv.Item("FREEHEP") = "."

Sub DoBuildVectorGraphics(objFS)
  On Error Resume Next
  Set objDone = objFS.GetFile(".build_vectorgraphics_done")
  If Err <> 0 Then
    Set objDone = objFS.CreateTextFile(".build_vectorgraphics_done")
    objDone.Close
    objWshShell.CurrentDirectory = "vectorgraphics"
    objWshShell.Run "tools\ant.bat -Djar=base", 4, 1
    objWshShell.Run "tools\ant.bat -Djar=graphics2d", 4, 1
    objWshShell.Run "tools\ant.bat -Djar=graphicsio", 4, 1
    objWshShell.Run "tools\ant.bat -Djar=graphicsio-cgm", 4, 0
    objWshShell.Run "tools\ant.bat -Djar=graphicsio-emf", 4, 0
    objWshShell.Run "tools\ant.bat -Djar=graphicsio-gif", 4, 0
    objWshShell.Run "tools\ant.bat -Djar=graphicsio-java", 4, 0
    objWshShell.Run "tools\ant.bat -Djar=graphicsio-pdf", 4, 0
    objWshShell.Run "tools\ant.bat -Djar=graphicsio-ppm", 4, 0
    objWshShell.Run "tools\ant.bat -Djar=graphicsio-ps", 4, 0
    objWshShell.Run "tools\ant.bat -Djar=graphicsio-svg", 4, 0
    objWshShell.Run "tools\ant.bat -Djar=graphicsio-swf", 4, 0
    objWshShell.CurrentDirectory = ".."
  End If
  On Error Goto 0
End Sub

Sub DoCleanVectorGraphics(objFS)
  On Error Resume Next
  objFS.DeleteFile ".build_vectorgraphics_done"
  objFS.DeleteFile "vectorgraphics\lib\freehep-version.txt"
  objWshShell.CurrentDirectory = "vectorgraphics"
  objWshShell.Run "tools\ant.bat veryclean", 4, 1
  objWshShell.CurrentDirectory = ".."
  On Error Goto 0
End Sub

Sub DoRebuildVectorGraphics(objFS)
  On Error Resume Next
  objFS.DeleteFile ".build_vectorgraphics_done"
  On Error Goto 0
  DoBuildVectorGraphics objFS
End Sub

Sub PrintUsage()
  WScript.Echo "Usage : build.vbs { build | rebuild | clean }"
End Sub

If objArgs.Count = 1 Then
  Select Case objArgs(0)
    Case "build"   DoBuildVectorGraphics objFS
    Case "rebuild" DoRebuildVectorGraphics objFS
    Case "clean"   DoCleanVectorGraphics objFS
    Case Else      PrintUsage
  End Select
Else
  PrintUsage
End If
