/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElementDialog;

public class SGStringElement
extends SGFigureElement
implements SGIStringElement,
CaretListener {
    private ArrayList mElementStringList = new ArrayList();
    private ElementString mFocusedString = null;
    private int mFocusedX = 0;
    private int mFocusedY = 0;
    private float mFrameLineWidth = 1.0f;
    private Point mPressedStringOrigin = null;
    private JTextField mEditField = null;
    private Icon mBackgroundImageIcon = null;
    protected static final int BOUNDARY_LINE_WIDTH = 10;
    private ElementString mStringBuffer = null;
    private SGStringElementDialog mDialog = null;

    public SGStringElement() {
        this.initEditField();
        this.mBackgroundImageIcon = this.createIcon("/resources/Lines.gif");
    }

    private boolean initEditField() {
        this.mEditField = new JTextField(10);
        this.setLayout(null);
        this.add(this.mEditField);
        this.mEditField.setVisible(false);
        this.mEditField.addActionListener(this);
        this.mEditField.addCaretListener(this);
        return true;
    }

    public boolean addString(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        ElementString elementString = this.createElementString(string, 100.0f, 100.0f, 16.0f);
        this.mElementStringList.add(elementString);
        this.repaint();
        return true;
    }

    private ElementString createElementString(String string, float f, float f2, float f3) {
        ElementString elementString = new ElementString(string);
        elementString.setMagnification(this.mMagnification);
        elementString.setLocation(f, f2);
        elementString.setFontSize(f3);
        return elementString;
    }

    public boolean addString(ElementString elementString) {
        char c;
        if (elementString == null) {
            return false;
        }
        String string = elementString.getString();
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        if (n < string.length() && ((c = string.charAt(n)) == ' ' || c == '\u3000')) {
            return false;
        }
        ElementString elementString2 = new ElementString(elementString);
        elementString2.setMagnification(this.mMagnification);
        this.mElementStringList.add(elementString2);
        this.updateHistory();
        elementString2.addPropertiesHistory();
        this.repaint();
        return true;
    }

    public boolean addString(int n, int n2) {
        this.clearFocusedString();
        this.mFocusedX = n;
        this.mFocusedY = n2;
        this.mEditField.setVisible(true);
        int n3 = SGUtilityText.getFontStyle("Plain");
        Font font = new Font("Serif", n3, (int)(this.mMagnification * 16.0f));
        this.mEditField.setFont(font);
        this.mStringBuffer = new ElementString("   ", n3, 16.0f);
        Rectangle2D rectangle2D = font.getStringBounds("   ", new FontRenderContext(null, false, false));
        int n4 = this.mFocusedX;
        int n5 = this.mFocusedY - (int)(this.mMagnification * 16.0f / 2.0f);
        int n6 = (int)(rectangle2D.getWidth() + (double)(this.mMagnification * 16.0f));
        int n7 = (int)(rectangle2D.getHeight() + (double)(this.mMagnification * 16.0f));
        this.mEditField.setLocation(n4, n5);
        this.mEditField.setSize(n6, n7);
        this.mEditField.setText("");
        this.repaint();
        return true;
    }

    public void paintGraphics2D(Graphics2D graphics2D) {
        super.paintGraphics2D(graphics2D);
        for (int i = 0; i < this.mElementStringList.size(); ++i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            if (!elementString.isVisible()) continue;
            elementString.drawString(graphics2D);
            if (!elementString.mFrameFlag) continue;
            this.drawFrameLines(elementString, graphics2D);
        }
        if (this.mEditField.isVisible()) {
            graphics2D.setPaint(Color.black);
            graphics2D.setStroke(new BasicStroke(10.0f));
            graphics2D.draw(this.mEditField.getBounds());
            graphics2D.setStroke(new BasicStroke(2.0f));
            this.mEditField.repaint();
        }
    }

    private void drawFrameLines(SGDrawingElementString2D sGDrawingElementString2D, Graphics2D graphics2D) {
        Rectangle2D rectangle2D = sGDrawingElementString2D.getElementBounds();
        graphics2D.setPaint(Color.black);
        graphics2D.setStroke(new BasicStroke(this.mFrameLineWidth));
        graphics2D.draw(rectangle2D);
    }

    protected ArrayList getVisibleStringElementList() {
        ArrayList<ElementString> arrayList = new ArrayList<ElementString>();
        for (int i = 0; i < this.mElementStringList.size(); ++i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            if (!elementString.isVisible()) continue;
            arrayList.add(elementString);
        }
        return arrayList;
    }

    protected boolean setVisibleStringElement(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        for (int i = 0; i < this.mElementStringList.size(); ++i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            elementString.setVisible(arrayList.contains(elementString));
        }
        return true;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement)) {
            if (sGIFigureElement instanceof SGIAxisElement) {
                SGIAxisElement sGIAxisElement = (SGIAxisElement)sGIFigureElement;
                float f = sGIAxisElement.getGraphAreaX();
                float f2 = sGIAxisElement.getGraphAreaY();
                float f3 = sGIAxisElement.getGraphAreaWidth();
                float f4 = sGIAxisElement.getGraphAreaHeight();
                bl = this.setGraphAreaRect(f, f2, f3, f4);
                this.drawBackAllStringElements();
            } else {
                bl = sGIFigureElement.synchronizeArgument(this);
            }
        }
        return bl;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error("");
    }

    public boolean setISize(SGTuple2f sGTuple2f) {
        super.setISize(sGTuple2f);
        this.drawBackAllStringElements();
        this.repaint();
        return true;
    }

    public boolean zoom(int n, int n2, int n3, int n4, float f) {
        super.zoom(n, n2, n3, n4, f);
        for (int i = 0; i < this.mElementStringList.size(); ++i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            elementString.zoom(n3, n4, f);
        }
        return true;
    }

    public boolean getMarginAroundGraphAreaRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        Object object;
        if (!super.getMarginAroundGraphAreaRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphAreaRect();
        ArrayList arrayList = this.getVisibleStringElementList();
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (ElementString)arrayList.get(i);
            arrayList2.add(((SGDrawingElementString2D)object).getElementBounds());
        }
        if (arrayList2.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D2 = SGUtility.createUnion(arrayList2);
        object = new ArrayList();
        ((ArrayList)object).add(rectangle2D);
        ((ArrayList)object).add(rectangle2D2);
        Rectangle2D rectangle2D3 = SGUtility.createUnion((ArrayList)object);
        float f = (float)(rectangle2D.getY() - rectangle2D3.getY());
        float f2 = (float)(rectangle2D3.getY() + rectangle2D3.getHeight() - (rectangle2D.getY() + rectangle2D.getHeight()));
        float f3 = (float)(rectangle2D.getX() - rectangle2D3.getX());
        float f4 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = this.onEdge(n, n2);
        for (int i = this.mElementStringList.size() - 1; i >= 0; --i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            if (elementString.contains(n, n2)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    this.mFocusedString = elementString;
                    this.mFocusedX = (int)elementString.getX();
                    this.mFocusedY = (int)elementString.getY();
                    this.showEditField(this.mFocusedString);
                    this.repaint();
                }
                return true;
            }
            if (!bl || !elementString.equals(this.mFocusedString)) continue;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                return true;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                JDialog jDialog = elementString.getDialog();
                jDialog.show();
                this.mEditField.setVisible(false);
            } else if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                JPopupMenu jPopupMenu = elementString.getPopupMenu();
                jPopupMenu.show(this, n, n2);
            }
            return true;
        }
        return false;
    }

    private boolean terminateEditField() {
        if (this.mFocusedString == null) {
            this.addStringElementFromTextField();
            this.hideEditField();
            return true;
        }
        this.commitEdit();
        this.hideEditField();
        return true;
    }

    private boolean commitEdit() {
        String string = this.mFocusedString.getString();
        String string2 = this.mEditField.getText();
        this.mFocusedString.setString(string2);
        if (!string.equals(string2)) {
            this.mFocusedString.updateHistory();
        }
        return true;
    }

    private boolean hideEditField() {
        this.mEditField.setText("");
        this.mEditField.setVisible(false);
        return true;
    }

    private boolean clearFocusedString() {
        this.mFocusedString = null;
        this.mPressedStringOrigin = null;
        return true;
    }

    private boolean showEditField(ElementString elementString) {
        Rectangle2D rectangle2D = elementString.getElementBounds();
        Rectangle2D rectangle2D2 = elementString.getStringRect();
        float f = elementString.getMagnification() * elementString.getFontSize();
        int n = (int)rectangle2D.getX();
        int n2 = (int)(rectangle2D.getY() - (double)(f / 2.0f));
        int n3 = (int)(rectangle2D2.getWidth() + (double)f);
        int n4 = (int)(rectangle2D2.getHeight() + (double)f);
        this.mEditField.setVisible(true);
        this.mEditField.setLocation(n, n2);
        this.mEditField.setSize(n3, n4);
        this.mEditField.setFont(new Font(elementString.getFontFamilyName(), elementString.getFontStyle(), (int)f));
        this.mEditField.setForeground(elementString.getColor(0));
        this.mEditField.setText(elementString.getString());
        return true;
    }

    public boolean clearSelectedElements() {
        super.clearSelectedElements();
        if (this.mEditField.isVisible()) {
            this.terminateEditField();
        }
        this.clearFocusedString();
        this.repaint();
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (int i = 0; i < this.mElementStringList.size(); ++i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            if (!elementString.contains(n, n2)) continue;
            this.mFocusedString = elementString;
            elementString.mFrameFlag = true;
            this.mPressedStringOrigin = new Point(n - (int)elementString.getX(), n2 - (int)elementString.getY());
            elementString.mTemporaryProperties = elementString.getProperties();
            this.repaint();
            return true;
        }
        if (this.mFocusedString != null && this.onEdge(n, n2)) {
            return true;
        }
        if (this.mEditField.isVisible()) {
            this.terminateEditField();
        }
        this.clearFocusedString();
        this.repaint();
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mFocusedString != null && this.mPressedStringOrigin != null) {
            float f = mouseEvent.getX() - this.mPressedStringOrigin.x;
            float f2 = mouseEvent.getY() - this.mPressedStringOrigin.y;
            this.mFocusedString.setLocation(f, f2);
            this.repaint();
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.drawBackStringElement(this.mFocusedString);
        if (this.mFocusedString.isChanged()) {
            this.mFocusedString.updateHistory();
        }
        if (this.mFocusedString == null || !this.onEdge(n, n2)) {
            this.clearFocusedString();
            this.repaint();
        }
        return true;
    }

    public boolean onEdge(int n, int n2) {
        Rectangle rectangle = this.mEditField.getBounds();
        int n3 = rectangle.x - 10;
        int n4 = rectangle.y - 10;
        int n5 = rectangle.width + 20;
        int n6 = rectangle.height + 20;
        Rectangle rectangle2 = new Rectangle(n3, n4, n5, n6);
        boolean bl = rectangle.contains(n, n2);
        boolean bl2 = rectangle2.contains(n, n2);
        boolean bl3 = !bl && bl2;
        return bl3;
    }

    public boolean isResizable(double d, double d2) {
        for (int i = 0; i < this.mElementStringList.size(); ++i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            Rectangle2D rectangle2D = elementString.getElementBounds();
            if (!(d < rectangle2D.getWidth()) && !(d2 < rectangle2D.getHeight())) continue;
            return false;
        }
        return true;
    }

    public boolean drawBackAllStringElements() {
        for (int i = 0; i < this.mElementStringList.size(); ++i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            this.drawBackStringElement(elementString);
        }
        return true;
    }

    public boolean chkBoundsVisible() {
        return true;
    }

    private boolean drawBackStringElement(ElementString elementString) {
        return true;
    }

    public boolean onKeyPressed(KeyEvent keyEvent) {
        return true;
    }

    public boolean onKeyReleased(KeyEvent keyEvent) {
        return true;
    }

    public boolean onKeyTyped(KeyEvent keyEvent) {
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        for (int i = 0; i < this.mElementStringList.size(); ++i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            if (elementString.contains(n, n2)) {
                elementString.mFrameFlag = true;
                this.repaint();
                return true;
            }
            elementString.mFrameFlag = false;
        }
        this.repaint();
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mEditField)) {
            this.terminateEditField();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        float f;
        String string = this.mEditField.getText();
        Font font = null;
        if (this.mFocusedString != null) {
            f = this.mFocusedString.getFontSize();
            font = new Font(this.mFocusedString.getFontFamilyName(), this.mFocusedString.getFontStyle(), (int)(this.mFocusedString.getMagnification() * f));
        } else {
            f = 16.0f;
            font = new Font("Serif", SGUtilityText.getFontStyle("Plain"), (int)(this.mMagnification * f));
        }
        Rectangle2D rectangle2D = font.getStringBounds(string, new FontRenderContext(null, false, false));
        double d = rectangle2D.getWidth();
        if (d > (double)this.mEditField.getWidth()) {
            this.mEditField.setSize((int)(rectangle2D.getWidth() + (double)(this.mMagnification * f)), this.mEditField.getHeight());
        }
        this.repaint();
    }

    private boolean addStringElementFromTextField() {
        ElementString elementString = this.createElementString(this.mEditField.getText(), this.mFocusedX, this.mFocusedY, 16.0f);
        this.addString(elementString);
        this.hideEditField();
        return true;
    }

    private boolean removeString(ElementString elementString) {
        for (int i = this.mElementStringList.size() - 1; i >= 0; --i) {
            ElementString elementString2 = (ElementString)this.mElementStringList.get(i);
            if (!elementString2.equals(elementString)) continue;
            this.mElementStringList.remove(elementString);
            return true;
        }
        return false;
    }

    public boolean removeAllElements() {
        super.removeAllElements();
        this.mElementStringList.clear();
        return true;
    }

    public boolean createDataObject(BufferedReader bufferedReader, SGData sGData) throws IOException {
        super.createDataObject(bufferedReader, sGData);
        return true;
    }

    public boolean writeProperty(Writer writer) throws IOException {
        writer.write("[String]\n");
        for (int i = 0; i < this.mElementStringList.size(); ++i) {
            ElementString elementString = (ElementString)this.mElementStringList.get(i);
            elementString.writeProperty(writer);
        }
        writer.write("\n\n");
        return true;
    }

    public boolean readProperty(BufferedReader bufferedReader) throws IOException {
        String string = null;
        bufferedReader.mark(256);
        while (true) {
            if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                return false;
            }
            if (!string.equals("<String>")) break;
            ElementString elementString = new ElementString();
            boolean bl = this.setElementStringProperty(bufferedReader, elementString);
            if (!bl) {
                return false;
            }
            this.addString(elementString);
            bufferedReader.mark(256);
        }
        bufferedReader.reset();
        return true;
    }

    private SGProperties readProperties(BufferedReader bufferedReader) throws IOException {
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, "X");
        if (d == null) {
            return null;
        }
        float f = d.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Y");
        if (d2 == null) {
            return null;
        }
        float f2 = d2.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getStringPropertyFromLine(string, "Text");
        if (string2 == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string3 = SGUtilityText.getPropertyFromLine(string, "Font Family Name");
        if (string3 == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Font Size");
        if (d3 == null) {
            return null;
        }
        float f3 = d3.floatValue();
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Integer n = SGUtilityText.getFontStyleFromLine(string, "Font Style");
        if (n == null) {
            return null;
        }
        int n2 = n;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        ArrayList arrayList = SGUtilityText.getColorListFromLine(string, "Color List");
        if (arrayList == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Angle");
        if (d4 == null) {
            return null;
        }
        float f4 = d4.floatValue() * ((float)Math.PI / 180);
        ElementStringProperties elementStringProperties = new ElementStringProperties();
        elementStringProperties.x = f;
        elementStringProperties.y = f2;
        elementStringProperties.text = string2;
        elementStringProperties.fontFamilyName = string3;
        elementStringProperties.fontSize = f3;
        elementStringProperties.fontStyle = n2;
        elementStringProperties.colorList = arrayList;
        elementStringProperties.angle = f4;
        return elementStringProperties;
    }

    private boolean setElementStringProperty(BufferedReader bufferedReader, ElementString elementString) throws IOException {
        ElementStringProperties elementStringProperties = (ElementStringProperties)this.readProperties(bufferedReader);
        if (elementStringProperties == null) {
            return false;
        }
        return elementString.setProperties(elementStringProperties);
    }

    private boolean updateParentHistoryFromStringElement(ElementString elementString) {
        this.updateParentHistory();
        this.updateObjectHistory(elementString);
        return true;
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.notifyChange();
        this.repaint();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.notifyChange();
        this.repaint();
        return true;
    }

    private boolean createDialog() {
        SGStringElementDialog sGStringElementDialog;
        this.mDialog = sGStringElementDialog = new SGStringElementDialog(this.mDialogOwner, true);
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    public SGProperties getProperties() {
        StringElementProperties stringElementProperties = new StringElementProperties();
        stringElementProperties.visibleStringElementList = this.getVisibleStringElementList();
        return stringElementProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringElementProperties)) {
            return false;
        }
        StringElementProperties stringElementProperties = (StringElementProperties)sGProperties;
        this.setVisibleStringElement(stringElementProperties.visibleStringElementList);
        return true;
    }

    public static class ElementStringProperties
    extends SGProperties {
        float x;
        float y;
        String text;
        float fontSize;
        int fontStyle;
        String fontFamilyName;
        float angle;
        ArrayList colorList;

        public boolean equals(Object object) {
            if (!(object instanceof ElementStringProperties)) {
                return false;
            }
            ElementStringProperties elementStringProperties = (ElementStringProperties)object;
            if (elementStringProperties.x != this.x) {
                return false;
            }
            if (elementStringProperties.y != this.y) {
                return false;
            }
            if (!elementStringProperties.text.equals(this.text)) {
                return false;
            }
            if (elementStringProperties.fontSize != this.fontSize) {
                return false;
            }
            if (elementStringProperties.fontStyle != this.fontStyle) {
                return false;
            }
            if (!elementStringProperties.fontFamilyName.equals(this.fontFamilyName)) {
                return false;
            }
            if (elementStringProperties.angle != this.angle) {
                return false;
            }
            return elementStringProperties.colorList.equals(this.colorList);
        }

        public String toString() {
            String string = new String("[");
            string = string + new String("x=" + this.x + ", ");
            string = string + new String("y=" + this.y + ", ");
            string = string + new String("text=" + this.text + ", ");
            string = string + new String("fontSize=" + this.fontSize + ", ");
            string = string + new String("fontStyle=" + this.fontStyle + ", ");
            string = string + new String("fontFamilyName=" + this.fontFamilyName + ", ");
            string = string + new String("angle=" + this.angle + ", ");
            string = string + new String("colorList=" + this.colorList + ", ");
            string = string + new String("]");
            return string;
        }
    }

    public static class StringElementProperties
    extends SGProperties {
        ArrayList visibleStringElementList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof StringElementProperties)) {
                return false;
            }
            StringElementProperties stringElementProperties = (StringElementProperties)object;
            return stringElementProperties.visibleStringElementList.equals(this.visibleStringElementList);
        }
    }

    class ElementString
    extends SGDrawingElementString2D
    implements ActionListener,
    WindowListener,
    SGIUndoable {
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private final String REMOVE_STRING = "remove this string";
        private boolean mVisibleFlag = true;
        private boolean mFrameFlag = false;
        private SGProperties mTemporaryProperties = null;
        private ArrayList mStringElementPropertyHistoryList = new ArrayList();
        private int mStringElementStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();

        protected ElementString() {
            this.init();
        }

        protected ElementString(String string) {
            super(string);
            this.init();
        }

        protected ElementString(String string, int n, float f) {
            super(string, n, f);
            this.init();
        }

        private boolean init() {
            this.setColor(SGDefaultValues.LABEL_COLOR);
            this.setFontFamilyName("Serif");
            this.setFontSize(16.0f);
            int n = SGUtilityText.getFontStyle("Plain");
            if (n == -1) {
                return false;
            }
            this.setFontStyle(n);
            this.setAngle(0.0f);
            this.createPopupMenu();
            return true;
        }

        protected ElementString(ElementString elementString) {
            super(elementString);
            this.mX = elementString.mX;
            this.mY = elementString.mY;
            this.createPopupMenu();
        }

        private boolean createPopupMenu() {
            this.mPopupMenu.setBounds(0, 0, 100, 100);
            String[] stringArray = new String[]{"remove this string"};
            for (int i = 0; i < stringArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
                jMenuItem.addActionListener(this);
                this.mPopupMenu.add(jMenuItem);
            }
            return true;
        }

        private JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        private JDialog getDialog() {
            SGStringElement.this.mDialog.setActionListener(this);
            SGStringElement.this.mDialog.addWindowListener(this);
            SGStringElement.this.mDialog.setLocation(SGStringElement.this.mDialogOwner.getLocation());
            this.mFrameFlag = true;
            SGStringElement.this.mDialog.setColorButtonBorder(true);
            this.setDialogProperty();
            this.mTemporaryProperties = this.getProperties();
            SGStringElement.this.mEditField.setVisible(false);
            SGStringElement.this.repaint();
            return SGStringElement.this.mDialog;
        }

        public boolean writeProperty(Writer writer) throws IOException {
            writer.write("<String>\n");
            SGUtilityText.writePropertyLine(writer, "X", new Float(this.mX * 0.035277776f));
            SGUtilityText.writePropertyLine(writer, "Y", new Float(this.mY * 0.035277776f));
            SGUtilityText.writeStringPropertyLine(writer, "Text", this.getString());
            SGUtilityText.writePropertyLine(writer, "Font Family Name", this.getFontFamilyName());
            SGUtilityText.writePropertyLine(writer, "Font Size", new Float(this.getFontSize()));
            SGUtilityText.writePropertyLine(writer, "Font Style", SGUtilityText.getFontStyleName(this.getFontStyle()));
            SGUtilityText.writeColorListPropertyLine(writer, "Color List", this.getColorList());
            SGUtilityText.writePropertyLine(writer, "Angle", new Float((double)this.getAngle() / (Math.PI / 180)));
            return true;
        }

        private ElementStringProperties getPropertiesFromDialg() {
            SGStringElementDialog sGStringElementDialog = SGStringElement.this.mDialog;
            ElementStringProperties elementStringProperties = sGStringElementDialog.getProperties();
            if (elementStringProperties == null) {
                return null;
            }
            elementStringProperties.x = this.mX;
            elementStringProperties.y = this.mY;
            elementStringProperties.text = new String(this.mString);
            return elementStringProperties;
        }

        private boolean setDialogProperty() {
            SGStringElementDialog sGStringElementDialog = SGStringElement.this.mDialog;
            sGStringElementDialog.setFontSize(this.mFontSize);
            sGStringElementDialog.setFontFamilyName(this.mFontFamilyName);
            sGStringElementDialog.setFontStyle(this.mFontStyle);
            sGStringElementDialog.setAngle((double)this.mAngle / (Math.PI / 180));
            sGStringElementDialog.setTextColorList(this.mColorList);
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementStringProperties)) {
                return false;
            }
            ElementStringProperties elementStringProperties = (ElementStringProperties)sGProperties;
            if (sGProperties == null) {
                return false;
            }
            this.mX = elementStringProperties.x;
            this.mY = elementStringProperties.y;
            this.setString(elementStringProperties.text);
            this.setFontFamilyName(elementStringProperties.fontFamilyName);
            this.setFontSize(elementStringProperties.fontSize);
            this.setFontStyle(elementStringProperties.fontStyle);
            this.setAngle(elementStringProperties.angle);
            this.setColorList(elementStringProperties.colorList);
            return true;
        }

        public SGProperties getProperties() {
            ElementStringProperties elementStringProperties = new ElementStringProperties();
            elementStringProperties.x = this.mX;
            elementStringProperties.y = this.mY;
            elementStringProperties.text = this.mString;
            elementStringProperties.fontFamilyName = this.mFontFamilyName;
            elementStringProperties.fontSize = this.mFontSize;
            elementStringProperties.fontStyle = this.mFontStyle;
            elementStringProperties.colorList = this.mColorList;
            elementStringProperties.angle = this.mAngle;
            return elementStringProperties;
        }

        public boolean setPropertyWithDialog() {
            SGStringElementDialog sGStringElementDialog = SGStringElement.this.mDialog;
            ElementStringProperties elementStringProperties = this.getPropertiesFromDialg();
            if (elementStringProperties == null) {
                return false;
            }
            return this.setProperties(elementStringProperties);
        }

        public boolean isVisible() {
            return this.mVisibleFlag;
        }

        public boolean setVisible(boolean bl) {
            this.mVisibleFlag = bl;
            return true;
        }

        public float getX() {
            return this.mMagnification * this.mX + SGStringElement.this.mGraphAreaX;
        }

        public float getY() {
            return this.mMagnification * this.mY + SGStringElement.this.mGraphAreaY;
        }

        public boolean setX(float f) {
            this.mX = (f - SGStringElement.this.mGraphAreaX) / this.mMagnification;
            return true;
        }

        public boolean setY(float f) {
            this.mY = (f - SGStringElement.this.mGraphAreaY) / this.mMagnification;
            return true;
        }

        private boolean isChanged() {
            boolean bl = !this.getProperties().equals(this.mTemporaryProperties);
            return bl;
        }

        public void windowActivated(WindowEvent windowEvent) {
            System.out.println("windowActivated");
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            System.out.println("windowDeactivated");
        }

        public void windowIconified(WindowEvent windowEvent) {
            System.out.println("windowIconified");
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            System.out.println("windowDeiconified");
        }

        public void windowOpened(WindowEvent windowEvent) {
            System.out.println("windowOpened");
        }

        public void windowClosed(WindowEvent windowEvent) {
            System.out.println("windowClosed");
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.out.println("windowClosing");
            Object object = windowEvent.getSource();
            System.out.println(object);
            if (object.equals(SGStringElement.this.mDialog)) {
                this.onCanceled();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals("remove this string")) {
                this.setVisible(false);
                SGStringElement.this.callParentUpdateHistory();
                SGStringElement.this.terminateEditField();
                return;
            }
            if (string.equals("OK") || SGStringElement.this.mDialog.getActiveComponentList().contains(object) ? !this.onOK() : (string.equals("Cancel") ? !this.onCanceled() : string.equals("Preview") && !this.onPreviewed())) {
                return;
            }
            SGStringElement.this.repaint();
        }

        private boolean onOK() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.updateHistory();
            }
            this.mTemporaryProperties = null;
            this.mFrameFlag = false;
            SGStringElement.this.mDialog.hide();
            SGStringElement.this.mDialog.removeActionListener();
            SGStringElement.this.mDialog.removeWindowListener(this);
            return true;
        }

        private boolean onCanceled() {
            boolean bl = this.recover();
            if (!bl) {
                return false;
            }
            this.mTemporaryProperties = null;
            SGStringElement.this.mDialog.hide();
            SGStringElement.this.mDialog.removeActionListener();
            SGStringElement.this.mDialog.removeWindowListener(this);
            return true;
        }

        private boolean onPreviewed() {
            boolean bl = this.setPropertyWithDialog();
            return bl;
        }

        private boolean recover() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            return true;
        }

        public boolean addPropertiesHistory() {
            this.addStringPropertyHistory(this.getProperties());
            return true;
        }

        private boolean addStringPropertyHistory(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementStringProperties)) {
                return false;
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mStringElementStateCounter; ++i) {
                arrayList.add(this.mStringElementPropertyHistoryList.get(i));
            }
            arrayList.add(sGProperties);
            this.mStringElementPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mStringElementStateCounter;
            ElementStringProperties elementStringProperties = (ElementStringProperties)this.mStringElementPropertyHistoryList.get(this.mStringElementStateCounter);
            this.setProperties(elementStringProperties);
            SGStringElement.this.repaint();
            return true;
        }

        public boolean redo() {
            ++this.mStringElementStateCounter;
            ElementStringProperties elementStringProperties = (ElementStringProperties)this.mStringElementPropertyHistoryList.get(this.mStringElementStateCounter);
            this.setProperties(elementStringProperties);
            SGStringElement.this.repaint();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            this.updateParentHistory();
            this.updateObjectHistory(this);
            ++this.mStringElementStateCounter;
            this.addStringPropertyHistory(this.getProperties());
            return true;
        }

        public boolean updateParentHistory() {
            return SGStringElement.this.updateParentHistoryFromStringElement(this);
        }
    }
}

