/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDouble;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertySettingListener;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSignificantDifferenceSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSignificantDifferenceSymbolDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingLineDialog;

public abstract class SGGraphElement
extends SGFigureElement
implements SGIGraphElement,
Runnable,
CaretListener {
    protected SGIAxisElement mAxisElement = null;
    protected ArrayList mGroupSetList = new ArrayList();
    protected ArrayList mTimingElementGroupSetList = new ArrayList();
    protected SGTimingLineDialog mTimingLineDialog = null;
    protected static SGPropertyDialog mPropertyDialogForData = null;
    protected ArrayList mSelectedGroupSetList = new ArrayList();
    protected final float mTimingLineWidth = 2.0f;
    protected JTextField mEditField = null;
    protected int mFocusedX = 0;
    protected int mFocusedY = 0;
    public static final String REMOVE_SELECTED_GRAPH = "Remove selected datas";
    public static final String REMOVE_SELECTED_ELEMENTS = "Remove selected elements";
    public static final int MAX_NUMBER_EMPHASIS_SYMBOLS = 8;
    protected Thread mThread = null;
    protected SigDiffSymbol mTempSymbol = new SigDiffSymbol();
    private SGSignificantDifferenceSymbolDialog mSigDiffDialog = null;
    public static final int mEmphasisSymbolSize = 6;
    protected ArrayList mSignificantDifferentSymbolsList = new ArrayList();
    protected Point mPressedSymbolOrigin = null;
    protected SigDiffSymbol mFocusedSymbol = null;
    protected float mAnchorSize = 7.0f;

    protected void startBlinking() {
        if (this.mThread == null) {
            this.mThread = new Thread(this);
            this.mThread.start();
        }
    }

    public void run() {
        while (true) {
            System.out.println("run");
            if (this.mSelectedGroupSetList.size() == 0) break;
            try {
                Thread.sleep(400L);
                this.reverseVisible();
                this.repaint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("break");
        this.mThread = null;
    }

    private boolean reverseVisible() {
        for (int i = 0; i < this.mSelectedGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet;
            sGElementGroupSet.setVisible(!(sGElementGroupSet = (SGElementGroupSet)this.mSelectedGroupSetList.get(i)).isVisible());
        }
        return true;
    }

    public boolean clearSelectedElements() {
        super.clearSelectedElements();
        this.clearSelectedElementsGroupSet();
        if (this.mEditField.isVisible()) {
            this.terminateEditField();
        }
        this.clearFocusedSymbol();
        this.repaint();
        return true;
    }

    public SGGraphElement() {
        this.initEditField();
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createAllDialogs();
        return true;
    }

    private boolean createAllDialogs() {
        this.createDataDialog();
        this.createSignificanceDialog();
        this.createTimingLineDialog();
        return true;
    }

    protected abstract boolean createDataDialog();

    private boolean createSignificanceDialog() {
        SGSignificantDifferenceSymbolDialog sGSignificantDifferenceSymbolDialog;
        this.mSigDiffDialog = sGSignificantDifferenceSymbolDialog = new SGSignificantDifferenceSymbolDialog(this.mDialogOwner, true);
        return true;
    }

    private boolean createTimingLineDialog() {
        SGTimingLineDialog sGTimingLineDialog;
        this.mTimingLineDialog = sGTimingLineDialog = new SGTimingLineDialog(this.mDialogOwner, true);
        return true;
    }

    private boolean initEditField() {
        this.mEditField = new JTextField(10);
        this.setLayout(null);
        this.add(this.mEditField);
        this.mEditField.setVisible(false);
        this.mEditField.addActionListener(this);
        this.mEditField.addCaretListener(this);
        return true;
    }

    private boolean showEditField(SigDiffSymbol sigDiffSymbol) {
        Rectangle2D rectangle2D = sigDiffSymbol.getStringElement().getElementBounds();
        double d = sigDiffSymbol.getFontSize();
        this.mEditField.setVisible(true);
        this.mEditField.setLocation((int)rectangle2D.getX(), (int)rectangle2D.getY());
        this.mEditField.setSize((int)(rectangle2D.getWidth() + 0.2 * d), (int)rectangle2D.getHeight());
        this.mEditField.setFont(new Font(sigDiffSymbol.getFontFamilyName(), sigDiffSymbol.getFontStyle(), (int)((double)this.mMagnification * d)));
        this.mEditField.setForeground(sigDiffSymbol.getColor());
        this.mEditField.setText(sigDiffSymbol.getStringElement().getString());
        return true;
    }

    private boolean terminateEditField() {
        if (this.mFocusedSymbol == null) {
            this.hideEditField();
            return true;
        }
        this.commitEdit();
        this.hideEditField();
        return true;
    }

    private boolean clearFocusedSymbol() {
        this.mFocusedSymbol = null;
        this.mPressedSymbolOrigin = null;
        return true;
    }

    private boolean hideEditField() {
        this.mEditField.setText("");
        this.mEditField.setVisible(false);
        return true;
    }

    private boolean commitEdit() {
        String string = this.mFocusedSymbol.mStringElement.getString();
        String string2 = this.mEditField.getText();
        this.mFocusedSymbol.setText(string2);
        if (!string.equals(string2)) {
            this.mFocusedSymbol.updateHistory();
        }
        this.mFocusedSymbol.createDrawingElement();
        return true;
    }

    public abstract boolean addData(SGData var1);

    protected abstract boolean createAllDrawingElements();

    public boolean setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
        return true;
    }

    protected ElementGroupSetInGraph getGraphData(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            return elementGroupSetInGraph;
        }
        return null;
    }

    protected SGData getData(ElementGroupSetInGraph elementGroupSetInGraph) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph2 = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            if (!elementGroupSetInGraph2.equals(elementGroupSetInGraph)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public String getDataName(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mName;
        }
        return null;
    }

    public ArrayList getDrawingElementList(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getDrawingElementList();
        }
        return null;
    }

    public ArrayList getVisibleFlagList(SGData sGData) {
        if (sGData == null) {
            return null;
        }
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        ArrayList arrayList = elementGroupSetInGraph.getVisibleFlagList();
        return arrayList;
    }

    public boolean getTimingElementList(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        for (int i = 0; i < this.mTimingElementGroupSetList.size(); ++i) {
            TimingElementGroupSetInGraph timingElementGroupSetInGraph = (TimingElementGroupSetInGraph)this.mTimingElementGroupSetList.get(i);
            SGAxis sGAxis = timingElementGroupSetInGraph.mAxis;
            ArrayList arrayList4 = timingElementGroupSetInGraph.getDrawingElementList();
            SGDouble sGDouble = timingElementGroupSetInGraph.mValue;
            arrayList.add(sGAxis);
            arrayList2.add(arrayList4);
            arrayList3.add(sGDouble);
        }
        return true;
    }

    public SGAxis getXAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mXAxis;
        }
        return null;
    }

    public SGAxis getYAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mYAxis;
        }
        return null;
    }

    public SGAxis getZAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mZAxis;
        }
        return null;
    }

    public JPopupMenu getPopupMenu(SGData sGData) {
        return null;
    }

    public JDialog getDialog(SGData sGData) {
        return null;
    }

    public boolean zoom(int n, int n2, int n3, int n4, float f) {
        super.zoom(n, n2, n3, n4, f);
        this.onZoomed(n, n2, n3, n4, f);
        this.createAllDrawingElements();
        return true;
    }

    protected boolean onZoomed(int n, int n2, int n3, int n4, float f) {
        ActionListener actionListener;
        int n5;
        for (n5 = 0; n5 < this.mGroupSetList.size(); ++n5) {
            actionListener = (ElementGroupSetInGraph)this.mGroupSetList.get(n5);
            ((SGElementGroupSet)((Object)actionListener)).zoom(n3, n4, f);
        }
        for (n5 = 0; n5 < this.mSignificantDifferentSymbolsList.size(); ++n5) {
            actionListener = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(n5);
            ((SGSignificantDifferenceSymbol)((Object)actionListener)).zoom(f);
        }
        for (n5 = 0; n5 < this.mTimingElementGroupSetList.size(); ++n5) {
            actionListener = (TimingElementGroupSetInGraph)this.mTimingElementGroupSetList.get(n5);
            ((SGElementGroupSet)((Object)actionListener)).zoom(n3, n4, f);
        }
        return true;
    }

    public boolean removeData(SGData sGData) {
        SGElementGroupSet sGElementGroupSet = this.getElementGroupSet(sGData);
        this.mDataList.remove(sGData);
        this.mGroupSetList.remove(sGElementGroupSet);
        return true;
    }

    public boolean removeAllElements() {
        super.removeAllElements();
        this.mGroupSetList.clear();
        this.mTimingElementGroupSetList.clear();
        return true;
    }

    public boolean setDataVisible(SGData sGData, boolean bl) {
        SGElementGroupSet sGElementGroupSet = this.getElementGroupSet(sGData);
        sGElementGroupSet.setVisible(bl);
        return true;
    }

    public boolean setISize(SGTuple2f sGTuple2f) {
        super.setISize(sGTuple2f);
        this.drawBackAllSigDiffSymbols();
        return true;
    }

    public boolean setGraphAreaRect(float f, float f2, float f3, float f4) {
        super.setGraphAreaRect(f, f2, f3, f4);
        this.createAllDrawingElements();
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            sigDiffSymbol.createDrawingElement();
        }
        return true;
    }

    public boolean getMarginAroundGraphAreaRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphAreaRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList arrayList = this.getVisibleSigDiffSymbolList();
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            Rectangle2D rectangle2D = sigDiffSymbol.getElementBounds();
            arrayList2.add(rectangle2D);
        }
        if (arrayList2.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList2);
        float f = this.mGraphAreaY - (float)rectangle2D.getY();
        float f2 = -(this.mGraphAreaY + this.mGraphAreaHeight) + (float)(rectangle2D.getY() + rectangle2D.getHeight());
        float f3 = this.mGraphAreaX - (float)rectangle2D.getX();
        float f4 = -(this.mGraphAreaX + this.mGraphAreaWidth) + (float)(rectangle2D.getX() + rectangle2D.getWidth());
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public boolean drawBackAllSigDiffSymbols() {
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            if (this.drawBackSigDiffSymbol(sigDiffSymbol)) continue;
            return false;
        }
        return true;
    }

    public boolean chkBoundsVisible() {
        return true;
    }

    private boolean drawBackSigDiffSymbol(SigDiffSymbol sigDiffSymbol) {
        return true;
    }

    public void paintGraphics2D(Graphics2D graphics2D) {
        super.paintGraphics2D(graphics2D);
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            if (!sigDiffSymbol.isVisible()) continue;
            float f = this.mMagnification * sigDiffSymbol.getLineWidth();
            graphics2D.setStroke(new BasicStroke(f, 0, 0));
            graphics2D.setPaint(sigDiffSymbol.getColor());
            Shape shape = sigDiffSymbol.getConnectedShape();
            graphics2D.draw(shape);
            sigDiffSymbol.getStringElement().drawString(graphics2D);
        }
        if (this.mFocusedSymbol != null) {
            ArrayList<SigDiffSymbol> arrayList = new ArrayList<SigDiffSymbol>();
            arrayList.add(this.mFocusedSymbol);
            this.drawSignificantDifferenceSymbolAnchor(graphics2D, arrayList);
        }
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (sGIFigureElement instanceof SGILegendElement) {
            SGILegendElement sGILegendElement = (SGILegendElement)sGIFigureElement;
            bl = this.synchronizeToLegendElement(sGILegendElement);
        } else if (sGIFigureElement instanceof SGIAxisElement) {
            SGIAxisElement sGIAxisElement = (SGIAxisElement)sGIFigureElement;
            bl = this.synchronizeToAxisElement(sGIAxisElement);
        } else if (!(sGIFigureElement instanceof SGIStringElement) && !(sGIFigureElement instanceof SGIGraphElement)) {
            bl = this.synchronizeArgument(sGIFigureElement);
        }
        return bl;
    }

    protected boolean synchronizeToAxisElement(SGIAxisElement sGIAxisElement) {
        Object object;
        Object object2;
        int n;
        float f = sGIAxisElement.getGraphAreaX();
        float f2 = sGIAxisElement.getGraphAreaY();
        float f3 = sGIAxisElement.getGraphAreaWidth();
        float f4 = sGIAxisElement.getGraphAreaHeight();
        this.setGraphAreaRect(f, f2, f3, f4);
        this.drawBackAllSigDiffSymbols();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object object3 = new ArrayList();
        sGIAxisElement.getTimingElementList(arrayList, arrayList2, (ArrayList)object3);
        for (n = this.mTimingElementGroupSetList.size() - 1; n >= 0; --n) {
            object2 = (TimingElementGroupSetInGraph)this.mTimingElementGroupSetList.get(n);
            object = ((TimingElementGroupSetInGraph)object2).mValue;
            boolean bl = ((ArrayList)object3).contains(object);
            if (bl) continue;
            this.mTimingElementGroupSetList.remove(n);
        }
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            Object object4;
            object2 = (SGDouble)((ArrayList)object3).get(n);
            object = (SGAxis)arrayList.get(n);
            ArrayList arrayList3 = (ArrayList)arrayList2.get(n);
            boolean bl = false;
            for (int i = 0; i < this.mTimingElementGroupSetList.size(); ++i) {
                TimingElementGroupSetInGraph timingElementGroupSetInGraph = (TimingElementGroupSetInGraph)this.mTimingElementGroupSetList.get(i);
                object4 = timingElementGroupSetInGraph.mValue;
                if (!object4.equals(object2)) continue;
                ArrayList arrayList4 = timingElementGroupSetInGraph.mDrawingElementGroupList;
                for (int j = 0; j < arrayList4.size(); ++j) {
                    SGElementGroup sGElementGroup = (SGElementGroup)arrayList4.get(j);
                    SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList3.get(j);
                    sGElementGroup.setProperty(sGDrawingElement);
                }
                bl = true;
                break;
            }
            if (bl) continue;
            TimingElementGroupSetInGraph timingElementGroupSetInGraph = new TimingElementGroupSetInGraph();
            timingElementGroupSetInGraph.mAxis = object;
            timingElementGroupSetInGraph.mValue = object2;
            for (int i = 0; i < arrayList3.size(); ++i) {
                object4 = (SGDrawingElement)arrayList3.get(i);
                timingElementGroupSetInGraph.addDrawingElementGroup((SGDrawingElement)object4);
            }
            timingElementGroupSetInGraph.setMagnification(this.mMagnification);
            this.mTimingElementGroupSetList.add(n, timingElementGroupSetInGraph);
            timingElementGroupSetInGraph.addPropertiesHistory();
            this.updateHistory();
        }
        arrayList = sGIAxisElement.getAxisList();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            object3 = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            ArrayList arrayList5 = ((ElementGroupSetInGraph)object3).mDrawingElementGroupList;
            for (int j = 0; j < arrayList5.size(); ++j) {
                object = (SGElementGroup)arrayList5.get(j);
                for (int k = 0; k < arrayList.size(); ++k) {
                    SGAxis sGAxis = (SGAxis)arrayList.get(k);
                    SGTuple2d sGTuple2d = sGAxis.getRange();
                    if (sGAxis.equals(((ElementGroupSetInGraph)object3).mXAxis)) {
                        ((ElementGroupSetInGraph)object3).mXAxis.setRange(sGTuple2d.x, sGTuple2d.y);
                    }
                    if (sGAxis.equals(((ElementGroupSetInGraph)object3).mYAxis)) {
                        ((ElementGroupSetInGraph)object3).mYAxis.setRange(sGTuple2d.x, sGTuple2d.y);
                    }
                    if (!sGAxis.equals(((ElementGroupSetInGraph)object3).mZAxis)) continue;
                    ((ElementGroupSetInGraph)object3).mZAxis.setRange(sGTuple2d.x, sGTuple2d.y);
                }
            }
        }
        this.createAllDrawingElements();
        this.repaint();
        return true;
    }

    protected boolean createTimingElements(SGTimingElementGroupSet sGTimingElementGroupSet) {
        SGAxis sGAxis = sGTimingElementGroupSet.mAxis;
        double d = sGTimingElementGroupSet.mValue.mValue;
        ArrayList arrayList = sGTimingElementGroupSet.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof SGElementGroupLine)) {
                throw new Error();
            }
            SGElementGroupLine sGElementGroupLine = (SGElementGroupLine)sGElementGroup;
            ArrayList arrayList2 = this.calcLocationOfTimingLine(sGAxis, d);
            sGElementGroupLine.createDrawingElement(arrayList2);
        }
        return true;
    }

    protected boolean synchronizeToLegendElement(SGILegendElement sGILegendElement) {
        ArrayList arrayList = sGILegendElement.getDataList();
        if (arrayList.size() != this.mDataList.size()) {
            throw new Error("dataList.size() != this.mDataList.size()");
        }
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        ArrayList<SGElementGroupSet> arrayList3 = new ArrayList<SGElementGroupSet>();
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            SGData sGData = (SGData)arrayList.get(i);
            for (int j = this.mDataList.size() - 1; j >= 0; --j) {
                SGData sGData2 = (SGData)this.mDataList.get(j);
                if (!sGData.equals(sGData2)) continue;
                SGData sGData3 = (SGData)this.mDataList.remove(j);
                arrayList2.add(sGData3);
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.remove(j);
                arrayList3.add(sGElementGroupSet);
                continue block0;
            }
        }
        this.mDataList = arrayList2;
        this.mGroupSetList = arrayList3;
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error("");
    }

    private ArrayList calcLocationOfTimingLine(SGAxis sGAxis, double d) {
        float f;
        SGDrawingElementLine2D sGDrawingElementLine2D = new SGDrawingElementLine2D(new SGTuple2f(), new SGTuple2f(), 2.0f);
        ArrayList arrayList = this.mAxisElement.getHorizontalAxisList();
        ArrayList arrayList2 = this.mAxisElement.getPerpendicularAxisList();
        Boolean bl = null;
        if (arrayList.contains(sGAxis)) {
            bl = new Boolean(true);
        }
        if (arrayList2.contains(sGAxis)) {
            bl = new Boolean(false);
        }
        if (bl == null) {
            throw new Error("\u8ef8\u304c\u4e00\u81f4\u3057\u306a\u3044");
        }
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (bl.booleanValue()) {
            sGTuple2f.x = f = this.calcLocation(d, sGAxis, true);
            sGTuple2f.y = this.getHeight();
            sGTuple2f2.x = f;
            sGTuple2f2.y = 0.0f;
        } else {
            f = this.calcLocation(d, sGAxis, false);
            sGTuple2f.x = 0.0f;
            sGTuple2f.y = f;
            sGTuple2f2.x = this.getWidth();
            sGTuple2f2.y = f;
        }
        ArrayList<SGTuple2f> arrayList3 = new ArrayList<SGTuple2f>();
        arrayList3.add(sGTuple2f);
        arrayList3.add(sGTuple2f2);
        return arrayList3;
    }

    protected boolean isInsideAxisRange(SGTuple2d sGTuple2d, SGAxis sGAxis, SGAxis sGAxis2) {
        return sGAxis.insideRange(sGTuple2d.x) && sGAxis2.insideRange(sGTuple2d.y);
    }

    protected boolean calcLocationOfSXYData(SGTuple2d[] sGTuple2dArray, SGAxis sGAxis, SGAxis sGAxis2, ArrayList arrayList) {
        int n;
        float f = this.mGraphAreaX;
        float f2 = this.mGraphAreaY;
        float f3 = this.mGraphAreaWidth;
        float f4 = this.mGraphAreaHeight;
        SGTuple2d sGTuple2d = sGAxis.getRange();
        SGTuple2d sGTuple2d2 = sGAxis2.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = sGTuple2d2.x;
        double d4 = sGTuple2d2.y;
        int n2 = sGAxis.getScaleType();
        int n3 = sGAxis2.getScaleType();
        int n4 = sGTuple2dArray.length;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n5 = sGTuple2dArray.length;
        SGTuple2d[] sGTuple2dArray2 = new SGTuple2d[n5];
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        if (n2 == 0) {
            d5 = d;
            d6 = d2;
            for (n = 0; n < n5; ++n) {
                dArray[n] = sGTuple2dArray[n].x;
            }
        } else if (n2 == 1) {
            d5 = Math.log(d);
            d6 = Math.log(d2);
            for (n = 0; n < n5; ++n) {
                dArray[n] = Math.log(sGTuple2dArray[n].x);
            }
        }
        if (n3 == 0) {
            d7 = d3;
            d8 = d4;
            for (n = 0; n < n5; ++n) {
                dArray2[n] = sGTuple2dArray[n].y;
            }
        } else if (n3 == 1) {
            d7 = Math.log(d3);
            d8 = Math.log(d4);
            for (n = 0; n < n5; ++n) {
                dArray2[n] = Math.log(sGTuple2dArray[n].y);
            }
        }
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n5];
        for (int i = 0; i < n5; ++i) {
            if (n2 == 1 && (Double.isInfinite(dArray[i]) || Double.isNaN(dArray[i])) || n3 == 1 && (Double.isInfinite(dArray2[i]) || Double.isNaN(dArray2[i]))) continue;
            float f5 = (float)((dArray[i] - d5) / (d6 - d5));
            float f6 = (float)(1.0 - (dArray2[i] - d7) / (d8 - d7));
            float f7 = f + f5 * f3;
            float f8 = f2 + f6 * f4;
            SGTuple2f sGTuple2f = new SGTuple2f(f7, f8);
            arrayList.add(sGTuple2f);
        }
        return true;
    }

    protected boolean calcLocationOfVXYData(SGTuple2d[] sGTuple2dArray, SGTuple2d[] sGTuple2dArray2, SGAxis sGAxis, SGAxis sGAxis2, ArrayList arrayList, ArrayList arrayList2) {
        int n;
        int n2;
        if (sGTuple2dArray.length != sGTuple2dArray2.length) {
            throw new Error();
        }
        SGTuple2d sGTuple2d = sGAxis.getRange();
        SGTuple2d sGTuple2d2 = sGAxis2.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = sGTuple2d2.x;
        double d4 = sGTuple2d2.y;
        int n3 = sGAxis.getScaleType();
        int n4 = sGAxis2.getScaleType();
        int n5 = sGTuple2dArray.length;
        boolean[] blArray = new boolean[n5];
        boolean[] blArray2 = new boolean[n5];
        for (int i = 0; i < n5; ++i) {
            blArray[i] = this.isInsideAxisRange(sGTuple2dArray[i], sGAxis, sGAxis2);
            blArray2[i] = this.isInsideAxisRange(sGTuple2dArray2[i], sGAxis, sGAxis2);
        }
        ArrayList<SGTuple2d> arrayList3 = new ArrayList<SGTuple2d>();
        ArrayList<SGTuple2d> arrayList4 = new ArrayList<SGTuple2d>();
        for (int i = 0; i < n5; ++i) {
            if (!blArray[i] && !blArray2[i]) continue;
            arrayList3.add(sGTuple2dArray[i]);
            arrayList4.add(sGTuple2dArray2[i]);
        }
        SGTuple2d[] sGTuple2dArray3 = new SGTuple2d[arrayList3.size()];
        SGTuple2d[] sGTuple2dArray4 = new SGTuple2d[arrayList4.size()];
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            sGTuple2dArray3[n2] = (SGTuple2d)arrayList3.get(n2);
            sGTuple2dArray4[n2] = (SGTuple2d)arrayList4.get(n2);
        }
        n2 = sGTuple2dArray3.length;
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n2];
        for (int i = 0; i < n2; ++i) {
            double d5 = sGTuple2dArray3[i].x;
            double d6 = sGTuple2dArray3[i].y;
            sGTuple2fArray[i] = new SGTuple2f();
            sGTuple2fArray[i].x = (float)((d5 - d) / (d2 - d));
            sGTuple2fArray[i].y = (float)(1.0 - (d6 - d3) / (d4 - d3));
        }
        SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[n2];
        for (n = 0; n < n2; ++n) {
            double d7 = sGTuple2dArray4[n].x;
            double d8 = sGTuple2dArray4[n].y;
            sGTuple2fArray2[n] = new SGTuple2f();
            sGTuple2fArray2[n].x = (float)((d7 - d) / (d2 - d));
            sGTuple2fArray2[n].y = (float)(1.0 - (d8 - d3) / (d4 - d3));
        }
        for (n = 0; n < n2; ++n) {
            float f = this.mGraphAreaX + sGTuple2fArray[n].x * this.mGraphAreaWidth;
            float f2 = this.mGraphAreaY + sGTuple2fArray[n].y * this.mGraphAreaHeight;
            SGTuple2f sGTuple2f = new SGTuple2f(f, f2);
            arrayList.add(sGTuple2f);
        }
        for (n = 0; n < n2; ++n) {
            float f = this.mGraphAreaX + sGTuple2fArray2[n].x * this.mGraphAreaWidth;
            float f3 = this.mGraphAreaY + sGTuple2fArray2[n].y * this.mGraphAreaHeight;
            SGTuple2f sGTuple2f = new SGTuple2f(f, f3);
            arrayList2.add(sGTuple2f);
        }
        return true;
    }

    public boolean hasSelectedData() {
        return this.mSelectedGroupSetList.size() != 0;
    }

    protected boolean clickeElementGroupSet(MouseEvent mouseEvent, ElementGroupSetInGraph elementGroupSetInGraph) {
        boolean bl = elementGroupSetInGraph.contains(mouseEvent.getX(), mouseEvent.getY());
        if (!bl) {
            return false;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.clearSelectedElementsGroupSet();
            elementGroupSetInGraph.showPropertyDialog();
            return true;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
            elementGroupSetInGraph.mPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            this.repaint();
            return true;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1 && ((mouseEvent.getModifiers() & 2) != 0 || (mouseEvent.getModifiers() & 1) != 0)) {
            if (this.mSelectedGroupSetList.contains(elementGroupSetInGraph)) {
                this.removeSelectedGroupSet(elementGroupSetInGraph);
            } else {
                ArrayList<ElementGroupSetInGraph> arrayList = new ArrayList<ElementGroupSetInGraph>(this.mSelectedGroupSetList);
                arrayList.add(elementGroupSetInGraph);
                this.clearSelectedElementsGroupSet();
                for (int i = 0; i < arrayList.size(); ++i) {
                    ElementGroupSetInGraph elementGroupSetInGraph2 = (ElementGroupSetInGraph)arrayList.get(i);
                    this.addSelectedGroupSet(elementGroupSetInGraph2);
                }
            }
            this.repaint();
            return true;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1 && (mouseEvent.getModifiers() & 2) == 0 && (mouseEvent.getModifiers() & 1) == 0) {
            if (this.mSelectedGroupSetList.contains(elementGroupSetInGraph)) {
                this.removeSelectedGroupSet(elementGroupSetInGraph);
            } else {
                this.clearSelectedElementsGroupSet();
                this.addSelectedGroupSet(elementGroupSetInGraph);
            }
            this.repaint();
            return true;
        }
        return false;
    }

    protected boolean moveGroupSetToFront(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        if (sGData == null) {
            return false;
        }
        this.mGroupSetList.add(this.mGroupSetList.size(), sGElementGroupSet);
        this.mDataList.add(this.mDataList.size(), sGData);
        return true;
    }

    protected boolean moveGroupSetToBack(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        if (sGData == null) {
            return false;
        }
        this.mGroupSetList.add(0, sGElementGroupSet);
        this.mDataList.add(0, sGData);
        return true;
    }

    protected boolean removeGroupSet(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            this.mDataList.remove(i);
            return true;
        }
        return false;
    }

    public boolean hideSelectedData() {
        if (this.mSelectedGroupSetList.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.mSelectedGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mSelectedGroupSetList.get(i);
            sGElementGroupSet.setVisible(false);
        }
        this.mSelectedGroupSetList.clear();
        this.updateHistory();
        this.notifyChange();
        this.repaint();
        return true;
    }

    public boolean isDataVisible(SGData sGData) {
        SGElementGroupSet sGElementGroupSet = this.getElementGroupSet(sGData);
        return sGElementGroupSet.isVisible();
    }

    public boolean removeSelectedData() {
        if (this.mSelectedGroupSetList.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.mSelectedGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mSelectedGroupSetList.get(i);
            this.removeGroupSet(sGElementGroupSet);
        }
        this.notifyChange();
        this.repaint();
        return true;
    }

    public boolean moveSelectedDataToFront() {
        SGElementGroupSet sGElementGroupSet;
        int n;
        if (this.mSelectedGroupSetList.size() == 0) {
            return true;
        }
        for (n = this.mSelectedGroupSetList.size() - 1; n >= 0; --n) {
            sGElementGroupSet = (SGElementGroupSet)this.mSelectedGroupSetList.get(n);
            this.moveGroupSetToFront(sGElementGroupSet);
        }
        this.mSelectedGroupSetList.clear();
        for (n = 0; n < this.mGroupSetList.size(); ++n) {
            sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(n);
            sGElementGroupSet.setVisible(true);
        }
        this.notifyChange();
        this.repaint();
        return true;
    }

    public boolean moveSelectedDataToBack() {
        SGElementGroupSet sGElementGroupSet;
        int n;
        if (this.mSelectedGroupSetList.size() == 0) {
            return true;
        }
        for (n = this.mSelectedGroupSetList.size() - 1; n >= 0; --n) {
            sGElementGroupSet = (SGElementGroupSet)this.mSelectedGroupSetList.get(n);
            this.moveGroupSetToBack(sGElementGroupSet);
        }
        this.mSelectedGroupSetList.clear();
        for (n = 0; n < this.mGroupSetList.size(); ++n) {
            sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(n);
            sGElementGroupSet.setVisible(true);
        }
        this.notifyChange();
        this.repaint();
        return true;
    }

    protected SGElementGroupSet getElementGroupSet(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(i);
            return sGElementGroupSet;
        }
        return null;
    }

    protected SGData getData(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet2 = (SGElementGroupSet)this.mGroupSetList.get(i);
            if (!sGElementGroupSet2.equals(sGElementGroupSet)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    private boolean addSelectedGroupSet(SGElementGroupSet sGElementGroupSet) {
        this.mSelectedGroupSetList.add(sGElementGroupSet);
        sGElementGroupSet.mSelectedFlag = true;
        return true;
    }

    private boolean removeSelectedGroupSet(SGElementGroupSet sGElementGroupSet) {
        this.mSelectedGroupSetList.remove(sGElementGroupSet);
        sGElementGroupSet.mSelectedFlag = false;
        sGElementGroupSet.setVisible(true);
        return true;
    }

    private boolean clearSelectedElementsGroupSet() {
        for (int i = this.mSelectedGroupSetList.size() - 1; i >= 0; --i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mSelectedGroupSetList.get(i);
            this.removeSelectedGroupSet(sGElementGroupSet);
        }
        return true;
    }

    public ArrayList getPropertySettingListerListOfDataElements() {
        return this.mSelectedGroupSetList;
    }

    public SGPropertyDialog getPropertyDialogForDataElements() {
        return mPropertyDialogForData;
    }

    protected boolean drawEmphasisSymol(Graphics2D graphics2D, Point2D point2D) {
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)point2D.getX() - 3.0f, (float)point2D.getY() - 3.0f, 6.0f, 6.0f);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fill(float_);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.draw(float_);
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        ActionListener actionListener;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.clickDrawingElements(mouseEvent)) {
            return true;
        }
        this.clearSelectedElementsGroupSet();
        this.repaint();
        for (n = this.mSignificantDifferentSymbolsList.size() - 1; n >= 0; --n) {
            actionListener = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(n);
            if (!((SigDiffSymbol)actionListener).isVisible()) continue;
            if (((SGSignificantDifferenceSymbol)((Object)actionListener)).contains(n2, n3)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    return true;
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    JDialog jDialog = ((SigDiffSymbol)actionListener).getDialog();
                    jDialog.show();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    JPopupMenu jPopupMenu = ((SigDiffSymbol)actionListener).getPopupMenu();
                    jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                }
                return true;
            }
            if (!((SigDiffSymbol)actionListener).mStringElement.contains(n2, n3)) continue;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                this.mFocusedSymbol = actionListener;
                this.mFocusedX = this.getX();
                this.mFocusedY = this.getY();
                this.showEditField((SigDiffSymbol)actionListener);
                this.repaint();
            }
            return true;
        }
        for (n = this.mTimingElementGroupSetList.size() - 1; n >= 0; --n) {
            actionListener = (TimingElementGroupSetInGraph)this.mTimingElementGroupSetList.get(n);
            if (!((SGElementGroupSet)((Object)actionListener)).isVisible() || !((TimingElementGroupSetInGraph)actionListener).clickDrawingElements(mouseEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean clickDrawingElements(MouseEvent mouseEvent) {
        for (int i = this.mGroupSetList.size() - 1; i >= 0; --i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            ArrayList arrayList = elementGroupSetInGraph.mDrawingElementGroupList;
            if (!this.clickeElementGroupSet(mouseEvent, elementGroupSetInGraph)) continue;
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        for (int i = this.mSignificantDifferentSymbolsList.size() - 1; i >= 0; --i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            if (!sigDiffSymbol.isVisible() || !sigDiffSymbol.pressDrawingElements(mouseEvent)) continue;
            this.mFocusedSymbol = sigDiffSymbol;
            this.mPressedSymbolOrigin = new Point((int)((float)mouseEvent.getX() - sigDiffSymbol.getX()), (int)((float)mouseEvent.getY() - sigDiffSymbol.getY()));
            this.repaint();
            return true;
        }
        if (this.mEditField.isVisible()) {
            this.terminateEditField();
        }
        this.clearFocusedSymbol();
        this.repaint();
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mFocusedSymbol != null) {
            if (!this.mFocusedSymbol.drag(mouseEvent)) {
                return false;
            }
            this.drawBackSigDiffSymbol(this.mFocusedSymbol);
            this.mFocusedSymbol.createDrawingElement();
            this.repaint();
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        if (this.mFocusedSymbol != null) {
            if (this.mFocusedSymbol.isChanged()) {
                this.mFocusedSymbol.updateHistory();
            }
            this.repaint();
        }
        return true;
    }

    public boolean onKeyPressed(KeyEvent keyEvent) {
        return true;
    }

    public boolean onKeyReleased(KeyEvent keyEvent) {
        return true;
    }

    public boolean onKeyTyped(KeyEvent keyEvent) {
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            if (!sigDiffSymbol.isVisible() || !sigDiffSymbol.onDrawingElement(n, n2)) continue;
            if (sigDiffSymbol.equals(this.mFocusedSymbol)) {
                sigDiffSymbol.setMouseLocation(n, n2);
                this.mCursor = sigDiffSymbol.getCursor();
                this.repaint();
                return true;
            }
            this.mCursor = new Cursor(12);
            this.repaint();
            return true;
        }
        if (!this.isInsideGraphArea(n, n2)) {
            return false;
        }
        this.repaint();
        return false;
    }

    public boolean addSignificantDifferenceSymbol(int n, int n2) {
        SigDiffSymbol sigDiffSymbol = new SigDiffSymbol();
        sigDiffSymbol.zoom(this.mMagnification);
        sigDiffSymbol.setLocation(n, n2);
        sigDiffSymbol.createDrawingElement();
        this.mSignificantDifferentSymbolsList.add(sigDiffSymbol);
        this.updateHistory();
        sigDiffSymbol.addPropertiesHistory();
        return true;
    }

    protected boolean clipGraphArea(Graphics2D graphics2D) {
        if (this.mViewBounds == null) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphAreaRect();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        Rectangle2D.intersect(rectangle2D, this.mViewBounds, float_);
        graphics2D.setClip(float_);
        return true;
    }

    protected boolean drawTimingElements(Graphics2D graphics2D) {
        for (int i = 0; i < this.mTimingElementGroupSetList.size(); ++i) {
            TimingElementGroupSetInGraph timingElementGroupSetInGraph = (TimingElementGroupSetInGraph)this.mTimingElementGroupSetList.get(i);
            ArrayList arrayList = timingElementGroupSetInGraph.mDrawingElementGroupList;
            for (int j = 0; j < arrayList.size(); ++j) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(j);
                sGElementGroup.paintElement(graphics2D);
            }
        }
        return true;
    }

    protected boolean moveTimingElementGroupSetToFront(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mTimingElementGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mTimingElementGroupSetList.get(i))) continue;
            this.mTimingElementGroupSetList.remove(i);
            break;
        }
        this.mTimingElementGroupSetList.add(this.mTimingElementGroupSetList.size(), sGElementGroupSet);
        return true;
    }

    protected boolean moveTimingElementGroupSetToBack(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mTimingElementGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mTimingElementGroupSetList.get(i))) continue;
            this.mTimingElementGroupSetList.remove(i);
            break;
        }
        this.mTimingElementGroupSetList.add(0, sGElementGroupSet);
        return true;
    }

    protected boolean removeTimingElementGroupSet(SGElementGroupSet sGElementGroupSet) {
        this.mTimingElementGroupSetList.remove(sGElementGroupSet);
        this.updateHistory();
        return false;
    }

    protected boolean drawRectangle(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        Line2D.Double double_ = new Line2D.Double(d, d3, d2, d3);
        Line2D.Double double_2 = new Line2D.Double(d, d4, d2, d4);
        Line2D.Double double_3 = new Line2D.Double(d, d3, d, d4);
        Line2D.Double double_4 = new Line2D.Double(d2, d3, d2, d4);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
        graphics2D.draw(double_3);
        graphics2D.draw(double_4);
        return true;
    }

    public boolean changeXAxis(SGData sGData) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            this.changeXAxis(elementGroupSetInGraph);
            return true;
        }
        return false;
    }

    public boolean changeYAxis(SGData sGData) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            this.changeYAxis(elementGroupSetInGraph);
            return true;
        }
        return false;
    }

    public boolean changeZAxis(SGData sGData) {
        return true;
    }

    protected boolean changeXAxis(ElementGroupSetInGraph elementGroupSetInGraph) {
        SGAxis sGAxis = elementGroupSetInGraph.mXAxis;
        ArrayList arrayList = this.mAxisElement.getXAxisList();
        SGAxis sGAxis2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGAxis sGAxis3 = (SGAxis)arrayList.get(i);
            if (sGAxis != sGAxis3) continue;
            sGAxis2 = (SGAxis)arrayList.get((i + 1) % arrayList.size());
            break;
        }
        sGAxis = sGAxis2;
        elementGroupSetInGraph.mXAxis = sGAxis2;
        return true;
    }

    protected boolean changeYAxis(ElementGroupSetInGraph elementGroupSetInGraph) {
        SGAxis sGAxis = elementGroupSetInGraph.mYAxis;
        ArrayList arrayList = this.mAxisElement.getYAxisList();
        SGAxis sGAxis2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGAxis sGAxis3 = (SGAxis)arrayList.get(i);
            if (sGAxis != sGAxis3) continue;
            sGAxis2 = (SGAxis)arrayList.get((i + 1) % arrayList.size());
            break;
        }
        sGAxis = sGAxis2;
        elementGroupSetInGraph.mYAxis = sGAxis2;
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals(REMOVE_SELECTED_GRAPH)) {
            this.removeSelectedData();
        }
        if (object.equals(this.mEditField)) {
            this.terminateEditField();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        String string = this.mEditField.getText();
        System.out.println("@" + string + "@");
        if (this.mFocusedSymbol != null) {
            Font font = new Font(this.mFocusedSymbol.getFontFamilyName(), this.mFocusedSymbol.getFontStyle(), (int)(this.mFocusedSymbol.getFontSize() * this.getMagnification()));
            Rectangle2D rectangle2D = font.getStringBounds(string, new FontRenderContext(null, false, false));
            double d = rectangle2D.getWidth();
            if (d > (double)this.mEditField.getWidth()) {
                this.mEditField.setSize((int)(rectangle2D.getWidth() + (double)(this.getMagnification() * this.mFocusedSymbol.getFontSize())), this.mEditField.getHeight());
            }
            this.repaint();
        }
    }

    private boolean setSigDiffProperty(BufferedReader bufferedReader, SigDiffSymbol sigDiffSymbol) throws IOException {
        SigDiffProperties sigDiffProperties = this.readPropertiesOfSigDiffSymbol(bufferedReader);
        if (sigDiffProperties == null) {
            return false;
        }
        return sigDiffSymbol.setProperties(sigDiffProperties);
    }

    public boolean readProperty(BufferedReader bufferedReader) throws IOException {
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return false;
        }
        bufferedReader.mark(256);
        while (true) {
            if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                return false;
            }
            if (!string.equals("<Significant Difference Symbol>")) break;
            SigDiffProperties sigDiffProperties = this.readPropertiesOfSigDiffSymbol(bufferedReader);
            if (sigDiffProperties == null) {
                return false;
            }
            SigDiffSymbol sigDiffSymbol = new SigDiffSymbol();
            if (!sigDiffSymbol.setProperties(sigDiffProperties)) {
                return false;
            }
            sigDiffSymbol.createDrawingElement();
            this.mSignificantDifferentSymbolsList.add(sigDiffSymbol);
            sigDiffSymbol.addPropertiesHistory();
            bufferedReader.mark(256);
        }
        bufferedReader.reset();
        return true;
    }

    public boolean writeProperty(Writer writer) throws IOException {
        writer.write("[Graph]\n");
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            sigDiffSymbol.writeProperty(writer);
        }
        writer.write("\n");
        return true;
    }

    public boolean writePropertyOfData(Writer writer) throws IOException {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            writer.write("[Data]\n");
            SGData sGData = (SGData)this.mDataList.get(i);
            String string = null;
            if (sGData instanceof SGSXYData) {
                string = "SXY";
            } else if (sGData instanceof SGVXYData) {
                string = "VXY";
            } else if (sGData instanceof SGSXYMultipleData) {
                string = sGData instanceof SGSXYSamplingData ? "SXY_SAMPLING" : "SXY_MULTIPLE";
            } else {
                return false;
            }
            SGUtilityText.writePropertyLine(writer, "Class Name", string);
            ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
            elementGroupSetInGraph.writePropertyOfData(writer);
        }
        writer.write("\n\n");
        return true;
    }

    public SGProperties getProperties() {
        GraphProperties graphProperties = new GraphProperties();
        if (!this.getProperties(graphProperties)) {
            return null;
        }
        return graphProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        GraphProperties graphProperties = (GraphProperties)sGProperties;
        graphProperties.visibleElementGroupList = this.getVisibleElementGroupList();
        graphProperties.visibleTimingElementList = this.getVisibleTimingElementList();
        graphProperties.visibleSigDiffSymbolList = this.getVisibleSigDiffSymbolList();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        GraphProperties graphProperties = (GraphProperties)sGProperties;
        boolean bl = this.setVisibleElementGroupList(graphProperties.visibleElementGroupList);
        if (!bl) {
            return false;
        }
        bl = this.setVisibleTimingElements(graphProperties.visibleTimingElementList);
        if (!bl) {
            return false;
        }
        bl = this.setVisibleSigDiffSymbols(graphProperties.visibleSigDiffSymbolList);
        return bl;
    }

    protected ArrayList getVisibleElementGroupList() {
        ArrayList<SGElementGroupSet> arrayList = new ArrayList<SGElementGroupSet>();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(i);
            if (!sGElementGroupSet.isVisible()) continue;
            arrayList.add(sGElementGroupSet);
        }
        return arrayList;
    }

    protected ArrayList getVisibleTimingElementList() {
        ArrayList<SGElementGroupSet> arrayList = new ArrayList<SGElementGroupSet>();
        for (int i = 0; i < this.mTimingElementGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mTimingElementGroupSetList.get(i);
            if (!sGElementGroupSet.isVisible()) continue;
            arrayList.add(sGElementGroupSet);
        }
        return arrayList;
    }

    protected ArrayList getVisibleSigDiffSymbolList() {
        ArrayList<SigDiffSymbol> arrayList = new ArrayList<SigDiffSymbol>();
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            if (!sigDiffSymbol.isVisible()) continue;
            arrayList.add(sigDiffSymbol);
        }
        return arrayList;
    }

    protected boolean setVisibleElementGroupList(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(i);
            sGElementGroupSet.setVisible(arrayList.contains(sGElementGroupSet));
        }
        return true;
    }

    protected boolean setVisibleTimingElements(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        for (int i = 0; i < this.mTimingElementGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mTimingElementGroupSetList.get(i);
            sGElementGroupSet.setVisible(arrayList.contains(sGElementGroupSet));
        }
        return true;
    }

    protected boolean setVisibleSigDiffSymbols(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            sigDiffSymbol.setVisible(arrayList.contains(sigDiffSymbol));
        }
        return true;
    }

    private boolean updateParentHistoryFromElementGroupSet(SGIUndoable sGIUndoable) {
        this.updateParentHistory();
        this.updateObjectHistory(sGIUndoable);
        return true;
    }

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        boolean bl = super.addPropertiesHistory(sGProperties);
        return bl;
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        this.repaint();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        this.repaint();
        return true;
    }

    private SigDiffProperties readPropertiesOfSigDiffSymbol(BufferedReader bufferedReader) throws IOException {
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, "X");
        if (d == null) {
            return null;
        }
        float f = d.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Y");
        if (d2 == null) {
            return null;
        }
        float f2 = d2.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Width");
        if (d3 == null) {
            return null;
        }
        float f3 = d3.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Left Height");
        if (d4 == null) {
            return null;
        }
        float f4 = d4.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d5 = SGUtilityText.getDoublePropertyFromLine(string, "Right Height");
        if (d5 == null) {
            return null;
        }
        float f5 = d5.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getStringPropertyFromLine(string, "Text");
        if (string2 == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string3 = SGUtilityText.getPropertyFromLine(string, "Font Family Name");
        if (string3 == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d6 = SGUtilityText.getDoublePropertyFromLine(string, "Font Size");
        if (d6 == null) {
            return null;
        }
        float f6 = d6.floatValue();
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Integer n = SGUtilityText.getFontStyleFromLine(string, "Font Style");
        if (n == null) {
            return null;
        }
        int n2 = n;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        ArrayList arrayList = SGUtilityText.getColorListFromLine(string, "Color List");
        if (arrayList == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d7 = SGUtilityText.getDoublePropertyFromLine(string, "Line Width");
        if (d7 == null) {
            return null;
        }
        float f7 = d7.floatValue();
        SigDiffProperties sigDiffProperties = new SigDiffProperties();
        sigDiffProperties.x = f;
        sigDiffProperties.y = f2;
        sigDiffProperties.width = f3;
        sigDiffProperties.leftHeight = f4;
        sigDiffProperties.rightHeight = f5;
        sigDiffProperties.text = string2;
        sigDiffProperties.fontFamilyName = string3;
        sigDiffProperties.fontSize = f6;
        sigDiffProperties.fontStyle = n2;
        sigDiffProperties.colorList = arrayList;
        sigDiffProperties.lineWidth = f7;
        return sigDiffProperties;
    }

    protected boolean drawSignificantDifferenceSymbolAnchor(Graphics2D graphics2D, ArrayList arrayList) {
        if (graphics2D == null || arrayList == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            sigDiffSymbol.drawAllAnchors(graphics2D);
        }
        return true;
    }

    private boolean updateParentHistoryFromStringElement(SigDiffSymbol sigDiffSymbol) {
        this.updateParentHistory();
        this.updateObjectHistory(sigDiffSymbol);
        return true;
    }

    public static class GraphProperties
    extends SGProperties {
        ArrayList visibleElementGroupList = new ArrayList();
        ArrayList visibleTimingElementList = new ArrayList();
        ArrayList visibleSigDiffSymbolList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof GraphProperties)) {
                return false;
            }
            GraphProperties graphProperties = (GraphProperties)object;
            if (!graphProperties.visibleElementGroupList.equals(this.visibleElementGroupList)) {
                return false;
            }
            if (!graphProperties.visibleTimingElementList.equals(this.visibleTimingElementList)) {
                return false;
            }
            return graphProperties.visibleSigDiffSymbolList.equals(this.visibleSigDiffSymbolList);
        }

        public String toString() {
            String string = new String("[");
            string = string + this.visibleElementGroupList.toString();
            string = string + this.visibleTimingElementList.toString();
            string = string + this.visibleSigDiffSymbolList.toString();
            string = string + new String("]");
            return string;
        }
    }

    public static class SigDiffProperties
    extends SGProperties {
        float x;
        float y;
        float width;
        float leftHeight;
        float rightHeight;
        float space;
        float lineWidth;
        String text;
        String fontFamilyName;
        float fontSize;
        int fontStyle;
        ArrayList colorList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof SigDiffProperties)) {
                return false;
            }
            SigDiffProperties sigDiffProperties = (SigDiffProperties)object;
            if (sigDiffProperties.x != this.x) {
                return false;
            }
            if (sigDiffProperties.y != this.y) {
                return false;
            }
            if (sigDiffProperties.width != this.width) {
                return false;
            }
            if (sigDiffProperties.leftHeight != this.leftHeight) {
                return false;
            }
            if (sigDiffProperties.rightHeight != this.rightHeight) {
                return false;
            }
            if (sigDiffProperties.space != this.space) {
                return false;
            }
            if (sigDiffProperties.lineWidth != this.lineWidth) {
                return false;
            }
            if (!sigDiffProperties.text.equals(this.text)) {
                return false;
            }
            if (!sigDiffProperties.fontFamilyName.equals(this.fontFamilyName)) {
                return false;
            }
            if (sigDiffProperties.fontSize != this.fontSize) {
                return false;
            }
            if (sigDiffProperties.fontStyle != this.fontStyle) {
                return false;
            }
            return sigDiffProperties.colorList.equals(this.colorList);
        }
    }

    class SigDiffSymbol
    extends SGSignificantDifferenceSymbol
    implements ActionListener,
    WindowListener,
    SGIUndoable {
        private boolean mVisible = true;
        private SGProperties mTemporaryProperties = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private final String REMOVE_SYMBOL = "Remove this Symbol";
        private int mMouseLocation;
        protected final int OTHER = 0;
        protected final int NORTH = 1;
        protected final int SOUTH = 2;
        protected final int WEST = 3;
        protected final int EAST = 4;
        protected final int NORTH_WEST = 5;
        protected final int NORTH_EAST = 6;
        protected final int SOUTH_WEST = 7;
        protected final int SOUTH_EAST = 8;
        protected final int ON_STRING = 9;
        protected Point mPressedPoint = null;
        private ArrayList mStringElementPropertyHistoryList = new ArrayList();
        private int mStringElementStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();

        protected SigDiffSymbol() {
            this.init();
        }

        protected SigDiffSymbol(float f, float f2, float f3, float f4, float f5) {
            super(f, f2, f3, f4, f5);
            this.init();
        }

        private boolean createPopupMenu() {
            this.mPopupMenu.setBounds(0, 0, 100, 100);
            String[] stringArray = new String[]{"Remove this Symbol"};
            for (int i = 0; i < stringArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
                jMenuItem.addActionListener(this);
                this.mPopupMenu.add(jMenuItem);
            }
            return true;
        }

        private boolean init() {
            this.setWidth(28.346458f);
            this.setLeftHeight(28.346458f);
            this.setRightHeight(28.346458f);
            this.setFontFamilyName("Serif");
            this.setFontSize(24.0f);
            int n = SGUtilityText.getFontStyle("Plain");
            if (n == -1) {
                return false;
            }
            this.setFontStyle(n);
            this.setLineWidth(1.0f);
            this.setColor(SGDefaultValues.SIGDIFF_SYMBOL_COLOR);
            this.setSpace(0.0f);
            this.createPopupMenu();
            return true;
        }

        private JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        private JDialog getDialog() {
            SGGraphElement.this.mSigDiffDialog.setActionListener(this);
            SGGraphElement.this.mSigDiffDialog.addWindowListener(this);
            SGGraphElement.this.mSigDiffDialog.setLocation(SGGraphElement.this.mDialogOwner.getLocation());
            SGGraphElement.this.mSigDiffDialog.setColorButtonBorder(true);
            this.setDialogProperty();
            this.mTemporaryProperties = this.getProperties();
            SGGraphElement.this.mEditField.setVisible(false);
            SGGraphElement.this.repaint();
            return SGGraphElement.this.mSigDiffDialog;
        }

        public boolean writeProperty(Writer writer) throws IOException {
            writer.write("<Significant Difference Symbol>\n");
            SGUtilityText.writePropertyLine(writer, "X", new Float(this.mX * 0.035277776f));
            SGUtilityText.writePropertyLine(writer, "Y", new Float(this.mY * 0.035277776f));
            SGUtilityText.writePropertyLine(writer, "Width", new Float(this.mWidth * 0.035277776f));
            SGUtilityText.writePropertyLine(writer, "Left Height", new Float(this.mLeftHeight * 0.035277776f));
            SGUtilityText.writePropertyLine(writer, "Right Height", new Float(this.mRightHeight * 0.035277776f));
            SGUtilityText.writeStringPropertyLine(writer, "Text", this.getText());
            SGUtilityText.writePropertyLine(writer, "Font Family Name", this.getFontFamilyName());
            SGUtilityText.writePropertyLine(writer, "Font Size", new Float(this.getFontSize()));
            SGUtilityText.writePropertyLine(writer, "Font Style", SGUtilityText.getFontStyleName(this.getFontStyle()));
            SGUtilityText.writeColorListPropertyLine(writer, "Color List", this.getColorList());
            SGUtilityText.writePropertyLine(writer, "Line Width", new Float(this.getLineWidth()));
            writer.write("\n");
            return true;
        }

        private SigDiffProperties getPropertiesFromDialg() {
            SGSignificantDifferenceSymbolDialog sGSignificantDifferenceSymbolDialog = SGGraphElement.this.mSigDiffDialog;
            SigDiffProperties sigDiffProperties = sGSignificantDifferenceSymbolDialog.getProperties();
            if (sigDiffProperties == null) {
                return null;
            }
            sigDiffProperties.x = this.mX;
            sigDiffProperties.y = this.mY;
            sigDiffProperties.width = this.mWidth;
            sigDiffProperties.leftHeight = this.mLeftHeight;
            sigDiffProperties.rightHeight = this.mRightHeight;
            sigDiffProperties.text = this.getText();
            return sigDiffProperties;
        }

        private boolean setDialogProperty() {
            SGSignificantDifferenceSymbolDialog sGSignificantDifferenceSymbolDialog = SGGraphElement.this.mSigDiffDialog;
            sGSignificantDifferenceSymbolDialog.setSpace(this.mSpace * 0.035277776f);
            sGSignificantDifferenceSymbolDialog.setFontSize(this.getFontSize());
            sGSignificantDifferenceSymbolDialog.setFontFamilyName(this.getFontFamilyName());
            sGSignificantDifferenceSymbolDialog.setFontStyle(this.getFontStyle());
            sGSignificantDifferenceSymbolDialog.setLineWidth(this.getLineWidth());
            sGSignificantDifferenceSymbolDialog.setColorList(this.getColorList());
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (sGProperties == null) {
                return false;
            }
            if (!(sGProperties instanceof SigDiffProperties)) {
                return false;
            }
            SigDiffProperties sigDiffProperties = (SigDiffProperties)sGProperties;
            this.mX = sigDiffProperties.x;
            this.mY = sigDiffProperties.y;
            this.setSize(sigDiffProperties.width, sigDiffProperties.leftHeight, sigDiffProperties.rightHeight);
            this.setText(sigDiffProperties.text);
            this.setSpace(sigDiffProperties.space);
            this.setFontFamilyName(sigDiffProperties.fontFamilyName);
            this.setFontSize(sigDiffProperties.fontSize);
            this.setFontStyle(sigDiffProperties.fontStyle);
            this.setLineWidth(sigDiffProperties.lineWidth);
            this.setColorList(sigDiffProperties.colorList);
            return true;
        }

        public SGProperties getProperties() {
            SigDiffProperties sigDiffProperties = new SigDiffProperties();
            sigDiffProperties.x = this.mX;
            sigDiffProperties.y = this.mY;
            sigDiffProperties.width = this.mWidth;
            sigDiffProperties.leftHeight = this.mLeftHeight;
            sigDiffProperties.rightHeight = this.mRightHeight;
            sigDiffProperties.text = this.getText();
            sigDiffProperties.space = this.getSpace();
            sigDiffProperties.fontFamilyName = this.getFontFamilyName();
            sigDiffProperties.fontSize = this.getFontSize();
            sigDiffProperties.fontStyle = this.getFontStyle();
            sigDiffProperties.colorList = this.mColorList;
            sigDiffProperties.lineWidth = this.getLineWidth();
            return sigDiffProperties;
        }

        public boolean setPropertyWithDialog() {
            SigDiffProperties sigDiffProperties = this.getPropertiesFromDialg();
            if (sigDiffProperties == null) {
                return false;
            }
            return this.setProperties(sigDiffProperties);
        }

        public void windowActivated(WindowEvent windowEvent) {
            System.out.println("windowActivated");
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            System.out.println("windowDeactivated");
        }

        public void windowIconified(WindowEvent windowEvent) {
            System.out.println("windowIconified");
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            System.out.println("windowDeiconified");
        }

        public void windowOpened(WindowEvent windowEvent) {
            System.out.println("windowOpened");
        }

        public void windowClosed(WindowEvent windowEvent) {
            System.out.println("windowClosed");
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.out.println("windowClosing");
            Object object = windowEvent.getSource();
            System.out.println(object);
            if (object.equals(SGGraphElement.this.mSigDiffDialog)) {
                this.onCanceled();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals("Remove this Symbol")) {
                this.setVisible(false);
                SGGraphElement.this.callParentUpdateHistory();
                SGGraphElement.this.mFocusedSymbol = null;
                SGGraphElement.this.repaint();
                return;
            }
            if (string.equals("OK") || SGGraphElement.this.mSigDiffDialog.getActiveComponentList().contains(object) ? !this.onOK() : (string.equals("Cancel") ? !this.onCanceled() : string.equals("Preview") && !this.onPreviewed())) {
                return;
            }
        }

        private boolean onOK() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.updateHistory();
            }
            this.createDrawingElement();
            SGGraphElement.this.repaint();
            this.mTemporaryProperties = null;
            SGGraphElement.this.mSigDiffDialog.hide();
            SGGraphElement.this.mSigDiffDialog.removeActionListener();
            SGGraphElement.this.mSigDiffDialog.removeWindowListener(this);
            return true;
        }

        private boolean onCanceled() {
            boolean bl = this.recover();
            if (!bl) {
                return false;
            }
            this.createDrawingElement();
            SGGraphElement.this.repaint();
            this.mTemporaryProperties = null;
            SGGraphElement.this.mSigDiffDialog.hide();
            SGGraphElement.this.mSigDiffDialog.removeActionListener();
            SGGraphElement.this.mSigDiffDialog.removeWindowListener(this);
            return true;
        }

        private boolean onPreviewed() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            this.createDrawingElement();
            SGGraphElement.this.repaint();
            return true;
        }

        private boolean recover() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            return true;
        }

        public float getX() {
            return this.mMagnification * this.mX + SGGraphElement.this.mGraphAreaX;
        }

        public float getY() {
            return this.mMagnification * this.mY + SGGraphElement.this.mGraphAreaY;
        }

        public boolean setLocation(float f, float f2) {
            this.setX(f);
            this.setY(f2);
            return true;
        }

        public boolean setX(float f) {
            this.mX = (f - SGGraphElement.this.mGraphAreaX) / this.mMagnification;
            return true;
        }

        public boolean setY(float f) {
            this.mY = (f - SGGraphElement.this.mGraphAreaY) / this.mMagnification;
            return true;
        }

        public Point2D getLocation() {
            Point2D.Float float_ = new Point2D.Float(this.getX(), this.getY());
            return float_;
        }

        public boolean isVisible() {
            return this.mVisible;
        }

        public boolean setVisible(boolean bl) {
            this.mVisible = bl;
            return true;
        }

        protected boolean pressDrawingElements(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (this.contains(n2, n = mouseEvent.getY()) || this.mStringElement.contains(n2, n)) {
                this.mTemporaryProperties = this.getProperties();
                this.mPressedPoint = mouseEvent.getPoint();
                SGGraphElement.this.mTempSymbol.setMagnification(this.mMagnification);
                SGGraphElement.this.mTempSymbol.setLocation(this.getX(), this.getY());
                SGGraphElement.this.mTempSymbol.setSize(this.getWidth(), this.getLeftHeight(), this.getRightHeight());
                return true;
            }
            return false;
        }

        protected boolean onDrawingElement(int n, int n2) {
            if (this.mStringElement.contains(n, n2)) {
                return true;
            }
            if (this.mLineTop.contains(n, n2)) {
                return true;
            }
            if (this.mLineLeft.contains(n, n2)) {
                return true;
            }
            return this.mLineRight.contains(n, n2);
        }

        protected boolean drawAllAnchors(Graphics2D graphics2D) {
            float f = this.getX();
            float f2 = this.getX() + this.getWidth();
            float f3 = (f + f2) / 2.0f;
            float f4 = this.getY();
            float f5 = this.getY() + this.getLeftHeight();
            float f6 = (f4 + f5) / 2.0f;
            float f7 = this.getY() + this.getRightHeight();
            float f8 = (f4 + f7) / 2.0f;
            this.drawAnchor(graphics2D, f3, f4);
            this.drawAnchor(graphics2D, f, f4);
            this.drawAnchor(graphics2D, f, f6);
            this.drawAnchor(graphics2D, f, f5);
            this.drawAnchor(graphics2D, f2, f4);
            this.drawAnchor(graphics2D, f2, f8);
            this.drawAnchor(graphics2D, f2, f7);
            return true;
        }

        private void drawAnchor(Graphics2D graphics2D, float f, float f2) {
            Ellipse2D.Float float_ = new Ellipse2D.Float(f - 0.5f * SGGraphElement.this.mAnchorSize, f2 - 0.5f * SGGraphElement.this.mAnchorSize, SGGraphElement.this.mAnchorSize, SGGraphElement.this.mAnchorSize);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.draw(float_);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(float_);
        }

        private boolean setMouseLocation(int n, int n2) {
            double d = 1.25 * (double)SGGraphElement.this.mAnchorSize;
            float f = this.getX();
            float f2 = this.getY();
            float f3 = this.getWidth();
            float f4 = this.getLeftHeight();
            float f5 = this.getRightHeight();
            if ((double)Math.abs((float)n - f) < d && (double)Math.abs((float)n2 - f2) < d) {
                this.mMouseLocation = 5;
            } else if ((double)Math.abs((float)n - (f + f3)) < d && (double)Math.abs((float)n2 - (f2 + f5)) < d) {
                this.mMouseLocation = 8;
            } else if ((double)Math.abs((float)n - (f + f3)) < d && (double)Math.abs((float)n2 - f2) < d) {
                this.mMouseLocation = 6;
            } else if ((double)Math.abs((float)n - f) < d && (double)Math.abs((float)n2 - (f2 + f4)) < d) {
                this.mMouseLocation = 7;
            } else if ((double)Math.abs((float)n - f) < d && (double)Math.abs((float)n2 - (f2 + f4 / 2.0f)) < d) {
                this.mMouseLocation = 3;
            } else if ((double)Math.abs((float)n - (f + f3)) < d && (double)Math.abs((float)n2 - (f2 + f5 / 2.0f)) < d) {
                this.mMouseLocation = 4;
            } else if ((double)Math.abs((float)n2 - f2) < d && (double)Math.abs((float)n - (f + f3 / 2.0f)) < d) {
                this.mMouseLocation = 1;
            } else {
                if (this.mStringElement.contains(n, n2)) {
                    this.mMouseLocation = 9;
                    return true;
                }
                this.mMouseLocation = 0;
            }
            return true;
        }

        private Cursor getCursor() {
            Cursor cursor = null;
            switch (this.mMouseLocation) {
                case 3: {
                    cursor = new Cursor(10);
                    break;
                }
                case 4: {
                    cursor = new Cursor(11);
                    break;
                }
                case 1: {
                    cursor = new Cursor(8);
                    break;
                }
                case 2: {
                    cursor = new Cursor(9);
                    break;
                }
                case 5: {
                    cursor = new Cursor(6);
                    break;
                }
                case 8: {
                    cursor = new Cursor(5);
                    break;
                }
                case 6: {
                    cursor = new Cursor(7);
                    break;
                }
                case 7: {
                    cursor = new Cursor(4);
                    break;
                }
                case 9: {
                    cursor = new Cursor(12);
                    break;
                }
                default: {
                    cursor = new Cursor(12);
                }
            }
            return cursor;
        }

        protected boolean drag(MouseEvent mouseEvent) {
            if (this.mPressedPoint == null) {
                return false;
            }
            if (!SGGraphElement.this.getBounds().contains(mouseEvent.getPoint())) {
                return false;
            }
            if (this.mMouseLocation == 0 || this.mMouseLocation == 9) {
                boolean bl = this.dragOtherPoint(mouseEvent);
                return bl;
            }
            float f = SGGraphElement.this.mTempSymbol.getX();
            float f2 = SGGraphElement.this.mTempSymbol.getY();
            float f3 = SGGraphElement.this.mTempSymbol.getWidth();
            float f4 = SGGraphElement.this.mTempSymbol.getLeftHeight();
            float f5 = SGGraphElement.this.mTempSymbol.getRightHeight();
            int n = mouseEvent.getX() - this.mPressedPoint.x;
            int n2 = mouseEvent.getY() - this.mPressedPoint.y;
            float f6 = f3;
            float f7 = f4;
            float f8 = f5;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            float f12 = f;
            float f13 = f2;
            float f14 = f3;
            float f15 = f4;
            float f16 = f5;
            System.out.println((float)n * 0.035277776f + "  " + (float)n2 * 0.035277776f);
            if (this.mMouseLocation == 1) {
                this.mPressedPoint.setLocation(this.mPressedPoint.getX(), this.mPressedPoint.getY() + (double)n2);
                f10 = f7 - (float)n2;
                f11 = f8 - (float)n2;
                f13 = f2 + f7 - f10;
                f15 = f10;
                f16 = f11;
            } else if (this.mMouseLocation == 3) {
                this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
                f9 = f6 - (float)n;
                f12 = f + f6 - f9;
                f14 = f9;
            } else if (this.mMouseLocation == 4) {
                this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY());
                f14 = f9 = f6 + (float)n;
            } else if (this.mMouseLocation == 5) {
                this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
                if ((mouseEvent.getModifiers() & 1) != 0) {
                    f10 = f9 * (f7 / f6);
                    f11 = f9 * (f8 / f6);
                } else {
                    f10 = f7 - (float)n2;
                    f11 = f8 - (float)n2;
                }
                f9 = f6 - (float)n;
                f12 = f + f6 - f9;
                f13 = f2 + f7 - f10;
                f14 = f9;
                f15 = f10;
                f16 = f11;
            } else if (this.mMouseLocation == 6 && (mouseEvent.getModifiers() & 1) == 0) {
                this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
                f9 = f6 + (float)n;
                f10 = f7 - (float)n2;
                f11 = f8 - (float)n2;
                f13 = f2 + f8 - f11;
                f14 = f9;
                f15 = f10;
                f16 = f11;
            } else if (this.mMouseLocation == 7 && (mouseEvent.getModifiers() & 1) == 0) {
                this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
                f9 = f6 - (float)n;
                f10 = f7 + (float)n2;
                f12 = f + f6 - f9;
                f14 = f9;
                f15 = f10;
            } else if (this.mMouseLocation == 8 && (mouseEvent.getModifiers() & 1) == 0) {
                this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
                f9 = f6 + (float)n;
                f11 = f8 + (float)n2;
                f14 = f9;
                f16 = f11;
            }
            if (f14 < 10.0f) {
                System.out.println("w < mMinWidth");
                return true;
            }
            if (f15 < 10.0f) {
                System.out.println("hl < mMinHeight");
                return true;
            }
            if (f16 < 10.0f) {
                System.out.println("hr < mMinHeight");
                return true;
            }
            this.setLocation(f12, f13);
            this.setWidth(f14);
            this.setLeftHeight(f15);
            this.setRightHeight(f16);
            this.createDrawingElement();
            SGGraphElement.this.mTempSymbol.setLocation(f12, f13);
            SGGraphElement.this.mTempSymbol.setSize(f14, f15, f16);
            SGGraphElement.this.repaint();
            return true;
        }

        private boolean dragOtherPoint(MouseEvent mouseEvent) {
            if (this.mPressedPoint != null) {
                float f = mouseEvent.getX() - SGGraphElement.this.mPressedSymbolOrigin.x;
                float f2 = mouseEvent.getY() - SGGraphElement.this.mPressedSymbolOrigin.y;
                this.setLocation(f, f2);
                this.createDrawingElement();
                SGGraphElement.this.repaint();
            }
            return true;
        }

        public boolean addPropertiesHistory() {
            this.addStringPropertyHistory(this.getProperties());
            return true;
        }

        private boolean addStringPropertyHistory(SGProperties sGProperties) {
            if (!(sGProperties instanceof SigDiffProperties)) {
                return false;
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mStringElementStateCounter; ++i) {
                arrayList.add(this.mStringElementPropertyHistoryList.get(i));
            }
            arrayList.add(sGProperties);
            this.mStringElementPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            System.out.println("undo : SigDiffSymbol");
            System.out.println();
            --this.mStringElementStateCounter;
            SigDiffProperties sigDiffProperties = (SigDiffProperties)this.mStringElementPropertyHistoryList.get(this.mStringElementStateCounter);
            System.out.println(sigDiffProperties);
            System.out.println();
            this.setProperties(sigDiffProperties);
            this.createDrawingElement();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean redo() {
            System.out.println("redo : SigDiffSymbol");
            System.out.println();
            ++this.mStringElementStateCounter;
            SigDiffProperties sigDiffProperties = (SigDiffProperties)this.mStringElementPropertyHistoryList.get(this.mStringElementStateCounter);
            System.out.println(sigDiffProperties);
            System.out.println();
            this.setProperties(sigDiffProperties);
            this.createDrawingElement();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            this.updateParentHistory();
            this.updateObjectHistory(this);
            ++this.mStringElementStateCounter;
            this.addStringPropertyHistory(this.getProperties());
            return true;
        }

        public boolean updateParentHistory() {
            return SGGraphElement.this.updateParentHistoryFromStringElement(this);
        }

        private boolean isChanged() {
            boolean bl = !this.getProperties().equals(this.mTemporaryProperties);
            return bl;
        }
    }

    class TimingElementGroupLine
    extends SGElementGroupLine {
        private static final String MOVE_TO_FRONT = "Move to Front";
        private static final String MOVE_TO_BACK = "Move to Back";
        private static final String REMOVE_TIMING_LINE = "Remove this Line";

        protected TimingElementGroupLine() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals(MOVE_TO_FRONT)) {
                SGGraphElement.this.moveTimingElementGroupSetToFront(this.mGroupSet);
            } else if (string.equals(MOVE_TO_BACK)) {
                SGGraphElement.this.moveTimingElementGroupSetToBack(this.mGroupSet);
            } else if (string.equals(REMOVE_TIMING_LINE)) {
                this.mGroupSet.setVisible(false);
                SGGraphElement.this.callParentUpdateHistory();
            }
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
        }

        protected String[] getPopupMenuCommandArray() {
            String[] stringArray = new String[]{MOVE_TO_FRONT, MOVE_TO_BACK, REMOVE_TIMING_LINE};
            return stringArray;
        }

        public boolean setDialogProperty() {
            TimingElementGroupSetInGraph timingElementGroupSetInGraph = (TimingElementGroupSetInGraph)this.mGroupSet;
            SGTimingLineDialog sGTimingLineDialog = SGGraphElement.this.mTimingLineDialog;
            sGTimingLineDialog.setTiminValueString(timingElementGroupSetInGraph.mValue.mValue);
            sGTimingLineDialog.setLineType(this.mLineType);
            sGTimingLineDialog.setLineWidth(this.mLineWidth);
            sGTimingLineDialog.setLineColorList(this.mColorList);
            return true;
        }

        public boolean setPropertyWithDialog() {
            TimingElementGroupSetInGraph timingElementGroupSetInGraph = (TimingElementGroupSetInGraph)this.mGroupSet;
            SGTimingLineDialog sGTimingLineDialog = SGGraphElement.this.mTimingLineDialog;
            double d = 0.0;
            try {
                d = Double.valueOf(sGTimingLineDialog.getTimingValueString());
            }
            catch (Exception exception) {
                SGUtility.showIllegalInputErrorMessageDialog(sGTimingLineDialog);
                sGTimingLineDialog.setTiminValueString(timingElementGroupSetInGraph.mValue.mValue);
                return false;
            }
            timingElementGroupSetInGraph.mValue.mValue = d;
            SGElementGroupLine.LineProperties lineProperties = sGTimingLineDialog.getLineProperties();
            if (lineProperties == null) {
                return false;
            }
            lineProperties.setVisible(this.isVisible());
            return this.setProperties(lineProperties);
        }

        class TimingLineProperties
        extends SGElementGroupLine.LineProperties {
            double value;

            TimingLineProperties() {
            }

            public boolean equals(Object object) {
                if (!(object instanceof TimingLineProperties)) {
                    return false;
                }
                if (!super.equals(object)) {
                    return false;
                }
                TimingLineProperties timingLineProperties = (TimingLineProperties)object;
                return timingLineProperties.value == this.value;
            }
        }
    }

    class TimingElementGroupSetInGraph
    extends SGTimingElementGroupSet
    implements ActionListener,
    WindowListener,
    SGIUndoable {
        private SGProperties mTemporaryProperties = null;
        private ArrayList mElementGroupSetPropertyHistoryList = new ArrayList();
        private int mElementGroupSetStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();

        protected TimingElementGroupSetInGraph() {
        }

        protected SGElementGroup createDrawingElementGroup(int n) {
            TimingElementGroupLine timingElementGroupLine = null;
            if (n != 0) {
                throw new Error("");
            }
            timingElementGroupLine = new TimingElementGroupLine();
            timingElementGroupLine.mGroupSet = this;
            return timingElementGroupLine;
        }

        public SGElementGroup createDrawingElementGroup(SGDrawingElement sGDrawingElement) {
            TimingElementGroupLine timingElementGroupLine = null;
            if (!(sGDrawingElement instanceof SGDrawingElementLine)) {
                throw new Error("");
            }
            timingElementGroupLine = new TimingElementGroupLine();
            ((SGElementGroup)timingElementGroupLine).setProperty(sGDrawingElement);
            timingElementGroupLine.mGroupSet = this;
            return timingElementGroupLine;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                sGElementGroup.paintElement(graphics2D);
            }
        }

        protected boolean clickDrawingElements(MouseEvent mouseEvent) {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                ArrayList arrayList2 = sGElementGroup.mDrawingElementList;
                for (int j = 0; j < arrayList2.size(); ++j) {
                    SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList2.get(j);
                    boolean bl = sGDrawingElement.contains(mouseEvent.getX(), mouseEvent.getY());
                    if (!bl) continue;
                    if (!SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() == 1) {
                        // empty if block
                    }
                    if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() != 2) continue;
                    JDialog jDialog = this.getDialog();
                    jDialog.show();
                    return true;
                }
            }
            return false;
        }

        public boolean onDrawingElement(int n, int n2) {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                ArrayList arrayList2 = sGElementGroup.mDrawingElementList;
                for (int j = 0; j < arrayList2.size(); ++j) {
                    SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList2.get(j);
                    boolean bl = sGDrawingElement.contains(n, n2);
                    if (!bl) continue;
                    return true;
                }
            }
            return false;
        }

        public JDialog getDialog() {
            SGTimingLineDialog sGTimingLineDialog = SGGraphElement.this.mTimingLineDialog;
            this.setDialogProperty();
            sGTimingLineDialog.setLocation(SGGraphElement.this.mDialogOwner.getLocation());
            sGTimingLineDialog.setColorButtonBorder(true);
            sGTimingLineDialog.setActionListener(this);
            sGTimingLineDialog.addWindowListener(this);
            this.mTemporaryProperties = this.getWholeProperties();
            return sGTimingLineDialog;
        }

        public void windowActivated(WindowEvent windowEvent) {
            System.out.println("windowActivated");
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            System.out.println("windowDeactivated");
        }

        public void windowIconified(WindowEvent windowEvent) {
            System.out.println("windowIconified");
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            System.out.println("windowDeiconified");
        }

        public void windowOpened(WindowEvent windowEvent) {
            System.out.println("windowOpened");
        }

        public void windowClosed(WindowEvent windowEvent) {
            System.out.println("windowClosed");
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.out.println("windowClosing");
            Object object = windowEvent.getSource();
            System.out.println(object);
            if (object.equals(SGGraphElement.this.mTimingLineDialog)) {
                this.onCanceled();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            SGTimingLineDialog sGTimingLineDialog = SGGraphElement.this.mTimingLineDialog;
            if (string.equals("OK") || sGTimingLineDialog.getActiveComponentList().contains(object) ? !this.onOK() : (string.equals("Cancel") ? !this.onCanceled() : string.equals("Preview") && !this.onPreviewed())) {
                return;
            }
        }

        private boolean onOK() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.updateHistory();
            }
            this.mTemporaryProperties = null;
            SGGraphElement.this.mTimingLineDialog.hide();
            SGGraphElement.this.mTimingLineDialog.removeActionListener();
            SGGraphElement.this.mTimingLineDialog.removeWindowListener(this);
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        private boolean onCanceled() {
            boolean bl = this.recover();
            if (!bl) {
                return false;
            }
            this.mTemporaryProperties = null;
            SGGraphElement.this.mTimingLineDialog.hide();
            SGGraphElement.this.mTimingLineDialog.removeActionListener();
            SGGraphElement.this.mTimingLineDialog.removeWindowListener(this);
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        private boolean onPreviewed() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean recover() {
            if (!this.setWholeProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            return true;
        }

        private SGElementGroupSet.WholeProperties readProperties(BufferedReader bufferedReader) {
            SGElementGroupSet.WholeProperties wholeProperties = new SGElementGroupSet.WholeProperties();
            String string = null;
            try {
                double d;
                SGTimingElementGroupSet.TimingElementGroupSetProperties timingElementGroupSetProperties = new SGTimingElementGroupSet.TimingElementGroupSetProperties();
                if (!this.readProperties(bufferedReader, timingElementGroupSetProperties)) {
                    return null;
                }
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    return null;
                }
                Integer n = SGUtilityText.getIntegerPropertyFromLine(string, "Location");
                if (n == null) {
                    return null;
                }
                int n2 = n;
                timingElementGroupSetProperties.axis = SGGraphElement.this.mAxisElement.getAxisInCube(n2);
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    return null;
                }
                Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Value");
                if (d2 == null) {
                    return null;
                }
                timingElementGroupSetProperties.value = d = d2.doubleValue();
                ArrayList<SGProperties> arrayList = new ArrayList<SGProperties>();
                for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                    SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                    string = SGUtilityText.readLine(bufferedReader);
                    if (string == null) {
                        return null;
                    }
                    SGProperties sGProperties = sGElementGroup.readProperties(bufferedReader);
                    if (sGProperties == null) {
                        return null;
                    }
                    arrayList.add(sGProperties);
                }
                wholeProperties.ep = timingElementGroupSetProperties;
                wholeProperties.ipList = arrayList;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            return wholeProperties;
        }

        private boolean readProperty(BufferedReader bufferedReader) {
            SGElementGroupSet.WholeProperties wholeProperties = this.readProperties(bufferedReader);
            if (wholeProperties == null) {
                return false;
            }
            return this.setWholeProperties(wholeProperties);
        }

        private boolean setDialogProperty() {
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                sGElementGroup.setDialogProperty();
            }
            return true;
        }

        private boolean setPropertyWithDialog() {
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                sGElementGroup.setPropertyWithDialog();
            }
            return true;
        }

        public boolean addPropertiesHistory() {
            this.addElementGroupSetPropertyHistory((SGElementGroupSet.WholeProperties)this.getWholeProperties());
            return true;
        }

        private boolean addElementGroupSetPropertyHistory(SGProperties sGProperties) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mElementGroupSetStateCounter; ++i) {
                arrayList.add(this.mElementGroupSetPropertyHistoryList.get(i));
            }
            arrayList.add(sGProperties);
            this.mElementGroupSetPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean redo() {
            ++this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            this.updateParentHistory();
            this.updateObjectHistory(this);
            ++this.mElementGroupSetStateCounter;
            this.addElementGroupSetPropertyHistory(this.getWholeProperties());
            return true;
        }

        public boolean updateParentHistory() {
            return SGGraphElement.this.updateParentHistoryFromElementGroupSet(this);
        }
    }

    abstract class ElementGroupSetForMultipleData
    extends ElementGroupSetInGraph
    implements ActionListener {
        protected ArrayList mElementGroupSetList = new ArrayList();

        protected ElementGroupSetForMultipleData() {
        }

        public ArrayList getVisibleFlagList() {
            if (this.mElementGroupSetList.size() == 0) {
                return new ArrayList();
            }
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(0);
            ArrayList arrayList = elementGroupSetInGraph.getVisibleFlagList();
            return arrayList;
        }

        public boolean setMagnification(float f) {
            super.setMagnification(f);
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(i);
                sGElementGroupSet.setMagnification(f);
            }
            return true;
        }

        public boolean zoom(int n, int n2, float f) {
            super.zoom(n, n2, f);
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(i);
                sGElementGroupSet.zoom(n, n2, f);
            }
            return true;
        }

        public boolean addDrawingElementGroup(int n) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                elementGroupSetInGraph.addDrawingElementGroup(n);
            }
            return true;
        }

        public boolean addDrawingElementGroup(SGDrawingElement sGDrawingElement) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                elementGroupSetInGraph.addDrawingElementGroup(sGDrawingElement);
            }
            return true;
        }

        protected boolean clickDrawingElements(MouseEvent mouseEvent) {
            for (int i = this.mElementGroupSetList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                boolean bl = elementGroupSetInGraph.clickDrawingElements(mouseEvent);
                if (!bl) continue;
                return true;
            }
            return false;
        }

        public boolean onDrawingElement(int n, int n2) {
            for (int i = this.mElementGroupSetList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                boolean bl = elementGroupSetInGraph.onDrawingElement(n, n2);
                if (!bl) continue;
                return true;
            }
            return false;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            for (int i = this.mElementGroupSetList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                elementGroupSetInGraph.paintGraphics2D(graphics2D);
            }
        }

        public ArrayList getDrawingElementList() {
            ArrayList<SGDrawingElement> arrayList = new ArrayList<SGDrawingElement>();
            if (this.mElementGroupSetList.size() == 0) {
                return arrayList;
            }
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(0);
            for (int i = 0; i < sGElementGroupSet.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)sGElementGroupSet.mDrawingElementGroupList.get(i);
                SGDrawingElement sGDrawingElement = sGElementGroup.getDrawingElement();
                arrayList.add(sGDrawingElement);
            }
            return arrayList;
        }
    }

    protected abstract class ElementGroupSetInGraph
    extends SGElementGroupSetInFigureElement
    implements ActionListener,
    WindowListener,
    SGIUndoable,
    SGIPropertySettingListener {
        protected SGAxis mXAxis = null;
        protected SGAxis mYAxis = null;
        protected SGAxis mZAxis = null;
        protected SGProperties mTemporaryProperties = null;
        protected JPopupMenu mPopupMenu = new JPopupMenu();
        private ArrayList mElementGroupSetPropertyHistoryList = new ArrayList();
        private int mElementGroupSetStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();

        protected ElementGroupSetInGraph() {
        }

        protected boolean setXAxis(SGAxis sGAxis) {
            this.mXAxis = sGAxis;
            return true;
        }

        protected boolean setYAxis(SGAxis sGAxis) {
            this.mYAxis = sGAxis;
            return true;
        }

        protected boolean setZAxis(SGAxis sGAxis) {
            this.mZAxis = sGAxis;
            return true;
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public SGAxis getZAxis() {
            return this.mZAxis;
        }

        public ArrayList getVisibleFlagList() {
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
            ArrayList arrayList2 = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                boolean bl = sGElementGroup.isVisible();
                arrayList.add(new Boolean(bl));
            }
            return arrayList;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object.equals(mPropertyDialogForData)) {
                this.cancel();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Dialog")) {
                SGGraphElement.this.setPropertyOfSelectedData();
            }
        }

        protected abstract boolean createDrawingElements();

        public boolean onDrawingElement(int n, int n2) {
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                ArrayList arrayList = sGElementGroup.mDrawingElementList;
                for (int j = 0; j < arrayList.size(); ++j) {
                    SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(j);
                    if (!sGDrawingElement.contains(n, n2)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean showPropertyDialog() {
            SGPropertyDialog sGPropertyDialog = mPropertyDialogForData;
            sGPropertyDialog.addPropertySettingListener(this);
            sGPropertyDialog.setLocation(SGGraphElement.this.mDialogOwner.getLocation());
            return true;
        }

        public boolean commit() {
            boolean bl = this.setPropertiesFromDialog();
            if (!bl) {
                return false;
            }
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getWholeProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.updateHistory();
            }
            this.mTemporaryProperties = null;
            mPropertyDialogForData.hide();
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean cancel() {
            if (!this.recover()) {
                throw new Error();
            }
            this.mTemporaryProperties = null;
            SGPropertyDialog sGPropertyDialog = mPropertyDialogForData;
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean preview() {
            boolean bl = this.setPropertiesFromDialog();
            if (!bl) {
                return false;
            }
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean setPropertiesFromDialog() {
            return true;
        }

        protected boolean recover() {
            return this.setWholeProperties(this.mTemporaryProperties);
        }

        public SGProperties getProperties() {
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = new ElementGroupSetInGraphProperties();
            if (!this.getProperties(elementGroupSetInGraphProperties)) {
                return null;
            }
            return elementGroupSetInGraphProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInGraphProperties)) {
                return false;
            }
            super.getProperties(sGProperties);
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)sGProperties;
            elementGroupSetInGraphProperties.xAxis = this.mXAxis;
            elementGroupSetInGraphProperties.yAxis = this.mYAxis;
            elementGroupSetInGraphProperties.zAxis = this.mZAxis;
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInGraphProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)sGProperties;
            this.mXAxis = elementGroupSetInGraphProperties.xAxis;
            this.mYAxis = elementGroupSetInGraphProperties.yAxis;
            this.mZAxis = elementGroupSetInGraphProperties.zAxis;
            return true;
        }

        public boolean readProperties(BufferedReader bufferedReader, SGProperties sGProperties) throws IOException {
            if (bufferedReader == null || sGProperties == null) {
                return false;
            }
            if (!super.readProperties(bufferedReader, sGProperties)) {
                return false;
            }
            if (!(sGProperties instanceof ElementGroupSetInGraphProperties)) {
                return false;
            }
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)sGProperties;
            String string = null;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            String string2 = SGUtilityText.getPropertyFromLine(string, "Location of the X-Axis");
            if (string2 == null) {
                return false;
            }
            int n = SGGraphElement.this.mAxisElement.getConfigurationInCubeFromStringInPlane(string2);
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            String string3 = SGUtilityText.getPropertyFromLine(string, "Location of the Y-Axis");
            if (string3 == null) {
                return false;
            }
            int n2 = SGGraphElement.this.mAxisElement.getConfigurationInCubeFromStringInPlane(string3);
            SGAxis sGAxis = SGGraphElement.this.mAxisElement.getAxisInCube(n);
            SGAxis sGAxis2 = SGGraphElement.this.mAxisElement.getAxisInCube(n2);
            elementGroupSetInGraphProperties.xAxis = sGAxis;
            elementGroupSetInGraphProperties.yAxis = sGAxis2;
            return true;
        }

        public boolean addPropertiesHistory() {
            this.addElementGroupSetPropertyHistory((SGElementGroupSet.WholeProperties)this.getWholeProperties());
            return true;
        }

        private boolean addElementGroupSetPropertyHistory(SGElementGroupSet.WholeProperties wholeProperties) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mElementGroupSetStateCounter; ++i) {
                arrayList.add(this.mElementGroupSetPropertyHistoryList.get(i));
            }
            arrayList.add(wholeProperties);
            this.mElementGroupSetPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean redo() {
            ++this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGGraphElement.this.createAllDrawingElements();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.repaint();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            this.updateParentHistory();
            this.updateObjectHistory(this);
            ++this.mElementGroupSetStateCounter;
            this.addElementGroupSetPropertyHistory((SGElementGroupSet.WholeProperties)this.getWholeProperties());
            return true;
        }

        public boolean updateParentHistory() {
            return SGGraphElement.this.updateParentHistoryFromElementGroupSet(this);
        }

        class ElementGroupSetInGraphProperties
        extends SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement {
            SGAxis xAxis;
            SGAxis yAxis;
            SGAxis zAxis;

            ElementGroupSetInGraphProperties() {
            }

            public boolean equals(Object object) {
                if (!(object instanceof ElementGroupSetInGraphProperties)) {
                    return false;
                }
                if (!super.equals(object)) {
                    return false;
                }
                ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)object;
                if (!elementGroupSetInGraphProperties.xAxis.equals(this.xAxis)) {
                    return false;
                }
                if (!elementGroupSetInGraphProperties.yAxis.equals(this.yAxis)) {
                    return false;
                }
                return elementGroupSetInGraphProperties.zAxis == null && this.zAxis == null || elementGroupSetInGraphProperties.zAxis.equals(this.zAxis);
            }

            public String toString() {
                String string = new String("[");
                string = string + super.toString();
                string = string + new String("xAxis=" + this.xAxis + ", ");
                string = string + new String("yAxis=" + this.yAxis + ", ");
                string = string + new String("zAxis=" + this.zAxis + ", ");
                string = string + new String("]");
                return string;
            }
        }
    }
}

