/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.io.IOException;
import java.io.Writer;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;

public abstract class SGElementGroupString
extends SGElementGroup {
    protected String mFontFamilyName = "SansSerif";
    protected float mFontSize = 28.346458f;
    protected int mFontStyle = 0;
    protected float mAngle = 0.0f;
    public static final String PF_STRING_TITLE = "<String>";
    public static final String KEY_FONT_SIZE = "Font Size";
    public static final String KEY_FONT_FAMILY_NAME = "Font Family Name";
    public static final String KEY_FONT_STYLE = "Font Style";
    public static final String KEY_STRING_ANGLE = "Angle";

    public boolean setFontFamilyName(String string) {
        this.mFontFamilyName = string;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementList.get(i);
            sGDrawingElementString.setFontFamilyName(string);
        }
        return true;
    }

    public boolean setFontSize(float f) {
        this.mFontSize = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementList.get(i);
            sGDrawingElementString.setFontSize(f);
        }
        return true;
    }

    public boolean setFontStyle(int n) {
        this.mFontStyle = n;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementList.get(i);
            sGDrawingElementString.setFontStyle(n);
        }
        return true;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementList.get(i);
            sGDrawingElementString.setAngle(f);
        }
        return true;
    }

    public String getFontFamilyName() {
        return this.mFontFamilyName;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)this.mDrawingElementList.get(i);
            sGDrawingElementString2D.drawString(graphics2D);
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        return null;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementString)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)sGDrawingElement;
        this.setFontFamilyName(sGDrawingElementString.getFontFamilyName());
        this.setFontSize(sGDrawingElementString.getFontSize());
        this.setFontStyle(sGDrawingElementString.getFontStyle());
        this.setAngle(sGDrawingElementString.getAngle());
        return true;
    }

    public boolean writePropertyOfData(Writer writer) throws IOException {
        writer.write("<String>\n");
        SGUtilityText.writePropertyLine(writer, KEY_FONT_SIZE, new Float(this.mFontSize));
        SGUtilityText.writePropertyLine(writer, KEY_FONT_FAMILY_NAME, this.mFontFamilyName);
        SGUtilityText.writePropertyLine(writer, KEY_FONT_STYLE, new Integer(this.mFontStyle));
        SGUtilityText.writeColorListPropertyLine(writer, "Colors", this.mColorList);
        SGUtilityText.writePropertyLine(writer, KEY_STRING_ANGLE, new Double((double)(-this.mAngle) / (Math.PI / 180)));
        writer.write("\n");
        return false;
    }

    public SGProperties getProperties() {
        StringProperties stringProperties = new StringProperties();
        this.getProperties(stringProperties);
        return stringProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        StringProperties stringProperties = (StringProperties)sGProperties;
        stringProperties.setFontFamilyName(this.getFontFamilyName());
        stringProperties.setFontSize(this.getFontSize());
        stringProperties.setFontStyle(this.getFontStyle());
        stringProperties.setAngle(this.getAngle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        StringProperties stringProperties = (StringProperties)sGProperties;
        this.setFontFamilyName(stringProperties.getFontFamilyName());
        Float f = stringProperties.getFontSize();
        if (f == null) {
            return false;
        }
        this.setFontSize(f.floatValue());
        Integer n = stringProperties.getFontStyle();
        if (n == null) {
            return false;
        }
        this.setFontStyle(n);
        Float f2 = stringProperties.getAngle();
        if (f2 == null) {
            return false;
        }
        this.setAngle(f2.floatValue());
        return true;
    }

    public static class StringProperties
    extends SGElementGroup.ElementGroupProperties {
        public static final String[] keys = new String[]{"Font Size", "Font Style", "Font Family Name", "Angle"};

        public boolean equals(Object object) {
            if (!(object instanceof StringProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            StringProperties stringProperties = (StringProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(stringProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getFontSize() {
            String string = this.getProperty(SGElementGroupString.KEY_FONT_SIZE);
            return SGUtilityText.getFloat(string);
        }

        public Integer getFontStyle() {
            String string = this.getProperty(SGElementGroupString.KEY_FONT_STYLE);
            return SGUtilityText.getInteger(string);
        }

        public String getFontFamilyName() {
            return this.getProperty(SGElementGroupString.KEY_FONT_FAMILY_NAME);
        }

        public Float getAngle() {
            String string = this.getProperty(SGElementGroupString.KEY_STRING_ANGLE);
            return SGUtilityText.getFloat(string);
        }

        public boolean setFontSize(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupString.KEY_FONT_SIZE, new Float(f).toString());
            return true;
        }

        public boolean setFontStyle(int n) {
            this.setProperty(SGElementGroupString.KEY_FONT_STYLE, new Integer(n).toString());
            return true;
        }

        public boolean setFontFamilyName(String string) {
            if (string == null) {
                return false;
            }
            this.setProperty(SGElementGroupString.KEY_FONT_FAMILY_NAME, new String(string));
            return true;
        }

        public boolean setAngle(float f) {
            this.setProperty(SGElementGroupString.KEY_STRING_ANGLE, new Float(f).toString());
            return true;
        }
    }
}

