/*
 * Decompiled with CFR 0.152.
 */
package sakana.web.view;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sakana.resource.ConfigDefinition;
import sakana.resource.ConfigReader;
import sakana.validator.ExecuteOption;
import sakana.validator.Validator;
import sakana.validator.ValidatorInfo;
import sakana.validator.ValidatorTypes;
import sakana.web.Clipboard;
import sakana.web.session.Request;
import sakana.web.session.UserInfo;
import sakana.web.view.View;

public abstract class AbstractView
implements View {
    private ConfigReader cr = ConfigReader.getInstance();
    private String ticket;
    private HttpServletRequest req;
    private PrintWriter pw;
    private List<ValidatorInfo> vaList;
    private final Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    @Override
    public void prepare(HttpServletRequest req, HttpServletResponse res, String ticket) throws IOException {
        this.log.info("enter prepare");
        res.setContentType(this.cr.getString((Object)ConfigDefinition.CONTENT_TYPE));
        this.req = req;
        this.ticket = ticket;
        this.pw = res.getWriter();
        this.vaList = new ArrayList<ValidatorInfo>();
        this.show();
        req.getSession().setAttribute(Request.VALIDATOR.getValue(), this.vaList);
    }

    public void printMessage() {
        Clipboard cb = (Clipboard)this.req.getAttribute(Request.CLIPBOARD.getValue());
        if (cb != null) {
            if (cb.isInfo()) {
                this.pw.println(cb.getInfoMessage());
            }
            if (cb.isError()) {
                this.pw.println(cb.getErrorMessage());
            }
        }
    }

    @Override
    public abstract void show();

    public String getParameter(String name) {
        return this.req.getParameter(name);
    }

    public UserInfo getUserInfo() {
        return (UserInfo)this.req.getSession().getAttribute(Request.USER.getValue());
    }

    public void ticket() {
        this.write(this.input("hidden", String.valueOf(this.name(Request.TICKET.getValue())) + this.value(this.ticket)));
    }

    public void addValidator(String label, String name, ValidatorTypes type, String servletPath, String trigger, int optInt, ExecuteOption exec) {
        this.vaList.add(new ValidatorInfo(label, name, type, servletPath, trigger, optInt, exec));
    }

    public void addValidator(String label, String name, ValidatorTypes type, String servletPath, String trigger, ExecuteOption exec) {
        this.vaList.add(new ValidatorInfo(label, name, type, servletPath, trigger, exec));
    }

    public void addValidator(Validator validator, String servletPath, String trigger, ExecuteOption exec) {
        this.vaList.add(new ValidatorInfo(validator, servletPath, trigger, exec));
    }

    public void addValidator(Validator validator, ExecuteOption exec) {
        this.vaList.add(new ValidatorInfo(validator, null, null, exec));
    }

    public void write(String str) {
        this.print(str);
    }

    public String title(String str) {
        return "<title>" + str + "</title>";
    }

    public String form(String method, String action) {
        return this.form(method, null, action);
    }

    public String form(String method, String attr, String action) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form method=");
        sb.append(this.sandDoubleQuote(method));
        if (attr != null) {
            sb.append(attr);
        }
        sb.append(" action=");
        sb.append(this.sandDoubleQuote(action));
        sb.append(">");
        return sb.toString();
    }

    public String formEnd() {
        return "</form>";
    }

    public String input(String type, String attr) {
        StringBuilder sb = new StringBuilder();
        sb.append("<input type=");
        sb.append(this.sandDoubleQuote(type));
        if (attr != null) {
            sb.append(attr);
        }
        sb.append(">");
        return sb.toString();
    }

    public String select(String attr) {
        StringBuilder sb = new StringBuilder();
        sb.append("<select");
        sb.append(attr);
        sb.append(">");
        return sb.toString();
    }

    public String option(List<String> valueList, List<String> labelList) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < valueList.size()) {
            sb.append("<option");
            sb.append(this.value(valueList.get(i)));
            sb.append(">");
            sb.append(labelList.get(i));
            ++i;
        }
        return sb.toString();
    }

    public String font(String attr) {
        StringBuilder sb = new StringBuilder();
        sb.append("<font");
        sb.append(attr);
        sb.append(">");
        return sb.toString();
    }

    public String fontEnd() {
        return "</font>";
    }

    public String name(String str) {
        return this.attribute("name", str);
    }

    public String id(String str) {
        return this.attribute("id", str);
    }

    public String value(String str) {
        return this.attribute("value", str);
    }

    public String size(String str) {
        return this.attribute("size", str);
    }

    public String maxlength(String str) {
        return this.attribute("maxlength", str);
    }

    public String align(String str) {
        return this.attribute("align", str);
    }

    public String alt(String str) {
        return this.attribute("alt", str);
    }

    public String border(String str) {
        return this.attribute("border", str);
    }

    public String height(String str) {
        return this.attribute("height", str);
    }

    public String src(String str) {
        return this.attribute("src", str);
    }

    public String width(String str) {
        return this.attribute("width", str);
    }

    public String clas(String str) {
        return this.attribute("class", str);
    }

    public String cls(String str) {
        return this.attribute("style", str);
    }

    public String color(String str) {
        return this.attribute("color", str);
    }

    public String enctype(String str) {
        return this.attribute("enctype", str);
    }

    private void print(String str) {
        this.pw.print(str);
    }

    private String attribute(String name, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" " + name + "=");
        if (value != null) {
            sb.append(this.sandDoubleQuote(value));
        }
        return sb.toString();
    }

    private String sandDoubleQuote(String str) {
        return "\"" + str + "\"";
    }
}

