/*
 * Decompiled with CFR 0.152.
 */
package sakana.web.action;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import sakana.database.DatabaseAccessor;
import sakana.database.dao.AbstractDao;
import sakana.resource.ConfigDefinition;
import sakana.resource.ConfigReader;
import sakana.service.Service;
import sakana.util.StringUtil;
import sakana.validator.ExecuteOption;
import sakana.validator.ValidationEngine;
import sakana.validator.Validator;
import sakana.validator.ValidatorInfo;
import sakana.web.Clipboard;
import sakana.web.action.Action;
import sakana.web.action.CheckTicket;
import sakana.web.session.MethodPrefix;
import sakana.web.session.Request;
import sakana.web.session.UserInfo;
import sakana.web.view.View;

public abstract class AbstractAction
extends HttpServlet
implements Action {
    private static final long serialVersionUID = 1052165661798022781L;
    private DatabaseAccessor da = null;
    private boolean checkTicketFlag = false;
    private ConfigReader cr;
    protected List<FileItem> fileList = null;
    private final Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.log.info("enter doPost");
        if (this.cr == null) {
            this.cr = ConfigReader.getInstance();
            this.cr.setJarFilePath(this.getServletContext().getResource("/WEB-INF/lib/sakana.jar").toString());
        }
        if (this.getClass().isAnnotationPresent(CheckTicket.class)) {
            this.log.info("\u30c1\u30b1\u30c3\u30c8\u30c1\u30a7\u30c3\u30af\u691c\u51fa");
            this.checkTicketFlag = true;
        }
        HttpSession ses = req.getSession();
        Clipboard cb = new Clipboard();
        this.fileList = null;
        if (this.checkTicketFlag) {
            String sesTicket;
            UserInfo info;
            String reqTicket;
            boolean ticketFlag = false;
            String string = reqTicket = req.getContentType().startsWith("multipart/form-data") ? this.getParameterMulti(req, Request.TICKET.getValue()) : req.getParameter(Request.TICKET.getValue());
            if (reqTicket != null && (info = (UserInfo)ses.getAttribute(Request.USER.getValue())) != null && (sesTicket = info.getTicket()) != null && reqTicket.equals(sesTicket)) {
                ticketFlag = true;
            }
            if (!ticketFlag) {
                this.log.info("\u30c1\u30b1\u30c3\u30c8\u4e0d\u4e00\u81f4");
                this.log.info("reqTicket=" + reqTicket);
                cb.addErrorMessage(this.cr.getString((Object)ConfigDefinition.MESSAGE_ILLEGAL_OPERATION));
                cb.setFatalFlag(true);
            }
        }
        String ticket = StringUtil.createRandomString(this.cr.getInt((Object)ConfigDefinition.TICKET_LENGTH));
        if (cb.isFatal()) {
            this.fatalForward(req, res, cb);
        } else {
            try {
                this.loadClass(this, this.cr.getString((Object)ConfigDefinition.SUFFIX_SERVICE), this.cr.getString((Object)ConfigDefinition.PACKAGE_SERVICE), true);
            }
            catch (Exception e) {
                this.log.info("\u30ed\u30fc\u30c9\u306b\u5931\u6557");
                e.printStackTrace();
                this.fatalForward(req, res, cb);
            }
            cb = this.validate(req, cb);
            if (cb.isFatal()) {
                this.fatalForward(req, res, cb);
            } else if (cb.isError()) {
                this.resume(req, res, ticket, cb);
            } else if (cb.isInfo()) {
                this.info(req, res, ticket, cb);
            } else {
                this.execute(req, res, ticket, cb);
            }
        }
        if (this.da != null) {
            this.da.close();
            this.da = null;
            this.log.info("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u7834\u68c4");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void display(HttpServletRequest req, HttpServletResponse res, View view, String ticket, Clipboard cb) throws ServletException, IOException {
        this.log.info("enter display");
        HashMap<String, Method> getterMap = new HashMap<String, Method>();
        Method[] getters = this.getClass().getMethods();
        String getterPrefix = MethodPrefix.GETTER.getValue();
        int getterLength = getterPrefix.length();
        Method[] methodArray = getters;
        int n = getters.length;
        int n2 = 0;
        while (n2 < n) {
            Method getter = methodArray[n2];
            String getterName = getter.getName();
            if (getterName.startsWith(getterPrefix)) {
                getterMap.put(StringUtil.toUnCapital(getterName.substring(getterLength, getterName.length())), getter);
            }
            ++n2;
        }
        Method[] setters = view.getClass().getMethods();
        String setterPrefix = MethodPrefix.SETTER.getValue();
        int setterLength = setterPrefix.length();
        Method[] methodArray2 = setters;
        int n3 = setters.length;
        int n4 = 0;
        while (n4 < n3) {
            String propName;
            Method setter = methodArray2[n4];
            String setterName = setter.getName();
            if (setterName.startsWith(setterPrefix) && getterMap.containsKey(propName = StringUtil.toUnCapital(setterName.substring(setterLength, setterName.length())))) {
                try {
                    Object[] param = new Object[]{((Method)getterMap.get(propName)).invoke((Object)this, null)};
                    setter.invoke((Object)view, param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.fatalForward(req, res, cb);
                }
            }
            ++n4;
        }
        this.saveRequest(req, ticket, cb);
        view.prepare(req, res, ticket);
    }

    public void forward(HttpServletRequest req, HttpServletResponse res, String url, ServletContext sc, String ticket, Clipboard cb) throws ServletException, IOException {
        this.saveRequest(req, ticket, cb);
        if (this.da != null) {
            this.da.close();
            this.da = null;
            this.log.info("forward\u3059\u308b\u306e\u3067\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u3092\u5207\u65ad");
        }
        sc.getRequestDispatcher(url).forward((ServletRequest)req, (ServletResponse)res);
    }

    private Clipboard validate(HttpServletRequest req, Clipboard cb) throws ServletException {
        ArrayList vaList = (ArrayList)req.getSession().getAttribute(Request.VALIDATOR.getValue());
        if (vaList != null) {
            ValidationEngine base = new ValidationEngine();
            HashMap<String, Boolean> itemMap = new HashMap<String, Boolean>();
            int errors = 0;
            for (ValidatorInfo info : vaList) {
                String servletPath = info.getServletPath();
                String trigger = info.getTrigger();
                ExecuteOption opt = info.getExec();
                String label = info.getLabel();
                String requestTrigger = trigger == null ? null : (req.getContentType().startsWith("multipart/form-data") ? this.getParameterMulti(req, trigger) : req.getParameter(trigger));
                boolean exists = itemMap.containsKey(label);
                if (servletPath != null && !servletPath.equals(req.getServletPath()) || trigger != null && requestTrigger == null || !opt.equals((Object)ExecuteOption.ALWAYS) && (!opt.equals((Object)ExecuteOption.WHEN_ITEM_NORMAL) || exists && (!exists || !((Boolean)itemMap.get(label)).booleanValue())) && (!opt.equals((Object)ExecuteOption.WHEN_STATUS_NORMAL) || !cb.isNormal())) continue;
                String param = info.getName() == null ? null : (req.getContentType().startsWith("multipart/form-data") ? this.getParameterMulti(req, info.getName()) : req.getParameter(info.getName()));
                switch (info.getType()) {
                    case NECESSARY: {
                        cb = base.nessesary(label, param, cb);
                        break;
                    }
                    case MAX_LENGTH: {
                        cb = base.maxLength(label, param, info.getOptInt(), cb);
                        break;
                    }
                    case MIN_LENGTH: {
                        cb = base.minLength(label, param, info.getOptInt(), cb);
                        break;
                    }
                    case HALF_SIZE: {
                        cb = base.halfSize(label, param, cb);
                        break;
                    }
                    case FULL_SIZE: {
                        cb = base.fullSize(label, param, cb);
                        break;
                    }
                    case ALPHABET: {
                        cb = base.alphabet(label, param, cb);
                        break;
                    }
                    case NUMERIC: {
                        cb = base.numeric(label, param, cb);
                        break;
                    }
                    case SIGNED_NUMERIC: {
                        cb = base.signedNumeric(label, param, cb);
                        break;
                    }
                    case ALPHABET_NUMERIC: {
                        cb = base.alphabetNumeric(label, param, cb);
                        break;
                    }
                    case HALF_SIZE_ALPHABET: {
                        cb = base.halfSizeAlphabet(label, param, cb);
                        break;
                    }
                    case HALF_SIZE_NUMERIC: {
                        cb = base.halfSizeNumeric(label, param, cb);
                        break;
                    }
                    case HALF_SIZE_SIGNED_NUMERIC: {
                        cb = base.halfSizeSignedNumeric(label, param, cb);
                        break;
                    }
                    case HALF_SIZE_MARK: {
                        cb = base.halfSizeMark(label, param, cb);
                        break;
                    }
                    case HALF_SIZE_ALPHABET_NUMERIC: {
                        cb = base.halfSizeAlphabetNumeric(label, param, cb);
                        break;
                    }
                    case HALF_SIZE_ALPHABET_MARK: {
                        cb = base.halfSizeAlphabetMark(label, param, cb);
                        break;
                    }
                    case HALF_SIZE_NUMERIC_MARK: {
                        cb = base.halfSizeNumericMark(label, param, cb);
                        break;
                    }
                    case HALF_SIZE_ALPHABET_NUMERIC_MARK: {
                        cb = base.halfSizeAlphabetNumericMark(label, param, cb);
                        break;
                    }
                    case FULL_SIZE_ALPHABET: {
                        cb = base.fullSizeAlphabet(label, param, cb);
                        break;
                    }
                    case FULL_SIZE_NUMERIC: {
                        cb = base.fullSizeNumeric(label, param, cb);
                        break;
                    }
                    case FULL_SIZE_ALPHABET_NUMERIC: {
                        cb = base.fullSizeAlphabetNumeric(label, param, cb);
                        break;
                    }
                    case MAIL_ADDRESS: {
                        cb = base.email(label, param, cb);
                        break;
                    }
                    case OPTION_VALIDATOR: {
                        Validator validator = info.getValidator();
                        cb = validator.validate(req, cb);
                    }
                }
                if (cb.getErrorMessageCount() > errors) {
                    itemMap.put(label, false);
                    ++errors;
                    continue;
                }
                itemMap.put(label, true);
            }
        }
        return cb;
    }

    private void saveRequest(HttpServletRequest req, String ticket, Clipboard cb) {
        if (cb != null && !cb.isEmpty()) {
            req.setAttribute(Request.CLIPBOARD.getValue(), (Object)cb);
        }
        HttpSession ses = req.getSession();
        if (ticket == null) {
            if (req.isRequestedSessionIdValid()) {
                ses.invalidate();
            }
        } else {
            UserInfo info = (UserInfo)ses.getAttribute(Request.USER.getValue());
            if (info == null) {
                info = new UserInfo();
            }
            info.setTicket(ticket);
            ses.setAttribute(Request.USER.getValue(), (Object)info);
        }
    }

    private Object loadClass(Action action, String suffix, String pkg, boolean dbFlag) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException, NamingException, InvocationTargetException {
        this.log.info("enter loadClass");
        Object result = null;
        Method[] methods = action.getClass().getMethods();
        String setterPrefix = MethodPrefix.SETTER.getValue();
        int setterLength = setterPrefix.length();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (methodName.startsWith(setterPrefix) && methodName.endsWith(suffix)) {
                String className = String.valueOf(pkg) + "." + methodName.substring(setterLength, methodName.length());
                Class<?> cls = Class.forName(className);
                Object instance = cls.newInstance();
                if (dbFlag) {
                    if (this.da == null) {
                        this.da = DatabaseAccessor.getInstance(this.cr.getString((Object)ConfigDefinition.DATASOURCE));
                        this.log.info("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u78ba\u7acb");
                    }
                    if (instance instanceof Service) {
                        ((Service)instance).setDa(this.da);
                        this.loadClass((Action)instance, this.cr.getString((Object)ConfigDefinition.SUFFIX_DAO), this.cr.getString((Object)ConfigDefinition.PACKAGE_DAO), true);
                    } else {
                        ((AbstractDao)instance).setDa(this.da);
                    }
                }
                Object[] param = new Object[]{instance};
                method.invoke((Object)action, param);
                result = instance;
            }
            ++n2;
        }
        return result;
    }

    public abstract void execute(HttpServletRequest var1, HttpServletResponse var2, String var3, Clipboard var4) throws ServletException, IOException;

    public void info(HttpServletRequest req, HttpServletResponse res, String ticket, Clipboard cb) throws ServletException, IOException {
        this.execute(req, res, ticket, cb);
    }

    public void resume(HttpServletRequest req, HttpServletResponse res, String ticket, Clipboard cb) throws ServletException, IOException {
        this.execute(req, res, ticket, cb);
    }

    public void fatalForward(HttpServletRequest req, HttpServletResponse res, Clipboard cb) throws ServletException, IOException {
        this.forwardByError(req, res, cb, ConfigDefinition.MESSAGE_SYSTEM);
    }

    public void illegalForward(HttpServletRequest req, HttpServletResponse res, Clipboard cb) throws ServletException, IOException {
        this.forwardByError(req, res, cb, ConfigDefinition.MESSAGE_ILLEGAL_OPERATION);
    }

    private void forwardByError(HttpServletRequest req, HttpServletResponse res, Clipboard cb, ConfigDefinition cd) throws ServletException, IOException {
        if (cb.isNormal()) {
            cb.addErrorMessage(this.cr.getString((Object)cd));
        }
        this.forward(req, res, this.cr.getString((Object)ConfigDefinition.FATAL_URL), this.getServletContext(), null, cb);
    }

    protected String getParameterMulti(HttpServletRequest req, String name) throws ServletException {
        ServletFileUpload fu = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        try {
            if (this.fileList == null) {
                this.fileList = fu.parseRequest(req);
            }
            for (FileItem item : this.fileList) {
                if (!item.isFormField() || !name.equals(item.getFieldName())) continue;
                return item.getString(this.cr.getString((Object)ConfigDefinition.ENCODE));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        return null;
    }
}

