/*
 * Decompiled with CFR 0.152.
 */
package sakana.web;

import java.util.ArrayList;
import java.util.List;
import sakana.database.dto.Dto;
import sakana.resource.ConfigDefinition;
import sakana.util.Color;

public class Clipboard {
    private ArrayList<String> error;
    private ArrayList<String> info;
    private ConfigDefinition cd;
    private boolean fatalFlag;
    private Dto dto;
    private List<Dto> dtoList;

    public void addErrorMessage(String msg) {
        if (this.error == null) {
            this.error = new ArrayList();
        }
        this.error.add(msg);
    }

    public String getErrorMessage() {
        return this.getFormattedMessage(Color.RED);
    }

    public void addInfoMessage(String msg) {
        if (this.info == null) {
            this.info = new ArrayList();
        }
        this.info.add(msg);
    }

    public String getInfoMessage() {
        return this.getFormattedMessage(Color.BLUE);
    }

    public void addErrorMessages(List<String> list) {
        if (this.error == null) {
            this.error = new ArrayList();
        }
        this.error.addAll(list);
    }

    public List<String> getErrorMessages() {
        return this.error;
    }

    public ConfigDefinition getCd() {
        return this.cd;
    }

    public void setCd(ConfigDefinition cd) {
        this.cd = cd;
    }

    public boolean isFatal() {
        return this.fatalFlag;
    }

    public void setFatalFlag(boolean fatalFlag) {
        this.fatalFlag = fatalFlag;
    }

    public Dto getDto() {
        return this.dto;
    }

    public void setDto(Dto dto) {
        this.dto = dto;
    }

    public List<Dto> getDtoList() {
        return this.dtoList;
    }

    public void setDtoList(List<Dto> dtoList) {
        this.dtoList = dtoList;
    }

    public boolean isNormal() {
        return this.error == null || this.error.isEmpty();
    }

    public boolean isEmpty() {
        return !this.isError() && !this.isInfo();
    }

    public boolean isError() {
        return this.error != null && !this.error.isEmpty();
    }

    public boolean isInfo() {
        return this.info != null && !this.info.isEmpty();
    }

    public void clearInfo() {
        this.info = null;
    }

    public int getErrorMessageCount() {
        return this.error == null ? 0 : this.error.size();
    }

    private String getFormattedMessage(Color color) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = color == Color.RED ? this.error : this.info;
        int i = 0;
        while (i < list.size()) {
            sb.append("<p><font color=\"").append(color.getName()).append("\">").append((String)list.get(i)).append("</font></p>");
            ++i;
        }
        return sb.toString();
    }
}

