/*
 * Decompiled with CFR 0.152.
 */
package sakana.validator;

import org.apache.commons.validator.GenericValidator;
import sakana.resource.ConfigDefinition;
import sakana.resource.ConfigReader;
import sakana.util.StringUtil;
import sakana.web.Clipboard;

public class ValidationEngine {
    private ConfigReader cr = ConfigReader.getInstance();

    public Clipboard nessesary(String label, String value, Clipboard cb) {
        if (GenericValidator.isBlankOrNull((String)value)) {
            cb.addErrorMessage(StringUtil.replace(this.cr.getString((Object)ConfigDefinition.MESSAGE_NECESSARY), label));
        }
        return cb;
    }

    public Clipboard maxLength(String label, String value, int max, Clipboard cb) {
        if (!GenericValidator.maxLength((String)value, (int)max)) {
            cb.addErrorMessage(StringUtil.replace(this.cr.getString((Object)ConfigDefinition.MESSAGE_MAX_LENGTH), label, String.valueOf(max)));
        }
        return cb;
    }

    public Clipboard minLength(String label, String value, int min, Clipboard cb) {
        if (!GenericValidator.minLength((String)value, (int)min)) {
            cb.addErrorMessage(StringUtil.replace(this.cr.getString((Object)ConfigDefinition.MESSAGE_MIN_LENGTH), label, String.valueOf(min)));
        }
        return cb;
    }

    public Clipboard type(String label, String value, String pattern, String category, Clipboard cb) {
        if (value == null || !value.matches(pattern)) {
            cb.addErrorMessage(StringUtil.replace(this.cr.getString((Object)ConfigDefinition.MESSAGE_ILLEGAL_TYPE), label, category));
        }
        return cb;
    }

    public Clipboard halfSize(String label, String value, Clipboard cb) {
        return this.type(label, value, "[ -~\uff61-\uff9f]+", "\u534a\u89d2", cb);
    }

    public Clipboard fullSize(String label, String value, Clipboard cb) {
        return this.type(label, value, "[^ -~\uff61-\uff9f]+", "\u5168\u89d2", cb);
    }

    public Clipboard alphabet(String label, String value, Clipboard cb) {
        return this.type(label, value, "[A-Za-z\uff21-\uff3a\uff41-\uff5a]+", "\u82f1\u5b57", cb);
    }

    public Clipboard numeric(String label, String value, Clipboard cb) {
        return this.type(label, value, "[0-9\uff10-\uff19]+", "\u6570\u5b57", cb);
    }

    public Clipboard signedNumeric(String label, String value, Clipboard cb) {
        return this.type(label, value, "-?[0-9\uff10-\uff19]+", "\u7b26\u53f7\u4ed8\u304d\u6570\u5b57", cb);
    }

    public Clipboard alphabetNumeric(String label, String value, Clipboard cb) {
        return this.type(label, value, "[0-9A-Za-z\uff10-\uff19\uff21-\uff3a\uff41-\uff5a]+", "\u82f1\u5b57\u307e\u305f\u306f\u6570\u5b57", cb);
    }

    public Clipboard halfSizeAlphabet(String label, String value, Clipboard cb) {
        return this.type(label, value, "[A-Za-z]+", "\u534a\u89d2\u82f1\u5b57", cb);
    }

    public Clipboard halfSizeNumeric(String label, String value, Clipboard cb) {
        return this.type(label, value, "[0-9]+", "\u534a\u89d2\u6570\u5b57", cb);
    }

    public Clipboard halfSizeSignedNumeric(String label, String value, Clipboard cb) {
        return this.type(label, value, "-?[0-9]+", "\u7b26\u53f7\u4ed8\u304d\u534a\u89d2\u6570\u5b57", cb);
    }

    public Clipboard halfSizeMark(String label, String value, Clipboard cb) {
        return this.type(label, value, "[ -/:-@\\[-\\`\\{-\\~]+", "\u534a\u89d2\u8a18\u53f7", cb);
    }

    public Clipboard halfSizeAlphabetNumeric(String label, String value, Clipboard cb) {
        return this.type(label, value, "[0-9A-Za-z]+", "\u534a\u89d2\u82f1\u6570\u5b57", cb);
    }

    public Clipboard halfSizeAlphabetMark(String label, String value, Clipboard cb) {
        return this.type(label, value, "[A-Za-z -/:-@\\[-\\`\\{-\\~]+", "\u534a\u89d2\u82f1\u5b57\u307e\u305f\u306f\u8a18\u53f7", cb);
    }

    public Clipboard halfSizeNumericMark(String label, String value, Clipboard cb) {
        return this.type(label, value, "[0-9 -/:-@\\[-\\`\\{-\\~]+", "\u534a\u89d2\u6570\u5b57\u307e\u305f\u306f\u8a18\u53f7", cb);
    }

    public Clipboard halfSizeAlphabetNumericMark(String label, String value, Clipboard cb) {
        return this.type(label, value, "[0-9A-Za-z -/:-@\\[-\\`\\{-\\~]+", "\u534a\u89d2\u82f1\u6570\u5b57\u307e\u305f\u306f\u8a18\u53f7", cb);
    }

    public Clipboard fullSizeAlphabet(String label, String value, Clipboard cb) {
        return this.type(label, value, "[\uff21-\uff3a\uff41-\uff5a]+", "\u5168\u89d2\u82f1\u5b57", cb);
    }

    public Clipboard fullSizeNumeric(String label, String value, Clipboard cb) {
        return this.type(label, value, "[\uff10-\uff19]+", "\u5168\u89d2\u6570\u5b57", cb);
    }

    public Clipboard fullSizeAlphabetNumeric(String label, String value, Clipboard cb) {
        return this.type(label, value, "[\uff10-\uff19\uff21-\uff3a\uff41-\uff5a]+", "\u5168\u89d2\u82f1\u6570\u5b57", cb);
    }

    public Clipboard email(String label, String value, Clipboard cb) {
        if (value == null || !value.matches("[0-9A-Za-z\\-_\\.@]+") || !GenericValidator.isEmail((String)value)) {
            cb.addErrorMessage(StringUtil.replace(this.cr.getString((Object)ConfigDefinition.MESSAGE_ILLEGAL_FORMAT), label));
        }
        return cb;
    }
}

