/*---------------------------------------------------------------------------
   SaikoroTable.cpp

   ---------------------------------------------------------------------------
   Copyright (C) 2002, 2003 August Nowake(앪) nowake@debilotte.net
   This program is free software; you can redistribute it and/or modify it 
   under the terms of the GNU General Public License version 2 as published 
   by the Free Software Foundation.
   This program is distributed in the hope that it will be useful, but 
      WITHOUT ANY WARRANTY;
   without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE. See the GNU General Public License for more details.
   You should have received a copy of the GNU General Public License along 
   with this program; if not, write to the Free Software Foundation, Inc., 
   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   ---------------------------------------------------------------------------
    ̃vO̓t[\tgEFAłBȂ͂At[\tgEFAc
    Ĕsꂽ GNUʌOp_(o[W2)̒߂̉ōĔЕz
    ܂͉ς邱Ƃł܂B
    ̃vO͗Lpł邱ƂĔЕz܂A
      *S̖ۏ*
    łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂܂ߑS
    ܂BڂGNU ʌOp_񏑂B
    Ȃ͂̃vOƋɁAGNU ʌOp_񏑂̕ꕔ󂯎
    ͂łB󂯎ĂȂ΁At[\tgEFAc܂ŐĂB
    ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
    Boston, MA 02111-1307 USA)
----------------------------------------------------------------------------*/

#if defined(__BORLANDC__) || defined(_MSC_VER)
#pragma hdrstop
#endif

#ifdef NDEBUG
   #undef _STLP_DEBUG
#else
   #pragma warning(disable:4786)
   #define _STLP_DEBUG 1
#endif

#include <xercesc/util/XMLUniDefs.hpp>
#include <xercesc/sax2/Attributes.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/TransService.hpp>
#include <xercesc/sax2/SAX2XMLReader.hpp>
#include <xercesc/sax2/XMLReaderFactory.hpp>

#include "wx/wx.h"

#include "main.h"
#include "SaikoroTable.h"

using namespace boost;

//---------------------------------------------------------------------------
Saikoro::TItem::~TItem()
{
};

int Saikoro::TItem::get_key_code()
{
   return holder.lock()->getKeyCode();
};

Saikoro::TKeyUpDown Saikoro::TItem::get_key_action()
{
   return holder.lock()->getKeyAction();
};

//---------------------------------------------------------------------------
Saikoro::TAppropriateWord::~TAppropriateWord()
{
   for ( TWkLearningDictionaries::iterator i = learndics.begin();
         i != learndics.end();
         ++i) {
      (*i).lock()->save();
   }
};

void Saikoro::TAppropriateWord::addChild(TSrItem Item)
{
   if (TSrDictionary d = shared_dynamic_cast<TBaseDictionary>(Item)) {
      dics.push_back(d);
      if (TSrLearningDictionary l
            = shared_dynamic_cast<TLearningDictionary>(d)) {
         learndics.push_front(TWkLearningDictionary(l));
      }
   }
};

void Saikoro::TAppropriateWord::setValue(
      const string Attribute, const string Value )
{
   if (Attribute == "id") {
      name = Value;
   }
};

void Saikoro::TAppropriateWord::addHeadwordToken( const string Token )
{
   current_index = Ignore;
   headword_table.push_front(pair<string, TStrings>());
   headword_table.front().first = Token;
   string hw = getHeadword();
   for ( TSrDictionaries::iterator i = dics.begin(); i != dics.end(); ++i ) {
      TStrings sv = i->get()->getWords( hw );
      for ( TStrings::iterator si = sv.begin(); si != sv.end(); ++si ) {
         addWord(*si);
      }
   }
};

void Saikoro::TAppropriateWord::addHeadwordToken( const int Token )
{
   if (headword_table.empty()) return;
   if (Token == Dakuon) {
      string s( headword_table.front().first );
      delete_last_token();
      addHeadwordToken( SrKanaChange->convertToDakuon( s ) );
   } else if (Token == HanDakuon) {
      string s( headword_table.front().first );
      delete_last_token();
      addHeadwordToken( SrKanaChange->convertToHanDakuon( s ) );
   } else if (Token == DeleteBack) {
      delete_last_token();
   } else if (Token == DeleteFront) {
      delete_first_token();
   }
};

void Saikoro::TAppropriateWord::addWord( const string s )
{
   t_headword_table::iterator i = headword_table.begin();
   for ( TStrings::iterator j = (*i).second.begin();
         j != (*i).second.end();
         ++j ) {
      if (*j == s) return;
   }
   current_index = Ignore;
   string hs(i->first);
   ++i;
   while (i != headword_table.end()) {
      TStrings::iterator k = (*i).second.begin();
      while (k != (*i).second.end()) {
         if (*k+hs == s) {
            k = (*i).second.erase(k);
         } else {
            ++k;
         }
      }
      hs = i->first + hs;
      ++i;
   }
   headword_table.front().second.push_back(s);
};

void Saikoro::TAppropriateWord::delete_last_token()
{
   if (headword_table.empty()) return;

   current_index = Ignore;
   t_headword_table temp( headword_table );
   headword_table.clear();
   temp.pop_front();
   for ( t_headword_table::reverse_iterator ri = temp.rbegin();
         ri != temp.rend(); ++ri ) {
      addHeadwordToken( ri->first );
   }
};

void Saikoro::TAppropriateWord::delete_first_token()
{
   if (headword_table.empty()) return;

   current_index = Ignore;
   t_headword_table temp( headword_table );
   headword_table.clear();
   temp.pop_back();
   for ( t_headword_table::reverse_iterator ri = temp.rbegin();
         ri != temp.rend(); ++ri ) {
      addHeadwordToken( ri->first );
   }
};

void Saikoro::TAppropriateWord::clear()
{
   current_index = Ignore;
   headword_table.clear();
};

string Saikoro::TAppropriateWord::getHeadword()
{
   string s = "";
   for ( t_headword_table::reverse_iterator ri = headword_table.rbegin();
         ri != headword_table.rend();
         ++ri ) {
      s += ri->first;
   }
   return s;
};

string Saikoro::TAppropriateWord::getWord( const int index )
{
   set_index( index );
   string s = registed_word + postfix();
   return s;
};

void Saikoro::TAppropriateWord::addWordToLearningDictionary(
      const string Headword, const string Word )
{
   for ( TWkLearningDictionaries::iterator i = learndics.begin();
         i != learndics.end();
         ++i ) {
      (*i).lock()->addWord( Headword, Word );
   }
};
void Saikoro::TAppropriateWord::addWordToLearningDictionary( const int Index )
{
   if (Index <= Ignore) return;
   set_index( Index );
   if ((learning_headword+index_word) == (learning_word+registed_word)) {
      addWordToLearningDictionary(
            learning_headword+index_word, learning_word+registed_word );
   } else {
      TStrings iw = divid_to_token( index_word );
      TStrings rw = divid_to_token( registed_word );
      TStrings px = postfix_token_list;
      TStrings::reverse_iterator riwi = iw.rbegin();
      TStrings::reverse_iterator rirw = rw.rbegin();
      while ((riwi != iw.rend())&&(rirw != rw.rend())) {
         if (*riwi == *rirw) {
            px.push_front( *rirw );
            ++riwi; ++rirw;
            iw.pop_back(); rw.pop_back();
         } else {
            break;
         }
      }
      learning_headword += connect_to_text( iw );
      learning_word += connect_to_text( rw );
      addWordToLearningDictionary( learning_headword, learning_word );   
      for ( TStrings::iterator j = px.begin(); j != px.end(); ++j ) {
         learning_headword += *j;
         learning_word += *j;
         addWordToLearningDictionary( learning_headword, learning_word );
      }
   }
   if (!store_with_next) {
      learning_headword.clear();
      learning_word.clear();
   }
   store_with_next = false;
}

void Saikoro::TAppropriateWord::set_index( const int Index )
{
   if (Index == current_index) return;
   postfix_token_list.clear();
   current_index = Ignore;
   index_word = "";
   registed_word = "";
   if (Index <= Ignore) {
   } else if (Index == Katakana) {
      current_index = Index;
      index_word = getHeadword();
      registed_word = SrKanaChange.get()->convertToKatakana( getHeadword() );
   } else if (Index == AsIs) {
      current_index = Index;
      index_word = getHeadword();
      registed_word = getHeadword();
   } else {
      int c(0);
      t_headword_table::iterator i = headword_table.begin();
      for ( ; i != headword_table.end(); ++i) {
         c += i->second.size();
         if (c > Index) break;
      }
      if (i == headword_table.end()) return;
      current_index = Index;
      registed_word = i->second.at( i->second.size()  - (c - current_index) );
      for ( t_headword_table::reverse_iterator ri(i);
            ri != headword_table.rend();
            ++ri ) {
         postfix_token_list.push_back( ri->first );
      }
      for ( t_headword_table::reverse_iterator ri2 = headword_table.rbegin();
            ri2 != t_headword_table::reverse_iterator(i);
            ++ri2 ) {
         index_word += ri2->first;
      }
   }
};

string Saikoro::TAppropriateWord::postfix()
{
   string s;
   for ( TStrings::iterator i = postfix_token_list.begin();
         i != postfix_token_list.end();
         ++i ) {
      s += *i;
   }
   return s;
}

Saikoro::TStrings Saikoro::TAppropriateWord::divid_to_token(
   const string Text )
{
   TShiftJisTokenizer t( Text );
   TStrings st;
   for ( TShiftJisTokenizer::iterator i = t.begin(); i != t.end(); ++i ) {
      st.push_back( *i );      
   }
   return st;
}

string Saikoro::TAppropriateWord::connect_to_text( TStrings Text )
{
   string r;
   for ( TStrings::iterator i = Text.begin(); i != Text.end(); ++i ) {
      r += *i;
   }
   return r;
}

//---------------------------------------------------------------------------
Saikoro::TStrings Saikoro::TSkkDictionary::getWords(string headword)
{
   Items::iterator i = items.find(headword);
   TStrings s;
   if (i != items.end())
      s = i->second;
   return s;
};

void Saikoro::TSkkDictionary::setValue(
      const string Attribute, const string Value)
{
   if (Attribute == "href") {
      char ch;
      string head;
      string word;
      string *target(&head);

      string file;
      file += ::wxPathOnly(wxGetApp().argv[0]).c_str();
      file += "/";
      file += Value;

      ifstream ifs(file.c_str());

      pair<string, TStrings> h;
      Items::iterator i;

      while(ifs.get(ch)) {
         if (ch & 0x80) {
            *target += ch;
            ifs.get(ch);
            *target += ch;
         } else if (ch == '\n') {
            target = &head;
            head = "";
            word = "";
         } else if (ch == '/') {
            if (word != "") {
               i = items.find(head);
               if (i != items.end())
                  i->second.push_back(word);
            }
            word = "";
         } else if (ch == ' ') {
            h.first = head;
            items.insert(h);
            target = &word;
         } else if (ch == ';') {
            if (head == "") {
               while((ch = ifs.get()) != ('\n')) {
                  if (ch == '\0')
                     return;
               }
            } else {
               *target += ch;
            }
         } else {
            *target += ch;
         }
      }
   } else if ((Attribute == "locale")||(Attribute == "Locale")) {
      locale = Value;
   }
};
//---------------------------------------------------------------------------
Saikoro::TStrings Saikoro::TLearningDictionary::getWords(string headword)
{
   Items::iterator i = items.find(headword);
   TStrings s;
   if (i != items.end()) {
      for ( ItemPairs::iterator j = i->second.begin(); j != i->second.end(); ++j)
         s.push_back(j->second);
   }
   return s;
};

void Saikoro::TLearningDictionary::addWord(const string headword,
   const string word, const unsigned int count)
{
   unsigned int c(count);
   if (c >= maxcount)
      c = maxcount;

   if (headword.empty() || word.empty())
      return;

   addCount(headword, word, c);
}

bool Saikoro::TLearningDictionary::addCount(
      const string headword, const string word, unsigned int count)
{
   Items::iterator i = items.find(headword);
   if (i == items.end()) {
      ItemPairs ips;
      ips.insert(make_pair(count, word));
      items.insert(make_pair(headword, ips));
   } else {
      ItemPairs::iterator it;
      for ( it = i->second.begin(); it != i->second.end(); ++it) {
         if (it->second == word)
            break;
      }
      if (it == i->second.end()) {
         i->second.insert(make_pair(count, word));
      } else if (it->first != maxcount) {
         if ((it->first + count) < maxcount)
            count += it->first;
         else
            count = maxcount;
         i->second.insert(make_pair(count, it->second));
         i->second.erase(it);
      }
   }
   return true;
};

void Saikoro::TLearningDictionary::setValue(const string Attribute, const string Value)
{
   if (Attribute == "href") {
      char ch;
      string head;
      string word;
      string countstring;
      unsigned int count;
      string *target(&head);

      filename += ::wxPathOnly(wxGetApp().argv[0]).c_str();
      filename += "/";
      filename += Value;

      ifstream ifs(filename.c_str());

      while(ifs.get(ch)) {
         if (ch & 0x80) {
            *target += ch;
            ifs.get(ch);
            *target += ch;
         } else if (ch == '\n') {
            target = &head;
            head = "";
            word = "";
            countstring = "1";
            count = 1;
         } else if (ch == '/') {
            if ((head != "")&&(word != "")) {
               istringstream is(countstring);
               is >> count;
               if (count > maxcount)
                  count = maxcount;
               addWord(head, word, count);
            }
            word = "";
            countstring = "1";
            count = 1;
            target = &word;
         } else if (ch == '\\') {
            target = &countstring;
            countstring = "0";
         } else if (ch == ' ') {
            target = &word;
         } else if (ch == ';') {
            if (head == "") {
               while(ifs.get(ch)) {
                  if (ch == '\n')
                     break;
               }
            } else {
            *target += ch;
            }
         } else {
            *target += ch;
         }
      }
   } else if ((Attribute == "maxcount")||(Attribute == "MaxCount")) {
      istringstream is(Value);
      is >> hex >> maxcount;
   }
};


void Saikoro::TLearningDictionary::save()
{
   if (filename.empty()) return;

   ofstream ofs(filename.c_str(), ios::out|ios::trunc);
   ofs << ";; okuri-ari entries." << endl << ";; okuri-nasi entries." << endl;
   for ( Items::iterator i = items.begin(); i != items.end(); ++i) {
      ofs << i->first << " /";
      for ( ItemPairs::iterator it = i->second.begin();
            it != i->second.end(); ++it)
      {
         ofs << it->second << "\\" <<  it->first << "/";
      }
      ofs << endl;
   }
};

//---------------------------------------------------------------------------
void Saikoro::TSendKey::setValue(const string Attribute, const string Value)
{
   string sa(Attribute);
   transform(sa.begin(), sa.end(), sa.begin(), tolower);
   string sv(Value);
   transform(sv.begin(), sv.end(), sv.begin(), tolower);
   if (sa == "code") {
      code = convert_code(sv);
   } else if (sa == "iskeyup") {
      if (sv == "true")
         keyupdown =Up;
      else
         keyupdown = Down;
   } else if (sa == "shift") {
      if (sv == "forceup")
         shift =Up;
      else
         shift = Down;
   } else if (sa == "ctrl") {
      if (sv == "forceup")
         ctrl =Up;
      else
         ctrl = Down;
   } else if (sa == "alt") {
      if (sv == "forceup")
         alt =Up;
      else
         alt = Down;
   } else if (sa == "kana") {
      if (sv == "forceup")
         kana =Up;
      else
         kana = Down;
   } else if (sa == "guideword") {
      guideword = Value;
   } else if (sa == "fontcolor") {
      istringstream is(sv);
      is >> hex >> fontcolor;
   }
};

int Saikoro::TSendKey::convert_code(const std::string& val)
{
   if(val == "0") return 0x30;
   if(val == "1") return 0x31;
   if(val == "2") return 0x32;
   if(val == "3") return 0x33;
   if(val == "4") return 0x34;
   if(val == "5") return 0x35;
   if(val == "6") return 0x36;
   if(val == "7") return 0x37;
   if(val == "8") return 0x38;
   if(val == "9") return 0x39;
   if(val == "a") return 0x41;
   if(val == "b") return 0x42;
   if(val == "c") return 0x43;
   if(val == "d") return 0x44;
   if(val == "e") return 0x45;
   if(val == "f") return 0x46;
   if(val == "g") return 0x47;
   if(val == "h") return 0x48;
   if(val == "i") return 0x49;
   if(val == "j") return 0x4a;
   if(val == "k") return 0x4b;
   if(val == "l") return 0x4c;
   if(val == "m") return 0x4d;
   if(val == "n") return 0x4e;
   if(val == "o") return 0x4f;
   if(val == "p") return 0x50;
   if(val == "q") return 0x51;
   if(val == "r") return 0x52;
   if(val == "s") return 0x53;
   if(val == "t") return 0x54;
   if(val == "u") return 0x55;
   if(val == "v") return 0x56;
   if(val == "w") return 0x57;
   if(val == "x") return 0x58;
   if(val == "y") return 0x59;
   if(val == "z") return 0x5a;
   if(val == "_a") return 0x33;
   if(val == "_i") return 0x45;
   if(val == "_u") return 0x34;
   if(val == "_e") return 0x35;
   if(val == "_o") return 0x36;
   if(val == "_ka") return 0x54;
   if(val == "_ki") return 0x47;
   if(val == "_ku") return 0x48;
   if(val == "_ke") return 0xba;
   if(val == "_ko") return 0x42;
   if(val == "_sa") return 0x58;
   if(val == "_si") return 0x44;
   if(val == "_su") return 0x52;
   if(val == "_se") return 0x50;
   if(val == "_so") return 0x43;
   if(val == "_ta") return 0x51;
   if(val == "_ti") return 0x41;
   if(val == "_tu") return 0x5a;
   if(val == "_te") return 0x57;
   if(val == "_to") return 0x53;
   if(val == "_na") return 0x55;
   if(val == "_ni") return 0x49;
   if(val == "_nu") return 0x31;
   if(val == "_ne") return 0xbc;
   if(val == "_no") return 0x4b;
   if(val == "_ha") return 0x46;
   if(val == "_hi") return 0x56;
   if(val == "_hu") return 0x32;
   if(val == "_he") return 0xde;
   if(val == "_ho") return 0xbd;
   if(val == "_ma") return 0x4a;
   if(val == "_mi") return 0x4e;
   if(val == "_mu") return 0xdd;
   if(val == "_me") return 0xbf;
   if(val == "_mo") return 0x4d;
   if(val == "_ya") return 0x37;
   if(val == "_yu") return 0x38;
   if(val == "_yo") return 0x39;
   if(val == "_ra") return 0x4f;
   if(val == "_ri") return 0x4c;
   if(val == "_ru") return 0xbe;
   if(val == "_re") return 0xbb;
   if(val == "_ro") return 0xe2;
   if(val == "_wa") return 0x30;
   if(val == "_daku") return 0xc0;
   if(val == "_hann") return 0xdb;
   if(val == "_-") return 0xdc;

   int v;
   istringstream is(val);
   is >> hex >> v;
   if (( 1 <= v)&&(v <= 255)) return v;
   return 0;
};

bool Saikoro::TSendKey::executeKeyEvent()
{
   int kc;
   if (code == AsIs) {
      kc = get_key_code();
   } else {
      kc = code;
   }

   bool sup = IsKeyUp(ShiftKeyCode);
   bool cup = IsKeyUp(ControlKeyCode);
   bool aup = IsKeyUp(MenuKeyCode);
   bool kup = IsKeyUp(KanaKeyCode);

   bool scng = setupKeyStatus(shift, sup, ShiftKeyCode);
   bool ccng = setupKeyStatus(ctrl, cup, ControlKeyCode);
   bool acng = setupKeyStatus(alt, aup, MenuKeyCode);
   bool kcng = setupKeyStatus(kana, kup, KanaKeyCode);

   if (keyupdown == DownAndUp) {
      SendKeyboardEvent(kc, false);
      SendKeyboardEvent(kc, true);
   } else if (keyupdown == Up) {
      SendKeyboardEvent(kc, true);
   } else if (keyupdown == Down) {
      SendKeyboardEvent(kc, false);
      if (get_key_action()  == Up) {
         SendKeyboardEvent(kc, true);
      } else {
         holder.lock()->setDownedKey(get_key_code(), kc);
      }
   }

   if (kcng) {
      SendKeyboardEvent(KanaKeyCode, kup);
   }
   if (acng) {
      SendKeyboardEvent(MenuKeyCode, aup);
   }
   if (ccng) {
      SendKeyboardEvent(ControlKeyCode, cup);
   }
   if (scng) {
      SendKeyboardEvent(ShiftKeyCode, sup);
   }
   return true;
};

bool Saikoro::TSendKey::setupKeyStatus(TKeyUpDown st, bool cs, int vk)
{
   if ((st == Up)&&(!cs)) {
      SendKeyboardEvent(vk, true);
      return true;
   } else if ((st == Down)&&(cs)) {
      SendKeyboardEvent(vk, false);
      return true;
   } else {
      return false;
   }
};

//---------------------------------------------------------------------------
void Saikoro::TUseTable::setValue(const string Attribute, const string Value)
{
   if (Attribute == "idref")
      name = Value;
};

bool Saikoro::TUseTable::executeKeyEvent()
{
   return
      holder.lock()->executeKeyEvent(name, get_key_code(), get_key_action() );
};

string Saikoro::TUseTable::getWord( )
{
   return holder.lock()->getWord( name, get_key_code(), get_key_action() );
};

//---------------------------------------------------------------------------
void Saikoro::TChangeTable::setValue(const string Attribute, const string Value)
{
   if (Attribute == "idref")
      name = Value;
};

bool Saikoro::TChangeTable::executeKeyEvent()
{
   holder.lock()->changeCurrentTable(name);
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TSetGlobalImeStatus::setValue(const string Attribute, const string Value)
{
   string sa(Attribute);
   transform(sa.begin(), sa.end(), sa.begin(), tolower);
   string sv(Value);
   transform(sv.begin(), sv.end(), sv.begin(), tolower);
	if (sa == "status") {
		if (sv == "on")
			status = ImeOn;
		else if (sv == "off")
			status = ImeOff;
      else if (sv == "alphanumeric")
         status = AlphaNumeric;
      else if (sv == "native")
         status = Native;
	}
}

bool Saikoro::TSetGlobalImeStatus::executeKeyEvent()
{
   if (status == ImeOn)
      SetGlobalImeOn();
   else if (status == ImeOff)
      SetGlobalImeOff();
   else if (status == AlphaNumeric)
      SetGlobalImeAlphaNumeric();
   else if (status == Native)
      SetGlobalImeNative();
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TInputGlobalIme::setValue(const string Attribute, const string Value)
{
   string sa(Attribute);
   transform(sa.begin(), sa.end(), sa.begin(), tolower);
	if (sa == "input")
      s = Value;
}

bool Saikoro::TInputGlobalIme::executeKeyEvent()
{
   InputGlobalIme(s);
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TInputIme::setValue(const string Attribute, const string Value)
{
   string sa(Attribute);
   transform(sa.begin(), sa.end(), sa.begin(), tolower);
   if (sa == "input")
      s = Value;
   else if (sa == "idref")
      awname = Value;
};

bool Saikoro::TInputIme::executeKeyEvent()
{
   holder.lock()->getAppropriateWord(awname).lock()->addHeadwordToken(s);
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TDeleteImeHeadword::setValue(const string Attribute, const string Value)
{
   if (Attribute == "idref")
      awname = Value;
};

bool Saikoro::TDeleteImeHeadword::executeKeyEvent()
{
   holder.lock()->getAppropriateWord(awname).lock()->clear();
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TChangeImeLastTokenToDakuon::setValue(const string Attribute, const string Value)
{
   if (Attribute == "idref")
      awname = Value;
};

bool Saikoro::TChangeImeLastTokenToDakuon::executeKeyEvent()
{
   holder.lock()->getAppropriateWord(awname).lock()->addHeadwordToken( Dakuon );
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TChangeImeLastTokenToHanDakuon::setValue(const string Attribute, const string Value)
{
   if (Attribute == "idref")
      awname = Value;
};

bool Saikoro::TChangeImeLastTokenToHanDakuon::executeKeyEvent()
{
   holder.lock()->getAppropriateWord(awname).lock()
         ->addHeadwordToken( HanDakuon );
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TDeleteImeFirstToken::setValue(const string Attribute, const string Value)
{
   if (Attribute == "idref")
      awname = Value;
};

bool Saikoro::TDeleteImeFirstToken::executeKeyEvent()
{
   holder.lock()->getAppropriateWord(awname).lock()
         ->addHeadwordToken( DeleteFront );
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TDeleteImeLastToken::setValue(const string Attribute, const string Value)
{
   if (Attribute == "idref")
      awname = Value;
};

bool Saikoro::TDeleteImeLastToken::executeKeyEvent()
{
   holder.lock()->getAppropriateWord(awname).lock()
         ->addHeadwordToken( DeleteBack );
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TSendImeWord::setValue(const string Attribute, const string Value)
{
   string sa(Attribute);
   transform(sa.begin(), sa.end(), sa.begin(), tolower);
   string sv(Value);
   transform(sv.begin(), sv.end(), sv.begin(), tolower);
   if (sa == "index") {
      if (sv == "asis") {
         index = AsIs;
      } else if (sv == "katakana") {
         index = Katakana;
      } else {
         istringstream is(Value);
         is >> index;
      }
   } else if (sa == "idref")
      awname = Value;
};

bool Saikoro::TSendImeWord::executeKeyEvent()
{
   TWkAppropriateWord aw = holder.lock()->getAppropriateWord(awname);
   string h(aw.lock()->getHeadword());
   string w = "";
   if (index == Katakana) {
      w = aw.lock()->getWord( Katakana );
      SendWordToWindow( w );
   } else if (index == AsIs) {
      SendWordToWindow( aw.lock()->getHeadword() );
   } else {
      w = aw.lock()->getWord( index );
      SendWordToWindow( w );
   }
   aw.lock()->addWordToLearningDictionary( index );
   holder.lock()->getAppropriateWord().lock()->clear();
   return true;
};

string Saikoro::TSendImeWord::getWord()
{
   if (index == Katakana) {
      return holder.lock()->getAppropriateWord(awname).lock()
            ->getWord( Katakana );
   } else if (index == AsIs) {
      return holder.lock()->getAppropriateWord(awname).lock()->getHeadword();
   } else {
      return holder.lock()->getAppropriateWord(awname).lock()->getWord(index);
   }
};

//---------------------------------------------------------------------------
bool Saikoro::TStoreLearningDictionaryWithNext::executeKeyEvent()
{
   holder.lock()->getAppropriateWord(awname).lock()
         ->doStoreLearningDictionaryWithNext();
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TValueStatus::setHolder(TWkHolder Holder)
{
   TItem::setHolder(Holder);
   aw = Holder.lock()->getAppropriateWord();
};

void Saikoro::TValueStatus::setValue(const string Attribute, const string Value)
{
   string sa(Attribute);
   transform(sa.begin(), sa.end(), sa.begin(), tolower);
   string sv(Value);
   transform(sv.begin(), sv.end(), sv.begin(), tolower);
   if (sa == "name") {
      if (sv == "all") {
         index = all;
      } else if (sv == "headwordexists") {
         index = headword_exists;
      } else if (sv == "currentequalsecondfromlasttime") {
         index = current_equal_second_from_last_time;
      } else {
         istringstream is(Value);
         is >> index;
      }
   } else if (sa == "value") {
      istringstream is(sv);
      is >> boolalpha >> val;
   }
};

void Saikoro::TValueStatus::addChild(TSrItem Item)
{
   if (TSrValueStatus ti = boost::shared_dynamic_cast<TValueStatus>(Item)) {
      items.push_back(ti);
   }
};

void Saikoro::TValueStatus::setGlobalStatus()
{
   if (index == all) {
      for ( unsigned int i = 0; i < holder.lock()->getGlobalValueCount(); ++i)
         holder.lock()->setGlobalValue(i, val);
   } else if (index == headword_exists) {
   } else if (index == current_equal_second_from_last_time) {
   } else {
      holder.lock()->setGlobalValue(index, val);
   }
};

bool Saikoro::TValueStatus::checkGlobalStatus()
{
   bool t(false);
   if (index == headword_exists) { //headwordexists
      t = (aw.lock()->isHeadwordExists() == val);
   } else if (index == current_equal_second_from_last_time) {
      t = (holder.lock()->getCurrentTableName()
            == holder.lock()->getSecondFromLastTimeTableName());
   } else {
      t = (holder.lock()->getGlobalValue(index) == val);
   }
   if (!t) {
      return false;
   } else if (items.empty()) {
      return t;
   } else {
      t = false;
      for ( TSrValueStatuses::iterator iter = items.begin();
            iter != items.end(); ++iter) {
         t = (t | (iter->get()->checkGlobalStatus()));
      }
      return t;
   }
};

//---------------------------------------------------------------------------
void Saikoro::TSetStatus::addChild(TSrItem Item)
{
   if (TSrValueStatus ti = boost::shared_dynamic_cast<TValueStatus>(Item)) {
      val.push_back(ti);
   }
};

bool Saikoro::TSetStatus::executeKeyEvent()
{
   for ( TSrValueStatuses::iterator ti = val.begin(); ti != val.end(); ++ti)
      ti->get()->setGlobalStatus();
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TExecuteIf::addChild(TSrItem Item)
{
   if (TSrValueStatus ti = boost::shared_dynamic_cast<TValueStatus>(Item)) {
      val.push_back(ti);
   } else {
      items.push_back(Item);
   }
};

bool Saikoro::TExecuteIf::executeKeyEvent()
{
   for ( TSrValueStatuses::iterator i = val.begin(); i != val.end(); ++i) {
      if (!(i->get()->checkGlobalStatus())) return true;
   }
   for ( TSrItems::iterator i = items.begin(); i != items.end(); ++i ) {
      i->get()->executeKeyEvent();
   }
   return true;
};

string Saikoro::TExecuteIf::getWord()
{
   for ( TSrValueStatuses::iterator i = val.begin(); i != val.end(); ++i ) {
      if (!(i->get()->checkGlobalStatus())) return "";
   }
   string s;
   for ( TSrItems::iterator i = items.begin(); i != items.end(); ++i ) {
      s = i->get()->getWord();
      if (s != "") return s;
   }
   return "";
};

//---------------------------------------------------------------------------
void Saikoro::TKeyEvent::setValue(const string Attribute, const string Value)
{
   string sa(Attribute);
   transform(sa.begin(), sa.end(), sa.begin(), tolower);
   string sv(Value);
   transform(sv.begin(), sv.end(), sv.begin(), tolower);
   if (sa == "code") {
      if (sv == "other") {
         code = OtherKey;
      } else {
         istringstream is(Value);
         int v;
         is >> hex >> v;
         if (( 1 <= v)&&(v <= 255))
            code = v;
      }
   } else if (sa == "iskeyup") {
      if (sv == "true")
         key =Up;
      else
         key = Down;
   } else if (sa == "dootherkey") {
      if (sv == "true")
         dootherkey = Positive;
      else
         dootherkey = Negative;
   }
};

void Saikoro::TKeyEvent::addChild(TSrItem Item)
{
   items.push_back(Item);
};

bool Saikoro::TKeyEvent::executeKeyEvent()
{
   if ((get_key_code() != code)&&(code != OtherKey)&&(code != AllKey))
         return true;

   bool t(false);
   for ( TSrItems::iterator i = items.begin(); i != items.end(); ++i ) {
      t = t | i->get()->executeKeyEvent();
   }

   if (dootherkey == Neutral) {
      return t;
   } else if (dootherkey == Negative) {
      return true;
   } else {
      return false;
   }
};

string Saikoro::TKeyEvent::getWord()
{
   string s;
   for ( TSrItems::iterator i = items.begin(); i != items.end(); ++i ) {
      s = i->get()->getWord();
      if (s != "") return s;
   }
   return "";
};

//---------------------------------------------------------------------------
Saikoro::TTable::TTable()
{
   upkeytable.resize(256);
   downkeytable.resize(256);
};

void Saikoro::TTable::setValue(const string Attribute, const string Value)
{
   if (Attribute == "id")
      name = Value;
};

void Saikoro::TTable::addChild(TSrItem Item)
{
   if (TKeyEvent *k = dynamic_cast<TKeyEvent*>(Item.get())) {
      if (k->isAllKey()) {
         if (k->isUpKey()) {
            for ( TSrItemMatrix2::iterator iter = upkeytable.begin();
                  iter != upkeytable.end(); ++iter) {
               iter->push_back(Item);
            }
         }
         if (k->isDownKey()) {
            for ( TSrItemMatrix2::iterator iter = downkeytable.begin();
                  iter != downkeytable.end(); ++iter) {
               iter->push_back(Item);
            }
         }
      } else if (k->isOtherKey()) {
         if (k->isUpKey()) {
            otherupkeylist.push_back(Item);
         }
         if (k->isDownKey()) {
            otherdownkeylist.push_back(Item);
         }
      } else {
         if (k->isUpKey()) {
            upkeytable.at(k->getCode()).push_back(Item);
         }
         if (k->isDownKey()) {
            downkeytable.at(k->getCode()).push_back(Item);
         }
      }
   }
};

bool Saikoro::TTable::executeKeyEvent()
{
   if ((get_key_code() < 1)||(255 < get_key_code())) return false;

   bool doevent(false);
   if ((get_key_action() == Down)||(get_key_action() == DownAndUp)) {
      for ( TSrItems::iterator iter = downkeytable[get_key_code()].begin();
            iter != downkeytable[get_key_code()].end();
            ++iter) {
         doevent = doevent | iter->get()->executeKeyEvent();
      }
   }
   if ((get_key_action() == Up)||(get_key_action() == DownAndUp)) {
      for ( TSrItems::iterator i = upkeytable[get_key_code()].begin();
            i != upkeytable[get_key_code()].end();
            ++i ) {
         doevent = doevent | i->get()->executeKeyEvent();
      }
   }
   if (!doevent) {
      if ((get_key_action() == Down)||(get_key_action() == DownAndUp)) {
         for ( TSrItems::iterator i = otherdownkeylist.begin();
               i != otherdownkeylist.end();
               ++i ) {
            i->get()->executeKeyEvent();
         }
      }
      if ((get_key_action() == Up)||(get_key_action() == DownAndUp)) {
         for ( TSrItems::iterator i = otherupkeylist.begin();
               i != otherupkeylist.end();
               ++i ) {
            i->get()->executeKeyEvent();
         }
      }
   }
   return true;
};

string Saikoro::TTable::getWord()
{
   if ((get_key_code() < 1)||(255 < get_key_code())) return "";

   string s;
   bool doevent(false);
   if ((get_key_action() == Down)||(get_key_action() == DownAndUp)) {
      for ( TSrItems::iterator i = downkeytable[get_key_code()].begin();
            i != downkeytable[get_key_code()].end();
            ++i ) {
         s = i->get()->getWord();
         doevent = true;
         if (s != "") return s;
      }
   }
   if ((get_key_action() == Up)||(get_key_action() == DownAndUp)) {
      for ( TSrItems::iterator i = upkeytable[get_key_code()].begin();
            i != upkeytable[get_key_code()].end();
            ++i ) {
         s = i->get()->getWord();
         doevent = true;
         if (s != "") return s;
      }
   }
   if (!doevent) {
      if ((get_key_action() == Down)||(get_key_action() == DownAndUp)) {
         for ( TSrItems::iterator i = otherdownkeylist.begin();
               i != otherdownkeylist.end();
               ++i) {
            s = i->get()->getWord();
            if (s != "") return s;
         }
      }
      if ((get_key_action() == Up)||(get_key_action() == DownAndUp)) {
         for ( TSrItems::iterator i = otherupkeylist.begin();
            i != otherupkeylist.end();
            ++i ) {
            s = i->get()->getWord();
            if (s != "") return s;
         }
      }
   }
   return s;
};

//---------------------------------------------------------------------------
bool Saikoro::TShowFrame::executeKeyEvent()
{
   ::wxGetApp().getFrame()->Show();
   return true;
};
//---------------------------------------------------------------------------
bool Saikoro::THideFrame::executeKeyEvent()
{
   ::wxGetApp().getFrame()->Hide();
   return true;
};
//---------------------------------------------------------------------------
bool Saikoro::TShowRegistFrame::executeKeyEvent()
{
   ::wxGetApp().getFrame()->showRegistFrame();
   return true;
};

//---------------------------------------------------------------------------
void Saikoro::TAppropriateWordHolder::addAppropriateWord(
      string name, TSrAppropriateWord aword )
{
   awt.insert( make_pair( name, aword ) );
   if (aw.expired()) {
      aw = aword;
   }
};

Saikoro::TWkAppropriateWord Saikoro::TAppropriateWordHolder::getAppropriateWord(const string s)
{
   if (awt.size() <= 1) {
      return aw;
   } else {
      AppropriateWordTable::iterator i = awt.find(s);
      if (i != awt.end()) {
         return i->second;
      } else {
         return TWkAppropriateWord();
      }
   }
};

void Saikoro::TAppropriateWordHolder::addHeadwordToken(const string s)
{
   for ( AppropriateWordTable::iterator i = awt.begin();
         i != awt.end();
         ++i ) {
      i->second->addHeadwordToken(s);
   }
};

void Saikoro::TAppropriateWordHolder::deleteLastToken()
{
   for ( AppropriateWordTable::iterator i = awt.begin();
         i != awt.end();
         ++i ) {
      i->second->addHeadwordToken( DeleteBack );
   }
};


void Saikoro::TAppropriateWordHolder::clear()
{
   for ( AppropriateWordTable::iterator i = awt.begin();
         i != awt.end();
         ++i ) {
      i->second->clear();
   }
};

string Saikoro::TAppropriateWordHolder::getHeadword()
{
	if (TAppropriateWord *a = aw.lock().get())
      return a->getHeadword();
	else
		return "";
};

string Saikoro::TAppropriateWordHolder::getWord(const int index)
{
	if (TAppropriateWord *a = aw.lock().get())
		return a->getWord(index);
	else
		return "";
};

void Saikoro::TAppropriateWordHolder::addWordToLearningDictionary(string head, string word)
{
	if (TAppropriateWord *a = aw.lock().get())
		a->addWordToLearningDictionary(head, word);
};

void Saikoro::TAppropriateWordHolder::doStoreLearningDictionaryWithNext()
{
	if (TAppropriateWord *a = aw.lock().get())
		a->doStoreLearningDictionaryWithNext();
};

bool Saikoro::TAppropriateWordHolder::isHeadwordExists()
{
	if (TAppropriateWord *a = aw.lock().get())
		return a->isHeadwordExists();
   else
      return false;
};

//---------------------------------------------------------------------------
Saikoro::THolder::THolder() : isusingclipboard(false)
{
   awh = TSrAppropriateWordHolder(new TAppropriateWordHolder);
};

void Saikoro::THolder::addChild(TSrItem Item)
{
   if (TSrTable ti = boost::shared_dynamic_cast<TTable>(Item)) {
      tableitems.insert(pair<string, TSrTable>(ti->getName(), ti));
      if ((ti->getName() == "normal")||(ti->getName() == "Normal")) {
         currenttable = TWkTable(ti);
      }
   } else if (TSrAppropriateWord wd
         = boost::shared_dynamic_cast<TAppropriateWord>(Item)) {
      string n = wd->getName();
      awh->addAppropriateWord(n, wd);
   }
};

bool Saikoro::THolder::executeKeyEvent(int KeyCode, TKeyUpDown KeyAction)
{
   if ((KeyCode < 0)||(MaxKeyCode <= KeyCode)) return false;

   key_code = KeyCode;
   key_action = KeyAction;

   if ((KeyAction == Saikoro::Up)||(KeyAction == Saikoro::DownAndUp)) {
      for ( int i = 0; i < MaxKeyCode; ++i) {
         if (downedkey[KeyCode][i]) {
            SendKeyboardEvent(i, true);
            for ( int j = 0; j < MaxKeyCode; ++j)
               downedkey[j][i] = false;
         }
      }
   }

   return currenttable.lock()->executeKeyEvent();
};

bool Saikoro::THolder::executeKeyEvent(
      string tablename, int KeyCode, TKeyUpDown KeyAction)
{
   if ((KeyCode < 0)||(MaxKeyCode <= KeyCode)) return false;
   map<string, TSrTable>::iterator i = tableitems.find(tablename);
   if (i == tableitems.end()) return false;

   key_code = KeyCode;
   key_action = KeyAction;

   return i->second->executeKeyEvent();
};

void Saikoro::THolder::setDownedKey(int RealKeyCode, int SimulatedKeyCode)
{
   if ((RealKeyCode < 0)||(MaxKeyCode  <= RealKeyCode)
      ||(SimulatedKeyCode < 0)||(MaxKeyCode <= SimulatedKeyCode))
      return;

   downedkey[RealKeyCode][SimulatedKeyCode] = true;
};

void Saikoro::THolder::changeCurrentTable(string name)
{
   map<string, TSrTable>::iterator i = tableitems.find(name);
   if (i != tableitems.end()) {
      secondfromlasttimetable = lasttimetable;
      lasttimetable = currenttable;
      currenttable = i->second;
   }
};

void Saikoro::THolder::setGlobalValue(unsigned int index, bool Value)
{
   if (val.size() < index+1)
      val.resize(index+1, false);
   val[index] = Value;
};

bool Saikoro::THolder::getGlobalValue(unsigned int index)
{
   if (val.size() < index+1)
      val.resize(index+1, false);

   return val.at(index);
};

string Saikoro::THolder::getWord(int KeyCode, TKeyUpDown KeyAction)
{
   if ((KeyCode < 0)||(MaxKeyCode <= KeyCode)) return "";
   
   key_code = KeyCode;
   key_action = KeyAction;

   return currenttable.lock()->getWord();
};

string Saikoro::THolder::getWord(string name, int KeyCode, TKeyUpDown KeyAction)
{
   if ((KeyCode < 0)||(MaxKeyCode <= KeyCode)) return "";
   map<string, TSrTable>::iterator i = tableitems.find(name);
   if (i == tableitems.end()) return string();
   
   key_code = KeyCode;
   key_action = KeyAction;

   return i->second->getWord();
};


Saikoro::TWkAppropriateWord Saikoro::THolder::getAppropriateWord(string s)
{
   TWkAppropriateWord wd = awh->getAppropriateWord(s);
   if (wd.expired())
      wd = TWkAppropriateWord(awh);
   return wd;
};
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
Saikoro::TSrHolder Saikoro::THolderFactory::createHolder(string filename)
{
   factory.Register("appropriateword", TAppropriateWord::Create);
   factory.Register("skkdictionary", TSkkDictionary::Create);
   factory.Register("learningdictionary", TLearningDictionary::Create);
   factory.Register("sendkey", TSendKey::Create);
   factory.Register("usetable", TUseTable::Create);
   factory.Register("changetable", TChangeTable::Create);
   factory.Register("setglobalimestatus", TSetGlobalImeStatus::Create);	
   factory.Register("inputglobalime", TInputGlobalIme::Create);
   factory.Register("inputime", TInputIme::Create);
   factory.Register("deleteimeheadword", TDeleteImeHeadword::Create);
   factory.Register("deleteimefirsttoken", TDeleteImeFirstToken::Create);
   factory.Register("deleteimelasttoken", TDeleteImeLastToken::Create);
   factory.Register("changeimelasttokentodakuon", TChangeImeLastTokenToDakuon::Create);
   factory.Register("changeimelasttokentohandakuon", TChangeImeLastTokenToHanDakuon::Create);
   factory.Register("sendimeword", TSendImeWord::Create);
   factory.Register("storelearndicwithnext", TStoreLearningDictionaryWithNext::Create);
   factory.Register("storelearningdictionarywithnext", TStoreLearningDictionaryWithNext::Create);
   factory.Register("valuestatus", TValueStatus::Create);
   factory.Register("setstatus", TSetStatus::Create);
   factory.Register("executeif", TExecuteIf::Create);
   factory.Register("keyevent", TKeyEvent::Create);
   factory.Register("table", TTable::Create);
   factory.Register("showframe", TShowFrame::Create);
   factory.Register("hideframe", THideFrame::Create);
   factory.Register("showregistframe", TShowRegistFrame::Create);
   factory.Register("configuration", THolder::Create);

   XMLPlatformUtils::Initialize();
   XMLTransService::Codes failReason;
   transcoder = boost::shared_ptr<XMLTranscoder>(
      XMLPlatformUtils::fgTransService->makeNewTranscoderFor(
         "Shift_JIS", failReason, bufStringSize,
         XMLPlatformUtils::fgMemoryManager
      )
   );
   auto_ptr<SAX2XMLReader> parser
         = auto_ptr<SAX2XMLReader>(XMLReaderFactory::createXMLReader());
   parser->setContentHandler(this);
   parser->parse(filename.c_str());
   TSrHolder th = boost::shared_dynamic_cast<THolder>(items.front());   
   return th;
}

void Saikoro::THolderFactory::startElement(const XMLCh* const uri,
   const XMLCh* const localname, const XMLCh* const qname,
   const Attributes& Attributes)
{
   char *n = XMLString::transcode(localname);
   string sn(n);
   transform(sn.begin(), sn.end(), sn.begin(), tolower);
   TSrItem si(factory.CreateObject(sn));
   XMLString::release(&n);

   for ( unsigned int i=0; i<Attributes.getLength(); i++) {
      char *q = XMLString::transcode(Attributes.getQName(i));
      unsigned int charsEaten;
      XMLByte buf[bufStringSize] = {};
      transcoder->transcodeTo(
         Attributes.getValue(i), XMLString::stringLen(Attributes.getValue(i)),
         buf, bufStringSize, charsEaten, XMLTranscoder::UnRep_Throw
      );
      si->setValue(q, reinterpret_cast<char*>(buf));
      XMLString::release(&q);
   }
   if (items.empty()) {
      items.push_back(si);
      wh = TWkHolder(boost::shared_dynamic_cast<THolder, TItem>(si));
   }
   si->setHolder(wh);
   items.back()->addChild(si);
   items.push_back(si);
};

#if defined(__BORLANDC__)
#pragma package(smart_init)
#endif
