/*---------------------------------------------------------------------------
   main.h

   ---------------------------------------------------------------------------
   Copyright (C) 2002, 2003 August Nowake(앪) nowake@debilotte.net
   This program is free software; you can redistribute it and/or modify it 
   under the terms of the GNU General Public License version 2 as published 
   by the Free Software Foundation.
   This program is distributed in the hope that it will be useful, but 
      WITHOUT ANY WARRANTY;
   without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE. See the GNU General Public License for more details.
   You should have received a copy of the GNU General Public License along 
   with this program; if not, write to the Free Software Foundation, Inc., 
   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   ---------------------------------------------------------------------------
    ̃vO̓t[\tgEFAłBȂ͂At[\tgEFAc
    Ĕsꂽ GNUʌOp_(o[W2)̒߂̉ōĔЕz
    ܂͉ς邱Ƃł܂B
    ̃vO͗Lpł邱ƂĔЕz܂A
      *S̖ۏ*
    łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂܂ߑS
    ܂BڂGNU ʌOp_񏑂B
    Ȃ͂̃vOƋɁAGNU ʌOp_񏑂̕ꕔ󂯎
    ͂łB󂯎ĂȂ΁At[\tgEFAc܂ŐĂB
    ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
    Boston, MA 02111-1307 USA)
----------------------------------------------------------------------------*/

#ifndef SAIKORO_MAINH
#define SAIKORO_MAINH

#ifdef NDEBUG
   #undef _STLP_DEBUG
#else
   #pragma warning( disable:4786 )
   #define _STLP_DEBUG 1
#endif 

#ifdef __GNUG__
#pragma interface "main.h"
#endif 

#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif 

#if defined(__WXGTK__)||defined(__WXX11__)||defined(__WXMOTIF__)||defined(__WXMAC__)
   #include "../../../Common/SaikoroIcon.xpm"
#endif 

#include "SaikoroTable.h"
#include <wx/minifram.h>
#include <wx/taskbar.h>

//----------------------------------------------------------------------------
static const wxString CommantName = wxT( "Saikoro" );
static wxLocale LocaleObject( wxLANGUAGE_DEFAULT );
static wxMutex MutexObject;

//----------------------------------------------------------------------------
class SaikoroFrame;

//----------------------------------------------------------------------------
class SaikoroTaskBarIcon : public wxTaskBarIcon {
public:
   SaikoroTaskBarIcon(){};
   virtual void OnLButtonDown(wxTaskBarIconEvent&);
   DECLARE_EVENT_TABLE();
};

//----------------------------------------------------------------------------

class SaikoroApp : public wxApp {
public:
   SaikoroFrame* getFrame(){ return frame; };
private:
   bool isHookOwner;
	bool isImeControlerOwner;
   virtual bool OnInit();
   int OnExit();
   SaikoroFrame *frame;
   wxString get_config_filename();
};
DECLARE_APP( SaikoroApp );

//----------------------------------------------------------------------------
class SaikoroText : public wxStaticText {
public:
   SaikoroText(
         unsigned int keyno, wxWindow *parent,
         const wxPoint& pos = wxDefaultPosition,
         const wxSize& size = wxSize( 60, 12 ) );
   unsigned int getKeyNo() { return no; };
private:
   unsigned int no;
};

enum {
   ID_Quit = 1,
   ID_About,
   ID_RegistWord,
   ID_ToggleInput,
   Btn_OK,
};

class SaikoroFrame : public wxFrame {
public:
   SaikoroFrame(
         wxWindow *parent,
         wxWindowID id = -1,
         const wxString& title = wxT( "낦҂" ) ,
         const wxPoint& pos = wxDefaultPosition,
         const wxSize& size = wxSize( 645,125 ) ,
         long style = (
               wxSTAY_ON_TOP|wxSYSTEM_MENU|wxCLOSE_BOX
               |wxCAPTION|wxSIMPLE_BORDER),
         const wxString& name = wxFrameNameStr);
   virtual ~SaikoroFrame();
   void OnQuit( wxCommandEvent& event );
   void OnAbout( wxCommandEvent& event );
   void OnRegistWord( wxCommandEvent& event );
   void OnLeftDown( wxMouseEvent &event );
   void OnRightDown( wxMouseEvent &event );
   void OnSysColourChanged( wxSysColourChangedEvent& event );
   virtual long MSWWindowProc( WXUINT nMsg, WXWPARAM wParam, WXLPARAM lParam );
   WXHWND getWindowHandle() { return m_hWnd; };
   void loadConfigure( string configurename );
   void addWordToLearningDictianary( string head, string word );
   void showRegistFrame();
   DECLARE_EVENT_TABLE()
private:
   wxMenu *menu;
   SaikoroTaskBarIcon *icon;
   typedef std::vector<SaikoroText*> t_panels;
   t_panels panels;
   wxStaticText *key_code_text;
   wxStaticText *key_status_text;
   wxStaticText *keytable_text;
   wxStaticText *headword_text;
   wxStaticText *global_value_text;
   Saikoro::TSrHolder sr_holder;
   string name;
   void updateKeyStatus( unsigned int vk, Saikoro::TKeyUpDown isKU );
   void RefreshDisplay( unsigned int vk, Saikoro::TKeyUpDown isKU );
};

class SaikoroAboutFrame : public wxMiniFrame {
public:
   SaikoroAboutFrame(
         wxWindow *parent,
         wxWindowID id = -1,
         const wxString& title =  wxT( "About" ) ,
         const wxPoint& pos = wxDefaultPosition,
         const wxSize& size = wxSize( 250,120 ) ,
         long style = (wxSTAY_ON_TOP|wxSYSTEM_MENU|wxCAPTION|wxCLOSE_BOX|wxSIMPLE_BORDER),
         const wxString& name = wxFrameNameStr );
};

class SaikoroRegistWordFrame : public wxMiniFrame {
public:
   SaikoroRegistWordFrame(
         wxWindow *parent,
         wxWindowID id = -1,
         const wxString& title =  wxT( "Regist Word" ),
         const wxPoint& pos = wxDefaultPosition,
         const wxSize& size = wxSize( 400,180 ),
         long style = (wxSTAY_ON_TOP|wxSYSTEM_MENU|wxCAPTION|wxCLOSE_BOX|wxSIMPLE_BORDER),
         const wxString& name = wxFrameNameStr );
   void OnButtonOK( wxCommandEvent& WXUNUSED( event ) );
   void setWindowStatus( string text );
   DECLARE_EVENT_TABLE()
private:
   wxTextCtrl *head_text;
   wxTextCtrl *word_text;
};

#endif //SAIKORO_MAINH
