/*----------------------------------------------------------------------------
   main.cpp

   ---------------------------------------------------------------------------
   Copyright (C) 2002, 2003 August Nowake(앪) nowake@debilotte.net
   This program is free software; you can redistribute it and/or modify it 
   under the terms of the GNU General Public License version 2 as published 
   by the Free Software Foundation.
   This program is distributed in the hope that it will be useful, but 
      WITHOUT ANY WARRANTY;
   without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE. See the GNU General Public License for more details.
   You should have received a copy of the GNU General Public License along 
   with this program; if not, write to the Free Software Foundation, Inc., 
   59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   ---------------------------------------------------------------------------
    ̃vO̓t[\tgEFAłBȂ͂At[\tgEFAc
    Ĕsꂽ GNUʌOp_(o[W2)̒߂̉ōĔЕz
    ܂͉ς邱Ƃł܂B
    ̃vO͗Lpł邱ƂĔЕz܂A
      *S̖ۏ*
    łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂܂ߑS
    ܂BڂGNU ʌOp_񏑂B
    Ȃ͂̃vOƋɁAGNU ʌOp_񏑂̕ꕔ󂯎
    ͂łB󂯎ĂȂ΁At[\tgEFAc܂ŐĂB
    ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
    Boston, MA 02111-1307 USA)
----------------------------------------------------------------------------*/

#ifdef __GNUG__
#pragma implementation "main.h"
#endif //__GNUG__

#if defined( __BORLANDC__ ) || defined( _MSC_VER )
#pragma hdrstop
#endif //__BORLANDC__||_MSC_VER

#ifdef NDEBUG
   #undef _STLP_DEBUG
#else
   #pragma warning( disable:4786 )
   #define _STLP_DEBUG 1
#endif //NDEBUG

#include "BurglarFunc.h"
#include "ImeControlFunc.h"
#include "SaikoroTable.h"

#include "main.h"
#include <wx/utils.h>

using namespace std;
using namespace Saikoro::Burglar;
using namespace Saikoro::ImeControler;

IMPLEMENT_APP( SaikoroApp )

//----------------------------------------------------------------------------
bool SaikoroApp::OnInit()
{
   #ifdef __WXMSW__
   LocaleObject.AddCatalogLookupPathPrefix( ::wxPathOnly( this->argv[0] ));
   #endif //__WXMSW__
   LocaleObject.AddCatalog( CommantName );

   isHookOwner = false;

   frame = new SaikoroFrame( static_cast<wxFrame *>(NULL) );
   bool fail_key_hooking = !(InstallHook( (HWND)frame->getWindowHandle() ));
   if (fail_key_hooking) return false;
   isHookOwner = true;
   bool fail_ime_hooking
         = !(InstallImeControler( (HWND)frame->getWindowHandle() ));
   if (fail_ime_hooking) {
      Saikoro::Burglar::UninstallHook();
      return false;
   }
	isImeControlerOwner = true;

   wxString config = get_config_filename();
   if (!config) {
      return false;
   } else {
      frame->loadConfigure( config.c_str() );
      frame->Hide();
      return true;
   }
}

int SaikoroApp::OnExit()
{
   if ( isHookOwner )
      Saikoro::Burglar::UninstallHook();

	if ( isImeControlerOwner )
		Saikoro::ImeControler::UninstallImeControler();

   return 0;
}

wxString SaikoroApp::get_config_filename()
{
   wxString config;
   wxString path;
   path = wxGetHomeDir();
   config = path + "/.saikoropencil";
   if (wxFileExists( config )) return config;
   config = path + "/saikoropencil.xml";
   if (wxFileExists( config )) return config;
   path = wxPathOnly(this->argv[0]);
   config = path +"/saikoropencil.xml";
   if (wxFileExists( config )) return config;
   config = path + "/../../sample/saikoropencil.xml";
   if (wxFileExists( config )) return config;
   config = path + "/../../sample/qwerty.xml";
   if (wxFileExists( config )) return config;
   wxMessageBox(
         wxT( "Error! No Configuration File!!!" ),
         wxT( "Error" ) , wxOK | wxICON_ERROR, frame );
   return "";
}

//----------------------------------------------------------------------------
BEGIN_EVENT_TABLE(SaikoroTaskBarIcon, wxTaskBarIcon)
    EVT_TASKBAR_LEFT_DOWN(SaikoroTaskBarIcon::OnLButtonDown)
END_EVENT_TABLE()

void SaikoroTaskBarIcon::OnLButtonDown(wxTaskBarIconEvent&) 
{
   ::wxGetApp().getFrame()->Show();
}

//----------------------------------------------------------------------------
SaikoroText::SaikoroText(
      unsigned int keyno, wxWindow *parent,const wxPoint& pos,
      const wxSize& size )
      :  wxStaticText( parent, -1, _(""), pos, size,
               (wxST_NO_AUTORESIZE || wxALIGN_LEFT), wxStaticTextNameStr ),
         no( 0 )
{
   SetBackgroundColour( wxSystemSettings::GetColour( wxSYS_COLOUR_WINDOW ));
   no = keyno;
};

//----------------------------------------------------------------------------
BEGIN_EVENT_TABLE( SaikoroFrame, wxFrame )
   EVT_MENU( ID_Quit, SaikoroFrame::OnQuit )
   EVT_MENU( ID_About, SaikoroFrame::OnAbout )
   EVT_MENU( ID_RegistWord, SaikoroFrame::OnRegistWord )
   EVT_LEFT_DOWN( SaikoroFrame::OnLeftDown )
   EVT_RIGHT_DOWN( SaikoroFrame::OnRightDown )
   EVT_SYS_COLOUR_CHANGED( SaikoroFrame::OnSysColourChanged )
END_EVENT_TABLE()

SaikoroFrame::SaikoroFrame( wxWindow *parent, wxWindowID id, const wxString& title,
   const wxPoint& pos, const wxSize& size, long style, const wxString& name )
   : wxFrame( parent, id, title, pos, size, style, name )
{
   SetIcon( wxICON( SaikoroIcon ));
   icon = new SaikoroTaskBarIcon();
   icon->SetIcon(wxICON(SaikoroIcon), wxT("Saikoro Pencil"));

   SetBackgroundColour( wxSystemSettings::GetColour( wxSYS_COLOUR_3DFACE ));

   menu = new wxMenu;
   menu->Append( ID_RegistWord, "&Regist Word" );
   menu->AppendSeparator();
   menu->Append( ID_About, "&About" );
   menu->AppendSeparator();
   menu->Append( ID_Quit, "E&xit" );

   panels.push_back( new SaikoroText( 0x31, this, wxPoint( 5, 3 ) ) );
   panels.push_back( new SaikoroText( 0x32, this, wxPoint( 66, 3 ) ) );
   panels.push_back( new SaikoroText( 0x33, this, wxPoint( 127, 3 ) ) );
   panels.push_back( new SaikoroText( 0x34, this, wxPoint( 188, 3 ) ) );
   panels.push_back( new SaikoroText( 0x35, this, wxPoint( 249, 3 ) ) );
   panels.push_back( new SaikoroText( 0x36, this, wxPoint( 315, 3 ) ) );
   panels.push_back( new SaikoroText( 0x37, this, wxPoint( 376, 3 ) ) );
   panels.push_back( new SaikoroText( 0x38, this, wxPoint( 437, 3 ) ) );
   panels.push_back( new SaikoroText( 0x39, this, wxPoint( 498, 3 ) ) );
   panels.push_back( new SaikoroText( 0x30, this, wxPoint( 559, 3 ) ) );

   panels.push_back( new SaikoroText( 0x51, this, wxPoint( 10, 18 ) ) );
   panels.push_back( new SaikoroText( 0x57, this, wxPoint( 71, 18 ) ) );
   panels.push_back( new SaikoroText( 0x45, this, wxPoint( 132, 18 ) ) );
   panels.push_back( new SaikoroText( 0x52, this, wxPoint( 193, 18 ) ) );
   panels.push_back( new SaikoroText( 0x54, this, wxPoint( 254, 18 ) ) );
   panels.push_back( new SaikoroText( 0x59, this, wxPoint( 320, 18 ) ) );
   panels.push_back( new SaikoroText( 0x55, this, wxPoint( 381, 18 ) ) );
   panels.push_back( new SaikoroText( 0x49, this, wxPoint( 442, 18 ) ) );
   panels.push_back( new SaikoroText( 0x4f, this, wxPoint( 503, 18 ) ) );
   panels.push_back( new SaikoroText( 0x50, this, wxPoint( 564, 18 ) ) );

   panels.push_back( new SaikoroText( 0x41, this, wxPoint( 15, 33 ) ) );
   panels.push_back( new SaikoroText( 0x53, this, wxPoint( 76, 33 ) ) );
   panels.push_back( new SaikoroText( 0x44, this, wxPoint( 137, 33 ) ) );
   panels.push_back( new SaikoroText( 0x46, this, wxPoint( 198, 33 ) ) );
   panels.push_back( new SaikoroText( 0x47, this, wxPoint( 259, 33 ) ) );
   panels.push_back( new SaikoroText( 0x48, this, wxPoint( 325, 33 ) ) );
   panels.push_back( new SaikoroText( 0x4a, this, wxPoint( 386, 33 ) ) );
   panels.push_back( new SaikoroText( 0x4b, this, wxPoint( 447, 33 ) ) );
   panels.push_back( new SaikoroText( 0x4c, this, wxPoint( 508, 33 ) ) );
   panels.push_back( new SaikoroText( 0xbb, this, wxPoint( 569, 33 ) ) );

   panels.push_back( new SaikoroText( 0x5a, this, wxPoint( 20, 48 ) ) );
   panels.push_back( new SaikoroText( 0x58, this, wxPoint( 81, 48 ) ) );
   panels.push_back( new SaikoroText( 0x43, this, wxPoint( 142, 48 ) ) );
   panels.push_back( new SaikoroText( 0x56, this, wxPoint( 203, 48 ) ) );
   panels.push_back( new SaikoroText( 0x42, this, wxPoint( 264, 48 ) ) );
   panels.push_back( new SaikoroText( 0x4e, this, wxPoint( 330, 48 ) ) );
   panels.push_back( new SaikoroText( 0x4d, this, wxPoint( 391, 48 ) ) );
   panels.push_back( new SaikoroText( 0xbc, this, wxPoint( 452, 48 ) ) );
   panels.push_back( new SaikoroText( 0xbe, this, wxPoint( 513, 48 ) ) );
   panels.push_back( new SaikoroText( 0xbf, this, wxPoint( 574, 48 ) ) );

   panels.push_back( new SaikoroText( 0x1d, this, wxPoint( 260, 63 ) ) );
   panels.push_back(
         new SaikoroText( 0x20, this, wxPoint( 321, 63 ), wxSize( 80, 12 )));
   panels.push_back( new SaikoroText( 0x1c, this, wxPoint( 402, 63 ) ) );
   panels.push_back( new SaikoroText( 0x0d, this, wxPoint( 463, 63 ) ) );

   new wxTextCtrl( this, -1, _("") , wxPoint( 525,70 ), wxSize( 110,20 ) );

   key_code_text = new wxStaticText( this, -1, _("Code"), wxPoint( 20, 63 ) );
   key_status_text
         = new wxStaticText( this, -1, _("Status"), wxPoint( 81, 63 ) );
   global_value_text
         = new wxStaticText( this, -1, _("GlobalValue"), wxPoint( 142, 63 ) );

   keytable_text
         = new wxStaticText( this, -1, _("KeyTable"), wxPoint( 20, 78 ) );
   headword_text
         = new wxStaticText( this, -1, _("Headword"), wxPoint( 142, 78 ) );
}

SaikoroFrame::~SaikoroFrame()
{
   icon->RemoveIcon();
   delete icon;
}

void SaikoroFrame::loadConfigure( string configurename )
{
   Saikoro::THolderFactory thf;
   sr_holder = thf.createHolder( configurename );
}

void SaikoroFrame::OnQuit( wxCommandEvent& WXUNUSED( event ))
{
   Close( true );
}

void SaikoroFrame::OnAbout( wxCommandEvent& WXUNUSED( event ))
{
   SaikoroAboutFrame *frame = new SaikoroAboutFrame( this );
   frame->Show( true );
}

void SaikoroFrame::OnRegistWord( wxCommandEvent& WXUNUSED( event ))
{
   showRegistFrame();
}
void SaikoroFrame::showRegistFrame()
{
   SaikoroRegistWordFrame *frame = new SaikoroRegistWordFrame( this );
   frame->setWindowStatus(
         sr_holder->getAppropriateWord().lock()->getHeadword() );
   frame->Move(
         this->GetPosition().x, this->GetPosition().y + this->GetSize().y );
   frame->Show( true );
}

void SaikoroFrame::OnLeftDown( wxMouseEvent &event )
{
   Hide();
}

void SaikoroFrame::OnRightDown( wxMouseEvent &event )
{
   PopupMenu( menu, event.GetX(), event.GetY() );
}

void SaikoroFrame::OnSysColourChanged( wxSysColourChangedEvent& event )
{
   SetBackgroundColour( wxSystemSettings::GetColour( wxSYS_COLOUR_3DFACE ) );
   Refresh();
   wxWindow::OnSysColourChanged( event );
}

long SaikoroFrame::MSWWindowProc(
      WXUINT nMsg, WXWPARAM wParam, WXLPARAM lParam )
{
   Saikoro::TKeyUpDown isKU;
   if (nMsg == Saikoro::Burglar::GetUniqueMessage()) {
      wxMutexLocker lock( MutexObject );
      if (lParam) {
         isKU = Saikoro::Up;
      } else {
         isKU = Saikoro::Down;
      }
      unsigned int vk( wParam & 0x000000FF );
      sr_holder->executeKeyEvent( vk, isKU );
      RefreshDisplay( vk, isKU );
   }
   return wxFrame::MSWWindowProc( nMsg, wParam, lParam );
}

void SaikoroFrame::updateKeyStatus( unsigned int vk, Saikoro::TKeyUpDown isKU )
{
   RefreshDisplay(vk,isKU);
}

void SaikoroFrame::RefreshDisplay( unsigned int vk, Saikoro::TKeyUpDown isKU )
{
   keytable_text->SetLabel( sr_holder->getCurrentTableName().c_str());
   headword_text->SetLabel(
         sr_holder->getAppropriateWord().lock()->getHeadword().c_str());

   string s;
   for ( unsigned int i = 0;i < sr_holder->getGlobalValueCount(); ++i ) {
      if (sr_holder->getGlobalValue( i )) {
         s += "1";
      } else {
         s += "0";
      }
   }
   global_value_text->SetLabel( s.c_str());

   for ( t_panels::iterator i = panels.begin();
         i != panels.end(); ++i ) {
      string s( sr_holder->getWord( (*i)->getKeyNo(), Saikoro::Down ) );
      (*i)->SetLabel( s.c_str() );
      //dynamic_cast<TLabel*> ( FLabelList->Objects[i] ) ->Font->Color
      // = TSrHolder->getGuideColor( StrToInt( FLabelList[i] ));
   }

   ostringstream os;
   os << "0x" << hex << vk;
   key_code_text->SetLabel( os.str() .c_str());

   if (isKU == Saikoro::Up) {
      key_status_text->SetLabel( _ ( "Up" ));
   } else {
      key_status_text->SetLabel( _ ( "Down" ));
   }
};

void SaikoroFrame::addWordToLearningDictianary( string head, string word )
{
   sr_holder->getAppropriateWord().lock()
         ->addWordToLearningDictionary( head, word );
};

//----------------------------------------------------------------------------
SaikoroAboutFrame::SaikoroAboutFrame(
      wxWindow *parent, wxWindowID id, const wxString& title,
      const wxPoint& pos, const wxSize& size, long style,
      const wxString& name )
      :  wxMiniFrame( parent, id, title, pos, size, style, name )
{
   this->Centre();
   SetIcon( wxICON( SaikoroIcon ) );
   SetBackgroundColour( wxSystemSettings::GetColour( wxSYS_COLOUR_3DFACE ));
   wxStaticText *tt
      = new wxStaticText(
            this, -1, _("Saikoro Pencil"), wxPoint( 10, 10 ),
            wxSize( -1, -1 ), 0 );
   wxFont ft = tt->GetFont();
   ft.SetPointSize( 20 );
   tt->SetFont( ft );
   new wxStaticText(
         this, -1, _("Copyright( C ) 2002, 2003 Nowake"), wxPoint( 10, 65 ),
         wxSize( -1, -1 ), 0 );
}

//----------------------------------------------------------------------------
BEGIN_EVENT_TABLE( SaikoroRegistWordFrame, wxFrame )
   EVT_BUTTON( Btn_OK, SaikoroRegistWordFrame::OnButtonOK )
END_EVENT_TABLE()

SaikoroRegistWordFrame::SaikoroRegistWordFrame(
   wxWindow *parent, wxWindowID id, const wxString& title, const wxPoint& pos,
   const wxSize& size, long style, const wxString& name )
   :  wxMiniFrame( parent, id, title, pos, size, style, name )
{
   this->Centre();
   SetIcon( wxICON( SaikoroIcon ));
   SetBackgroundColour( wxSystemSettings::GetColour( wxSYS_COLOUR_3DFACE ) );
   new wxStaticText(
         this, -1, _("After Change"), wxPoint( 10, 70 ),
         wxSize( -1, -1 ) , 0 );
   word_text = new wxTextCtrl(
         this, -1, _(""), wxPoint( 10,90 ), wxSize( 370,20 ));

   new wxStaticText(
         this, -1, _("Before Change"), wxPoint( 10, 10 ),
         wxSize( -1, -1 ), 0 );
   head_text = new wxTextCtrl(
         this, -1, _(""), wxPoint( 10,30 ), wxSize( 370,20 ) );

   new wxButton( this, Btn_OK, _("   OK   "), wxPoint( 300, 120 ) );
}

void SaikoroRegistWordFrame::OnButtonOK( wxCommandEvent& WXUNUSED( event ))
{
   dynamic_cast<SaikoroFrame*> (GetParent())->addWordToLearningDictianary(
      head_text->GetValue().c_str(), word_text->GetValue().c_str() );
   Close( true );
}

void SaikoroRegistWordFrame::setWindowStatus( string text )
{
   head_text->WriteText( text.c_str());
   word_text->WriteText( text.c_str());
};
//----------------------------------------------------------------------------