/*
 * Copyright (C) 2008-2014 Renesas Solutions Corp.
 * Copyright (C) 2012 Renesas Electronics Europe Ltd.
 * Copyright (C) 2012 Phil Edworthy
 * Copyright (C) 2008 Nobuhiro Iwamatsu
 *
 * Based on board/renesas/rsk7264/lowlevel_init.S
 *
 * This file is released under the terms of GPL v2 and any later version.
 * See the file COPYING in the root directory of the source tree for details.
 */
#include <config.h>
#include <version.h>
#include <asm/arch/rza1-regs.h>
#include <asm/macro.h>

	.global	lowlevel_init

	.text
	.align	2

lowlevel_init:
	/* PL310 init */
	write32 0x3FFFFF80, 0x00000001

	/* Disable WDT */
	write16	WTCSR, WTCSR_D
	write16	WTCNT, WTCNT_D

	/* Disable Register Bank interrupts */
	/* write16 IBNR, IBNR_D */

	/* Set clocks */
	write16	FRQCR,  FRQCR_D
	write16	FRQCR2, FRQCR2_D

	/* Enable all peripherals(Standby Control) */
	write8 STBCR2,  STBCR2_D
	write8 STBCR3,  STBCR3_D
	write8 STBCR4,  STBCR4_D
	write8 STBCR5,  STBCR5_D
	write8 STBCR6,  STBCR6_D
	write8 STBCR7,  STBCR7_D
	write8 STBCR8,  STBCR8_D
	write8 STBCR9,  STBCR9_D
	write8 STBCR10, STBCR10_D
	write8 STBCR11, STBCR11_D
	write8 STBCR12, STBCR12_D

	/* Port Control Register */

	/* Port0 */
	write16 PIBC0, PIBC0_D

	write16 PMC0,  PMC0_S
	write16 PIBC0, PIBC0_S

	/* PORT1 */
	write16 PIBC1,  PIBC1_D
	write16 PBDC1,  PBDC1_D
	write16 PM1,    PM1_D
	write16 PMC1,   PMC1_D
	write16 PIPC1,  PIPC1_D

	write16 PBDC1,  PBDC1_S
	write16 PFC1,   PFC1_S
	write16 PFCE1,  PFCE1_S
	write16 PFCAE1, PFCAE1_S
	write16 PIPC1,  PIPC1_S
	write16 PMC1,   PMC1_S
	write16 P1,     P1_S
	write16 PM1,    PM1_S
	write16 PIBC1,  PIBC1_S

	/* PORT2 */
	write16 PIBC2,  PIBC2_D
	write16 PBDC2,  PBDC2_D
	write16 PM2,    PM2_D
	write16 PMC2,   PMC2_D
	write16 PIPC2,  PIPC2_D

	write16 PBDC2,  PBDC2_S
	write16 PFC2,   PFC2_S
	write16 PFCE2,  PFCE2_S
	write16 PFCAE2, PFCAE2_S
	write16 PIPC2,  PIPC2_S
	write16 PMC2,   PMC2_S
	write16 P2,     P2_S
	write16 PM2,    PM2_S
	write16 PIBC2,  PIBC2_S

	/* PORT3 */
	write16 PIBC3,  PIBC3_D
	write16 PBDC3,  PBDC3_D
	write16 PM3,    PM3_D
	write16 PMC3,   PMC3_D
	write16 PIPC3,  PIPC3_D

	write16 PBDC3,  PBDC3_S
	write16 PFC3,   PFC3_S
	write16 PFCE3,  PFCE3_S
	write16 PFCAE3, PFCAE3_S
	write16 PIPC3,  PIPC3_S
	write16 PMC3,   PMC3_S
	write16 P3,     P3_S
	write16 PM3,    PM3_S
	write16 PIBC3,  PIBC3_S

	/* PORT4 */
	write16 PIBC4,  PIBC4_D
	write16 PBDC4,  PBDC4_D
	write16 PM4,    PM4_D
	write16 PMC4,   PMC4_D
	write16 PIPC4,  PIPC4_D

	write16 PBDC4,  PBDC4_S
	write16 PFC4,   PFC4_S
	write16 PFCE4,  PFCE4_S
	write16 PFCAE4, PFCAE4_S
	write16 PIPC4,  PIPC4_S
	write16 PMC4,   PMC4_S
	write16 P4,     P4_S
	write16 PM4,    PM4_S
	write16 PIBC4,  PIBC4_S

	/* PORT5 */
	write16 PIBC5,  PIBC5_D
	write16 PBDC5,  PBDC5_D
	write16 PM5,    PM5_D
	write16 PMC5,   PMC5_D
	write16 PIPC5,  PIPC5_D

	write16 PBDC5,  PBDC5_S
	write16 PFC5,   PFC5_S
	write16 PFCE5,  PFCE5_S
	write16 PFCAE5, PFCAE5_S
	write16 PIPC5,  PIPC5_S
	write16 PMC5,   PMC5_S
	write16 P5,     P5_S
	write16 PM5,    PM5_S
	write16 PIBC5,  PIBC5_S

	/* PORT6 */
	write16 PIBC6,  PIBC6_D
	write16 PBDC6,  PBDC6_D
	write16 PM6,    PM6_D
	write16 PMC6,   PMC6_D
	write16 PIPC6,  PIPC6_D

	write16 PBDC6,  PBDC6_S
	write16 PFC6,   PFC6_S
	write16 PFCE6,  PFCE6_S
	write16 PFCAE6, PFCAE6_S
	write16 PIPC6,  PIPC6_S
	write16 PMC6,   PMC6_S
	write16 P6,     P6_S
	write16 PM6,    PM6_S
	write16 PIBC6,  PIBC6_S

	/* PORT7 */
	write16 PIBC7,  PIBC7_D
	write16 PBDC7,  PBDC7_D
	write16 PM7,    PM7_D
	write16 PMC7,   PMC7_D
	write16 PIPC7,  PIPC7_D

	write16 PBDC7,  PBDC7_S
	write16 PFC7,   PFC7_S
	write16 PFCE7,  PFCE7_S
	write16 PFCAE7, PFCAE7_S
	write16 PIPC7,  PIPC7_S
	write16 PMC7,   PMC7_S
	write16 P7,     P7_S
	write16 PM7,    PM7_S
	write16 PIBC7,  PIBC7_S

	/* PORT8 */
	write16 PIBC8,  PIBC8_D
	write16 PBDC8,  PBDC8_D
	write16 PM8,    PM8_D
	write16 PMC8,   PMC8_D
	write16 PIPC8,  PIPC8_D

	write16 PBDC8,  PBDC8_S
	write16 PFC8,   PFC8_S
	write16 PFCE8,  PFCE8_S
	write16 PFCAE8, PFCAE8_S
	write16 PIPC8,  PIPC8_S
	write16 PMC8,   PMC8_S
	write16 P8,     P8_S
	write16 PM8,    PM8_S
	write16 PIBC8,  PIBC8_S

	/* Configure SDRAM (CS3) */
	write32	CS3BCR, CS3BCR_D
	write32	CS3WCR, CS3WCR_D
	write32	SDCR,   SDCR_D
	write32	RTCOR,  RTCOR_D
	write32	RTCSR,  RTCSR_D

	/* wait */
	ldr	r3, REPEAT_D
	mov	r2, #0
repeat0:
	add	r2, r2, #1
	cmp	r2, r3
	ble	repeat0
	nop

	/* write16 0x3FFFE440, 0x0000 */
	write16 SDRAM_MODE_CS3, 0x0000

	nop
	/* back to arch calling code */
	mov	pc, lr

	.align 4

.align 2
SDRAM_MODE_CS3:	.long 0x3FFFE440
REPEAT_D:	.long 0x000033F1
