
require 'java'
require 'listener'

module Ruwing
  include_package 'java.lang'
  include_package 'javax.swing'
  
  GUI_COMPONENT_TABLE = {
    "Button" => {:wrap=>"wrapButtonComponent"},
    "CheckBox" => {:wrap=>"wrapButtonComponent"},
    "CheckBoxMenuItem" => {:wrap=>"wrapComponent"},
    "ColorChooser" => {:wrap=>"wrapComponent"},
    "ComboBox" => {:wrap=>"wrapComponent"},
    "DesktopPane" => {:wrap=>"wrapComponent"},
    "Dialog" => {:wrap=>"wrapComponent"},
    "EditorPane" => {:wrap=>"wrapComponent"},
    "FileChooser" => {:wrap=>"wrapComponent"},
    "FormattedTextField" => {:wrap=>"wrapComponent"},
    "Frame" => {:wrap=>"wrapWindowComponent"},
    "InternalFrame" => {:wrap=>"wrapComponent"},
    "Label" => {:wrap=>"wrapComponent"},
    "LayeredPane" => {:wrap=>"wrapComponent"},
    "List" => {:wrap=>"wrapComponent"},
    "Menu" => {:wrap=>"wrapComponent"},
    "MenuBar" => {:wrap=>"wrapComponent"},
    "MenuItem" => {:wrap=>"wrapButtonComponent"},
    "Panel" => {:wrap=>"wrapComponent"},
    "PasswordField" => {:wrap=>"wrapComponent"},
    "PopupMenu" => {:wrap=>"wrapComponent"},
    "ProgressBar" => {:wrap=>"wrapComponent"},
    "RadioButton" => {:wrap=>"wrapButtonComponent"},
    "RadioButtonMenuItem" => {:wrap=>"wrapComponent"},
    "RootPane" => {:wrap=>"wrapComponent"},
    "ScrollBar" => {:wrap=>"wrapComponent"},
    "ScrollPane" => {:wrap=>"wrapComponent"},
    "Separator" => {:wrap=>"wrapComponent"},
    "Slider" => {:wrap=>"wrapComponent"},
    "Spinner" => {:wrap=>"wrapComponent"},
    "SplitPane" => {:wrap=>"wrapComponent"},
    "TabbedPane" => {:wrap=>"wrapComponent"},
    "Table" => {:wrap=>"wrapComponent"},
    "TextArea" => {:wrap=>"wrapComponent"},
    "TextField" => {:wrap=>"wrapComponent"},
    "TextPane" => {:wrap=>"wrapComponent"},
    "ToggleButton" => {:wrap=>"wrapButtonComponent"},
    "ToolBar" => {:wrap=>"wrapComponent"},
    "ToolTip" => {:wrap=>"wrapComponent"},
    "Tree" => {:wrap=>"wrapComponent"},
    "ViewPort" => {:wrap=>"wrapComponent"},
    "Window" => {:wrap=>"wrapComponent"}
  }
  
  # JavaのGUIコンポーネントをラップする
  def wrapComponent(obj)
    Translator.new(obj,nil)
  end

  # JavaのWindow系GUIコンポーネントをラップする
  def wrapWindowComponent(obj)
    WindowTranslator.new(obj,nil)
  end

  # JavaのButton系GUIコンポーネントをラップする
  def wrapButtonComponent(obj)
    ButtonTranslator.new(obj,nil)
  end
  
  # 各コンポーネントを作成するメソッドを作成
  GUI_COMPONENT_TABLE.each{|key,val|
    src = <<EOT
        def #{key}(id=nil,&proc)
          c = J#{key}.new
          wrapObj = #{val[:wrap]}(c)
          wrapObj.instance_eval(&proc)
          unless id.nil?
            wrapObj.global_components[id] = c
          end
          c
        end
EOT
    self.module_eval(src)
  }
  
  # 画像表示用のCanvas
  class ImageCanvas < java.awt.Canvas
    def path=(file)
      load(file)
      set_size @img.width, @img.height
    end
    
    def paint(g)
      if @img != nil
        g.drawImage(@img,0,0,nil,self)
      end
    end
    
    def load(file)
      @img = java.awt.Toolkit.getDefaultToolkit.getImage(file)
      if @img.height == -1
        raise "file not found.(#{file})"
      end
    end
  end
  
  #スケールする画像用のCanvas
  class ScalableImageCanvas < ImageCanvas
    def path=(file)
      load(file)
    end
    def paint(g)
      if @img != nil
        g.drawImage(@img,0,0,width,height,nil)
      end
    end
  end
  
  # DSL内で使えるメソッドとプロパティへのアクセス手段を提供する
  class Translator
    include_package 'java.lang'
    include_package 'javax.swing'
    include ComponentListeners
    attr_accessor :parent,:all_components,:global_components
    
    def initialize(component,parent=nil)
      super(component,parent) if defined?(super)
      @component = component
      @parent = parent
      @global_components = {}
      @all_components = []
    end
    
    # ルートのTranslatorオブジェクトを取得する
    def root
      obj = self
      while obj.parent != nil
        obj = obj.parent
      end
      obj
    end
    
    # IDを付与されたコンポーネント群へのアクセスを提供する
    def ref()
      root.global_components
    end

    # GUIコンポーネントのアクセサを呼び出す
    def method_missing(name, *args)
      if args.length == 0
        @component.__send__(name.to_s, *args)
      else
        @component.__send__(name.to_s + "=", *args)
      end
    end

    # 名前付きでコンポーネントを追加
    # コンポーネントはプロパティとしてアクセスできる
    def addwn(name,c)
      self.instance_eval("@#{name} = c")
      self.instance_eval("def #{name}() @#{name}; end")
      self << (c)
    end

    # コンポーネントを追加する
    def add(c)
      addwin(nil,nil,c)
    end

    # コンポーネントを追加する
    # add(c)と同じ
    def <<(c)
      add(c)
    end
    
    # ID付きでコンポーネントを追加
    # globalメソッドを使用してアクセスできる
    def addwi(id,c)
      root.global_components[id] = c
      addwin(id,nil,c)
    end
    
    # IDと名前付きでコンポーネントを追加
    # コンポーネントのプロパティとしてアクセスでき、globalメソッドを
    # 使用してもアクセスできる
    def addwin(id,name,c)
      @all_components << c
      
      unless @component.nil?
        if @component.class == javax.swing.JFrame
          if c.class == javax.swing.JMenuBar
            @component.jmenu_bar = c
          else
            @component.get_content_pane.add(c)
          end
        else
          if c.class == javax.swing.JMenuBar
            raise "#{@component.class.to_s} can't include MenuBar"
          end
          @component.add(c)
        end
      end
      
      unless id.nil?
        self.instance_eval("@#{name} = c")
        self.instance_eval("def #{name}() @#{name}; end")
      end
      unless name.nil?
        root.global_components[name] = c
      end
    end

    # JavaのGUIコンポーネントをラップする
    def wrapComponent(obj)
      Translator.new(obj,self)
    end
    
    # JavaのWindow系GUIコンポーネントをラップする
    def wrapWindowComponent(obj)
      WindowTranslator.new(obj,self)
    end
    
    def wrapButtonComponent(obj)
      ButtonTranslator.new(obj,self)
    end
    
    def Box(axis,&proc)
      c = Box.new(axis)
      wrapObj = wrapComponent(c)
      wrapObj.instance_eval(&proc)
      c
    end
    
    def Canvas(id=nil,&proc)
      c = java.awt.Canvas.new()
      addwin(id,id,c)
      wrapObj = wrapComponent(c)
      wrapObj.instance_eval(&proc)
      c
    end
    
    def Image(id=nil,&proc)
      c = Ruwing::ImageCanvas.new
      addwin(id,id,c)
      wrapObj = wrapComponent(c)
      wrapObj.instance_eval(&proc)
      c
    end
    
    def ScalableImage(id=nil,&proc)
      c = Ruwing::ScalableImageCanvas.new
      addwin(id,id,c)
      wrapObj = wrapComponent(c)
      wrapObj.instance_eval(&proc)
      c
    end
    
    GUI_COMPONENT_TABLE.each{|key,val|
      src = <<EOT
        def #{key}(id=nil,&proc)
          c = J#{key}.new
          addwin(id,id,c)
          wrapObj = #{val[:wrap]}(c)
          wrapObj.instance_eval(&proc)
          c
        end
EOT
      module_eval(src)
    }

  end
  
  # Button系GUIコンポーネント用
  # Button系のイベントを扱うためのインタフェースが提供される
  class ButtonTranslator < Translator
    include ProcActionListener
    include ComponentListeners
    def initialize(target,parent=nil)
      super(target,parent)
    end
  end
  
  # Window系GUIコンポーネント用
  # Window系のイベントを扱うためのインタフェースが提供される
  class WindowTranslator < Translator
    include_package 'java.lang'
    include_package 'javax.swing'
    include ComponentListeners
    include WindowListeners
    
    def initialize(component,parent=nil)
      super(component,parent)
      if component.class == javax.swing.JFrame
        component.set_default_close_operation javax.swing.WindowConstants::DISPOSE_ON_CLOSE
      end
    end
    
    def x(x)
      @component.set_location x, @component.location.y
    end
    def y(y)
      @component.set_location @component.location.y, y
    end
    def width(w)
      @component.set_size w, @component.size.height
    end
    def height(h)
      @component.set_size @component.size.width, h
    end
  end
end

