# 各コンポーネントから呼び出すリスナーの実装
# 

module Ruwing
  
  module ListenerHelper
    # イベントにより起動するProcインスタンスのプロパティを作成する
    def event_handller(listener,*args)
      args.each{|item|
        self.instance_eval(
          %Q|
          @_#{listener}_registered = false
          def #{item}(&proc)
            if @_#{listener}_registered == false
              @component.add_#{listener}(self)
              @_#{listener}_registered = true
            end
            @#{item} = proc
          end
          |)
      }
    end
  end
  
  def self.decamelize(str)
    str.scan(/[A-Z]?[a-z0-9]+/).map{|i| i.downcase}.join("_")
  end
  
  def self.define_listener(clazz,isroot=false)
    method_src = ""
    fields  = []
    clazz = clazz.java_class
    clazz.declared_instance_methods.each{|m|
      method_src << %Q|
        def #{m.name}(e)
          unless @on_#{decamelize(m.name)}.nil?
            @on_#{decamelize(m.name)}.call(e)
          end
        end
      |
      fields << "on_#{decamelize(m.name)}"
    }
    
    call_super = isroot ? "super(*args) if defined?(super)" : "super(*args)"
    src = "module Proc#{clazz.simple_name}"
    src << %Q|
        include #{clazz.name}
        def initialize(*args)
          #{call_super}
          @_#{decamelize(clazz.simple_name)}_registered = false
        end
        #{method_src}
    |
    fields.each{|f|
      src << %Q|
          def #{f}(&proc)
            if @_#{decamelize(clazz.simple_name)}_registered == false
              @component.add_#{decamelize(clazz.simple_name)}(self)
              @_#{decamelize(clazz.simple_name)}_registered = true
            end
            @#{f} = proc
          end
      |
    }
    src << "end"
    self.module_eval(src)
  end
  
  define_listener(java.awt.event.ComponentListener,true)
  define_listener(java.awt.event.ContainerListener)
  define_listener(java.beans.PropertyChangeListener,true)
  define_listener(java.awt.event.KeyListener,true)
  define_listener(java.awt.event.InputMethodListener,true)
  define_listener(java.awt.event.FocusListener,true)
  define_listener(java.awt.event.HierarchyBoundsListener,true)
  define_listener(java.awt.event.HierarchyListener,true)
  define_listener(java.awt.event.ActionListener)
  define_listener(java.awt.event.WindowListener)
  define_listener(java.awt.event.WindowFocusListener)
  define_listener(java.awt.event.WindowStateListener)
  define_listener(java.awt.event.MouseListener)
  define_listener(java.awt.event.MouseMotionListener)
  define_listener(java.awt.event.MouseWheelListener)
  
  
  module ComponentListeners
    include ProcComponentListener
    include ProcFocusListener
    include ProcHierarchyListener
    include ProcHierarchyBoundsListener
    include ProcInputMethodListener
    include ProcPropertyChangeListener
    include ProcKeyListener
    include ProcMouseListener
    include ProcMouseMotionListener
    include ProcMouseWheelListener
  end
  
  module WindowListeners
    include ProcWindowListener
    include ProcWindowFocusListener
    include ProcWindowStateListener
  end
end