=begin
  RuviEdit Syntax-highlight test source code
  =end 行頭以外の =end は無視
=end

# キーワード
class Hoge 
  def initialize
    @hoge = 1
    @@fuga = 2
    $foobar = "hoge"
  end
  def fuga
    if @hoge!=2
      @hoge=3
    end
  end
  def ishoge?(a)
    return  a == "hoge"
  end
  def max(a, b)
    if a > b && ishoge?(a) then
      return a
    else
      return b
    end
    return a if a > b 
    return b
    return a > b ? a : b
  end
end
c = Hoge.new
c.ishoge?(a)
Hoge::fuga

# リテラル
##  数値リテラル
a = 123
a = 0d123
a = -123      # - は数値色表示されない仕様とする
a = 123.45
a = 1.2e-3
a = 0xabcd
a = 0b1010
a = 0377
a = 0o377
a = ?a      # ３項演算子の ? と区別が難しい
a = ?\C-a
a = ?\M-a
a = ?\M-\C-a

## 文字列リテラル
p "this is a\tstring expression\n"     # ダブルクォート文字列
p "octal\012constant"   # ８進数の場合は、４文字色を変える
p "hex \xab constant \x0AB\Xabc"     # \xnn は２桁１６進数、\X は１６進数ではない
p "control char \cxも大丈夫"    # コントロール文字
p "control char \C-xも大丈夫"    # コントロール文字
p "meta-char \M-xも大丈夫"    # メタ文字
p "meta-control char \M-\C-xも大丈夫"    # メタコントロール文字
p "hoge#{exp+1}fuga" # #{exp} を含む場合
p "hoge#{ar["str"]}fuga" # #{exp} のなかにダブルクォート文字列を含む場合
p "hoge#{ar['str']}fuga" # #{exp} のなかにシングルクォート文字列を含む場合
p "hoge#{ar["str"]
}fuga" # #{exp} のなかにダブルクォート文字列を含む場合 & 途中で改行
p "hoge#{ar['str']
}fuga" # #{exp} のなかにシングルクォート文字列を含む場合 ＆ 途中で改行
"hoge#{"fuga #{exp}"}hoge" #  #{exp} が入れ子になっている場合
p 'this is a string \\expression\n'    # シングルクォート文字列
p 'this is a string \'expression\n'    # シングルクォート文字列
p %q!I said, "You said, 'She said it.'"\n#{a}!    # シングルクォート文字列
p %!I said, "You said, 'She said it.'"\n#{a}!     # ダブルクォート文字列
p %(hoge(x)hoge)    # 括弧の入れ子の場合
p %(hoge(x#{exp})hoge)    # 括弧 ＆ #{exp} の入れ子の場合
p %(hoge(x#{exp
})hoge)    # 括弧 ＆ #{exp} の入れ子の場合 ＆ 改行
p %[hoge[x]hoge]
p %{hoge{x}hoge}
p %<hoge<x>hoge>
p %(hoge(x
)hoge)    # 括弧の入れ子の途中で改行した場合
p %Q('This is it.'\n#{a})     # ダブルクォート文字列
p %q('This is it.'\n#{a})     # シングルクォート文字列
p %!STRING\n#{a}!     # ダブルクォート文字列
p %Q!STRING\n#{a}!    # 同上
p %q!STRING\n#{a}!    # シングルクォート文字列
p %x!STRING!    # コマンド出力 未実装
p "this is multi line

string\nthis is \'multi line
string" # マルチライン文字列終わり
# コメント
p 'this is multi line
string \n this is \'multi line
string' # マルチライン文字列終わり
p %|hello|
p %|
hello
|                # "\nhello\n" と同じ
p "hoge #{a}hoge"   # 式展開 #{exp}
# マルチライン文字列と #{exp} の組み合わせ
p "hoge #{a}hoge
hoge #{a}hoge
hoge #{a}hoge"
# exp と } の間で改行した場合
p "hoge #{a
}hoge
hoge #{
a}hoge
hoge #{a}hoge"
# ヒアドキュメント＋#{exp} ＋ その中にマルチライン文字列
p <<-EOS
  hoge#{"fuga
  fuga"}hoge
  EOS
  #
  
## here document
print <<EOM
ここはそのまま表示される
  EOM
  ↑ - が無い場合、インデント不可
  # 行コメントより優先
EOM
print <<-EOMess
ここはそのまま表示される
  EOMess
  # 行コメント
print <<-EOMess
ここは#{a}そのまま表示される。式展開は有効だよ
  EOMess
  # 行コメント
print <<-EOMess
ここは#{"hoge #{exp} のなかにマルチライン文字列がある場合
fuga"}そのまま表示される。式展開は有効だよ
  EOMess
  # 行コメント
print <<-EOMess
ここは#{'hoge #{exp} のなかにマルチライン文字列がある場合
fuga'}そのまま表示される。式展開は有効だよ
  EOMess
  # 行コメント
print <<"EOM"
ここはそのまま表示される
  EOM
  ↑ - が無い場合、インデント不可
  # 行コメントより優先
EOM
print <<-"#{a}"
ここはそのまま表示される
  #{a}
  # 行コメント
print <<-"#{a}"
ここは#{a}そのまま表示される
  #{a}
  # 行コメント
print <<'EOM'
ここはそのまま表示される
  EOM
  ↑ - が無い場合、インデント不可
  # 行コメントより優先
EOM
print <<-'EOMess'
ここはそのまま表示される
  EOMess
  # 行コメント
print <<-'EOMess'
ここは#{a}そのまま表示される。式展開は無効だよ
  EOMess
  # 行コメント
print <<'#{a}'
ここはそのまま表示される
  #{a}
  ↑ - が無い場合、インデント不可
  # 行コメントより優先
#{a}
print <<-'#{a}'
ここは#{a}そのまま表示される。式展開は無効だよ
  #{a}
  # 行コメント
print <<-'#{a}'
ここは#{a}そのまま表示される。式展開は無効だよ
  #{a}
  # 行コメント
print <<`EOM`
ここはそのまま表示される
  EOM
  ↑ - が無い場合、インデント不可
  # 行コメントより優先
EOM
print <<-`EOMess`
ここはそのまま表示される
  EOMess
  # 行コメント
print <<-`EOMess`
ここは#{a}そのまま表示される。式展開は有効だよ
  EOMess
  # 行コメント

## コマンド出力
p `dir`
p %x(dir)

## シンボル
p :class
p :lvar
p :method!
p :andthisis?
p :$gvar
p :@ivar
p :@@cvar
p :+
p :==
p :"string"
p :'string'
p :`cmd`
p %s(symbol)

## 正規表現リテラル
p /regular\texpression/i   # オプション部分の色は通常文字色とする
p %r|^https?://|    # 
p %r<^https?://>   # 
p /try-coloring.rb/   # 
p %r<hoge<table>hoge>   # <> の入れ子対応

p C.instance_methods.grep /\A.{1,3}\z/ 
p a/3/2   # この /3 は正規表現ではなく除算
p a / 3 / 2   # この /3 は正規表現ではなく除算
a = 1 if a =~ /foo\d+bar/
a = 1 if a =~ /3\/2/
p a[0]/3    # この /3 は正規表現ではなく除算
p f()/3       # この /3 は正規表現ではなく除算
# 正規表現入力途中の場合も正規表現色表示：
a = 1 if a =~ /\d+hoge

## %記法
p %W(hoge\nhoge)
p %w(hoge\nhoge)
p %W{hoge\n{foo}hoge}    # {} の入れ子
p %W{hoge\n{
foo}hoge}    # {} の入れ子＆改行
p %W{hoge{#{exp}hoge
}hoge} # {} 入れ子の中に #{...} がある場合

# 組み込み変数
p $"            # $LOADED_FEATURES          
p $'            # パターンマッチした部分の後ろ

# __END__

  __END__
# __END__ は前後に文字があると無効
class Fuga; end
"abc"

__END__
class Fuga; end
"abc"
