=begin
  RuviEdit Syntax-highlight test source code
  =end 行頭以外の =end は無視
=end

# キーワード
class Hoge 
  def initialize
    @hoge = 1
    @@fuga = 2
    $foobar = "hoge"
  end
  def max(a, b)
    if a > b then
      return a
    else
      return b
    end
    return a if a > b 
    return b
    return a > b ? a : b
  end
end

Hoge::fuga

# リテラル
##  数値リテラル
a = 123
a = 0d123
a = -123      # - は数値色表示されない仕様とする
a = 123.45
a = 1.2e-3
a = 0xabcd
a = 0b1010
a = 0377
a = 0o377
a = ?a
a = ?\C-a
a = ?\M-a
a = ?\M-\C-a

## 文字列リテラル
p "this is a\tstring expression\n"     # ダブルクォート文字列
p "octal \012 constant"   # ８進数の場合は、４文字色を変える
p 'this is a string \\expression\n'    # シングルクォート文字列
p 'this is a string \'expression\n'    # シングルクォート文字列
p %q!I said, "You said, 'She said it.'"\n#{a}!    # シングルクォート文字列
p %!I said, "You said, 'She said it.'"\n#{a}!     # ダブルクォート文字列
p %Q('This is it.'\n#{a})     # ダブルクォート文字列
p %q('This is it.'\n#{a})     # シングルクォート文字列
p %!STRING\n#{a}!     # ダブルクォート文字列
p %Q!STRING\n#{a}!    # 同上
p %q!STRING\n#{a}!    # シングルクォート文字列
p %x!STRING!    # コマンド出力 未実装
p "this is multi line
string\nthis is \'multi line
string" # マルチライン文字列終わり
# コメント
p 'this is multi line
string \n this is \'multi line
string' # マルチライン文字列終わり
p %|hello|
p %|
hello
|                # "\nhello\n" と同じ
p "hoge #{a}hoge"   # 式展開 #{exp}
# マルチライン文字列と #{exp} の組み合わせ
p "hoge #{a}hoge
hoge #{a}hoge
hoge #{a}hoge"
# exp と } の間で改行した場合
p "hoge #{a
}hoge
hoge #{a}hoge
hoge #{a}hoge"

## here document
print <<EOM
ここはそのまま表示される
  EOM
  ↑ - が無い場合、インデント不可
  # 行コメントより優先
EOM
print <<-EOMess
ここはそのまま表示される
  EOMess
  # 行コメント
print <<-EOMess
ここは#{a}そのまま表示される
  EOMess
  # 行コメント

## シンボル
p :class
p :lvar
p :method!
p :andthisis?
p :$gvar
p :@ivar
p :@@cvar
p :+
p :==
p :"string"
p :'string'
p %s(symbol)

## 正規表現リテラル
p /regular expression/i   # オプション部分の色はどうしましょ？
p %r|^https?://|    # 
p /try-coloring.rb/   # 
p a/3/2   # この /3 は正規表現ではなく除算
a = 1 if a =~ /\d+/
p a[0]/3    # この /3 は正規表現ではなく除算
p f()/3       # この /3 は正規表現ではなく除算

## %記法
p %W(hoge\n hoge)
p %w(hoge\n hoge)

# 組み込み変数
p $"            # $LOADED_FEATURES          
p $'            # パターンマッチした部分の後ろ

# __END__

  __END__
# __END__ は前後に文字があると無効
class Fuga; end
"abc"

__END__
class Fuga; end
"abc"
