=begin
  RuviEdit Syntax-highlight test source code
  =end 行頭以外の =end は無視
=end

# キーワード
class Hoge 
  def initialize
    @hoge = 1
    @@fuga = 2
    $foobar = "hoge"
  end
  def max(a, b)
    if a > b then
      return a
    else
      return b
    end
    return a if a > b 
    return b
    return a > b ? a : b
  end
end

# リテラル
##  数値リテラル
a = 123
a = 0d123
a = -123      # - は数値色表示されない仕様とする
a = 123.45
a = 1.2e-3
a = 0xabcd
a = 0b1010
a = 0377
a = 0o377
a = ?a
a = ?\C-a
a = ?\M-a
a = ?\M-\C-a

## 文字列リテラル
p "this is a\tstring expression\n"
p 'this is a string expression\n'
p %q!I said, "You said, 'She said it.'"!
p %!I said, "You said, 'She said it.'"!
p %Q('This is it.'\n)     # ダブルクォート文字列
p %q('This is it.'\n)     # シングルクォート文字列
p "this is multi line
string\nthis is multi line
string"
p 'this is multi line
string \n this is multi line
string'
p "hoge #{a}hoge"
# マルチライン文字列と #{exp} の組み合わせ
p "hoge #{a}hoge
hoge #{a}hoge
hoge #{a}hoge"

## here document
print <<EOM
ここはそのまま表示される
  EOM
  ↑ - が無い場合、インデント不可
  # 行コメントより優先
EOM
print <<-EOMess
ここはそのまま表示される
  EOMess
  # 行コメント

## シンボル
p :class
p :lvar
p :method!
p :andthisis?
p :$gvar
p :@ivar
p :@@cvar
p :+
p :==

# __END__

  __END__
# __END__ は前後に文字があると無効
class Fuga; end
"abc"

__END__
class Fuga; end
"abc"
