# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_comments`
#

DROP TABLE IF EXISTS runcms_comments;
CREATE TABLE runcms_comments (
  comment_id mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  item_id mediumint(8) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  user_id mediumint(8) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  subject varchar(60) NOT NULL default '',
  comment text NOT NULL,
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '0',
  type enum('admin','user') NOT NULL default 'user',
  icon varchar(255) NOT NULL default '',
  attachsig tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (comment_id),
  KEY idx (item_id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_comments`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_contact`
#

DROP TABLE IF EXISTS runcms_contact;
CREATE TABLE runcms_contact (
  contact_text text,
  contact_options varchar(5) NOT NULL default '1|1|1',
  contact_reasons varchar(255) NOT NULL default '',
  about_text text,
  about_options varchar(5) NOT NULL default '1|1|1',
  policy_text text,
  policy_options varchar(5) NOT NULL default '1|1|1',
  intro_text text NOT NULL,
  intro_options varchar(5) NOT NULL default '1|1|1',
  text_alt varchar(255) NOT NULL default '',
  text_caption varchar(255) NOT NULL default '',
  text_custom text,
  button_alt varchar(255) NOT NULL default '',
  button_img varchar(255) NOT NULL default '',
  button_custom text,
  logo_alt varchar(255) NOT NULL default '',
  logo_img varchar(255) NOT NULL default '',
  logo_custom text,
  banner_alt varchar(255) NOT NULL default '',
  banner_img varchar(255) NOT NULL default '',
  banner_custom text
) TYPE=MyISAM;

#
# Data dump for tabellen `runcms_contact`
#

INSERT INTO runcms_contact (contact_text, contact_options, contact_reasons, about_text, about_options, policy_text, policy_options, intro_text, intro_options, text_alt, text_caption, text_custom, button_alt, button_img, button_custom, logo_alt, logo_img, logo_custom, banner_alt, banner_img, banner_custom) VALUES ('', '1|1|1', 'Other|Support|Proposal', '', '1|1|1', '', '1|1|1', '', '1|1|1', '', '', '', '', '', '', '', '', '', '', '', '');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_groups`
#

DROP TABLE IF EXISTS runcms_groups;
CREATE TABLE runcms_groups (
  groupid mediumint(8) unsigned NOT NULL auto_increment,
  name varchar(30) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  type enum('Admin','User','Anonymous','Custom') NOT NULL default 'Custom',
  PRIMARY KEY  (groupid),
  KEY idx (type)
) TYPE=MyISAM AUTO_INCREMENT=4 ;

#
# Data dump for tabellen `runcms_groups`
#

INSERT INTO runcms_groups (groupid, name, description, type) VALUES (1, 'webmaster', 'webmasters of this site', 'Admin');
INSERT INTO runcms_groups (groupid, name, description, type) VALUES (2, 'Registered Users', 'Registered Users Group', 'User');
INSERT INTO runcms_groups (groupid, name, description, type) VALUES (3, 'Anonymous Users', 'Anonymous Users Group', 'Anonymous');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_groups_blocks_link`
#

DROP TABLE IF EXISTS runcms_groups_blocks_link;
CREATE TABLE runcms_groups_blocks_link (
  groupid mediumint(8) unsigned NOT NULL default '0',
  block_id mediumint(8) unsigned NOT NULL default '0',
  type char(1) NOT NULL default ''
) TYPE=MyISAM;

#
# Data dump for tabellen `runcms_groups_blocks_link`
#

INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 9, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 8, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 7, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 6, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 5, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 11, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 11, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 12, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 10, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 12, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 17, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 17, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 10, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 4, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 3, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 2, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 1, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 9, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 6, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 5, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 2, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 9, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 6, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 5, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 2, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 10, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 1, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 1, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 11, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 12, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 13, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 14, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 15, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 16, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 17, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 18, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (3, 19, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 19, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 19, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (2, 8, 'R');
INSERT INTO runcms_groups_blocks_link (groupid, block_id, type) VALUES (1, 8, 'R');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_groups_modules_link`
#

DROP TABLE IF EXISTS runcms_groups_modules_link;
CREATE TABLE runcms_groups_modules_link (
  groupid mediumint(8) unsigned NOT NULL default '0',
  mid mediumint(8) unsigned NOT NULL default '0',
  type char(1) NOT NULL default ''
) TYPE=MyISAM;

#
# Data dump for tabellen `runcms_groups_modules_link`
#

INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 2, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 2, 'A');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 1, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 1, 'A');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (2, 2, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (2, 1, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (3, 2, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (3, 1, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 3, 'A');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 3, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 4, 'A');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 4, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 5, 'A');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 5, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 6, 'A');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 6, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 7, 'A');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 7, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 8, 'A');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 8, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (2, 3, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (2, 4, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (2, 5, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (2, 6, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (2, 8, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (3, 3, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (3, 4, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (3, 5, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (3, 6, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (3, 8, 'R');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 9, 'A');
INSERT INTO runcms_groups_modules_link (groupid, mid, type) VALUES (1, 9, 'R');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_groups_users_link`
#

DROP TABLE IF EXISTS runcms_groups_users_link;
CREATE TABLE runcms_groups_users_link (
  groupid mediumint(8) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0'
) TYPE=MyISAM;

#
# Data dump for tabellen `runcms_groups_users_link`
#

INSERT INTO runcms_groups_users_link (groupid, uid) VALUES (1, 1);
INSERT INTO runcms_groups_users_link (groupid, uid) VALUES (2, 1);

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_lastseen`
#

DROP TABLE IF EXISTS runcms_lastseen;
CREATE TABLE runcms_lastseen (
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  time int(10) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  online tinyint(1) unsigned NOT NULL default '0',
  KEY idx (uid,online)
) TYPE=MyISAM;

#
# Data dump for tabellen `runcms_lastseen`
#

INSERT INTO runcms_lastseen (uid, username, time, ip, online) VALUES (0, 'Visitor', 1097588184, '127.0.0.1', 1);
INSERT INTO runcms_lastseen (uid, username, time, ip, online) VALUES (1, 'admin', 1097588206, '127.0.0.1', 1);

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_modules`
#

DROP TABLE IF EXISTS runcms_modules;
CREATE TABLE runcms_modules (
  mid mediumint(8) unsigned NOT NULL auto_increment,
  name varchar(60) NOT NULL default '',
  version float(3,2) unsigned NOT NULL default '1.00',
  last_update int(10) unsigned NOT NULL default '0',
  weight smallint(3) NOT NULL default '0',
  isactive tinyint(1) unsigned NOT NULL default '0',
  dirname varchar(30) NOT NULL default '',
  config text,
  hasmain tinyint(1) unsigned NOT NULL default '0',
  hasadmin tinyint(1) unsigned NOT NULL default '0',
  hassearch tinyint(1) unsigned NOT NULL default '0',
  haswaiting tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (mid),
  KEY idx (dirname,isactive)
) TYPE=MyISAM AUTO_INCREMENT=10 ;

#
# Data dump for tabellen `runcms_modules`
#

INSERT INTO runcms_modules (mid, name, version, last_update, weight, isactive, dirname, config, hasmain, hasadmin, hassearch, haswaiting) VALUES (1, 'System Admin', '1.02', 1096381777, 0, 1, 'system', '', 0, 1, 0, 0);
INSERT INTO runcms_modules (mid, name, version, last_update, weight, isactive, dirname, config, hasmain, hasadmin, hassearch, haswaiting) VALUES (2, 'News', '1.10', 1030908717, 1, 1, 'news', '', 1, 1, 1, 1);
INSERT INTO runcms_modules (mid, name, version, last_update, weight, isactive, dirname, config, hasmain, hasadmin, hassearch, haswaiting) VALUES (3, 'About', '1.00', 1096381503, 7, 1, 'contact', '', 1, 1, 0, 0);
INSERT INTO runcms_modules (mid, name, version, last_update, weight, isactive, dirname, config, hasmain, hasadmin, hassearch, haswaiting) VALUES (4, 'Downloads', '1.02', 1096381503, 2, 1, 'mydownloads', '', 1, 1, 1, 1);
INSERT INTO runcms_modules (mid, name, version, last_update, weight, isactive, dirname, config, hasmain, hasadmin, hassearch, haswaiting) VALUES (5, 'Web Links', '1.02', 1096381503, 3, 1, 'mylinks', '', 1, 1, 1, 1);
INSERT INTO runcms_modules (mid, name, version, last_update, weight, isactive, dirname, config, hasmain, hasadmin, hassearch, haswaiting) VALUES (6, 'Tutorials', '1.55', 1096381504, 4, 1, 'sections', '', 1, 1, 1, 0);
INSERT INTO runcms_modules (mid, name, version, last_update, weight, isactive, dirname, config, hasmain, hasadmin, hassearch, haswaiting) VALUES (7, 'Whos Online', '1.02', 1096381504, 0, 1, 'whosonline', '', 0, 0, 0, 0);
INSERT INTO runcms_modules (mid, name, version, last_update, weight, isactive, dirname, config, hasmain, hasadmin, hassearch, haswaiting) VALUES (8, 'FAQ', '1.02', 1096381504, 5, 1, 'xoopsfaq', '', 1, 1, 1, 0);
INSERT INTO runcms_modules (mid, name, version, last_update, weight, isactive, dirname, config, hasmain, hasadmin, hassearch, haswaiting) VALUES (9, 'Polls', '1.03', 1096382343, 6, 1, 'xoopspoll', '', 1, 1, 0, 0);

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mydownloads_broken`
#

DROP TABLE IF EXISTS runcms_mydownloads_broken;
CREATE TABLE runcms_mydownloads_broken (
  reportid mediumint(8) unsigned NOT NULL auto_increment,
  lid mediumint(8) unsigned NOT NULL default '0',
  sender mediumint(8) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  PRIMARY KEY  (reportid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mydownloads_broken`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mydownloads_cat`
#

DROP TABLE IF EXISTS runcms_mydownloads_cat;
CREATE TABLE runcms_mydownloads_cat (
  cid mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '0',
  imgurl varchar(255) NOT NULL default '',
  description text,
  PRIMARY KEY  (cid),
  KEY idx (pid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mydownloads_cat`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mydownloads_downloads`
#

DROP TABLE IF EXISTS runcms_mydownloads_downloads;
CREATE TABLE runcms_mydownloads_downloads (
  lid mediumint(8) unsigned NOT NULL auto_increment,
  cid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  description text NOT NULL,
  url varchar(255) NOT NULL default '',
  homepage varchar(255) NOT NULL default '',
  version varchar(10) NOT NULL default '',
  size int(10) unsigned NOT NULL default '0',
  platform varchar(30) NOT NULL default '',
  logourl varchar(255) NOT NULL default '',
  submitter mediumint(8) unsigned NOT NULL default '0',
  status tinyint(1) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  hits mediumint(8) unsigned NOT NULL default '0',
  rating float(3,2) unsigned NOT NULL default '0.00',
  votes smallint(5) unsigned NOT NULL default '0',
  comments smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (lid),
  KEY idx (status,cid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mydownloads_downloads`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mydownloads_mod`
#

DROP TABLE IF EXISTS runcms_mydownloads_mod;
CREATE TABLE runcms_mydownloads_mod (
  requestid mediumint(8) unsigned NOT NULL auto_increment,
  lid mediumint(8) unsigned NOT NULL default '0',
  cid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  homepage varchar(255) NOT NULL default '',
  version varchar(10) NOT NULL default '',
  size int(10) unsigned NOT NULL default '0',
  platform varchar(30) NOT NULL default '',
  logourl varchar(255) NOT NULL default '',
  description text NOT NULL,
  modifysubmitter mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (requestid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mydownloads_mod`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mydownloads_votedata`
#

DROP TABLE IF EXISTS runcms_mydownloads_votedata;
CREATE TABLE runcms_mydownloads_votedata (
  ratingid mediumint(8) unsigned NOT NULL auto_increment,
  lid mediumint(8) unsigned NOT NULL default '0',
  ratinguser mediumint(8) unsigned NOT NULL default '0',
  rating float(3,2) unsigned NOT NULL default '0.00',
  ratinghostname varchar(15) NOT NULL default '',
  ratingtimestamp int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (ratingid),
  KEY idx (lid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mydownloads_votedata`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mylinks_broken`
#

DROP TABLE IF EXISTS runcms_mylinks_broken;
CREATE TABLE runcms_mylinks_broken (
  reportid mediumint(8) unsigned NOT NULL auto_increment,
  lid mediumint(8) unsigned NOT NULL default '0',
  sender mediumint(8) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  PRIMARY KEY  (reportid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mylinks_broken`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mylinks_cat`
#

DROP TABLE IF EXISTS runcms_mylinks_cat;
CREATE TABLE runcms_mylinks_cat (
  cid mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  imgurl varchar(255) NOT NULL default '',
  description text,
  PRIMARY KEY  (cid),
  KEY idx (pid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mylinks_cat`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mylinks_links`
#

DROP TABLE IF EXISTS runcms_mylinks_links;
CREATE TABLE runcms_mylinks_links (
  lid mediumint(8) unsigned NOT NULL auto_increment,
  cid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  description text NOT NULL,
  url varchar(255) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  logourl varchar(255) NOT NULL default '',
  submitter mediumint(8) unsigned NOT NULL default '0',
  status tinyint(1) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  hits mediumint(8) unsigned NOT NULL default '0',
  rating float(3,2) unsigned NOT NULL default '0.00',
  votes smallint(5) unsigned NOT NULL default '0',
  comments smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (lid),
  KEY idx (status,cid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mylinks_links`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mylinks_mod`
#

DROP TABLE IF EXISTS runcms_mylinks_mod;
CREATE TABLE runcms_mylinks_mod (
  requestid mediumint(8) unsigned NOT NULL auto_increment,
  lid mediumint(8) unsigned NOT NULL default '0',
  cid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  logourl varchar(255) NOT NULL default '',
  description text NOT NULL,
  modifysubmitter mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (requestid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mylinks_mod`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_mylinks_votedata`
#

DROP TABLE IF EXISTS runcms_mylinks_votedata;
CREATE TABLE runcms_mylinks_votedata (
  ratingid mediumint(8) unsigned NOT NULL auto_increment,
  lid mediumint(8) unsigned NOT NULL default '0',
  ratinguser mediumint(8) unsigned NOT NULL default '0',
  rating float(3,2) unsigned NOT NULL default '0.00',
  ratinghostname varchar(15) NOT NULL default '',
  ratingtimestamp int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (ratingid),
  KEY idx (lid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_mylinks_votedata`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_newblocks`
#

DROP TABLE IF EXISTS runcms_newblocks;
CREATE TABLE runcms_newblocks (
  bid mediumint(8) unsigned NOT NULL auto_increment,
  mid mediumint(8) unsigned NOT NULL default '0',
  func_num tinyint(3) unsigned NOT NULL default '0',
  options varchar(255) NOT NULL default '',
  name varchar(60) NOT NULL default '',
  position tinyint(1) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  content text,
  side tinyint(3) unsigned NOT NULL default '0',
  weight smallint(3) NOT NULL default '0',
  visible tinyint(1) unsigned NOT NULL default '0',
  type char(1) NOT NULL default 'C',
  c_type char(1) NOT NULL default '',
  isactive tinyint(1) unsigned NOT NULL default '0',
  iscopy tinyint(1) unsigned NOT NULL default '0',
  dirname varchar(30) NOT NULL default '',
  func_file varchar(30) NOT NULL default '',
  show_func varchar(30) NOT NULL default '',
  show_mid varchar(255) NOT NULL default '0',
  show_template varchar(40) NOT NULL default 'standard',
  page_style tinyint(2) unsigned NOT NULL default '3',
  edit_func varchar(30) NOT NULL default '',
  PRIMARY KEY  (bid),
  KEY idx (mid,isactive,side,visible)
) TYPE=MyISAM AUTO_INCREMENT=20 ;

#
# Data dump for tabellen `runcms_newblocks`
#

INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (1, 1, 1, '', 'User Block', 1, 'User Block', '', 0, 0, 1, 'S', 'H', 1, 0, 'system', 'system_user.php', 'b_system_user_show', '0', 15, '');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (2, 1, 2, '', 'Login Block', 1, '', '', 1, 1, 1, 'S', '', 1, 0, 'system', 'system_login.php', 'b_system_login_show', '0', 3, '');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (3, 1, 3, '', 'Search Block', 1, '', '', 0, 0, 0, 'S', '', 1, 0, 'system', 'system_search.php', 'b_system_search_show', '0', 3, '');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (4, 1, 4, '', 'Waiting Contents Block', 1, 'Waiting Contents', '', 1, 1, 1, 'S', 'H', 1, 0, 'system', 'system_waiting.php', 'b_system_waiting_show', '2', 1, '');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (5, 1, 5, '1', 'Main Menu Block', 0, 'Main Menu', '', 0, 2, 1, 'S', 'H', 1, 0, 'system', 'system_menu.php', 'b_system_main_dynshow', '0', 15, 'b_system_main_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (6, 1, 6, '320|250|button.gif|1', 'Site Info Block', 0, 'Site Info', '', 0, 3, 1, 'S', 'H', 1, 0, 'system', 'system_info.php', 'b_system_info_show', '0', 15, 'b_system_info_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (7, 2, 1, '', 'News Topics Block', 0, '', '', 0, 0, 0, 'M', '', 1, 0, 'news', 'news_topics.php', 'b_news_topics_show', '0', 3, '');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (8, 2, 2, '', 'Big Story Block', 0, 'Big Story', '', 1, 5, 1, 'M', 'H', 1, 0, 'news', 'news_bigstory.php', 'b_news_bigstory_show', '2', 1, '');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (9, 2, 3, 'counter|0|19|5|0', 'Top News Block', 0, 'Top News', '', 4, 1, 1, 'M', 'H', 1, 0, 'news', 'news_top.php', 'b_news_top_show', '2', 1, 'b_news_top_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (10, 2, 4, 'published|0|19|5|0', 'Recent News Block', 0, 'Recent News', '', 3, 2, 0, 'M', 'H', 1, 0, 'news', 'news_top.php', 'b_news_top_show', '2', 1, 'b_news_top_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (11, 4, 1, 'date|0|19|5|0', 'Recent Downloads', 0, 'Recent Downloads', '', 4, 3, 0, 'M', 'H', 1, 0, 'mydownloads', 'mydownloads_top.php', 'b_mydownloads_top_show', '2', 1, 'b_mydownloads_top_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (12, 4, 2, 'hits|0|19|5|0', 'Top Downloads', 0, 'Top Downloads', '', 3, 0, 1, 'M', 'H', 1, 0, 'mydownloads', 'mydownloads_top.php', 'b_mydownloads_top_show', '2', 1, 'b_mydownloads_top_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (13, 5, 1, 'date|0|19|5|0', 'Recent Links', 0, '', '', 0, 0, 0, 'M', '', 1, 0, 'mylinks', 'mylinks_top.php', 'b_mylinks_top_show', '0', 3, 'b_mylinks_top_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (14, 5, 2, 'hits|0|19|5|0', 'Top Links', 0, '', '', 0, 0, 0, 'M', '', 1, 0, 'mylinks', 'mylinks_top.php', 'b_mylinks_top_show', '0', 3, 'b_mylinks_top_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (15, 6, 1, 'counter|0|19|5', 'Popular Section Articles', 0, '', '', 0, 0, 0, 'M', '', 1, 0, 'sections', 'nsection_top.php', 'b_nsection_top_show', '0', 3, 'b_nsection_top_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (16, 6, 2, 'date|0|19|5', 'Recent Section Articles', 0, '', '', 0, 0, 0, 'M', '', 1, 0, 'sections', 'nsection_top.php', 'b_nsection_top_show', '0', 3, 'b_nsection_top_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (17, 7, 1, '0|10|20', 'Whos Online Block', 0, 'Whos Online', '', 0, 4, 1, 'M', 'H', 1, 0, 'whosonline', 'whosonline.php', 'b_whosonline_show', '0', 15, 'b_whosonline_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (18, 8, 1, '0|19|5', 'Recent FAQ Additions', 0, '', '', 0, 0, 0, 'M', '', 1, 0, 'xoopsfaq', 'xoopsfaq.php', 'b_faq_show', '0', 3, 'b_faq_edit');
INSERT INTO runcms_newblocks (bid, mid, func_num, options, name, position, title, content, side, weight, visible, type, c_type, isactive, iscopy, dirname, func_file, show_func, show_mid, page_style, edit_func) VALUES (19, 9, 1, '', 'Polls Block', 0, 'Polls', '', 1, 2, 1, 'M', 'H', 1, 0, 'xoopspoll', 'xoopspoll.php', 'b_xoopspoll_show', '2', 1, '');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_nseccont`
#

DROP TABLE IF EXISTS runcms_nseccont;
CREATE TABLE runcms_nseccont (
  artid mediumint(8) unsigned NOT NULL auto_increment,
  secid mediumint(8) unsigned NOT NULL default '0',
  groupid varchar(100) NOT NULL default '1 2 3',
  title varchar(60) NOT NULL default '',
  byline varchar(255) NOT NULL default '',
  author mediumint(8) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  content text NOT NULL,
  counter mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (artid),
  KEY idx (secid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_nseccont`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_nsections`
#

DROP TABLE IF EXISTS runcms_nsections;
CREATE TABLE runcms_nsections (
  secid mediumint(8) unsigned NOT NULL auto_increment,
  groupid varchar(100) NOT NULL default '1 2 3',
  secname varchar(60) NOT NULL default '',
  image varchar(255) NOT NULL default '',
  secdesc text,
  PRIMARY KEY  (secid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_nsections`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_priv_msgs`
#

DROP TABLE IF EXISTS runcms_priv_msgs;
CREATE TABLE runcms_priv_msgs (
  msg_id mediumint(8) unsigned NOT NULL auto_increment,
  msg_image varchar(255) NOT NULL default '',
  subject varchar(60) NOT NULL default '',
  from_userid mediumint(8) unsigned NOT NULL default '0',
  to_userid mediumint(8) unsigned NOT NULL default '0',
  msg_time int(10) unsigned NOT NULL default '0',
  msg_text text NOT NULL,
  read_msg tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (msg_id),
  KEY idx (to_userid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_priv_msgs`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_ranks`
#

DROP TABLE IF EXISTS runcms_ranks;
CREATE TABLE runcms_ranks (
  rank_id mediumint(8) unsigned NOT NULL auto_increment,
  rank_title varchar(60) NOT NULL default '',
  rank_min int(10) NOT NULL default '0',
  rank_max int(10) NOT NULL default '0',
  rank_special tinyint(1) unsigned NOT NULL default '0',
  rank_image varchar(255) NOT NULL default '',
  PRIMARY KEY  (rank_id)
) TYPE=MyISAM AUTO_INCREMENT=9 ;

#
# Data dump for tabellen `runcms_ranks`
#

INSERT INTO runcms_ranks (rank_id, rank_title, rank_min, rank_max, rank_special, rank_image) VALUES (2, 'Just popping in', 0, 20, 0, '');
INSERT INTO runcms_ranks (rank_id, rank_title, rank_min, rank_max, rank_special, rank_image) VALUES (3, 'Not too shy to talk', 21, 40, 0, 'rank1.gif');
INSERT INTO runcms_ranks (rank_id, rank_title, rank_min, rank_max, rank_special, rank_image) VALUES (4, 'Quite a regular', 41, 70, 0, 'rank2.gif');
INSERT INTO runcms_ranks (rank_id, rank_title, rank_min, rank_max, rank_special, rank_image) VALUES (5, 'Just can\'t stay away', 71, 150, 0, 'rank3.gif');
INSERT INTO runcms_ranks (rank_id, rank_title, rank_min, rank_max, rank_special, rank_image) VALUES (6, 'Home away from home', 151, 10000, 0, 'rank4.gif');
INSERT INTO runcms_ranks (rank_id, rank_title, rank_min, rank_max, rank_special, rank_image) VALUES (7, 'Webmaster', -1, -1, 1, 'webmaster.gif');
INSERT INTO runcms_ranks (rank_id, rank_title, rank_min, rank_max, rank_special, rank_image) VALUES (8, 'Moderator', -1, -1, 1, 'moderator.gif');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_session`
#

DROP TABLE IF EXISTS runcms_session;
CREATE TABLE runcms_session (
  uid mediumint(8) unsigned NOT NULL default '0',
  uname varchar(30) NOT NULL default '',
  time int(10) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  mid mediumint(8) unsigned NOT NULL default '0',
  hash varchar(32) NOT NULL default '',
  KEY idx (uid,hash)
) TYPE=MyISAM;

#
# Data dump for tabellen `runcms_session`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_smiles`
#

DROP TABLE IF EXISTS runcms_smiles;
CREATE TABLE runcms_smiles (
  id mediumint(8) unsigned NOT NULL auto_increment,
  code varchar(30) NOT NULL default '',
  smile_url varchar(255) NOT NULL default '',
  emotion varchar(60) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=18 ;

#
# Data dump for tabellen `runcms_smiles`
#

INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (1, ':-D', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (2, ':-)', 'icon_smile.gif', 'Smile');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (3, ':-(', 'icon_frown.gif', 'Sad');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (4, ':-o', 'icon_eek.gif', 'Surprised');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (5, ':-?', 'icon_confused.gif', 'Confused');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (6, '8-)', 'icon_cool.gif', 'Cool');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (7, ':lol:', 'icon_lol.gif', 'Laughing');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (8, ':-x', 'icon_mad.gif', 'Mad');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (9, ':-P', 'icon_razz.gif', 'Razz');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (10, ':oops:', 'icon_redface.gif', 'Embaressed');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (11, ':cry:', 'icon_cry.gif', 'Crying (very sad)');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (12, ':evil:', 'icon_evil.gif', 'Evil or Very Mad');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (13, ':roll:', 'icon_rolleyes.gif', 'Rolling Eyes');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (14, ';-)', 'icon_wink.gif', 'Wink');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (15, ':pint:', 'icon_drink.gif', 'Another pint of beer');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (16, ':hammer:', 'icon_hammer.gif', 'ToolTimes at work');
INSERT INTO runcms_smiles (id, code, smile_url, emotion) VALUES (17, ':idea:', 'icon_idea.gif', 'I have an idea');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_stories`
#

DROP TABLE IF EXISTS runcms_stories;
CREATE TABLE runcms_stories (
  storyid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  created int(10) unsigned NOT NULL default '0',
  published int(10) unsigned NOT NULL default '0',
  hostname varchar(15) NOT NULL default '',
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '1',
  hometext text NOT NULL,
  bodytext text,
  counter mediumint(8) unsigned NOT NULL default '0',
  topicid mediumint(8) unsigned NOT NULL default '1',
  ihome tinyint(1) unsigned NOT NULL default '0',
  notifypub tinyint(1) unsigned NOT NULL default '0',
  type enum('admin','user') NOT NULL default 'user',
  topicdisplay tinyint(1) unsigned NOT NULL default '0',
  topicalign enum('R','L','0') NOT NULL default '0',
  PRIMARY KEY  (storyid),
  KEY idx (topicid,published,ihome,created)
) TYPE=MyISAM AUTO_INCREMENT=2 ;

#
# Data dump for tabellen `runcms_stories`
#

INSERT INTO runcms_stories (storyid, uid, title, created, published, hostname, allow_html, allow_smileys, allow_bbcode, hometext, bodytext, counter, topicid, ihome, notifypub, type, topicdisplay, topicalign) VALUES (1, 1, 'Welcome to your new site', 1030894461, 1030894461, '150.0.0.0', 0, 1, 1, 'To login, simply use the UserName/Password you provided during the setup process.\r\n\r\nIf you did a SQL dump, then simply login with admin/admin (case sensitive), and be sure to change your login information!\r\n\r\nAlso remember change file permissions on mainfile.php back to read-only (0444 unix), and be sure to delete the entire /_install folder from your server for security reasons.\r\n\r\n[b][size=xx-small]REMEMBER:[/size][/b]\r\nTo be able to save your configuration data, you need to make all /cache folders world writable (0777), and any files in them (0666).', '', 1, 1, 0, 0, 'admin', 1, 'R');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_topics`
#

DROP TABLE IF EXISTS runcms_topics;
CREATE TABLE runcms_topics (
  topic_id mediumint(8) unsigned NOT NULL auto_increment,
  topic_pid mediumint(8) unsigned NOT NULL default '0',
  topic_imgurl varchar(255) NOT NULL default '',
  topic_title varchar(60) NOT NULL default '',
  PRIMARY KEY  (topic_id),
  KEY idx (topic_pid)
) TYPE=MyISAM AUTO_INCREMENT=2 ;

#
# Data dump for tabellen `runcms_topics`
#

INSERT INTO runcms_topics (topic_id, topic_pid, topic_imgurl, topic_title) VALUES (1, 0, 'runcms.gif', 'RUNCMS');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_users`
#

DROP TABLE IF EXISTS runcms_users;
CREATE TABLE runcms_users (
  uid mediumint(8) unsigned NOT NULL auto_increment,
  name varchar(30) NOT NULL default '',
  uname varchar(30) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  user_avatar varchar(255) NOT NULL default '',
  user_regdate int(10) unsigned NOT NULL default '0',
  user_icq varchar(15) NOT NULL default '',
  user_from varchar(60) NOT NULL default '',
  user_sig varchar(255) NOT NULL default '',
  user_viewemail tinyint(1) unsigned NOT NULL default '0',
  actkey varchar(8) NOT NULL default '',
  user_aim varchar(60) NOT NULL default '',
  user_yim varchar(60) NOT NULL default '',
  user_msnm varchar(60) NOT NULL default '',
  pass varchar(32) NOT NULL default '',
  posts smallint(5) unsigned NOT NULL default '0',
  attachsig tinyint(1) unsigned NOT NULL default '0',
  rank int(5) NOT NULL default '0',
  level int(5) NOT NULL default '1',
  theme varchar(30) NOT NULL default '',
  timezone_offset tinyint(2) NOT NULL default '0',
  last_login int(10) unsigned NOT NULL default '0',
  umode enum('flat','thread','0') NOT NULL default 'flat',
  uorder tinyint(1) unsigned NOT NULL default '0',
  user_occ varchar(60) NOT NULL default '',
  bio varchar(255) NOT NULL default '',
  user_intrest varchar(255) NOT NULL default '',
  user_mailok tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (uid),
  UNIQUE KEY email (email),
  UNIQUE KEY uname (uname),
  KEY idx (uname)
) TYPE=MyISAM AUTO_INCREMENT=2 ;

#
# Data dump for tabellen `runcms_users`
#

INSERT INTO runcms_users (uid, name, uname, email, url, user_avatar, user_regdate, user_icq, user_from, user_sig, user_viewemail, actkey, user_aim, user_yim, user_msnm, pass, posts, attachsig, rank, level, theme, timezone_offset, last_login, umode, uorder, user_occ, bio, user_intrest, user_mailok) VALUES (1, '', 'admin', 'admin@mysite.com', 'http://www.mysite.com', '001.gif', 1097588181, '', '', '', 1, '66984a4b', '', '', '', '21232f297a57a5a743894a0e4a801fc3', 0, 0, 7, 5, 'runcms', 0, 1097588193, 'flat', 0, '', '', '', 1);

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_xoopsfaq_categories`
#

DROP TABLE IF EXISTS runcms_xoopsfaq_categories;
CREATE TABLE runcms_xoopsfaq_categories (
  category_id mediumint(8) unsigned NOT NULL auto_increment,
  category_title varchar(60) NOT NULL default '',
  category_order smallint(3) NOT NULL default '0',
  PRIMARY KEY  (category_id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_xoopsfaq_categories`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_xoopsfaq_contents`
#

DROP TABLE IF EXISTS runcms_xoopsfaq_contents;
CREATE TABLE runcms_xoopsfaq_contents (
  contents_id mediumint(8) unsigned NOT NULL auto_increment,
  category_id mediumint(8) unsigned NOT NULL default '0',
  contents_title varchar(255) NOT NULL default '',
  contents_contents text NOT NULL,
  contents_time int(10) unsigned NOT NULL default '0',
  contents_order smallint(3) NOT NULL default '0',
  contents_visible tinyint(1) unsigned NOT NULL default '1',
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (contents_id),
  KEY idx (category_id,contents_visible)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_xoopsfaq_contents`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_xoopspoll_desc`
#

DROP TABLE IF EXISTS runcms_xoopspoll_desc;
CREATE TABLE runcms_xoopspoll_desc (
  poll_id mediumint(8) unsigned NOT NULL auto_increment,
  question varchar(255) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  user_id mediumint(8) unsigned NOT NULL default '0',
  start_time int(10) unsigned NOT NULL default '0',
  end_time int(10) unsigned NOT NULL default '0',
  votes smallint(5) unsigned NOT NULL default '0',
  voters smallint(5) unsigned NOT NULL default '0',
  multiple tinyint(1) unsigned NOT NULL default '0',
  display tinyint(1) unsigned NOT NULL default '0',
  weight smallint(3) NOT NULL default '0',
  mail_status tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (poll_id),
  KEY idx (end_time,display)
) TYPE=MyISAM AUTO_INCREMENT=2 ;

#
# Data dump for tabellen `runcms_xoopspoll_desc`
#

INSERT INTO runcms_xoopspoll_desc (poll_id, question, description, user_id, start_time, end_time, votes, voters, multiple, display, weight, mail_status) VALUES (1, 'What do you think about RUNCMS?', 'A simple survey about the content management script used on this site.', 1, 1020447898, 1104451140, 0, 0, 0, 1, 0, 0);

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_xoopspoll_log`
#

DROP TABLE IF EXISTS runcms_xoopspoll_log;
CREATE TABLE runcms_xoopspoll_log (
  log_id mediumint(8) unsigned NOT NULL auto_increment,
  poll_id mediumint(8) unsigned NOT NULL default '0',
  option_id mediumint(8) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  user_id mediumint(8) unsigned NOT NULL default '0',
  time int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (log_id),
  KEY idx (poll_id,option_id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_xoopspoll_log`
#


# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_xoopspoll_option`
#

DROP TABLE IF EXISTS runcms_xoopspoll_option;
CREATE TABLE runcms_xoopspoll_option (
  option_id mediumint(8) unsigned NOT NULL auto_increment,
  poll_id mediumint(8) unsigned NOT NULL default '0',
  option_text varchar(60) NOT NULL default '',
  option_count smallint(5) unsigned NOT NULL default '0',
  option_color varchar(255) NOT NULL default '',
  PRIMARY KEY  (option_id),
  KEY idx (poll_id)
) TYPE=MyISAM AUTO_INCREMENT=5 ;

#
# Data dump for tabellen `runcms_xoopspoll_option`
#

INSERT INTO runcms_xoopspoll_option (option_id, poll_id, option_text, option_count, option_color) VALUES (1, 1, 'Excellent!', 0, 'aqua.gif');
INSERT INTO runcms_xoopspoll_option (option_id, poll_id, option_text, option_count, option_color) VALUES (2, 1, 'Cool', 0, 'blue.gif');
INSERT INTO runcms_xoopspoll_option (option_id, poll_id, option_text, option_count, option_color) VALUES (3, 1, 'Hmm..not bad', 0, 'brown.gif');
INSERT INTO runcms_xoopspoll_option (option_id, poll_id, option_text, option_count, option_color) VALUES (4, 1, 'What the hell is this?', 0, 'darkgreen.gif');

# --------------------------------------------------------

#
# Struktur dump for tabellen `runcms_xoopspollcomments`
#

DROP TABLE IF EXISTS runcms_xoopspollcomments;
CREATE TABLE runcms_xoopspollcomments (
  comment_id mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  item_id mediumint(8) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  user_id mediumint(8) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  subject varchar(60) NOT NULL default '',
  comment text NOT NULL,
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '0',
  type enum('admin','user') NOT NULL default 'user',
  icon varchar(255) NOT NULL default '',
  PRIMARY KEY  (comment_id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Data dump for tabellen `runcms_xoopspollcomments`
#

