<?php
include_once("../../../mainfile.php");

function importTable($src, $dest, $arrIgnoreFields = array())
{
	global $db;
	
	echo "Importing data from $src to $dest<br>";
	$numInserted = 0;
	$sql = "SELECT * FROM ".$db->prefix($src);
	$src_table = $db->query($sql);
	if($src_table && $db->num_rows($src_table) > 0)
	{
		$fields = array();
		for ($i = 0; $i < $db->num_fields($src_table); $i++)
		{
			$fields[$i] = $db->field_name($src_table, $i);
		}

		while ($src_row = $db->fetch_array($src_table))
		{
			$insert_sql = 'INSERT INTO '.$db->prefix($dest).' SET ';
			for($i=0; $i<count($fields); $i++)
			{
				if (in_array($fields[$i], $arrIgnoreFields))
					continue;

				if ($i == count($fields)-1)
					$insert_sql .= $fields[$i]."='".addslashes($src_row[$fields[$i]])."'";
				else
					$insert_sql .= $fields[$i]."='".addslashes($src_row[$fields[$i]])."', ";
			}
			if($db->query($insert_sql))
				$numInserted++;
			else
			  echo $db->error().'<br>';
		}
	}
	echo "Done: $numInserted row(s) inserted.<br><br>";
}

echo "<h3>Newbb to Newbb Plus 0.80 Importer</h3>";
echo "<hr>";
importTable('bb_categories','bbplus_categories');
importTable('bb_forum_access','bbplus_forum_access');
importTable('bb_forum_mods','bbplus_forum_mods');
importTable('bb_forums','bbplus_forums', array('forum_access','forum_type'));
importTable('bb_posts', 'bbplus_posts');
importTable('bb_topics', 'bbplus_topics');

// Set All posts as approved
$sql = "SELECT * FROM ".$db->prefix('bbplus_posts');
$result = $db->query($sql);
if(!$result) die('ERROR: '.$db->error());
while ($row = $db->fetch_object($result))
{
	$update_sql  = "UPDATE ".$db->prefix('bbplus_posts')." SET is_approved=1 WHERE post_id=".$row->post_id;
	if(!$db->query($update_sql)) die('ERROR: '.$db->error());
}

echo "<hr>";
echo "<h3>All data has been imported!</h3>";
echo "<h3>You will need to go to Forum Manager to set the access permissions for your forums.</h3>";
echo "<h3><font color='#ff0000'>The '_importer' directory should now be removed.</font></h3>";
?>
