<?php
// $Id: xoopsuser.php,v 1.1 2004/07/11 10:27:18 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: Kazumi Ono
// Author Website : http://www.mywebaddons.com/ , http://www.myweb.ne.jp
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //

if (!defined("XOOPS_USER_INCLUDED")) {
	define("XOOPS_USER_INCLUDED", 1);

include_once(XOOPS_ROOT_PATH."/class/xoopsobject.php");
include_once(XOOPS_ROOT_PATH."/class/xoopsgroup.php");

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
Class XoopsUser extends XoopsObject {

	var $inactive     = false;
	var $groups       = array();
	var $admin_groups = array();


	function XoopsUser($id=NULL) {
	global $xoopsConfig;

	$this->XoopsObject();
	$this->initVar("uid", "int", NULL, false);
	$this->initVar("name", "textbox", NULL, false, 60, false);
	$this->initVar("uname", "textbox", NULL, true, 25, false);
	$this->initVar("email", "textbox", NULL, true, 60, false);
	$this->initVar("url", "textbox", NULL, false, 100, false);
	$this->initVar("user_avatar", "textbox", NULL, false, 30);
	$this->initVar("user_regdate", "int", NULL, false);
	$this->initVar("user_icq", "textbox", NULL, false, 15, false);
	$this->initVar("user_from", "textbox", NULL, false, 100, true);
	$this->initVar("user_sig", "textarea", NULL, false, NULL, true);
	$this->initVar("user_viewemail", "int", 0, false);
	$this->initVar("actkey", "other", NULL, false);
	$this->initVar("user_aim", "textbox", NULL, false, 18, true);
	$this->initVar("user_yim", "textbox", NULL, false, 25, true);
	$this->initVar("user_msnm", "textbox", NULL, false, 25, true);
	$this->initVar("pass", "textbox", NULL, false, 32, false);
	$this->initVar("posts", "int", NULL, false);
	$this->initVar("attachsig", "int", 0, false);
	$this->initVar("rank", "int", NULL, false);
	$this->initVar("level", "int", 0, false);
	$this->initVar("theme", "other", NULL, false);
	$this->initVar("timezone_offset", "other", NULL, false);
	$this->initVar("last_login", "int", 0, false);
	$this->initVar("umode", "other", NULL, false);
	$this->initVar("uorder", "int", 1, false);
	$this->initVar("user_occ", "textbox", NULL, false, 100, true);
	$this->initVar("bio", "textarea", NULL, false, NULL, true);
	$this->initVar("user_intrest", "textbox", NULL, false, 150, true);
	$this->initVar("user_mailok", "int", 1, false);

	if ( !empty($id) ) {
		if ( is_array($id) ) {
			$this->set($id);
			} else {
				$this->load(intval($id));
			}
	}
	}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function login($uname, $pass) {
global $myts, $db;

$uname  = $myts->makeTboxData4Save($uname);
$result = $db->query("SELECT * FROM ".$db->prefix('users')." WHERE uname='".$uname."'");

if ( $db->num_rows($result) == 1 ) {
	$convert = false;
	$passed  = false;
	$myrow   = $db->fetch_array($result);
	if ( !empty($myrow['uid']) ) {
		if ( $myrow['pass'] == md5($pass) ) {
			$passed = true;
			} elseif ( $pass == $myrow['pass'] ) {
				$convert = true;
				$passed  = true;
				} elseif (function_exists('crypt')) {
					if (crypt($pass, substr($myrow['pass'], 0, 2)) == $myrow['pass'] ) {
						$convert = true;
						$passed  = true;
					}
				}
				if ( $convert ) {
					$newpass = md5($pass);
					$db->query("UPDATE ".$db->prefix('users')." SET pass='$newpass' WHERE uname='$uname'");
				}
				if ( $passed ) {
					return new XoopsUser($myrow);
				}
			}
		}

return false;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function updateLastLogin() {
global $db;

$db->query('UPDATE '.$db->prefix('users').' SET last_login='.time().' WHERE uid='.$this->getVar('uid'));
}

//---------------------------------------------------------------------------------------//
/**
* Logs out user
* removes user session from session table
*
* @param type $var description
* @return type description
*/
function logout() {
global $db, $xoopsConfig;

$db->query("DELETE FROM ".$db->prefix("session")." WHERE uid=".$this->getVar("uid")."");
if ($xoopsConfig['use_sessions'] == 1) {
	session_unset();
	session_destroy();
	} else {
		cookie($this->cookie);
	}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function load($id) {
global $db, $objCache;

if (!empty($objCache->XoopsUser['load'][$id])) {
	$this->set($objCache->XoopsUser['load'][$id]);
	if ( $this->getVar("level") == 0 ) {
		$this->inactive = true;
	}
	return;
}

$sql = "SELECT * FROM ".$db->prefix("users")." WHERE uid=".$id."";
if ( !$result = $db->query($sql) ) {
	die("ERROR");
}

$numrows = $db->num_rows($result);
if ( $numrows == 1 ) {
	$myrow = $db->fetch_array($result);
	$this->set($myrow);
	$objCache->XoopsUser['load'][$id] = $myrow;
	if ( $this->getVar("level") == 0 ) {
		$this->inactive = true;
	}
	} elseif ( $numrows == 0 ) {
		$this->inactive = true;
		} else {
			die("Duplicate User Entries!");
		}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function store() {
global $db;

if ( !$this->isCleaned() ) {
	if ( !$this->cleanVars() ) {
		return false;
	}
}

foreach ( $this->cleanVars as $k=>$v ) {
	$$k = $v;
}

if ( empty($uid) ) {
	$uid = $db->genId($db->prefix("users")."_uid_seq");
	$sql = "
		INSERT INTO ".$db->prefix("users")." SET
		uid=$uid,
		uname='$uname',
		name='$name',
		email='$email',
		url='$url',
		user_avatar='$user_avatar',
		user_regdate=".time().",
		user_icq='$user_icq',
		user_from='$user_from',
		user_sig='$user_sig',
		user_viewemail='$user_viewemail',
		actkey='$actkey',
		user_aim='$user_aim',
		user_yim='$user_yim',
		user_msnm='$user_msnm',
		pass='$pass',
		posts='$posts',
		attachsig='$attachsig',
		rank='$rank',
		level='$level',
		theme='$theme',
		timezone_offset='$timezone_offset',
		last_login=0,
		umode='$umode',
		uorder='$uorder',
		user_occ='$user_occ',
		bio='$bio',
		user_intrest='$user_intrest',
		user_mailok=$user_mailok";
	}  else {
		$sql ="UPDATE ".$db->prefix("users")." SET uname='$uname', name='$name', email='$email', url='$url', user_avatar='$user_avatar', user_icq='$user_icq', user_from='$user_from', user_sig='$user_sig', user_viewemail='$user_viewemail', user_aim='$user_aim', user_yim='$user_yim', user_msnm='$user_msnm', pass='$pass', attachsig='$attachsig', rank='$rank', theme='$theme', timezone_offset='$timezone_offset', umode='$umode', uorder='$uorder', user_occ='$user_occ', bio='$bio', user_intrest='$user_intrest', user_mailok=$user_mailok WHERE uid=$uid";
	}

if ( !$result = $db->query($sql) ) {
	$this->setErrors("Could not store data in database.");
	return false;
}

if ( empty($uid) ) {
	$uid = $db->insert_id();
}

return $uid;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function delete() {
global $db;

if ( $this->getVar("uid") > 0 ) {
	$sql = "DELETE FROM ".$db->prefix("users")." WHERE uid=".$this->getVar("uid")."";
	if ( !$result = $db->query($sql) ) {
		return false;
	}

	$db->query("DELETE FROM ".$db->prefix("groups_users_link")." WHERE uid=".$this->getVar("uid")."");
	$db->query("DELETE FROM ".$db->prefix("bb_forum_mods")." WHERE user_id=".$this->getVar("uid")."");
	$db->query("DELETE FROM ".$db->prefix("priv_msgs")." WHERE to_userid=".$this->getVar("uid")."");

	$avatar = avatarExists($this->getVar("uid"));
	if ($avatar) {
		@unlink(XOOPS_ROOT_PATH. '/images/avatar/'.$avatar);
	}
	$this->logout();
	}

return true;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function activate() {
global $db;

$sql = "UPDATE ".$db->prefix("users")." SET level=1 WHERE uid=".$this->getVar("uid")." AND actkey='".$this->getVar("actkey")."'";

if ( !$result = $db->query($sql) ) {
	return false;
}

return true;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function isActive() {

if ( $this->inactive == true) {
	return false;
}

return true;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function isAdmin($moduleid=0) {

if ($this->admin_groups[$moduleid] == TRUE) {
	return true;
	} else {
		$this->admin_groups[$moduleid] = XoopsGroup::checkRight("module", $moduleid, $this->groups(), "A");
		if ($this->admin_groups[$moduleid] == TRUE) {
			return true;
		}
	}

return false;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &rank($astitle=true) {
global $objCache;

if ($astitle) {
	if ($objCache->XoopsUser['rank']['title'][$this->getVar('uid')]) {
		return $objCache->XoopsUser['rank']['title'][$this->getVar('uid')];
	}

	$objCache->XoopsUser['rank']['title'][$this->getVar('uid')] = $this->getRank();
	return $objCache->XoopsUser['rank']['title'][$this->getVar('uid')];
	} else {
		if ($objCache->XoopsUser['rank']['normal'][$this->getVar('uid')]) {
			return $objCache->XoopsUser['rank']['normal'][$this->getVar('uid')];
		}

		$objCache->XoopsUser['rank']['normal'][$this->getVar('uid')] = $this->getVar("rank");
		return $objCache->XoopsUser['rank']['normal'][$this->getVar('uid')];
	}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getRank() {
global $db, $myts, $objCache;

if ( $this->getVar("rank") != 0 ) {
	$sql = "SELECT rank_title AS title, rank_image AS image FROM ".$db->prefix("ranks")." WHERE rank_id = ".$this->getVar("rank")."";
	} else {
		$sql = "SELECT rank_title AS title, rank_image AS image FROM ".$db->prefix("ranks")." WHERE rank_min <= " . $this->getVar("posts") . " AND rank_max >= " . $this->getVar("posts") . " AND rank_special = 0";
	}

$result = $db->query($sql);
$myrow  = $db->fetch_array($result);
$myrow['title'] = $myts->makeTboxData4Show($myrow['title']);
$myrow['id']    = $this->getVar("rank");

return $myrow;
}

//---------------------------------------------------------------------------------------//
/**
* returns an array of group ids this user belongs
*
* @param type $var description
* @return type description
*/
function &groups() {

if ( empty($this->groups) ) {
	$this->groups = XoopsGroup::getByUser($this);
}

return $this->groups;
}

//---------------------------------------------------------------------------------------//
/**
* Function to get user name from a certain user id
*
* @param type $var description
* @return type description
*/
function getUnameFromId($userid) {
global $xoopsConfig, $myts, $db, $objCache;

if ($objCache->XoopsUser['uname'][$userid]) {
	return $objCache->XoopsUser['uname'][$userid];
}

$sql = "SELECT uname FROM ".$db->prefix("users")." WHERE uid = $userid";

if ( !$result = $db->query($sql) ) {
	return false;
}

if ( !$arr = $db->fetch_array($result) ) {
	return false;
}

$uname = $myts->makeTboxData4Show($arr['uname']);
$objCache->XoopsUser['uname'][$userid] = $uname;

return $uname;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function incrementPost($uid) {
global $db;

$sql    = "UPDATE ".$db->prefix("users")." SET posts=posts+1 WHERE uid=".$uid."";
$result = $db->query($sql);
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function isOnline() {
global $db, $objCache;

if (isset($objCache->XoopsUser['isonline'][$this->getVar('uid')])) {
	return $objCache->XoopsUser['isonline'][$this->getVar('uid')];
}

$time = (time() - 300);
$sql  = 'SELECT COUNT(*) FROM '.$db->prefix('session').' WHERE uid='.$this->getVar('uid').' AND time > '.$time;

if ( !$result = $db->query($sql) ) {
	$objCache->XoopsUser['isonline'][$this->getVar('uid')] = false;
	return false;
}

list($count) = $db->fetch_row($result);
if ( $count > 0 ) {
	$objCache->XoopsUser['isonline'][$this->getVar('uid')] = true;
	return true;
}

$objCache->XoopsUser['isonline'][$this->getVar('uid')] = false;
return false;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getAllUsers($criteria=array(), $asobject=false, $orderby="uid ASC", $limit=0, $start=0){
global $db;

$ret = array();
$where_query = "";

if ( is_array($criteria) && count($criteria) > 0 ) {
	$where_query = " WHERE";
	foreach ( $criteria as $c ) {
		$where_query .= " $c AND";
	}
	$where_query = substr($where_query, 0, -4);
}

if ( !$asobject ) {
	$sql = "SELECT uid FROM ".$db->prefix("users")."$where_query ORDER BY $orderby";
	$result = $db->query($sql,$limit,$start);
	while ( $myrow = $db->fetch_array($result) ) {
		$ret[] = $myrow['uid'];
	}
	} else {
		$sql = "SELECT * FROM ".$db->prefix("users")."".$where_query." ORDER BY $orderby";
		$result = $db->query($sql,$limit,$start);
		while ( $myrow = $db->fetch_array($result) ) {
			$ret[] = new XoopsUser($myrow);
		}
	}

return $ret;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getAllUsersList($criteria=array(), $orderby="uid ASC", $limit=0, $start=0) {
global $myts, $db;

$ret = array();
$where_query = "";

if ( is_array($criteria) && count($criteria) > 0 ) {
	$where_query = " WHERE";
	foreach ( $criteria as $c ) {
		$where_query .= " $c AND";
	}
	$where_query = substr($where_query, 0, -4);
}

$sql = "SELECT uid, uname FROM ".$db->prefix("users")."".$where_query." ORDER BY $orderby";
$result = $db->query($sql,$limit,$start);

while ( $myrow = $db->fetch_array($result) ) {
	$ret[$myrow['uid']] = $myts->makeTboxData4Show($myrow['uname']);
}

return $ret;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function countAllUsers($criteria=array()) {
global $db;

$where_query = "";

if ( is_array($criteria) && count($criteria) > 0 ) {
	$where_query = " WHERE";
	foreach ( $criteria as $c ) {
		$where_query .= " $c AND";
	}
	$where_query = substr($where_query, 0, -4);
}

$sql       = "SELECT COUNT(*) FROM ".$db->prefix("users")."".$where_query."";
$result    = $db->query($sql);
list($ret) = @$db->fetch_row($result);

return $ret;
}
//---------------------------------------------------------------------------------------//

//### Methods from here will be deprecated. Use getVar() instead! ###

//---------------------------------------------------------------------------------------//
function uid() {
	return $this->getVar("uid");
}

function name($format="S") {
	return $this->getVar("name", $format);
}

function uname($format="S") {
	return $this->getVar("uname", $format);
}

function email($format="S") {
	return $this->getVar("email", $format);
}

function url($format="S") {
	return $this->getVar("url", $format);
}

function user_avatar($format="S") {
	return $this->getVar("user_avatar");
}

function user_regdate() {
	return $this->getVar("user_regdate");
}

function user_icq($format="S") {
	return $this->getVar("user_icq", $format);
}

function user_from($format="S") {
	return $this->getVar("user_from", $format);
}

function user_sig($format="S") {
		return $this->getVar("user_sig", $format);
}

function user_viewemail() {
	return $this->getVar("user_viewemail");
}

function actkey() {
	return $this->getVar("actkey");
}

function user_aim($format="S") {
	return $this->getVar("user_aim", $format);
}

function user_yim($format="S") {
	return $this->getVar("user_yim", $format);
}

function user_msnm($format="S") {
	return $this->getVar("user_msnm", $format);
}

function pass() {
	return $this->getVar("pass");
}

function posts() {
	return $this->getVar("posts");
}

function attachsig() {
	return $this->getVar("attachsig");
}

function level() {
	return $this->getVar("level");
}

function theme() {
	return $this->getVar("theme");
}

function timezone() {
	return $this->getVar("timezone_offset");
}

function umode() {
	return $this->getVar("umode");
}

function uorder() {
	return $this->getVar("uorder");
}

function user_occ($format="S") {
	return $this->getVar("user_occ", $format);
}

function bio($format="S") {
	return $this->getVar("bio", $format);
}

function user_intrest($format="S") {
	return $this->getVar("user_intrest", $format);
}

function last_login() {
	return $this->getVar("last_login");
}

//---------------------------------------------------------------------------------------//
} // END XOOPSUSER

// ------------------------------------------------------------------------- //
}
?>
