<?php
// $Id: cafeRSS.php,v 1.1 2004/07/11 10:27:17 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: Michel Valdrighi
// Author Website : http://www.tidakada.com
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //

if (!defined("EXOOPS_CAFERSS_INCLUDED")) {
	define("EXOOPS_CAFERSS_INCLUDED", 1);

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
class cafeRSS {

	var $error;
	var $items;
	var $template_string;
	var $template_file;
	var $use_cache;
	var $cache_dir;
	var $refresh_time;
	var $echo;

	function cafeRSS() {
			/* defaut values */
		$this->error           = 0;
		$this->items           = 'all';
		$this->template_string = '';
		// Set default template just in case
		$this->template_file   = XOOPS_ROOT_PATH . '/modules/headlines/templates/simple.txt';
		$this->use_cache       = 0;
		// if you want to cache, chmod a directory 777 and put its name here
		$this->cache_dir       = XOOPS_ROOT_PATH . '/cache';
		// in seconds - has no effect if $use_cache = 0;
		$this->refresh_time    = 7200;
		$this->echo            = 0;
	}

//---------------------------------------------------------------------------------------//
/**
* usage: $this->assign('var','value');
*
* @param type $var description
* @return type description
*/
function assign($var, $value) {
	$this->$var = $value;
}

//---------------------------------------------------------------------------------------//
/**
* usage: $this->display([url|file]);
*
* @param type $var description
* @return type description
*/
function display($rss_file) {
global $myts;

$rss_cache_file = $this->cache_dir.'/'.preg_replace('/[^a-z0-9_-]/i', '_', $rss_file).'.cache';

// Load the file
if ( !empty($this->use_cache) ) {
	$last_cached = @filemtime($rss_cache_file);
	$last_cached = $last_cached ? $last_cached :  0;

	if (
		@file_exists($rss_cache_file) &&
		( ($last_cached + $this->refresh_time) > time() )
		) {
			$cache_checked = 1;
			$content = @join('', @file($rss_cache_file));
			} else {
				$content = @join('', @file($rss_file));
				if ( !empty($content) && ($fp = @fopen($rss_cache_file, 'w')) ) {
					if ( @fwrite($fp, $content) == -1 ) {
						$this->error = sprintf(_NGWRITE, $rss_cache_file);
					}
					fclose($fp);
				}
			}
		} else {
			$content = @join('', @file($rss_file));
		}

if ( empty($content) && !$cache_checked && @file_exists($rss_cache_file) ) {
	$content = @join('', @file($rss_cache_file));
}

if ( empty($content) ) {
	$this->error = "Invalid or Unreachable Headline URL";
	return;
}

/* gets RSS channel & item info */
preg_match_all("'<channel.*?>(.+?)<title>(.*?)</title>(.+?)</channel>'si", $content, $rss_title);
preg_match_all("'<channel.*?>(.+?)<link>(.*?)</link>(.+?)</channel>'si", $content, $rss_link);
preg_match_all("'<channel.*?>(.+?)<description>(.*?)</description>(.+?)</channel>'si", $content, $rss_description);
preg_match_all("'<channel.*?>(.+?)<lastBuildDate>(.*?)</lastBuildDate>(.+?)</channel>'si", $content, $rss_lastBuildDate);
preg_match_all("'<channel.*?>(.+?)<docs>(.*?)</docs>(.+?)</channel>'si", $content, $rss_docs);
preg_match_all("'<channel.*?>(.+?)<managingEditor>(.*?)</managingEditor>(.+?)</channel>'si", $content, $rss_managingEditor);
preg_match_all("'<channel.*?>(.+?)<webMaster>(.*?)</webMaster>(.+?)</channel>'si", $content, $rss_webMaster);
preg_match_all("'<channel.*?>(.+?)<language>(.*?)</language>(.+?)</channel>'si", $content, $rss_language);

preg_match_all("'<image.*?>(.+?)<title>(.*?)</title>(.+?)</image>'si", $content, $rss_image_title);
preg_match_all("'<image.*?>(.+?)<url>(.*?)</url>(.+?)</image>'si", $content, $rss_image_url);
preg_match_all("'<image.*?>(.+?)<link>(.*?)</link>(.+?)</image>'si", $content, $rss_image_link);

preg_match_all("'<item.*?>(.+?)<title>(.*?)</title>(.+?)</item>'si", $content, $rss_item_titles);
preg_match_all("'<item.*?>(.+?)<link>(.*?)</link>(.+?)</item>'si", $content, $rss_item_links);
preg_match_all("'<item.*?>(.+?)<description>(.*?)</description>(.+?)</item>'si", $content, $rss_item_descriptions);

$rss_title          = strip_tags($myts->undoHtmlSpecialChars($rss_title[2][0]));
$rss_link           = $rss_link[2][0];
$rss_description    = $myts->makeClickable(strip_tags($myts->undoHtmlSpecialChars($rss_description[2][0])));
$rss_lastBuildDate  = $rss_lastBuildDate[2][0];
$rss_docs           = $rss_docs[2][0];
$rss_managingEditor = $rss_managingEditor[2][0];
$rss_webMaster      = $rss_webMaster[2][0];
$rss_language       = $rss_language[2][0];
$rss_image_title    = strip_tags($myts->undoHtmlSpecialChars($rss_image_title[2][0]));
$rss_image_url      = $rss_image_url[2][0];
$rss_image_link     = $rss_image_link[2][0];

/* gets the template */
if ( empty($this->template_string) ) {
	$rss_template = @join('', @file($this->template_file));
	} else {
		$rss_template = $this->template_string;
	}

if (trim($rss_template) == '') {
	$this->error = sprintf(_NGOPEN, $this->template_file);
	return;
}

preg_match_all("'{rss_items}(.+?){/rss_items}'si", $rss_template, $rss_template_loop);
$rss_template_loop = $rss_template_loop[1][0];
$rss_template      = str_replace('{rss_items}', '', $rss_template);
$rss_template      = str_replace('{/rss_items}', '', $rss_template);

/* processes the template - rss channel info */
$rss_template = str_replace('{$rss_title}', $rss_title, $rss_template);
$rss_template = str_replace('{$rss_link}', $rss_link, $rss_template);
$rss_template = str_replace('{$rss_description}', $rss_description, $rss_template);
$rss_template = str_replace('{$rss_lastBuildDate}', $rss_lastBuildDate, $rss_template);
$rss_template = str_replace('{$rss_docs}', $rss_docs, $rss_template);
$rss_template = str_replace('{$rss_managingEditor}', $rss_managingEditor, $rss_template);
$rss_template = str_replace('{$rss_webMaster}', $rss_webMaster, $rss_template);
$rss_template = str_replace('{$rss_language}', $rss_language, $rss_template);

/* processes the template - rss image info */
if ($rss_image_url != '') {
	$rss_template = str_replace('{rss_image}', '', $rss_template);
	$rss_template = str_replace('{/rss_image}', '', $rss_template);
	$rss_template = str_replace('{$rss_image_title}', $rss_image_title, $rss_template);
	$rss_template = str_replace('{$rss_image_link}', $rss_image_link, $rss_template);
	$rss_template = str_replace('{$rss_image_url}', $rss_image_url, $rss_template);
	} else {
		$rss_template = preg_replace("'{rss_image}(.*?){/rss_image}'", '', $rss_template);
	}

/* processes the template - rss items info */
$rss_template_loop_processed = '';

$titles       = count($rss_item_titles[2]);
$descriptions = count($rss_item_descriptions[2]);

$items = ($titles > $descriptions) ? $titles : $descriptions;
$items = (($this->items == 'all') || ($this->items > $items)) ? $items : intval($this->items);

for ($i=0; $i<$items; $i++) {
	if ($rss_item_descriptions[2][$i] == '') {
		$tmp_description = '-/-';
		} else {
			$tmp_description = $myts->makeClickable(strip_tags($myts->undoHtmlSpecialChars($rss_item_descriptions[2][$i])));
		}

	if ($rss_item_titles[2][$i] == '') {
		$tmp_title = substr($tmp_description, 0, 20);
		if (strlen($tmp_description) > 20) {
			$tmp_title .= '...';
		}
		} else {
			$tmp_title = strip_tags($myts->undoHtmlSpecialChars($rss_item_titles[2][$i]));
		}

	$tmp_template = $rss_template_loop;
	$tmp_link     = $rss_item_links[2][$i];
	$tmp_template = str_replace('{$rss_item_title}', $tmp_title, $tmp_template);
	$tmp_template = str_replace('{$rss_item_link}', $tmp_link, $tmp_template);
	$tmp_template = str_replace('{$rss_item_description}', $tmp_description, $tmp_template);
	$rss_template_loop_processed .= $tmp_template;
}

$rss_template = str_replace($rss_template_loop, $rss_template_loop_processed, $rss_template);
$rss_template = mb_convert_encoding($rss_template,"EUC-JP","auto");
/* echoes or returns the processed template :) */
if ($this->echo) {
	echo $rss_template;
	} else {
		return $rss_template;
	}

} // END DISPLAY

//---------------------------------------------------------------------------------------//
} // END CAFERSS

//---------------------------------------------------------------------------------------//
}
?>
