#include <stdio.h>
#include <string.h>
#include <gdbm.h>


#define set_datum(d, s) \
    do { \
	(d)->dptr = (s); \
	(d)->dsize = strlen(s) + 1; \
    } while (0)


int main(void)
{
    GDBM_FILE gdbm;
    datum key, val;

    printf("%s\n", gdbm_version);

    gdbm = gdbm_open("testdb", 2048, GDBM_WRCREAT, 0666, NULL);

    key = gdbm_firstkey(gdbm);
    if (key.dptr) {
	do {
	    val = gdbm_fetch(gdbm, key);
	    printf("[%s] = [%s]\n", key.dptr, val.dptr);
	    key = gdbm_nextkey(gdbm, key);
	} while (key.dptr);
    }
    else {
	set_datum(&key, "foobar");
	set_datum(&val, "FB");
	gdbm_store(gdbm, key, val, GDBM_REPLACE);
	gdbm_sync(gdbm);
	set_datum(&key, "baz");
	set_datum(&val, "BZ");
	gdbm_store(gdbm, key, val, GDBM_REPLACE);
	gdbm_sync(gdbm);
	set_datum(&key, "quux");
	set_datum(&val, "QX");
	gdbm_store(gdbm, key, val, GDBM_REPLACE);
	gdbm_sync(gdbm);
    }
    printf("[%d][%s]\n", gdbm_errno, gdbm_strerror(gdbm_errno));

    gdbm_close(gdbm);

    return 0;
}
