package robocode;

/**
 * A SkippedTurnEvent is sent to {@link robocode.AdvancedRobot#onSkippedTurn} when skipping a turn.
 * You must take an action every turn in order to participate in the game.
 * For example,
 * <PRE>
 *   try {Thread.sleep(1000);} catch (InterruptedException e) {}
 * </PRE>
 * will cause many SkippedTurnEvents, because you are not responding to the game.
 * If you receive 30 SkippedTurnEvents, you will be removed from the round.
 *
 * Instead, you should do something such as:
 * <PRE>
 * for (int i = 0; i < 30; i++)
 *   doNothing(); // or perhaps scan();
 * </PRE>
 *
 * This event may also be generated if your are simply doing too much processing between actions.
 *
 * @see robocode.AdvancedRobot#onSkippedTurn
 */
public class SkippedTurnEvent extends Event {
/**
 * Called by the game to create a new SkippedTurnEvent.
 */
public SkippedTurnEvent() {
	super();
}
}
