/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.distribute;

import java.io.File;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import rumblejp.common.Env;
import rumblejp.distribute.AugmentedRobocodeEngine;
import rumblejp.distribute.BattlesServiceClient;
import rumblejp.distribute.Division;
import rumblejp.distribute.remote.BattleResult;
import rumblejp.distribute.remote.BattleSpec;

public class Server {
    private static Logger logger = Logger.getLogger((Class)(class$rumblejp$distribute$Server == null ? (class$rumblejp$distribute$Server = Server.class$("rumblejp.distribute.Server")) : class$rumblejp$distribute$Server));
    private static final String ROBOTDATA_DIR = "robot_data";
    private static final String ROBOTCACHE_DIR = ".robotcache";
    private String hostname;
    private String password;
    private int times = -1;
    private BattlesServiceClient client = null;
    private Division division = null;
    private AugmentedRobocodeEngine engine;
    private Finalizer finalizer = new Finalizer();
    static /* synthetic */ Class class$rumblejp$distribute$Server;

    public static void main(String[] args) throws Exception {
        int times = args.length != 0 ? Integer.parseInt(args[0]) : -1;
        Server server = new Server(times);
        try {
            server.start();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception occured.", (Throwable)ex);
            server.shutdown();
        }
    }

    private Server(int times) {
        this.times = times;
    }

    private synchronized void initialize() throws Exception {
        DOMConfigurator.configure((String)"log4j.xml");
        this.hostname = Env.getString("hostname");
        this.password = Env.getString("password");
        File rootDir = new File(".");
        this.engine = new AugmentedRobocodeEngine(rootDir);
        File robotDataRoot = new File(rootDir, ROBOTDATA_DIR);
        File robotCacheRoot = new File(rootDir, ROBOTCACHE_DIR);
        URL endpoint = new URL(Env.getString("endpoint.battles"));
        this.client = new BattlesServiceClient(endpoint, this.hostname, this.password, robotDataRoot, robotCacheRoot);
        Runtime.getRuntime().addShutdownHook(this.finalizer);
    }

    public void shutdown() throws Exception {
        if (this.division != null) {
            System.setSecurityManager(null);
            this.client.sendResults(this.division, true);
            this.division = null;
        }
        logger.info((Object)"Distribute server shutdown.");
    }

    public void start() throws Exception {
        this.initialize();
        this.engine.updateRobots();
        logger.info((Object)"Distribute server started.");
        logger.info((Object)"Check new battle.");
        this.division = this.client.getDivision();
        int battleCount = 0;
        while (true) {
            if (this.division == null) {
                logger.info((Object)"Battle doesn't exist. Server will sleep.");
                Thread.sleep(600000L);
                this.division = this.client.getDivision();
                continue;
            }
            this.engine.updateRobots();
            long comBegin = System.currentTimeMillis();
            long begin = 0L;
            long end = 0L;
            BattleSpec battle = null;
            while ((battle = this.division.getNextBattle()) != null) {
                BattleResult result = null;
                do {
                    begin = System.currentTimeMillis();
                    result = this.engine.runBattle(battle.getBattleId(), this.division.getRounds(), this.division.getFieldHeight(), this.division.getFieldWidth(), this.division.getCoolingRate(), this.division.getInactivityTime(), this.division.getBattleRobots(battle));
                    if (result != null) continue;
                    logger.info((Object)"Server is sending result.");
                    this.client.sendResults(this.division, false);
                    comBegin = System.currentTimeMillis();
                } while (result == null);
                end = System.currentTimeMillis();
                result.setTotalTime((int)(end - begin));
                this.division.addResult(battle, result);
                if (this.times != -1 && ++battleCount >= this.times) {
                    logger.info((Object)("Complete " + this.times + " battles(specified limit)."));
                    logger.info((Object)"Server is sending result. And server will be terminated.");
                    this.shutdown();
                    return;
                }
                if (comBegin + 600000L >= end) continue;
                logger.info((Object)"Passed over 10 minites from last access.");
                logger.info((Object)"Server is sending result.");
                this.client.sendResults(this.division, false);
                comBegin = System.currentTimeMillis();
            }
            if (this.times != -1 && battleCount >= this.times) break;
            logger.info((Object)"Server is sending result and checking new battle.");
            this.division = this.client.sendResultAndGetNextDivision(this.division);
        }
        logger.info((Object)"Server is sending result. And server will be terminated.");
        this.shutdown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Finalizer
    extends Thread {
        public void run() {
            try {
                Server.this.shutdown();
            }
            catch (Exception e) {}
        }
    }
}

