/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.distribute;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import rumblejp.distribute.remote.BattleDivisionResult;
import rumblejp.distribute.remote.BattleDivisionSpec;
import rumblejp.distribute.remote.DownloadFiles;
import rumblejp.distribute.remote.RobotData;
import rumblejp.distribute.remote.RobotDataSpec;
import rumblejp.distribute.remote.RobotVersion;

public class RobotDataManager {
    private static Logger logger = Logger.getLogger((Class)(class$rumblejp$distribute$RobotDataManager == null ? (class$rumblejp$distribute$RobotDataManager = RobotDataManager.class$("rumblejp.distribute.RobotDataManager")) : class$rumblejp$distribute$RobotDataManager));
    private BattleDivisionSpec divisionSpec;
    private File leagueDir;
    private File robotCacheRoot;
    private LinkedList requests = new LinkedList();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static /* synthetic */ Class class$rumblejp$distribute$RobotDataManager;

    public RobotDataManager(File robotDataRoot, File robotCacheRoot, BattleDivisionSpec divisionSpec) throws Exception {
        this.divisionSpec = divisionSpec;
        this.leagueDir = new File(robotDataRoot, "" + divisionSpec.getLeagueId());
        this.robotCacheRoot = robotCacheRoot;
        this.generateDownloadRequest();
    }

    private void generateDownloadRequest() throws Exception {
        logger.info((Object)"Robot's data synchronization(download) start.");
        RobotVersion[] robots = this.divisionSpec.getRobots();
        int i = 0;
        while (i < robots.length) {
            RobotDataSpec[] dataSpecs;
            String jarFileName = robots[i].getJarFile();
            String className = robots[i].getClassName();
            logger.info((Object)("Checking robot's data. [" + className + "]"));
            File robotDataDir = new File(this.leagueDir, jarFileName);
            String path = className.replace('.', File.separatorChar);
            File robotCacheDataDir = new File(this.robotCacheRoot, jarFileName + "_" + File.separator + path + ".data");
            if (robotCacheDataDir.exists()) {
                this.rmdir(robotCacheDataDir);
            }
            if ((dataSpecs = robots[i].getFiles()) == null) {
                logger.debug((Object)("  [" + className + "] doesn't have any data."));
                if (robotDataDir.exists()) {
                    this.rmdir(robotDataDir);
                }
            } else {
                if (!robotDataDir.exists()) {
                    robotDataDir.mkdirs();
                }
                Arrays.sort(dataSpecs, new RobotDataSpecComparator());
                logger.debug((Object)("Center server (" + dataSpecs.length + "files):"));
                int j = 0;
                while (j < dataSpecs.length) {
                    logger.debug((Object)("  [" + dataSpecs[j].getName() + "] " + this.formatter.format(new Date(dataSpecs[j].getTime())) + " " + dataSpecs[j].getSize() + "bytes."));
                    ++j;
                }
                File[] localFiles = robotDataDir.listFiles();
                Arrays.sort(localFiles, new FileComparator());
                logger.debug((Object)("Local (" + localFiles.length + "files):"));
                int j2 = 0;
                while (j2 < localFiles.length) {
                    logger.debug((Object)("  [" + localFiles[j2].getName() + "] " + this.formatter.format(new Date(localFiles[j2].lastModified())) + " " + localFiles[j2].length() + "bytes."));
                    ++j2;
                }
                RobotDataSpec dataSpec = null;
                File localFile = null;
                LinkedList<RobotDataSpec> list = new LinkedList<RobotDataSpec>();
                int j3 = 0;
                int k = 0;
                while (j3 < dataSpecs.length || k < localFiles.length || dataSpec != null || localFile != null) {
                    if (dataSpec == null && j3 < dataSpecs.length) {
                        dataSpec = dataSpecs[j3++];
                    }
                    if (localFile == null && k < localFiles.length) {
                        localFile = localFiles[k++];
                    }
                    int comp = 0;
                    comp = dataSpec == null ? 1 : (localFile == null ? -1 : dataSpec.getName().compareTo(localFile.getName()));
                    if (comp < 0) {
                        list.add(dataSpec);
                        logger.info((Object)("  Not found    [" + dataSpec.getName() + "]"));
                        dataSpec = null;
                        continue;
                    }
                    if (comp > 0) {
                        logger.info((Object)("  Deleted      [" + localFile.getName() + "]"));
                        localFile.delete();
                        localFile = null;
                        continue;
                    }
                    long localTime = localFile.lastModified();
                    long fragment = localTime % 2000L;
                    if (fragment > 0L) {
                        localTime += 2000L - fragment;
                    }
                    if (localTime != dataSpec.getTime() || localFile.length() != (long)dataSpec.getSize()) {
                        list.add(dataSpec);
                        logger.info((Object)("  Changed     [" + dataSpec.getName() + "]"));
                    } else {
                        logger.debug((Object)("  Not Changed [" + dataSpec.getName() + "]"));
                    }
                    dataSpec = null;
                    localFile = null;
                }
                if (list.size() != 0) {
                    DownloadFiles downloadFiles = new DownloadFiles();
                    downloadFiles.setJarFileName(jarFileName);
                    downloadFiles.setClassName(className);
                    downloadFiles.setFiles(list.toArray(new RobotDataSpec[list.size()]));
                    this.requests.add(downloadFiles);
                }
            }
            ++i;
        }
    }

    public DownloadFiles[] getDownloadRequest() {
        return this.requests.toArray(new DownloadFiles[this.requests.size()]);
    }

    public void setDownloadedData(RobotData[] datas) throws Exception {
        int i = 0;
        while (i < datas.length) {
            String jarFileName = datas[i].getJarFileName();
            String className = datas[i].getClassName();
            logger.info((Object)("Downloaded [" + className + "]'s data."));
            File robotDataDir = new File(this.leagueDir, jarFileName);
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(datas[i].getData())));
            ZipEntry entry = null;
            byte[] buf = new byte[8192];
            while ((entry = in.getNextEntry()) != null) {
                File file = new File(robotDataDir, entry.getName());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                int len = 0;
                while ((len = in.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                out.close();
                file.setLastModified(entry.getTime());
                logger.info((Object)("  " + entry.getName() + " " + this.formatter.format(new Date(entry.getTime())) + " " + file.length() + "bytes."));
            }
            in.close();
            ++i;
        }
        RobotVersion[] robots = this.divisionSpec.getRobots();
        int i2 = 0;
        while (i2 < robots.length) {
            String jarFileName = robots[i2].getJarFile();
            String className = robots[i2].getClassName();
            File robotDataDir = new File(this.leagueDir, jarFileName);
            String path = className.replace('.', File.separatorChar);
            File robotCacheDataDir = new File(this.robotCacheRoot, jarFileName + "_" + File.separator + path + ".data");
            if (robotDataDir.exists()) {
                robotCacheDataDir.mkdirs();
                this.copyFiles(robotDataDir, robotCacheDataDir);
            }
            ++i2;
        }
    }

    public void copyToStoreArea(RobotVersion[] robots) throws Exception {
        int i = 0;
        while (i < robots.length) {
            String jarFileName = robots[i].getJarFile();
            String className = robots[i].getClassName();
            File robotDataDir = new File(this.leagueDir, jarFileName);
            String path = className.replace('.', File.separatorChar);
            File robotCacheDataDir = new File(this.robotCacheRoot, jarFileName + "_" + File.separator + path + ".data");
            if (robotDataDir.exists()) {
                this.rmdir(robotDataDir);
            }
            if (robotCacheDataDir.exists()) {
                robotDataDir.mkdirs();
                this.copyFiles(robotCacheDataDir, robotDataDir);
            }
            ++i;
        }
    }

    public void setUploadData(BattleDivisionSpec divisionSpec, BattleDivisionResult result) throws IOException {
        logger.info((Object)"Robot's data synchronization(upload) start.");
        LinkedList<RobotData> datas = new LinkedList<RobotData>();
        RobotVersion[] divisionRobots = divisionSpec.getRobots();
        int i = 0;
        while (i < divisionRobots.length) {
            RobotData data = this.createUploadData(divisionRobots[i]);
            if (data != null) {
                datas.add(data);
            }
            ++i;
        }
        result.setRobotDatas(datas.toArray(new RobotData[datas.size()]));
    }

    private RobotData createUploadData(RobotVersion robot) throws IOException {
        File[] storeFiles;
        String jarFileName = robot.getJarFile();
        String className = robot.getClassName();
        logger.info((Object)("Checking robot's data. [" + className + "]"));
        File robotDataDir = new File(this.leagueDir, jarFileName);
        RobotData data = new RobotData();
        data.setRobotVersionId(robot.getRobotVersionId());
        data.setJarFileName(jarFileName);
        data.setClassName(className);
        if (!robotDataDir.exists()) {
            if (robot.getFiles() != null) {
                logger.info((Object)"  robocode data dir doesn't exist. Central server's dir will be deleted.");
                data.setExistsDir(false);
                return data;
            }
            logger.debug((Object)"  robocode data dir doesn't exist.");
            return null;
        }
        RobotDataSpec[] centerFiles = robot.getFiles();
        if (centerFiles == null) {
            centerFiles = new RobotDataSpec[]{};
        } else {
            Arrays.sort(centerFiles, new RobotDataSpecComparator());
        }
        if (robotDataDir.exists()) {
            storeFiles = robotDataDir.listFiles();
            Arrays.sort(storeFiles, new FileComparator());
        } else {
            robotDataDir.mkdirs();
            storeFiles = new File[]{};
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Center dir (" + centerFiles.length + "files):"));
            int j = 0;
            while (j < centerFiles.length) {
                logger.debug((Object)("  [" + centerFiles[j].getName() + "] " + this.formatter.format(new Date(centerFiles[j].getTime())) + " " + centerFiles[j].getSize() + "bytes."));
                ++j;
            }
            logger.debug((Object)("Store dir (" + storeFiles.length + "files):"));
            int j2 = 0;
            while (j2 < storeFiles.length) {
                logger.debug((Object)("  [" + storeFiles[j2].getName() + "] " + this.formatter.format(new Date(storeFiles[j2].lastModified())) + " " + storeFiles[j2].length() + "bytes."));
                ++j2;
            }
        }
        LinkedList<File> uploadFiles = new LinkedList<File>();
        LinkedList<RobotDataSpec> deleteFiles = new LinkedList<RobotDataSpec>();
        RobotDataSpec centerFile = null;
        File storeFile = null;
        int j = 0;
        int k = 0;
        while (j < centerFiles.length || k < storeFiles.length || centerFile != null || storeFile != null) {
            if (centerFile == null && j < centerFiles.length) {
                centerFile = centerFiles[j++];
            }
            if (storeFile == null && k < storeFiles.length) {
                storeFile = storeFiles[k++];
            }
            int comp = 0;
            comp = centerFile == null ? -1 : (storeFile == null ? 1 : storeFile.getName().compareTo(centerFile.getName()));
            if (comp < 0) {
                logger.info((Object)("  New file    [" + storeFile.getName() + "] " + this.formatter.format(new Date(storeFile.lastModified())) + " " + storeFile.length() + "bytes."));
                uploadFiles.add(storeFile);
                storeFile = null;
                continue;
            }
            if (comp > 0) {
                deleteFiles.add(centerFile);
                logger.info((Object)("  Deleted     [" + centerFile.getName() + "]"));
                centerFile = null;
                continue;
            }
            if (centerFile.getTime() != storeFile.lastModified() || (long)centerFile.getSize() != storeFile.length()) {
                logger.info((Object)("  Changed     [" + storeFile.getName() + "] " + this.formatter.format(new Date(storeFile.lastModified())) + " " + storeFile.length() + "bytes."));
                uploadFiles.add(storeFile);
            } else {
                logger.debug((Object)("  Not Changed [" + storeFile.getName() + "] " + this.formatter.format(new Date(storeFile.lastModified())) + " " + storeFile.length() + "bytes."));
            }
            centerFile = null;
            storeFile = null;
        }
        if (uploadFiles.size() == 0 && deleteFiles.size() == 0) {
            return null;
        }
        data.setDeleteFiles(deleteFiles.toArray(new RobotDataSpec[deleteFiles.size()]));
        if (uploadFiles.size() != 0) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(byteOut));
            byte[] buf = new byte[8192];
            Iterator iter = uploadFiles.iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                ZipEntry entry = new ZipEntry(file.getName());
                entry.setTime(file.lastModified());
                entry.setSize(file.length());
                zipOut.putNextEntry(entry);
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                int len = 0;
                while ((len = in.read(buf)) != -1) {
                    zipOut.write(buf, 0, len);
                }
                in.close();
                zipOut.closeEntry();
            }
            zipOut.finish();
            zipOut.close();
            data.setData(byteOut.toByteArray());
        }
        data.setExistsDir(true);
        File[] files = robotDataDir.listFiles();
        RobotDataSpec[] dataSpecs = new RobotDataSpec[files.length];
        int j3 = 0;
        while (j3 < files.length) {
            dataSpecs[j3] = new RobotDataSpec();
            dataSpecs[j3].setName(files[j3].getName());
            dataSpecs[j3].setSize((int)files[j3].length());
            dataSpecs[j3].setTime(files[j3].lastModified());
            ++j3;
        }
        robot.setFiles(dataSpecs);
        return data;
    }

    private void rmdir(File dir) {
        File[] children = dir.listFiles();
        int i = 0;
        while (i < children.length) {
            children[i].delete();
            ++i;
        }
        dir.delete();
    }

    private void copyFiles(File fromDir, File toDir) throws IOException {
        File[] files = fromDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.length() > 0L;
            }
        });
        byte[] buf = new byte[8192];
        int i = 0;
        while (i < files.length) {
            File outFile = new File(toDir, files[i].getName());
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(files[i]));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
            int len = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            out.close();
            in.close();
            outFile.setLastModified(files[i].lastModified());
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RobotDataSpecComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            RobotDataSpec left = (RobotDataSpec)o1;
            RobotDataSpec right = (RobotDataSpec)o2;
            return left.getName().compareTo(right.getName());
        }
    }

    public class FileComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            File left = (File)o1;
            File right = (File)o2;
            return left.getName().compareTo(right.getName());
        }
    }
}

