/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.distribute;

import java.io.IOException;
import java.util.LinkedList;
import rumblejp.distribute.RobotDataManager;
import rumblejp.distribute.remote.BattleDivisionResult;
import rumblejp.distribute.remote.BattleDivisionSpec;
import rumblejp.distribute.remote.BattleResult;
import rumblejp.distribute.remote.BattleSpec;
import rumblejp.distribute.remote.RobotVersion;

public class Division {
    private RobotDataManager dataManager = null;
    private BattleDivisionSpec divisionSpec = null;
    private int indexBattleSpec = 0;
    private LinkedList results = new LinkedList();

    public Division(BattleDivisionSpec divisionSpec, RobotDataManager dataManager) {
        this.divisionSpec = divisionSpec;
        this.dataManager = dataManager;
    }

    public int getRounds() {
        return this.divisionSpec.getRounds();
    }

    public int getFieldHeight() {
        return this.divisionSpec.getFieldHeight();
    }

    public int getFieldWidth() {
        return this.divisionSpec.getFieldWidth();
    }

    public double getCoolingRate() {
        return this.divisionSpec.getCoolingRate();
    }

    public int getInactivityTime() {
        return this.divisionSpec.getInactivityTime();
    }

    public BattleSpec getNextBattle() {
        BattleSpec[] battles = this.divisionSpec.getBattles();
        if (this.indexBattleSpec < battles.length) {
            return battles[this.indexBattleSpec++];
        }
        return null;
    }

    public RobotVersion[] getBattleRobots(BattleSpec battle) throws RobotNotFoundException {
        int[] robotIds = battle.getRobotId();
        RobotVersion[] robots = this.divisionSpec.getRobots();
        RobotVersion[] battleRobots = new RobotVersion[robotIds.length];
        int i = 0;
        while (i < robotIds.length) {
            int j = 0;
            while (j < robots.length) {
                if (robots[j].getRobotId() == robotIds[i]) {
                    battleRobots[i] = robots[j];
                    break;
                }
                ++j;
            }
            if (battleRobots[i] == null) {
                throw new RobotNotFoundException(robotIds[i]);
            }
            ++i;
        }
        return battleRobots;
    }

    public synchronized void addResult(BattleSpec battle, BattleResult result) throws RobotNotFoundException, Exception {
        RobotVersion[] battleRobots = this.getBattleRobots(battle);
        this.results.add(result);
        this.dataManager.copyToStoreArea(battleRobots);
    }

    public synchronized boolean hasResult() {
        return !this.results.isEmpty();
    }

    public BattleDivisionResult getResult() throws IOException {
        BattleDivisionResult result = new BattleDivisionResult();
        result.setLeagueId(this.divisionSpec.getLeagueId());
        result.setSeason(this.divisionSpec.getSeason());
        result.setDivision(this.divisionSpec.getDivision());
        result.setConfirmString(this.divisionSpec.getConfirmString());
        this.dataManager.setUploadData(this.divisionSpec, result);
        if (this.results.isEmpty()) {
            result.setResults(null);
        } else {
            result.setResults(this.results.toArray(new BattleResult[this.results.size()]));
        }
        this.results.clear();
        return result;
    }

    public class RobotNotFoundException
    extends Exception {
        public RobotNotFoundException(int robotId) {
            super("Robot[id:" + robotId + "] is not found.");
        }
    }
}

