/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.distribute;

import java.io.File;
import java.net.URL;
import org.apache.log4j.Logger;
import rumblejp.distribute.Division;
import rumblejp.distribute.RobotDataManager;
import rumblejp.distribute.remote.BattleDivisionResult;
import rumblejp.distribute.remote.BattleDivisionSpec;
import rumblejp.distribute.remote.Battles;
import rumblejp.distribute.remote.BattlesServiceLocator;
import rumblejp.distribute.remote.RobotData;

public class BattlesServiceClient {
    private static Logger logger = Logger.getLogger((Class)(class$rumblejp$distribute$BattlesServiceClient == null ? (class$rumblejp$distribute$BattlesServiceClient = BattlesServiceClient.class$("rumblejp.distribute.BattlesServiceClient")) : class$rumblejp$distribute$BattlesServiceClient));
    private String hostname;
    private String password;
    private Battles battles;
    private File robotDataRoot;
    private File robotCacheRoot;
    static /* synthetic */ Class class$rumblejp$distribute$BattlesServiceClient;

    public BattlesServiceClient(URL endpoint, String hostname, String password, File robotDataRoot, File robotCacheRoot) throws Exception {
        this.hostname = hostname;
        this.password = password;
        BattlesServiceLocator service = new BattlesServiceLocator();
        this.battles = service.getBattles(endpoint);
        this.robotDataRoot = robotDataRoot;
        this.robotCacheRoot = robotCacheRoot;
    }

    public synchronized Division getDivision() throws Exception {
        BattleDivisionSpec spec = this.battles.getNewBattle(this.hostname, this.password);
        if (spec == null) {
            return null;
        }
        logger.info((Object)("Accepted new division[leagueId:" + spec.getLeagueId() + " season:" + spec.getSeason() + " division:" + spec.getDivision() + "], " + spec.getBattles().length + " battles."));
        RobotDataManager dataManager = new RobotDataManager(this.robotDataRoot, this.robotCacheRoot, spec);
        RobotData[] datas = this.battles.getRobotData(this.hostname, this.password, spec.getLeagueId(), dataManager.getDownloadRequest());
        dataManager.setDownloadedData(datas);
        Division division = new Division(spec, dataManager);
        return division;
    }

    public synchronized Division sendResultAndGetNextDivision(Division division) throws Exception {
        BattleDivisionSpec spec = null;
        if (division.hasResult()) {
            BattleDivisionResult result = division.getResult();
            result.setTerminated(false);
            spec = this.battles.setResultsAndGetNextBattle(this.hostname, this.password, result);
            if (spec == null) {
                return null;
            }
        } else {
            spec = this.battles.getNewBattle(this.hostname, this.password);
            if (spec == null) {
                return null;
            }
        }
        logger.info((Object)("Accepted new division[leagueId:" + spec.getLeagueId() + " season:" + spec.getSeason() + " division:" + spec.getDivision() + "], " + spec.getBattles().length + " battles."));
        RobotDataManager dataManager = new RobotDataManager(this.robotDataRoot, this.robotCacheRoot, spec);
        RobotData[] datas = this.battles.getRobotData(this.hostname, this.password, spec.getLeagueId(), dataManager.getDownloadRequest());
        dataManager.setDownloadedData(datas);
        division = new Division(spec, dataManager);
        return division;
    }

    public synchronized void sendResults(Division division, boolean terminate) throws Exception {
        BattleDivisionResult result = division.getResult();
        result.setTerminated(terminate);
        this.battles.setResults(this.hostname, this.password, result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

