/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import rumblejp.common.Env;
import rumblejp.common.PropertyException;
import rumblejp.common.utils.EJBTag;
import rumblejp.common.utils.ResourceLookupException;

public class ResourceFinder {
    private static Logger logger = Logger.getLogger((Class)(class$rumblejp$common$utils$ResourceFinder == null ? (class$rumblejp$common$utils$ResourceFinder = ResourceFinder.class$("rumblejp.common.utils.ResourceFinder")) : class$rumblejp$common$utils$ResourceFinder));
    private static Context context = null;
    private static DataSource ds = null;
    private static Map queues = new HashMap();
    private static Map topics = new HashMap();
    private static Map ejbHomes = new HashMap();
    private static Map entityHomes = new HashMap();
    private static ConnectionFactory factory = null;
    static /* synthetic */ Class class$rumblejp$common$utils$ResourceFinder;

    private static Context getContext() throws NamingException {
        if (context == null) {
            context = new InitialContext();
        }
        return context;
    }

    public static Connection getSQLConnection() throws ResourceLookupException {
        try {
            if (ds == null) {
                Context ctx = ResourceFinder.getContext();
                ds = (DataSource)ctx.lookup(Env.getString("datasource"));
            }
            return ds.getConnection();
        }
        catch (NamingException ex) {
            throw new ResourceLookupException("Failed to lookup DataSource", ex);
        }
        catch (SQLException ex) {
            throw new ResourceLookupException("Failed to get database connection", ex);
        }
        catch (PropertyException ex) {
            throw new ResourceLookupException("Failed to get properties", ex);
        }
    }

    public static TopicConnection createTopicConnection() throws ResourceLookupException {
        try {
            TopicConnectionFactory factory = (TopicConnectionFactory)ResourceFinder.getConnectionFactory();
            return factory.createTopicConnection();
        }
        catch (JMSException ex) {
            throw new ResourceLookupException("Failed to create TopicConnection.", ex);
        }
    }

    private static ConnectionFactory getConnectionFactory() throws ResourceLookupException {
        if (factory != null) {
            return factory;
        }
        try {
            Context ctx = ResourceFinder.getContext();
            factory = (ConnectionFactory)ctx.lookup(Env.getString("jms.connectionFactory"));
            return factory;
        }
        catch (NamingException ex) {
            throw new ResourceLookupException("Failed to lookup JMS connection factory.", ex);
        }
        catch (PropertyException ex) {
            throw new ResourceLookupException("Failed to get property.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue getQueue(String name) throws ResourceLookupException {
        try {
            Queue queue;
            Map map = queues;
            synchronized (map) {
                queue = (Queue)queues.get(name);
                if (queue == null) {
                    queue = (Queue)ResourceFinder.getContext().lookup(name);
                    queues.put(name, queue);
                }
            }
            return queue;
        }
        catch (NamingException ex) {
            throw new ResourceLookupException("Failed to lookup Queue[" + name + "].", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Topic getTopic(String name) throws ResourceLookupException {
        try {
            Topic topic;
            Map map = topics;
            synchronized (map) {
                topic = (Topic)topics.get(name);
                if (topic == null) {
                    topic = (Topic)ResourceFinder.getContext().lookup(name);
                    topics.put(name, topic);
                }
            }
            return topic;
        }
        catch (NamingException ex) {
            throw new ResourceLookupException("Failed to lookup Topic[" + name + "].", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EJBObject lookupEJB(String name) throws ResourceLookupException {
        EJBTag tag;
        Map map = ejbHomes;
        synchronized (map) {
            tag = (EJBTag)ejbHomes.get(name);
            if (tag == null) {
                try {
                    Context ctx = ResourceFinder.getContext();
                    EJBHome home = (EJBHome)ctx.lookup(name);
                    tag = new EJBTag(home);
                    ejbHomes.put(name, tag);
                }
                catch (NamingException ex) {
                    throw new ResourceLookupException("Failed to lookup EJB[" + name + "].", ex);
                }
            }
        }
        return tag.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EJBHome lookupEntityHome(String name) throws ResourceLookupException {
        EJBHome home = null;
        Map map = entityHomes;
        synchronized (map) {
            home = (EJBHome)entityHomes.get(name);
            if (home == null) {
                try {
                    home = (EJBHome)ResourceFinder.getContext().lookup(name);
                    entityHomes.put(name, home);
                }
                catch (NamingException ex) {
                    throw new ResourceLookupException("Failed to lookup entity home[" + name + "].", ex);
                }
            }
        }
        return home;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

