package robocode;

/**
 * This event is sent to {@link robocode.Robot#onBulletMissed onBulletMissed}
 * when one of your bullets has misses.
 */
public class BulletMissedEvent extends Event {
	private Bullet bullet;
/**
 * Called by the game to create a new BulletMissedEvent.
 */
public BulletMissedEvent(Bullet bullet) {
	this.bullet = bullet;
}
/**
 * Returns the Bullet that missed.
 * @return Bullet
 */
public Bullet getBullet() {
	return bullet;
}
}
