/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.server.AxisServer;
import org.apache.axis.session.Session;
import org.apache.axis.session.SimpleSession;
import org.apache.axis.transport.http.SimpleAxisWorker;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.Options;
import org.apache.commons.logging.Log;

public class SimpleAxisServer
implements Runnable {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$transport$http$SimpleAxisServer == null ? (class$org$apache$axis$transport$http$SimpleAxisServer = SimpleAxisServer.class$("org.apache.axis.transport.http.SimpleAxisServer")) : class$org$apache$axis$transport$http$SimpleAxisServer).getName());
    private Hashtable sessions = new Hashtable();
    private static boolean doThreads = true;
    private static boolean doSessions = true;
    public static int sessionIndex = 0;
    private static AxisServer myAxisServer = null;
    private boolean stopped = false;
    private ServerSocket serverSocket;
    static /* synthetic */ Class class$org$apache$axis$transport$http$SimpleAxisServer;

    protected boolean isSessionUsed() {
        return doSessions;
    }

    public void setDoThreads(boolean value) {
        doThreads = value;
    }

    public boolean getDoThreads() {
        return doThreads;
    }

    protected Session createSession(String cooky) {
        Session session = null;
        if (this.sessions.containsKey(cooky)) {
            session = (Session)this.sessions.get(cooky);
        } else {
            session = new SimpleSession();
            this.sessions.put(cooky, session);
        }
        return session;
    }

    protected static synchronized AxisServer getAxisServer() {
        if (myAxisServer == null) {
            myAxisServer = new AxisServer();
        }
        return myAxisServer;
    }

    public void run() {
        log.info((Object)Messages.getMessage("start00", "SimpleAxisServer", new Integer(this.getServerSocket().getLocalPort()).toString()));
        while (!this.stopped) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (InterruptedIOException iie) {
            }
            catch (Exception e) {
                log.debug((Object)Messages.getMessage("exception00"), (Throwable)e);
                break;
            }
            if (socket == null) continue;
            SimpleAxisWorker worker = new SimpleAxisWorker(this, socket);
            if (doThreads) {
                Thread thread = new Thread(worker);
                thread.setDaemon(true);
                thread.start();
                continue;
            }
            worker.run();
        }
        log.info((Object)Messages.getMessage("quit00", "SimpleAxisServer"));
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void start(boolean daemon) throws Exception {
        if (doThreads) {
            Thread thread = new Thread(this);
            thread.setDaemon(daemon);
            thread.start();
        } else {
            this.run();
        }
    }

    public void start() throws Exception {
        this.start(false);
    }

    public void stop() throws Exception {
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            log.info((Object)Messages.getMessage("exception00"), (Throwable)e);
        }
        log.info((Object)Messages.getMessage("quit00", "SimpleAxisServer"));
        System.exit(0);
    }

    public static void main(String[] args) {
        SimpleAxisServer sas = new SimpleAxisServer();
        Options opts = null;
        try {
            opts = new Options(args);
        }
        catch (MalformedURLException e) {
            log.error((Object)Messages.getMessage("malformedURLException00"), (Throwable)e);
            return;
        }
        try {
            doThreads = opts.isFlagSet('t') > 0;
            int port = opts.getPort();
            ServerSocket ss = null;
            int i = 0;
            while (i < 5) {
                try {
                    ss = new ServerSocket(port);
                    break;
                }
                catch (BindException be) {
                    log.debug((Object)Messages.getMessage("exception00"), (Throwable)be);
                    if (i >= 4) {
                        throw new Exception(Messages.getMessage("unableToStartServer00", Integer.toString(port)));
                    }
                    Thread.sleep(3000L);
                    ++i;
                }
            }
            sas.setServerSocket(ss);
            sas.start();
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

