/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class RobotAchivement
implements Serializable {
    private int leagueId;
    private int robotId;
    private int season;
    private int userId;
    private int robotVersionId;
    private int rank;
    private int previousRank = -1;

    public RobotAchivement(int robotId, int robotVersionId, int userId, int leagueId, int season, int rank, int previousRank) {
        this.robotId = robotId;
        this.robotVersionId = robotVersionId;
        this.userId = userId;
        this.leagueId = leagueId;
        this.season = season;
        this.rank = rank;
        this.previousRank = previousRank;
    }

    public RobotAchivement(ResultSet rs) throws SQLException {
        this.leagueId = rs.getInt("robot_achivements.league_id");
        this.robotId = rs.getInt("robot_achivements.robot_id");
        this.season = rs.getInt("robot_achivements.season");
        this.userId = rs.getInt("robot_achivements.user_id");
        this.robotVersionId = rs.getInt("robot_achivements.robot_version_id");
        this.rank = rs.getInt("robot_achivements.rank");
        this.previousRank = rs.getInt("robot_achivements.previous_rank");
    }

    public int getLeagueId() {
        return this.leagueId;
    }

    public int getPreviousRank() {
        return this.previousRank;
    }

    public int getRank() {
        return this.rank;
    }

    public int getSeason() {
        return this.season;
    }

    public int getRankShift() {
        if (this.previousRank > 0) {
            return this.previousRank - this.rank;
        }
        return 0;
    }

    public Map getSeasonId() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("leagueId", String.valueOf(this.leagueId));
        map.put("season", String.valueOf(this.season));
        map.put("focusRobotId", String.valueOf(this.robotId));
        return map;
    }
}

