package robocode;

/**
 * A HitRobotEvent is sent to {@link robocode.Robot#onHitRobot} when you collide with another robot
 * You can use the information contained in this event to determine what to do.
 */
public class HitRobotEvent extends Event {
	private java.lang.String robotName;
	private double bearing;
	private double energy;
	private boolean atFault = false;
/**
 * Called by the game to create a new HitRobotEvent.
 */
public HitRobotEvent(String name, double bearing, double energy, boolean atFault) {
	this.robotName = name;
	this.bearing = bearing;
	this.energy= energy;
	this.atFault = atFault;
}
/**
 * Returns the angle to the robot you hit, relative to your robot's heading.  -180 <= getBearing() < 180
 * @return the angle to the robot you hit, in degrees
 */
public double getBearing() {
	return getBearingDegrees();
}
/**
 * @deprecated use getBearing
 */
public double getBearingDegrees() {
	return bearing * 180.0 / Math.PI;
}
/**
 * Returns the angle to the robot you hit in radians, relative to your robot's heading.  -PI <= getBearing() < PI
 * @return the angle to the robot you hit, in radians
 */
public double getBearingRadians() {
	return bearing;
}
/**
 * Returns the energy of the robot you hit
 * @return the energy of the robot you hit
 */
public double getEnergy() {
	return energy;
}
/**
 * Returns the name of the robot you hit
 * @return the name of the robot you hit
 */
public java.lang.String getName() {
	return robotName;
}
/**
 * @deprecated use getName
 */
public java.lang.String getRobotName() {
	return robotName;
}
/**
 * If you were moving toward the robot you hit, isMyFault() will return true.
 * If isMyFault() is true, then your robot's movement (including turning)
 * will have stopped and been marked complete.
 * Note:  If two robots are moving toward each other and collide,
 * they will each receive two HitRobotEvents.  The first will be the one with isMyFault() == true.
 * @return whether or not you were moving toward the other robot.
 */
public boolean isMyFault() {
	return atFault;
}
}
