/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaTestCaseWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;
    private int counter = 1;
    static /* synthetic */ Class class$javax$xml$rpc$ServiceException;

    protected JavaTestCaseWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "TestCase", "testCase");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends junit.framework.TestCase ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        pw.print("    public ");
        pw.print(this.getClassName());
        pw.println("(java.lang.String name) {");
        pw.println("        super(name);");
        pw.println("    }");
        Map portMap = this.sEntry.getService().getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry.getBindingType() != 0) continue;
            String portName = p.getName();
            if (!JavaUtils.isJavaId(portName)) {
                portName = Utils.xmlNameToJavaClass(portName);
            }
            PortType portType = binding.getPortType();
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
            this.writeComment(pw, p.getDocumentationElement());
            this.writeServiceTestCode(pw, portName, portType, ptEntry, binding, bEntry);
        }
    }

    private final void writeServiceTestCode(PrintWriter pw, String portName, PortType portType, PortTypeEntry ptEntry, Binding binding, BindingEntry bEntry) throws IOException {
        Iterator ops = portType.getOperations().iterator();
        while (ops.hasNext()) {
            Operation op = (Operation)ops.next();
            OperationType type = op.getStyle();
            Parameters params = bEntry.getParameters(op);
            BooleanHolder bThrow = new BooleanHolder(false);
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println("    " + params.signature);
                continue;
            }
            String javaOpName = Utils.xmlNameToJavaClass(op.getName());
            String testMethodName = "test" + this.counter++ + portName + javaOpName;
            pw.println("    public void " + testMethodName + "() {");
            String bindingType = (String)bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
            this.writeBindingAssignment(pw, bindingType, portName);
            pw.println("        try {");
            if (params.returnParam != null) {
                TypeEntry returnType = params.returnParam.getType();
                pw.print("            ");
                pw.print(Utils.getParameterTypeName(params.returnParam));
                pw.print(" value = ");
                if (params.returnParam.getMIMEType() == null && Utils.isPrimitiveType(returnType)) {
                    if ("boolean".equals(returnType.getName())) {
                        pw.println("false;");
                    } else {
                        pw.println("-3;");
                    }
                } else {
                    pw.println("null;");
                }
            }
            pw.print("            ");
            if (params.returnParam != null) {
                pw.print("value = ");
            }
            pw.print("binding.");
            pw.print(Utils.xmlNameToJava(op.getName()));
            pw.print("(");
            Iterator iparam = ((AbstractList)params.list).iterator();
            boolean isFirst = true;
            while (iparam.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    pw.print(", ");
                }
                Parameter param = (Parameter)iparam.next();
                String paramType = param.getType().getName();
                String mimeType = param.getMIMEType();
                String suffix = "";
                if (param.getMode() != 1) {
                    pw.print("new " + Utils.holder(mimeType, param.getType(), this.emitter) + "(");
                    suffix = ")";
                }
                if (param.getMode() != 2) {
                    String constructorString = Utils.getConstructorForParam(param, this.symbolTable, bThrow);
                    pw.print(constructorString);
                }
                pw.print(suffix);
            }
            pw.println(");");
            pw.println("        }");
            Map faultMap = op.getFaults();
            if (faultMap != null) {
                Iterator i = faultMap.values().iterator();
                int count = 0;
                while (i.hasNext()) {
                    Fault f = (Fault)i.next();
                    pw.print("        catch (");
                    pw.print(Utils.getFullExceptionName(f, this.emitter));
                    pw.println(" e" + ++count + ") {");
                    pw.print("            ");
                    pw.println("throw new junit.framework.AssertionFailedError(\"" + f.getName() + " Exception caught: \" + e" + count + ");");
                    pw.println("        }");
                }
            }
            pw.println("        catch (java.rmi.RemoteException re) {");
            pw.print("            ");
            pw.println("throw new junit.framework.AssertionFailedError(\"Remote Exception caught: \" + re);");
            pw.println("        }");
            if (bThrow.value) {
                pw.println("        catch (Exception e) {");
                pw.println("            // Unsigned constructors can throw - ignore");
                pw.println("        }");
            }
            pw.println("    }");
            pw.println();
        }
    }

    public final void writeBindingAssignment(PrintWriter pw, String bindingType, String portName) throws IOException {
        pw.println("        " + bindingType + " binding;");
        pw.println("        try {");
        pw.print("            binding = new " + this.sEntry.getName());
        pw.println("Locator().get" + portName + "();");
        pw.println("        }");
        pw.println("        catch (" + (class$javax$xml$rpc$ServiceException == null ? (class$javax$xml$rpc$ServiceException = JavaTestCaseWriter.class$("javax.xml.rpc.ServiceException")) : class$javax$xml$rpc$ServiceException).getName() + " jre) {");
        pw.println("            if(jre.getLinkedCause()!=null)");
        pw.println("                jre.getLinkedCause().printStackTrace();");
        pw.println("            throw new junit.framework.AssertionFailedError(\"JAX-RPC ServiceException caught: \" + jre);");
        pw.println("        }");
        pw.println("        assertTrue(\"" + Messages.getMessage("null00", "binding") + "\", binding != null);");
        pw.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

