/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.util.ArrayList;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class NSStack {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$utils$NSStack == null ? (class$org$apache$axis$utils$NSStack = NSStack.class$("org.apache.axis.utils.NSStack")) : class$org$apache$axis$utils$NSStack).getName());
    private Mapping[] stack = new Mapping[32];
    private int top = 0;
    private int iterator = 0;
    static /* synthetic */ Class class$org$apache$axis$utils$NSStack;

    public NSStack() {
        this.stack[0] = null;
    }

    public void push() {
        ++this.top;
        if (this.top >= this.stack.length) {
            Mapping[] newstack = new Mapping[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newstack, 0, this.stack.length);
            this.stack = newstack;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("NSPush (" + this.stack.length + ")"));
        }
        this.stack[this.top] = null;
    }

    public void pop() {
        this.clearFrame();
        if (this.top == 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("NSPop (" + Messages.getMessage("empty00") + ")"));
            }
            return;
        }
        --this.top;
        if (log.isTraceEnabled()) {
            log.trace((Object)("NSPop (" + this.stack.length + ")"));
        }
    }

    public ArrayList cloneFrame() {
        if (this.stack[this.top] == null) {
            return null;
        }
        ArrayList<Mapping> clone = new ArrayList<Mapping>();
        Mapping map = this.topOfFrame();
        while (map != null) {
            clone.add(map);
            map = this.next();
        }
        return clone;
    }

    public void clearFrame() {
        while (this.stack[this.top] != null) {
            --this.top;
        }
    }

    public Mapping topOfFrame() {
        this.iterator = this.top;
        while (this.stack[this.iterator] != null) {
            --this.iterator;
        }
        ++this.iterator;
        return this.next();
    }

    public Mapping next() {
        if (this.iterator > this.top) {
            return null;
        }
        return this.stack[this.iterator++];
    }

    public void add(String namespaceURI, String prefix) {
        int cursor = this.top;
        while (this.stack[cursor] != null) {
            if (this.stack[cursor].getPrefix().equals(prefix)) {
                this.stack[cursor].setNamespaceURI(namespaceURI);
                return;
            }
            --cursor;
        }
        this.push();
        this.stack[this.top] = new Mapping(namespaceURI, prefix);
    }

    public String getPrefix(String namespaceURI, boolean noDefault) {
        if (namespaceURI == null || namespaceURI.equals("")) {
            return null;
        }
        int hash = namespaceURI.hashCode();
        int cursor = this.top;
        while (cursor > 0) {
            Mapping map = this.stack[cursor];
            if (map != null && map.getNamespaceHash() == hash && map.getNamespaceURI().equals(namespaceURI)) {
                String possiblePrefix = map.getPrefix();
                if (!noDefault || possiblePrefix.length() != 0) {
                    int ppHash = possiblePrefix.hashCode();
                    int cursor2 = this.top;
                    while (true) {
                        if (cursor2 == cursor) {
                            return possiblePrefix;
                        }
                        map = this.stack[cursor2];
                        if (map != null && ppHash == map.getPrefixHash() && possiblePrefix.equals(map.getPrefix())) break;
                        --cursor2;
                    }
                }
            }
            --cursor;
        }
        return null;
    }

    public String getPrefix(String namespaceURI) {
        return this.getPrefix(namespaceURI, false);
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        int hash = prefix.hashCode();
        int cursor = this.top;
        while (cursor > 0) {
            Mapping map = this.stack[cursor];
            if (map != null && map.getPrefixHash() == hash && map.getPrefix().equals(prefix)) {
                return map.getNamespaceURI();
            }
            --cursor;
        }
        return null;
    }

    public void dump(String dumpPrefix) {
        int cursor = this.top;
        while (cursor > 0) {
            Mapping map = this.stack[cursor];
            if (map == null) {
                log.trace((Object)(dumpPrefix + Messages.getMessage("stackFrame00")));
            } else {
                log.trace((Object)(dumpPrefix + map.getNamespaceURI() + " -> " + map.getPrefix()));
            }
            --cursor;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

