/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.AxisServletBase;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.ServletEndpointContextImpl;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class AxisServlet
extends AxisServletBase {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$transport$http$AxisServlet == null ? (class$org$apache$axis$transport$http$AxisServlet = AxisServlet.class$("org.apache.axis.transport.http.AxisServlet")) : class$org$apache$axis$transport$http$AxisServlet).getName());
    private static Log tlog = LogFactory.getLog("org.apache.axis.TIME");
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST = "axis.enableListQuery";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR = "axis.jws.servletClassDir";
    private String transportName;
    private ServletSecurityProvider securityProvider = null;
    private static boolean isDebug = false;
    private boolean enableList = false;
    private String jwsClassDir = null;
    static /* synthetic */ Class class$org$apache$axis$transport$http$AxisServlet;

    protected String getJWSClassDir() {
        return this.jwsClassDir;
    }

    public void init() {
        super.init();
        ServletContext context = this.getServletConfig().getServletContext();
        isDebug = log.isDebugEnabled();
        if (isDebug) {
            log.debug((Object)"In servlet init");
        }
        this.transportName = this.getOption(context, INIT_PROPERTY_TRANSPORT_NAME, "http");
        if (JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_USE_SECURITY, null))) {
            this.securityProvider = new ServletSecurityProvider();
        }
        this.enableList = JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_ENABLE_LIST, null));
        this.jwsClassDir = this.getOption(context, INIT_PROPERTY_JWS_CLASS_DIR, null);
        if (this.jwsClassDir != null) {
            if (this.getHomeDir() != null) {
                this.jwsClassDir = this.getHomeDir() + this.jwsClassDir;
            }
        } else {
            this.jwsClassDir = this.getDefaultJWSClassDir();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (isDebug) {
            log.debug((Object)"Enter: doGet()");
        }
        PrintWriter writer = response.getWriter();
        try {
            block21: {
                boolean hasNoPath;
                String queryString;
                AxisServer engine = this.getEngine();
                ServletContext servletContext = this.getServletConfig().getServletContext();
                String pathInfo = request.getPathInfo();
                String realpath = servletContext.getRealPath(request.getServletPath());
                if (realpath == null) {
                    realpath = request.getServletPath();
                }
                boolean wsdlRequested = false;
                boolean listRequested = false;
                boolean hasParameters = request.getParameterNames().hasMoreElements();
                boolean isJWSPage = request.getRequestURI().endsWith(".jws");
                if (isJWSPage) {
                    pathInfo = request.getServletPath();
                }
                if ((queryString = request.getQueryString()) != null) {
                    if (queryString.equalsIgnoreCase("wsdl")) {
                        wsdlRequested = true;
                    } else if (queryString.equalsIgnoreCase("list")) {
                        listRequested = true;
                    }
                }
                boolean bl = hasNoPath = pathInfo == null || pathInfo.equals("");
                if (!wsdlRequested && !listRequested && hasNoPath) {
                    this.reportAvailableServices(response, writer, request);
                } else if (realpath != null) {
                    MessageContext msgContext = this.createMessageContext(engine, request, response);
                    try {
                        String url = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
                        msgContext.setProperty(MessageContext.TRANS_URL, url);
                        if (wsdlRequested) {
                            this.processWsdlRequest(msgContext, response, writer);
                            break block21;
                        }
                        if (listRequested) {
                            this.processListRequest(response, writer);
                            break block21;
                        }
                        if (hasParameters) {
                            this.processMethodRequest(msgContext, request, response, writer);
                            break block21;
                        }
                        String serviceName = pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo;
                        SOAPService s = engine.getService(serviceName);
                        if (s == null) {
                            response.setStatus(404);
                            response.setContentType("text/html");
                            writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                            writer.println("<p>" + Messages.getMessage("noService06") + "</p>");
                            break block21;
                        }
                        this.reportServiceInfo(response, writer, s, serviceName);
                    }
                    catch (AxisFault fault) {
                        log.error((Object)Messages.getMessage("exception00"), (Throwable)fault);
                        response.setContentType("text/html");
                        response.setStatus(500);
                        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                        writer.println("<p>" + Messages.getMessage("somethingWrong00") + "</p>");
                        writer.println("<pre>Fault - " + fault.toString() + " </pre>");
                        writer.println("<pre>" + fault.dumpToString() + " </pre>");
                    }
                    catch (Exception e) {
                        log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
                        response.setContentType("text/html");
                        response.setStatus(500);
                        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                        writer.println("<p>" + Messages.getMessage("somethingWrong00") + "</p>");
                        writer.println("<pre>Exception - " + e + "<br>");
                        if (this.isDevelopment()) {
                            writer.println(JavaUtils.stackToString(e));
                        }
                        writer.println("</pre>");
                    }
                } else {
                    response.setContentType("text/html");
                    writer.println("<html><h1>Axis HTTP Servlet</h1>");
                    writer.println(Messages.getMessage("reachedServlet00"));
                    writer.println("<p>" + Messages.getMessage("transportName00", "<b>" + this.transportName + "</b>"));
                    writer.println("</html>");
                }
            }
            Object var19_20 = null;
            writer.close();
            if (!isDebug) return;
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            writer.close();
            if (!isDebug) throw throwable;
            log.debug((Object)"Exit: doGet()");
            throw throwable;
        }
        log.debug((Object)"Exit: doGet()");
    }

    protected void processMethodRequest(MessageContext msgContext, HttpServletRequest request, HttpServletResponse response, PrintWriter writer) throws AxisFault {
        Enumeration enumeration = request.getParameterNames();
        String method = null;
        String args = "";
        while (enumeration.hasMoreElements()) {
            String param = (String)enumeration.nextElement();
            if (param.equalsIgnoreCase("method")) {
                method = request.getParameter(param);
                continue;
            }
            args = args + "<" + param + ">" + request.getParameter(param) + "</" + param + ">";
        }
        if (method == null) {
            response.setContentType("text/html");
            writer.println("<h2>" + Messages.getMessage("error00") + ":  " + Messages.getMessage("invokeGet00") + "</h2>");
            writer.println("<p>" + Messages.getMessage("noMethod01") + "</p>");
        } else {
            this.invokeEndpointFromGet(msgContext, response, writer, method, args);
        }
    }

    protected void processWsdlRequest(MessageContext msgContext, HttpServletResponse response, PrintWriter writer) throws AxisFault {
        AxisServer engine = this.getEngine();
        try {
            ((BasicHandler)engine).generateWSDL(msgContext);
            Document doc = (Document)msgContext.getProperty("WSDL");
            if (doc != null) {
                response.setContentType("text/xml");
                XMLUtils.DocumentToWriter(doc, writer);
            } else {
                this.reportNoWSDL(response, writer);
            }
        }
        catch (AxisFault axisFault) {
            if (axisFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                this.reportNoWSDL(response, writer);
            }
            throw axisFault;
        }
    }

    protected void invokeEndpointFromGet(MessageContext msgContext, HttpServletResponse response, PrintWriter writer, String method, String args) throws AxisFault {
        AxisServer engine = this.getEngine();
        String body = "<" + method + ">" + args + "</" + method + ">";
        String msgtxt = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + body + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
        ByteArrayInputStream istream = new ByteArrayInputStream(msgtxt.getBytes());
        Message msg = new Message((Object)istream, false);
        msgContext.setRequestMessage(msg);
        ((BasicHandler)engine).invoke(msgContext);
        Message respMsg = msgContext.getResponseMessage();
        if (respMsg != null) {
            response.setContentType("text/xml");
            writer.println(respMsg.getSOAPPartAsString());
        } else {
            writer.println("<p>" + Messages.getMessage("noResponse01") + "</p>");
        }
    }

    protected void reportServiceInfo(HttpServletResponse response, PrintWriter writer, SOAPService service, String serviceName) {
        response.setContentType("text/html");
        writer.println("<h1>" + service.getName() + "</h1>");
        writer.println("<p>" + Messages.getMessage("axisService00") + "</p>");
        writer.println("<i>" + Messages.getMessage("perhaps00") + "</i>");
    }

    protected void processListRequest(HttpServletResponse response, PrintWriter writer) throws AxisFault {
        AxisServer engine = this.getEngine();
        if (this.enableList) {
            Document doc = Admin.listConfig(engine);
            if (doc != null) {
                response.setContentType("text/xml");
                XMLUtils.DocumentToWriter(doc, writer);
            } else {
                response.setStatus(404);
                response.setContentType("text/html");
                writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                writer.println("<p>" + Messages.getMessage("noDeploy00") + "</p>");
            }
        } else {
            response.setStatus(403);
            response.setContentType("text/html");
            writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
            writer.println("<p><i>?list</i>" + Messages.getMessage("disabled00") + "</p>");
        }
    }

    protected void reportNoWSDL(HttpServletResponse res, PrintWriter writer) {
        res.setStatus(404);
        res.setContentType("text/html");
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
    }

    protected void reportAvailableServices(HttpServletResponse response, PrintWriter writer, HttpServletRequest request) throws ConfigurationException, AxisFault {
        AxisServer engine = this.getEngine();
        response.setContentType("text/html");
        writer.println("<h2>And now... Some Services</h2>");
        Iterator i = engine.getConfig().getDeployedServices();
        String baseURL = this.getWebappBase(request) + "/services/";
        writer.println("<ul>");
        while (i.hasNext()) {
            ServiceDesc sd = (ServiceDesc)i.next();
            StringBuffer sb = new StringBuffer();
            sb.append("<li>");
            String name = sd.getName();
            sb.append(name);
            sb.append(" <a href=\"");
            sb.append(baseURL);
            sb.append(name);
            sb.append("?wsdl\"><i>(wsdl)</i></a></li>");
            writer.println(sb.toString());
            ArrayList operations = sd.getOperations();
            if (operations.isEmpty()) continue;
            writer.println("<ul>");
            Iterator it = ((AbstractList)operations).iterator();
            while (it.hasNext()) {
                OperationDesc desc = (OperationDesc)it.next();
                writer.println("<li>" + desc.getName());
            }
            writer.println("</ul>");
        }
        writer.println("</ul>");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        String soapAction = null;
        MessageContext msgContext = null;
        if (isDebug) {
            log.debug((Object)"Enter: doPost()");
        }
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        Message responseMsg = null;
        String contentType = null;
        try {
            AxisServer engine = this.getEngine();
            if (engine == null) {
                ServletException se = new ServletException(Messages.getMessage("noEngine00"));
                log.debug((Object)"No Engine!", (Throwable)se);
                throw se;
            }
            res.setBufferSize(8192);
            msgContext = this.createMessageContext(engine, req, res);
            if (this.securityProvider != null) {
                if (isDebug) {
                    log.debug((Object)("securityProvider:" + this.securityProvider));
                }
                msgContext.setProperty("securityProvider", this.securityProvider);
            }
            Message requestMsg = new Message(req.getInputStream(), false, req.getHeader("Content-Type"), req.getHeader("Content-Location"));
            if (isDebug) {
                log.debug((Object)("Request Message:" + requestMsg));
            }
            msgContext.setRequestMessage(requestMsg);
            try {
                soapAction = this.getSoapAction(req);
                if (soapAction != null) {
                    msgContext.setUseSOAPAction(true);
                    msgContext.setSOAPActionURI(soapAction);
                }
                msgContext.setSession(new AxisHttpSession(req));
                if (tlog.isDebugEnabled()) {
                    t1 = System.currentTimeMillis();
                }
                if (isDebug) {
                    log.debug((Object)"Invoking Axis Engine.");
                }
                ((BasicHandler)engine).invoke(msgContext);
                if (isDebug) {
                    log.debug((Object)"Return from Axis Engine.");
                }
                if (tlog.isDebugEnabled()) {
                    t2 = System.currentTimeMillis();
                }
                responseMsg = msgContext.getResponseMessage();
                contentType = responseMsg.getContentType(msgContext.getSOAPConstants());
            }
            catch (AxisFault e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
                int status = this.getHttpServletResponseStatus(e);
                if (status == 401) {
                    res.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
                }
                res.setStatus(status);
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg == null) {
                    responseMsg = new Message(e);
                }
                contentType = responseMsg.getContentType(msgContext.getSOAPConstants());
            }
            catch (Exception e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
                res.setStatus(500);
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg == null) {
                    responseMsg = new Message(AxisFault.makeFault(e));
                }
                contentType = responseMsg.getContentType(msgContext.getSOAPConstants());
            }
        }
        catch (AxisFault fault) {
            log.error((Object)Messages.getMessage("axisFault00"), (Throwable)fault);
            responseMsg = msgContext.getResponseMessage();
            if (responseMsg == null) {
                responseMsg = new Message(fault);
            }
            contentType = responseMsg.getContentType(msgContext.getSOAPConstants());
        }
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        if (responseMsg != null) {
            this.sendResponse(this.getProtocolVersion(req), contentType, res, responseMsg);
        }
        if (isDebug) {
            log.debug((Object)"Response sent.");
            log.debug((Object)"Exit: doPost()");
        }
        if (tlog.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            tlog.debug((Object)("axisServlet.doPost: " + soapAction + " pre=" + (t1 - t0) + " invoke=" + (t2 - t1) + " post=" + (t3 - t2) + " send=" + (t4 - t3) + " " + msgContext.getTargetService() + "." + (msgContext.getOperation() == null ? "" : msgContext.getOperation().getName())));
        }
    }

    protected int getHttpServletResponseStatus(AxisFault af) {
        return af.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String clientVersion, String contentType, HttpServletResponse res, Message responseMsg) throws AxisFault, IOException {
        if (responseMsg == null) {
            res.setStatus(204);
            if (isDebug) {
                log.debug((Object)"NO AXIS MESSAGE TO RETURN!");
            }
        } else {
            if (isDebug) {
                log.debug((Object)("Returned Content-Type:" + contentType));
            }
            try {
                res.setContentType(contentType);
                responseMsg.writeTo((OutputStream)res.getOutputStream());
            }
            catch (SOAPException e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            }
        }
        if (!res.isCommitted()) {
            res.flushBuffer();
        }
    }

    private MessageContext createMessageContext(AxisEngine engine, HttpServletRequest req, HttpServletResponse res) {
        MessageContext msgContext = new MessageContext(engine);
        if (isDebug) {
            log.debug((Object)("MessageContext:" + msgContext));
            log.debug((Object)("HEADER_CONTENT_TYPE:" + req.getHeader("Content-Type")));
            log.debug((Object)("HEADER_CONTENT_LOCATION:" + req.getHeader("Content-Location")));
            log.debug((Object)("Constants.MC_HOME_DIR:" + String.valueOf(this.getHomeDir())));
            log.debug((Object)("Constants.MC_RELATIVE_PATH:" + req.getServletPath()));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + String.valueOf(this.getWebInfPath())));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + req.getPathInfo()));
            log.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + req.getHeader("Authorization")));
            log.debug((Object)("Constants.MC_REMOTE_ADDR:" + req.getRemoteAddr()));
            log.debug((Object)("configPath:" + String.valueOf(this.getWebInfPath())));
        }
        msgContext.setTransportName(this.transportName);
        msgContext.setProperty("jws.classDir", this.jwsClassDir);
        msgContext.setProperty("home.dir", this.getHomeDir());
        msgContext.setProperty("path", req.getServletPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, req);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, res);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.getWebInfPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, req.getPathInfo());
        msgContext.setProperty("Authorization", req.getHeader("Authorization"));
        msgContext.setProperty("remoteaddr", req.getRemoteAddr());
        ServletEndpointContextImpl sec = new ServletEndpointContextImpl();
        msgContext.setProperty("servletEndpointContext", sec);
        String realpath = this.getServletConfig().getServletContext().getRealPath(req.getServletPath());
        if (realpath != null) {
            msgContext.setProperty("realpath", realpath);
        }
        msgContext.setProperty("configPath", this.getWebInfPath());
        return msgContext;
    }

    private String getSoapAction(HttpServletRequest req) throws AxisFault {
        String soapAction = req.getHeader("SOAPAction");
        if (isDebug) {
            log.debug((Object)("HEADER_SOAP_ACTION:" + soapAction));
        }
        if (soapAction == null) {
            AxisFault af = new AxisFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            log.error((Object)Messages.getMessage("genFault00"), (Throwable)af);
            throw af;
        }
        if (soapAction.length() == 0) {
            soapAction = req.getContextPath();
        }
        return soapAction;
    }

    protected String getDefaultJWSClassDir() {
        return this.getWebInfPath() == null ? null : this.getWebInfPath() + File.separator + "jwsClasses";
    }

    protected String getProtocolVersion(HttpServletRequest req) {
        String ver;
        int sindex;
        String ret = HTTPConstants.HEADER_PROTOCOL_V10;
        String prot = req.getProtocol();
        if (prot != null && -1 != (sindex = prot.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((ver = prot.substring(sindex + 1)).trim())) {
            ret = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

