/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import rumblejp.common.beans.User;

public class UserSummary
implements Serializable {
    private int robotNum;
    private int bestRobotId;
    private String bestRobotName;
    private String bestRobotCurrentVersion;
    private int bestRobotRank;
    private int bestRobotRankShift;
    private int userId;
    private String loginId;
    private int userType;
    private Date registDate;
    private String description;

    public UserSummary() {
    }

    public UserSummary(User user) {
        this.userId = user.getUserId();
        this.loginId = user.getLoginId();
        this.userType = user.getUserType();
        this.registDate = user.getRegistDate();
        this.description = user.getDescription();
        this.robotNum = -1;
        this.bestRobotId = -1;
        this.bestRobotName = null;
        this.bestRobotRank = -1;
    }

    public int getRobotNum() {
        return this.robotNum;
    }

    public int getBestRobotId() {
        return this.bestRobotId;
    }

    public String getBestRobotName() {
        return this.bestRobotName;
    }

    public String getBestRobotCurrentVersion() {
        return this.bestRobotCurrentVersion;
    }

    public int getBestRobotRank() {
        return this.bestRobotRank;
    }

    public int getBestRobotRankShift() {
        return this.bestRobotRankShift;
    }

    public void setRobotNum(int rn) {
        this.robotNum = rn;
    }

    public void setBestRobotId(int bri) {
        this.bestRobotId = bri;
    }

    public void setBestRobotName(String brn) {
        this.bestRobotName = brn;
    }

    public void setBestRobotCurrentVersion(String brcv) {
        this.bestRobotCurrentVersion = brcv;
    }

    public void setBestRobotRank(int brr) {
        this.bestRobotRank = brr;
    }

    public void setBestRobotRankShift(int brrd) {
        this.bestRobotRankShift = brrd;
    }

    public String getDescription() {
        return this.description;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getUserType() {
        return this.userType;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public Date getRegistDate() {
        return this.registDate;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }

    public static class RegistDateComparator
    implements Comparator {
        public int compare(Object olhs, Object orhs) {
            UserSummary lhs = (UserSummary)olhs;
            UserSummary rhs = (UserSummary)orhs;
            int comp = lhs.getRegistDate().compareTo(rhs.getRegistDate());
            if (comp != 0) {
                return -comp;
            }
            return new NameComparator().compare(lhs, rhs);
        }
    }

    public static class RobotNumComparator
    implements Comparator {
        public int compare(Object olhs, Object orhs) {
            UserSummary lhs = (UserSummary)olhs;
            UserSummary rhs = (UserSummary)orhs;
            int comp = lhs.getRobotNum() - rhs.getRobotNum();
            if (comp != 0) {
                return -comp;
            }
            return new NameComparator().compare(lhs, rhs);
        }
    }

    public static class NameComparator
    implements Comparator {
        public int compare(Object olhs, Object orhs) {
            UserSummary lhs = (UserSummary)olhs;
            UserSummary rhs = (UserSummary)orhs;
            return lhs.getLoginId().compareTo(rhs.getLoginId());
        }
    }
}

