/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import rumblejp.common.beans.RobotVersion;

public class Robot
implements Serializable {
    private int robotId;
    private String currentVersion;
    private int userId;
    private String className;
    private Date registDate;
    private Date updateDate;
    private String description;
    private String name;
    private RobotVersion[] versions = null;

    public Robot() {
        this.robotId = -1;
        this.currentVersion = null;
        this.userId = -1;
        this.registDate = null;
        this.updateDate = null;
        this.className = null;
        this.description = null;
        this.name = null;
    }

    public Robot(ResultSet rs) throws SQLException {
        this.robotId = rs.getInt("robots.robot_id");
        this.currentVersion = rs.getString("robots.current_version");
        this.userId = rs.getInt("robots.user_id");
        this.setClassName(rs.getString("robots.class_name"));
        this.registDate = new Date(rs.getTimestamp("robots.regist_date").getTime());
        this.updateDate = new Date(rs.getTimestamp("robot_versions.regist_date").getTime());
        this.description = rs.getString("robot_versions.description");
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public int getRobotId() {
        return this.robotId;
    }

    public Date getRegistDate() {
        return this.registDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setRobotId(int robotId) {
        this.robotId = robotId;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setClassName(String className) {
        this.className = className;
        int index = className.lastIndexOf(46);
        if (index == -1) {
            this.name = className;
            return;
        }
        this.name = className.substring(index + 1);
    }

    public String getName() {
        return this.name;
    }

    public RobotVersion[] getVersions() {
        return this.versions;
    }

    public void setVersions(RobotVersion[] versions) {
        this.versions = versions;
    }
}

