/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.axis;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.axis.AxisFault;
import org.apache.axis.client.AdminClient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AdminClientTask
extends Task {
    private boolean failOnError = true;
    private String hostname;
    private int port = 0;
    private String servletPath;
    private File xmlFile;
    private String transportChain;
    private String username;
    private String password;
    private String fileProtocol;
    private String action = "";
    private String url;
    private boolean debug;
    private String newPassword;
    private LinkedList argslist;

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setFileProtocol(String string) {
        this.fileProtocol = string;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setServletPath(String string) {
        this.servletPath = string;
    }

    public void setXmlFile(File file) {
        this.xmlFile = file;
    }

    public void setTransportChain(String string) {
        this.transportChain = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void execute() throws BuildException {
        Object object;
        this.argslist = new LinkedList();
        this.addArgs("-l", this.url, this.url != null);
        this.addArgs("-h", this.hostname, this.hostname != null);
        this.addArgs("-p", Integer.toString(this.port), this.port != 0);
        this.addArgs("-s", this.servletPath, this.servletPath != null);
        this.addArgs("-f", this.fileProtocol, this.fileProtocol != null);
        this.addArgs("-u", this.username, this.username != null);
        this.addArgs("-p", this.password, this.password != null);
        this.addArgs("-t", this.transportChain, this.transportChain != null);
        this.addArg("-d", this.debug);
        this.addArg(this.action, this.action != null);
        if ("passwd".equals(this.action)) {
            if (this.newPassword == null) {
                throw new BuildException("No newpassword set for passwd");
            }
            this.addArg(this.newPassword);
        } else if (this.newPassword != null) {
            throw new BuildException("newpassword is only used when action=passwd");
        }
        if (this.xmlFile != null) {
            if (!this.xmlFile.exists()) {
                throw new BuildException("File " + this.xmlFile + " no found");
            }
            this.addArg(this.xmlFile.toString());
        }
        int n = 0;
        String[] stringArray = new String[this.argslist.size()];
        Iterator iterator = this.argslist.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringArray[n] = object;
            ++n;
        }
        object = new AdminClient();
        String string = null;
        try {
            string = object.process(stringArray);
            if (string != null) {
                this.log(string);
            } else {
                this.logOrThrow(this.getTaskName() + " got a null response");
            }
        }
        catch (AxisFault axisFault) {
            this.log(axisFault.dumpToString(), 0);
            this.logOrThrow(this.getTaskName() + " failed with  " + axisFault.getFaultCode().toString() + " " + axisFault.getFaultString());
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            throw new BuildException("Exception in " + this.getTaskName(), (Throwable)exception);
        }
    }

    private void logOrThrow(String string) throws BuildException {
        if (this.failOnError) {
            throw new BuildException(string);
        }
        this.log(string, 0);
    }

    protected void addArg(String string) {
        this.argslist.add(string);
    }

    protected void addArg(String string, boolean bl) {
        if (bl) {
            this.argslist.add(string);
        }
    }

    protected void addArgs(String string, String string2) {
        this.addArg(string);
        this.addArg(string2);
    }

    protected void addArgs(String string, String string2, boolean bl) {
        if (bl) {
            this.addArg(string);
            this.addArg(string2);
        }
    }
}

