package robocode;

/**
 * A prebuilt condition you can use that indicates your radar has finished rotating.
 * @see robocode.Condition
 */
public class RadarTurnCompleteCondition extends Condition {
	private AdvancedRobot robot = null;
/**
 * Creates a new RadarTurnCompleteCondition with default priority.
 */
public RadarTurnCompleteCondition(AdvancedRobot r) {
	super();
	this.robot = r;
}
/**
 * Creates a new RadarTurnCompleteCondition with the specified priority.
 */
public RadarTurnCompleteCondition(AdvancedRobot r, int priority) {
	super();
	this.robot = r;
	this.priority = priority;
}
/**
 * Tests if the radar has stopped turning.
 */
public boolean test() {
	return (robot.getRadarTurnRemaining() == 0);
}
}
