/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.axis;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.CallTarget;

public class RunAxisFunctionalTestsTask
extends Task {
    private String startTarget1;
    private String startTarget2;
    private String testTarget;
    private String stopTarget;
    private URL url;

    public void execute() throws BuildException {
        try {
            this.callStart(this.startTarget1);
            this.callStart(this.startTarget2);
            this.callTests();
            Object var2_1 = null;
            this.callStop();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.callStop();
            throw throwable;
        }
    }

    private void callStart(String string) {
        new Thread(new TaskRunnable(string)).start();
        while (true) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.sendOnSocket("ping\r\n");
                System.out.println("RunAxisFunctionalTestsTask.callStart successfully pinged server.");
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void callTests() {
        this.antcall(this.testTarget);
    }

    private void callStop() {
        try {
            this.sendOnSocket("quit\r\n");
            URL uRL = new URL("http://localhost:8080/");
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                RunAxisFunctionalTestsTask.readFully(httpURLConnection);
                httpURLConnection.disconnect();
            }
            catch (IOException iOException) {
                System.out.println("Error from HTTP read: " + iOException);
                return;
            }
            this.antcall(this.stopTarget);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                throw new BuildException("Interruption during sleep", (Throwable)interruptedException);
            }
            System.out.println("RunAxisFunctionalTestsTask.callStop successfully sent quit message.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void antcall(String string) {
        CallTarget callTarget = (CallTarget)((ProjectComponent)this).project.createTask("antcall");
        callTarget.setOwningTarget(this.target);
        callTarget.setTaskName(this.getTaskName());
        callTarget.setLocation(this.location);
        callTarget.init();
        callTarget.setTarget(string);
        callTarget.execute();
    }

    private void sendOnSocket(String string) throws Exception {
        Socket socket = null;
        socket = new Socket(this.url.getHost(), this.url.getPort());
        socket.getOutputStream().write(new String(string).getBytes());
        int n = socket.getInputStream().read();
    }

    static void readFully(HttpURLConnection httpURLConnection) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
        byte[] byArray = new byte[256];
        while (bufferedInputStream.read(byArray) > 0) {
        }
        bufferedInputStream.close();
    }

    public void setStartTarget1(String string) {
        this.startTarget1 = string;
    }

    public void setStartTarget2(String string) {
        this.startTarget2 = string;
    }

    public void setTestTarget(String string) {
        this.testTarget = string;
    }

    public void setStopTarget(String string) {
        this.stopTarget = string;
    }

    public void setUrl(String string) {
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Can't make URL from " + string);
        }
    }

    public class TaskRunnable
    implements Runnable {
        String taskName;

        public TaskRunnable(String string) {
            this.taskName = string;
        }

        public void run() {
            RunAxisFunctionalTestsTask.this.antcall(this.taskName);
        }
    }
}

