/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.distribute;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import rumblejp.common.Env;
import rumblejp.distribute.AugmentedRobocodeEngine;
import rumblejp.distribute.FileComparator;
import rumblejp.distribute.RobotDataSpecComparator;
import rumblejp.distribute.remote.BattleResult;
import rumblejp.distribute.remote.BattleResultSet;
import rumblejp.distribute.remote.BattleSpec;
import rumblejp.distribute.remote.BattleSpecSet;
import rumblejp.distribute.remote.Battles;
import rumblejp.distribute.remote.BattlesServiceLocator;
import rumblejp.distribute.remote.DownloadFiles;
import rumblejp.distribute.remote.RobotData;
import rumblejp.distribute.remote.RobotDataSpec;
import rumblejp.distribute.remote.RobotDataSpecSet;

public class Server {
    private static Logger logger = Logger.getLogger((Class)(class$rumblejp$distribute$Server == null ? (class$rumblejp$distribute$Server = Server.class$("rumblejp.distribute.Server")) : class$rumblejp$distribute$Server));
    private static final String ROBOTDATA_DIR = "robot_data";
    private static final String ROBOTCACHE_DIR = ".robotcache";
    private File rootDir;
    private File robotDataRoot;
    private File robotCacheRoot;
    private String hostname;
    private String password;
    private int times = -1;
    private Battles battles;
    private BattleSpecSet battleSpecSet;
    private LinkedList results = new LinkedList();
    private AugmentedRobocodeEngine engine;
    private Finalizer finalizer = new Finalizer();
    static /* synthetic */ Class class$rumblejp$distribute$Server;

    public static void main(String[] args) throws Exception {
        int times = args.length != 0 ? Integer.parseInt(args[0]) : -1;
        Server server = new Server(times);
        try {
            server.start();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception occured.", (Throwable)ex);
            server.shutdown();
        }
    }

    private Server(int times) {
        this.times = times;
    }

    private void initialize() throws Exception {
        DOMConfigurator.configure((String)"log4j.xml");
        Runtime.getRuntime().addShutdownHook(this.finalizer);
        this.hostname = Env.getString("hostname");
        this.password = Env.getString("password");
        this.rootDir = new File(".");
        this.engine = new AugmentedRobocodeEngine(this.rootDir);
        this.robotDataRoot = new File(this.rootDir, ROBOTDATA_DIR);
        this.robotCacheRoot = new File(this.rootDir, ROBOTCACHE_DIR);
        URL endpoint = new URL(Env.getString("endpoint.battles"));
        BattlesServiceLocator service = new BattlesServiceLocator();
        this.battles = service.getBattles(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        Server server = this;
        synchronized (server) {
            if (this.battleSpecSet != null) {
                System.setSecurityManager(null);
                this.sendResults(true);
                this.battleSpecSet = null;
                this.results = new LinkedList();
                this.battles = null;
                this.engine = null;
            }
            logger.info((Object)"Distribute server shutdown.");
        }
    }

    private synchronized void sendResultAndGetNextBattle() throws Exception {
        try {
            if (this.battleSpecSet != null) {
                BattleResultSet resultSet = this.createBattleResultSet(this.battleSpecSet, false);
                resultSet.setResults(this.results.toArray(new BattleResult[this.results.size()]));
                this.results.clear();
                this.battleSpecSet = this.battles.setResultsAndGetNextBattle(this.hostname, this.password, resultSet);
            } else {
                this.battleSpecSet = this.battles.getNewBattle(this.hostname, this.password);
            }
        }
        catch (Exception ex) {
            this.battleSpecSet = null;
            throw ex;
        }
    }

    private synchronized void sendResults(boolean terminate) throws Exception {
        if (this.battleSpecSet == null) {
            return;
        }
        try {
            BattleResultSet resultSet = this.createBattleResultSet(this.battleSpecSet, terminate);
            resultSet.setResults(this.results.toArray(new BattleResult[this.results.size()]));
            this.results.clear();
            this.battles.setResults(this.hostname, this.password, resultSet);
        }
        catch (Exception ex) {
            this.battleSpecSet = null;
            throw ex;
        }
    }

    private BattleResultSet createBattleResultSet(BattleSpecSet bsSet, boolean terminate) throws IOException {
        BattleResultSet set = new BattleResultSet();
        set.setLeagueId(bsSet.getLeagueId());
        set.setSeason(bsSet.getSeason());
        set.setDivision(bsSet.getDivision());
        set.setConfirmString(bsSet.getConfirmString());
        set.setTerminated(terminate);
        this.setUploadData(this.battleSpecSet, set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start() throws Exception {
        this.initialize();
        logger.info((Object)"Distribute server started.");
        logger.info((Object)"Check new battle.");
        Server server = this;
        // MONITORENTER : server
        this.battleSpecSet = this.battles.getNewBattle(this.hostname, this.password);
        // MONITOREXIT : server
        int battleCount = 0;
        while (true) {
            if (this.battleSpecSet == null) {
                logger.info((Object)"Battle doesn't exist. Server will sleep.");
                Thread.sleep(600000L);
                Server server2 = this;
                // MONITORENTER : server2
                this.battleSpecSet = this.battles.getNewBattle(this.hostname, this.password);
                // MONITOREXIT : server2
                continue;
            }
            this.engine.updateRobots();
            logger.info((Object)("Accepted new division[leagueId:" + this.battleSpecSet.getLeagueId() + " season:" + this.battleSpecSet.getSeason() + " division:" + this.battleSpecSet.getDivision() + "], " + this.battleSpecSet.getBattles().length + " battles."));
            this.setupDataFiles(this.battleSpecSet);
            long comBegin = System.currentTimeMillis();
            long end = 0L;
            BattleSpec[] specs = this.battleSpecSet.getBattles();
            int i = 0;
            while (i < specs.length) {
                long begin = System.currentTimeMillis();
                BattleResult result = this.engine.runBattle(this.battleSpecSet.getRounds(), this.battleSpecSet.getFieldHeight(), this.battleSpecSet.getFieldWidth(), this.battleSpecSet.getCoolingRate(), this.battleSpecSet.getInactivityTime(), specs[i]);
                end = System.currentTimeMillis();
                result.setTotalTime((int)(end - begin));
                Server server3 = this;
                // MONITORENTER : server3
                this.results.add(result);
                // MONITOREXIT : server3
                if (this.times != -1 && ++battleCount >= this.times) {
                    logger.info((Object)("Complete " + this.times + " battles(specified limit)."));
                    logger.info((Object)"Server is sending executed battle result. And server will be terminated.");
                    this.shutdown();
                    return;
                }
                if (comBegin + 600000L < end) {
                    logger.info((Object)"Passed over 10 minites from last access.");
                    logger.info((Object)"Server is sending executed battle result.");
                    this.sendResults(false);
                    comBegin = System.currentTimeMillis();
                }
                ++i;
            }
            Server server4 = this;
            // MONITORENTER : server4
            if (!this.results.isEmpty()) {
                if (this.times != -1 && battleCount >= this.times) {
                    logger.info((Object)"Server is sending result. And server will be terminated.");
                    this.shutdown();
                    // MONITOREXIT : server4
                    return;
                }
                logger.info((Object)"Server is sending result and checking new battle.");
                this.sendResultAndGetNextBattle();
            } else {
                this.battleSpecSet = this.battles.getNewBattle(this.hostname, this.password);
            }
            // MONITOREXIT : server4
        }
    }

    private void setupDataFiles(BattleSpecSet battleSpecSet) throws Exception {
        logger.info((Object)"Robot's data synchronization(download) start.");
        RobotDataSpecSet[] dataSpecSet = battleSpecSet.getRobotDataSpecSet();
        int leagueId = battleSpecSet.getLeagueId();
        File leagueDir = new File(this.robotDataRoot, "" + leagueId);
        LinkedList<DownloadFiles> requests = new LinkedList<DownloadFiles>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int i = 0;
        while (i < dataSpecSet.length) {
            RobotDataSpec[] dataSpecs;
            String jarFileName = dataSpecSet[i].getJarFileName();
            String className = dataSpecSet[i].getClassName();
            int robotVersionId = dataSpecSet[i].getRobotVersionId();
            logger.info((Object)("Checking robot's data. [" + className + "]"));
            File robotDataDir = new File(leagueDir, jarFileName);
            String path = className.replace('.', File.separatorChar);
            File robotCacheDataDir = new File(this.robotCacheRoot, jarFileName + "_" + File.separator + path + ".data");
            if (robotCacheDataDir.exists()) {
                this.rmdir(robotCacheDataDir);
            }
            if ((dataSpecs = dataSpecSet[i].getRobotDataSpecs()) == null) {
                logger.debug((Object)("  [" + className + "] doesn't have any data."));
                if (robotDataDir.exists()) {
                    this.rmdir(robotDataDir);
                }
            } else {
                if (!robotDataDir.exists()) {
                    robotDataDir.mkdirs();
                }
                Arrays.sort(dataSpecs, new RobotDataSpecComparator());
                logger.debug((Object)("Center server (" + dataSpecs.length + "files):"));
                int j = 0;
                while (j < dataSpecs.length) {
                    logger.debug((Object)("  [" + dataSpecs[j].getName() + "] " + formatter.format(new Date(dataSpecs[j].getTime())) + " " + dataSpecs[j].getSize() + "bytes."));
                    ++j;
                }
                File[] localFiles = robotDataDir.listFiles();
                Arrays.sort(localFiles, new FileComparator());
                logger.debug((Object)("Local (" + localFiles.length + "files):"));
                int j2 = 0;
                while (j2 < localFiles.length) {
                    logger.debug((Object)("  [" + localFiles[j2].getName() + "] " + formatter.format(new Date(localFiles[j2].lastModified())) + " " + localFiles[j2].length() + "bytes."));
                    ++j2;
                }
                RobotDataSpec dataSpec = null;
                File localFile = null;
                LinkedList<RobotDataSpec> list = new LinkedList<RobotDataSpec>();
                int j3 = 0;
                int k = 0;
                while (j3 < dataSpecs.length || k < localFiles.length || dataSpec != null || localFile != null) {
                    if (dataSpec == null && j3 < dataSpecs.length) {
                        dataSpec = dataSpecs[j3++];
                    }
                    if (localFile == null && k < localFiles.length) {
                        localFile = localFiles[k++];
                    }
                    int comp = 0;
                    comp = dataSpec == null ? 1 : (localFile == null ? -1 : dataSpec.getName().compareTo(localFile.getName()));
                    if (comp < 0) {
                        list.add(dataSpec);
                        logger.info((Object)("  Not found    [" + dataSpec.getName() + "]"));
                        dataSpec = null;
                        continue;
                    }
                    if (comp > 0) {
                        localFile.delete();
                        logger.info((Object)("  Deleted      [" + dataSpec.getName() + "]"));
                        localFile = null;
                        continue;
                    }
                    long localTime = localFile.lastModified();
                    long fragment = localTime % 2000L;
                    if (fragment > 0L) {
                        localTime += 2000L - fragment;
                    }
                    if (localTime != dataSpec.getTime() || localFile.length() != (long)dataSpec.getSize()) {
                        list.add(dataSpec);
                        logger.info((Object)("  Changed     [" + dataSpec.getName() + "]"));
                    } else {
                        logger.debug((Object)("  Not Changed [" + dataSpec.getName() + "]"));
                    }
                    dataSpec = null;
                    localFile = null;
                }
                if (list.size() != 0) {
                    DownloadFiles downloadFiles = new DownloadFiles();
                    downloadFiles.setJarFileName(jarFileName);
                    downloadFiles.setClassName(className);
                    downloadFiles.setRobotVersionId(robotVersionId);
                    downloadFiles.setFiles(list.toArray(new RobotDataSpec[list.size()]));
                    requests.add(downloadFiles);
                }
            }
            ++i;
        }
        RobotData[] datas = this.battles.getRobotData(this.hostname, this.password, battleSpecSet.getLeagueId(), requests.toArray(new DownloadFiles[requests.size()]));
        int i2 = 0;
        while (i2 < datas.length) {
            String jarFileName = datas[i2].getJarFileName();
            String className = datas[i2].getClassName();
            logger.info((Object)("Downloaded [" + className + "]'s data."));
            File robotDataDir = new File(leagueDir, jarFileName);
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(datas[i2].getData())));
            ZipEntry entry = null;
            byte[] buf = new byte[8192];
            while ((entry = in.getNextEntry()) != null) {
                File file = new File(robotDataDir, entry.getName());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                int len = 0;
                while ((len = in.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                out.close();
                file.setLastModified(entry.getTime());
                logger.info((Object)("  " + entry.getName() + " " + formatter.format(new Date(entry.getTime())) + " " + file.length() + "bytes."));
            }
            in.close();
            ++i2;
        }
        int i3 = 0;
        while (i3 < dataSpecSet.length) {
            String jarFileName = dataSpecSet[i3].getJarFileName();
            String className = dataSpecSet[i3].getClassName();
            File robotDataDir = new File(leagueDir, jarFileName);
            String path = className.replace('.', File.separatorChar);
            File robotCacheDataDir = new File(this.robotCacheRoot, jarFileName + "_" + File.separator + path + ".data");
            if (robotDataDir.exists()) {
                robotCacheDataDir.mkdirs();
                this.copyFiles(robotDataDir, robotCacheDataDir);
            }
            ++i3;
        }
    }

    private void setUploadData(BattleSpecSet battleSpecSet, BattleResultSet battleResultSet) throws IOException {
        RobotDataSpecSet[] dataSpecSets = battleSpecSet.getRobotDataSpecSet();
        int leagueId = battleSpecSet.getLeagueId();
        File leagueDir = new File(this.robotDataRoot, "" + leagueId);
        logger.info((Object)"Robot's data synchronization(upload) start.");
        LinkedList<RobotData> datas = new LinkedList<RobotData>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int i = 0;
        while (i < dataSpecSets.length) {
            RobotDataSpecSet dataSpecSet = dataSpecSets[i];
            String jarFileName = dataSpecSet.getJarFileName();
            String className = dataSpecSet.getClassName();
            int robotVersionId = dataSpecSet.getRobotVersionId();
            logger.info((Object)("Checking robot's data. [" + className + "]"));
            File robotDataDir = new File(leagueDir, jarFileName);
            String path = className.replace('.', File.separatorChar);
            File robotCacheDataDir = new File(this.robotCacheRoot, jarFileName + "_" + File.separator + path + ".data");
            if (!robotCacheDataDir.exists()) {
                if (dataSpecSet.getRobotDataSpecs() != null) {
                    logger.info((Object)"  robocode data dir doesn't exist. Central server's dir will be deleted.");
                    RobotData data = new RobotData();
                    data.setExistsDir(false);
                    datas.add(data);
                    this.rmdir(robotDataDir);
                } else {
                    logger.debug((Object)"  robocode data dir doesn't exist.");
                }
            } else {
                File[] storeFiles;
                File[] robocodeFiles = robotCacheDataDir.listFiles();
                Arrays.sort(robocodeFiles, new FileComparator());
                logger.debug((Object)("Robocode dir (" + robocodeFiles.length + "files):"));
                int j = 0;
                while (j < robocodeFiles.length) {
                    logger.debug((Object)("  [" + robocodeFiles[j].getName() + "] " + formatter.format(new Date(robocodeFiles[j].lastModified())) + " " + robocodeFiles[j].length() + "bytes."));
                    ++j;
                }
                if (robotDataDir.exists()) {
                    storeFiles = robotDataDir.listFiles();
                } else {
                    robotDataDir.mkdirs();
                    storeFiles = new File[]{};
                }
                Arrays.sort(storeFiles, new FileComparator());
                logger.debug((Object)("Store dir (" + storeFiles.length + "files):"));
                int j2 = 0;
                while (j2 < storeFiles.length) {
                    logger.debug((Object)("  [" + storeFiles[j2].getName() + "] " + formatter.format(new Date(storeFiles[j2].lastModified())) + " " + storeFiles[j2].length() + "bytes."));
                    ++j2;
                }
                LinkedList<File> uploadFiles = new LinkedList<File>();
                LinkedList<File> deleteFiles = new LinkedList<File>();
                File robocodeFile = null;
                File storeFile = null;
                int j3 = 0;
                int k = 0;
                while (j3 < robocodeFiles.length || k < storeFiles.length || robocodeFile != null || storeFile != null) {
                    File file;
                    if (robocodeFile == null && j3 < robocodeFiles.length) {
                        robocodeFile = robocodeFiles[j3++];
                    }
                    if (storeFile == null && k < storeFiles.length) {
                        storeFile = storeFiles[k++];
                    }
                    int comp = 0;
                    comp = robocodeFile == null ? 1 : (storeFile == null ? -1 : robocodeFile.getName().compareTo(storeFile.getName()));
                    if (comp < 0) {
                        file = this.copyFile(robocodeFile, robotDataDir);
                        logger.info((Object)("  New file    [" + file.getName() + "] " + formatter.format(new Date(file.lastModified())) + " " + file.length() + "bytes."));
                        uploadFiles.add(file);
                        robocodeFile = null;
                        continue;
                    }
                    if (comp > 0) {
                        deleteFiles.add(storeFile);
                        logger.info((Object)("  Deleted     [" + storeFile.getName() + "]"));
                        storeFile = null;
                        continue;
                    }
                    if (robocodeFile.lastModified() != storeFile.lastModified() || robocodeFile.length() != storeFile.length()) {
                        file = this.copyFile(robocodeFile, robotDataDir);
                        logger.info((Object)("  Changed     [" + file.getName() + "] " + formatter.format(new Date(file.lastModified())) + " " + file.length() + "bytes."));
                        uploadFiles.add(file);
                    } else {
                        logger.debug((Object)("  Not Changed [" + storeFile.getName() + "] " + formatter.format(new Date(storeFile.lastModified())) + " " + storeFile.length() + "bytes."));
                    }
                    robocodeFile = null;
                    storeFile = null;
                }
                if (uploadFiles.size() != 0 || deleteFiles.size() != 0) {
                    RobotData data = new RobotData();
                    RobotDataSpec[] deleteFileSpecs = new RobotDataSpec[deleteFiles.size()];
                    int j4 = 0;
                    while (j4 < deleteFiles.size()) {
                        File deleteFile = (File)deleteFiles.get(j4);
                        deleteFileSpecs[j4] = new RobotDataSpec();
                        deleteFileSpecs[j4].setName(deleteFile.getName());
                        deleteFileSpecs[j4].setSize((int)deleteFile.length());
                        deleteFileSpecs[j4].setTime(deleteFile.lastModified());
                        deleteFile.delete();
                        ++j4;
                    }
                    data.setDeleteFiles(deleteFileSpecs);
                    if (uploadFiles.size() != 0) {
                        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(byteOut));
                        byte[] buf = new byte[8192];
                        Iterator iter = uploadFiles.iterator();
                        while (iter.hasNext()) {
                            File file = (File)iter.next();
                            ZipEntry entry = new ZipEntry(file.getName());
                            entry.setTime(file.lastModified());
                            entry.setSize(file.length());
                            zipOut.putNextEntry(entry);
                            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                            int len = 0;
                            while ((len = in.read(buf)) != -1) {
                                zipOut.write(buf, 0, len);
                            }
                            in.close();
                            zipOut.closeEntry();
                        }
                        zipOut.finish();
                        zipOut.close();
                        data.setData(byteOut.toByteArray());
                    }
                    data.setClassName(className);
                    data.setExistsDir(true);
                    data.setJarFileName(jarFileName);
                    data.setRobotVersionId(robotVersionId);
                    datas.add(data);
                    File[] files = robotDataDir.listFiles();
                    RobotDataSpec[] dataSpecs = new RobotDataSpec[files.length];
                    int j5 = 0;
                    while (j5 < files.length) {
                        dataSpecs[j5] = new RobotDataSpec();
                        dataSpecs[j5].setName(files[j5].getName());
                        dataSpecs[j5].setSize((int)files[j5].length());
                        dataSpecs[j5].setTime(files[j5].lastModified());
                        ++j5;
                    }
                    dataSpecSet.setRobotDataSpecs(dataSpecs);
                }
            }
            ++i;
        }
        battleResultSet.setRobotDatas(datas.toArray(new RobotData[datas.size()]));
    }

    private void rmdir(File dir) {
        File[] children = dir.listFiles();
        int i = 0;
        while (i < children.length) {
            children[i].delete();
            ++i;
        }
        dir.delete();
    }

    private void copyFiles(File fromDir, File toDir) throws IOException {
        File[] files = fromDir.listFiles();
        byte[] buf = new byte[8192];
        int i = 0;
        while (i < files.length) {
            File outFile = new File(toDir, files[i].getName());
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(files[i]));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
            int len = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            out.close();
            in.close();
            outFile.setLastModified(files[i].lastModified());
            ++i;
        }
    }

    private File copyFile(File from, File toDir) throws IOException {
        File outFile = new File(toDir, from.getName());
        byte[] buf = new byte[8192];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        int len = 0;
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        out.close();
        in.close();
        long time = from.lastModified() / 1000L * 1000L;
        long fragment = time % 2000L;
        if (fragment > 0L) {
            time += 2000L - fragment;
        }
        outFile.setLastModified(time);
        return outFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Finalizer
    extends Thread {
        public void run() {
            try {
                Server.this.shutdown();
            }
            catch (Exception e) {}
        }
    }
}

