/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import rumblejp.common.beans.Robot;

public class User
implements Serializable {
    private int userId;
    private String loginId;
    private int userType;
    private Date registDate;
    private String email;
    private boolean admin;
    private String description;
    private String password;

    public User() {
        this.userId = -1;
        this.loginId = null;
        this.userType = -1;
        this.registDate = null;
        this.description = null;
        this.password = null;
        this.admin = false;
    }

    public User(ResultSet rs) throws SQLException {
        this.userId = rs.getInt("users.user_id");
        this.loginId = rs.getString("users.login_id");
        this.userType = rs.getInt("users.user_type");
        this.registDate = new Date(rs.getTimestamp("users.regist_date").getTime());
        this.email = rs.getString("users.email");
        this.admin = rs.getInt("users.admin") == 1;
        this.description = rs.getString("users.description");
        this.password = null;
    }

    public String getDescription() {
        return this.description;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getUserType() {
        return this.userType;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public Date getRegistDate() {
        return this.registDate;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }

    public void setCurrentRobots(Robot[] robots) {
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }
}

