/*
 * Decompiled with CFR 0.152.
 */
package org.incava.etc;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;

public class FileDiff {
    public FileDiff(String fromFile, String toFile) {
        Object[] aLines = this.read(fromFile);
        Object[] bLines = this.read(toFile);
        List diffs = new Diff(aLines, bLines).diff();
        for (Difference diff : diffs) {
            int delStart = diff.getDeletedStart();
            int delEnd = diff.getDeletedEnd();
            int addStart = diff.getAddedStart();
            int addEnd = diff.getAddedEnd();
            String from = this.toString(delStart, delEnd);
            String to = this.toString(addStart, addEnd);
            String type = delEnd != -1 && addEnd != -1 ? "c" : (delEnd == -1 ? "a" : "d");
            System.out.println(from + type + to);
            if (delEnd != -1) {
                this.printLines(delStart, delEnd, "<", (String[])aLines);
                if (addEnd != -1) {
                    System.out.println("---");
                }
            }
            if (addEnd == -1) continue;
            this.printLines(addStart, addEnd, ">", (String[])bLines);
        }
    }

    protected void printLines(int start, int end, String ind, String[] lines) {
        for (int lnum = start; lnum <= end; ++lnum) {
            System.out.println(ind + " " + lines[lnum]);
        }
    }

    protected String toString(int start, int end) {
        StringBuffer buf = new StringBuffer();
        buf.append(end == -1 ? start : 1 + start);
        if (end != -1 && start != end) {
            buf.append(",").append(1 + end);
        }
        return buf.toString();
    }

    protected String[] read(String fileName) {
        try {
            String in;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            ArrayList<String> contents = new ArrayList<String>();
            while ((in = br.readLine()) != null) {
                contents.add(in);
            }
            return contents.toArray(new String[0]);
        }
        catch (Exception e) {
            System.err.println("error reading " + fileName + ": " + e);
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            new FileDiff(args[0], args[1]);
        } else {
            System.err.println("usage: org.incava.diffj.FileDiff from-file to-file");
        }
    }
}

