/*
 * Decompiled with CFR 0.152.
 */
package minicmds.model;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import minicmds.model.Document;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelDoc
extends Document {
    private List<String[][]> sheetList;

    public ExcelDoc(String path) {
        super(path);
    }

    public void read() throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(this.getPath());
        POIFSFileSystem fs = new POIFSFileSystem(is);
        HSSFWorkbook book = new HSSFWorkbook(fs);
        int numSheet = book.getNumberOfSheets();
        this.sheetList = new ArrayList<String[][]>();
        for (int sheet = 0; sheet < numSheet; ++sheet) {
            HSSFSheet sheetHandler = book.getSheetAt(sheet);
            int rowNum = sheetHandler.getLastRowNum();
            if (sheetHandler.getRow(0) == null) {
                rowNum = -1;
            }
            String[][] values = new String[rowNum + 1][];
            for (int row = 0; row <= rowNum; ++row) {
                HSSFRow hssfrow = sheetHandler.getRow(row);
                short columnNum = hssfrow.getLastCellNum();
                values[row] = new String[columnNum];
                for (short column = 0; column < columnNum; column = (short)(column + 1)) {
                    HSSFRichTextString cellvalue;
                    String value = "";
                    HSSFCell hssfcell = hssfrow.getCell(column);
                    if (hssfcell != null && (cellvalue = hssfcell.getRichStringCellValue()) != null) {
                        value = cellvalue.getString();
                    }
                    values[row][column] = value;
                }
            }
            this.sheetList.add(values);
        }
    }

    public String getCell(int sheet, int row, int column) {
        String result;
        try {
            result = this.sheetList.get(sheet)[row][column];
        }
        catch (IndexOutOfBoundsException e) {
            result = "";
        }
        return result;
    }

    public int getSheetSize() {
        return this.sheetList.size();
    }

    public int getRowSize(int sheet) {
        return this.sheetList.get(sheet).length;
    }

    public int getColumnSize(int sheet, int row) {
        return this.sheetList.get(sheet)[row].length;
    }
}

