/*
 * Decompiled with CFR 0.152.
 */
package minicmds.diff;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import minicmds.diff.Argument;
import minicmds.diff.DiffWriter;
import minicmds.diff.Document;
import minicmds.diff.Reader;
import minicmds.diff.ReaderFactory;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private MyFilenameFilter filter = new MyFilenameFilter();

    public static void main(String[] args) {
        Main main = new Main();
        main.run(args);
    }

    private void run(String[] args) {
        Argument arg = new Argument();
        arg.parse(args);
        if (arg.isHelpFlag()) {
            arg.printUsage();
            return;
        }
        this.procDirLoop(arg.getBefore(), arg.getAfter(), 0);
    }

    private void procDirLoop(String path1, String path2, int nest) {
        File file1 = new File(path1);
        File file2 = new File(path2);
        if (file1.isDirectory() && file2.isDirectory()) {
            String[] list1 = file1.list(this.filter);
            String[] list2 = file2.list(this.filter);
            int count1 = 0;
            int count2 = 0;
            while (count1 < list1.length || count2 < list2.length) {
                int cmp = 0;
                cmp = count1 >= list1.length ? 1 : (count2 >= list2.length ? -1 : list1[count1].compareTo(list2[count2]));
                if (cmp < 0) {
                    this.procOnePath(path1, list1[count1], cmp);
                    ++count1;
                    continue;
                }
                if (cmp > 0) {
                    this.procOnePath(path2, list2[count2], cmp);
                    ++count2;
                    continue;
                }
                this.procDirLoop(path1 + "/" + list1[count1], path2 + "/" + list2[count2], nest + 1);
                ++count1;
                ++count2;
            }
        } else {
            this.procFilePair(path1, path2, nest);
        }
    }

    private void procOnePath(String dir, String name, int cmp) {
        File file = new File(dir + "/" + name);
        if (file.isDirectory()) {
            String[] list;
            for (String str : list = file.list(this.filter)) {
                this.procOnePath(dir + "/" + name, str, cmp);
            }
        } else {
            Document doc;
            try {
                doc = this.read(dir + "/" + name);
            }
            catch (IOException e) {
                return;
            }
            ArrayList<Difference> diffList = new ArrayList<Difference>();
            if (cmp < 0) {
                diffList.add(new Difference(0, doc.getArray().length - 1, 0, -1));
            } else {
                diffList.add(new Difference(0, -1, 0, doc.getArray().length - 1));
            }
            System.out.println("Only in " + dir + ": " + name);
            DiffWriter twriter = new DiffWriter();
            twriter.printDiffList(System.out, doc, doc, diffList);
        }
    }

    private void procFilePair(String beforeName, String afterName, int nest) {
        Document after;
        Document before;
        File file1 = new File(beforeName);
        File file2 = new File(afterName);
        if (file1.isDirectory()) {
            beforeName = beforeName + "/" + file2.getName();
        }
        if (file2.isDirectory()) {
            afterName = afterName + "/" + file1.getName();
        }
        try {
            before = this.read(beforeName);
            after = this.read(afterName);
        }
        catch (IOException e) {
            return;
        }
        Diff diff = new Diff(before.getArray(), after.getArray());
        List<Difference> diffList = this.callDiff(diff);
        if (diffList.size() > 0 && nest > 0) {
            System.out.println("diff " + beforeName + " " + afterName);
        }
        DiffWriter twriter = new DiffWriter();
        twriter.printDiffList(System.out, before, after, diffList);
    }

    private Document read(String path) throws IOException {
        Document doc;
        try {
            Reader reader = ReaderFactory.getReader(path);
            doc = reader.read(path);
        }
        catch (IOException e) {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\uff1a" + path);
            System.out.println(e.toString());
            throw e;
        }
        return doc;
    }

    private List<Difference> callDiff(Diff diff) {
        return diff.diff();
    }

    class MyFilenameFilter
    implements FilenameFilter {
        private static final String EXCLUDE_PATTERN = ".svn";

        MyFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return !name.equals(EXCLUDE_PATTERN);
        }
    }
}

