/*
 * Decompiled with CFR 0.152.
 */
package minicmds.diff;

import java.util.ArrayList;
import java.util.List;

public class Document {
    private Type type;
    private List<String> sheetNameList = new ArrayList<String>();
    private List<Integer> rowList = new ArrayList<Integer>();
    private List<Integer> columnList = new ArrayList<Integer>();
    private List<String> list = new ArrayList<String>();

    public Document() {
        this.type = Type.TEXT;
    }

    public Document(Type type) {
        this.type = type;
    }

    public Document(String[] strings) {
        this.type = Type.TEXT;
        for (int i = 0; i < strings.length; ++i) {
            this.add(null, i, 1, strings[i]);
        }
    }

    public void add(String value) {
        this.add(null, this.list.size(), 1, value);
    }

    public void add(String sheetName, int row, int column, String cell) {
        this.sheetNameList.add(sheetName);
        this.rowList.add(row);
        this.columnList.add(column);
        this.list.add(cell);
    }

    public String[] getArray() {
        return this.list.toArray(new String[0]);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String getSheetName(int i) {
        return this.sheetNameList.get(i);
    }

    public int getRow(int i) {
        return this.rowList.get(i);
    }

    public int getColumn(int i) {
        return this.columnList.get(i);
    }

    public String get(int i) {
        return this.list.get(i);
    }

    public Type getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TEXT,
        EXCEL;

    }
}

